/*
 * Decompiled with CFR 0.152.
 */
package jpty;

import jpty.Constants;
import jpty.JPtyException;
import jpty.NativeMethods;
import jpty.Pty;
import jpty.Termios;
import jpty.linux.JPtyImplLinux;
import jpty.macosx.JPtyImplMac;
import jwrapper.jwutils.pty.WinSize;
import utils.ostools.OS;

public class JPty {
    public static int ONLCR = 4;
    public static int VINTR = 0;
    public static int VQUIT = 1;
    public static int VERASE = 2;
    public static int VKILL = 3;
    public static int VSUSP = 10;
    public static int VREPRINT = 12;
    public static int VWERASE = 14;
    public static int ECHOCTL = 4096;
    public static int ECHOKE = 16384;
    public static int SIGHUP = 1;
    public static int SIGINT = 2;
    public static int SIGQUIT = 3;
    public static int SIGILL = 4;
    public static int SIGABORT = 6;
    public static int SIGFPE = 8;
    public static int SIGKILL = 9;
    public static int SIGSEGV = 11;
    public static int SIGPIPE = 13;
    public static int SIGALRM = 14;
    public static int SIGTERM = 15;
    public static int WNOHANG = 1;
    public static int WUNTRACED = 2;
    private static JPtyInterface m_jpty;
    private static boolean triedToLoad;

    private static JPtyInterface getOrInit() {
        if (m_jpty == null && !triedToLoad) {
            triedToLoad = true;
            if (OS.isMacOS()) {
                m_jpty = new JPtyImplMac();
            } else if (OS.isLinux()) {
                m_jpty = new JPtyImplLinux();
            } else {
                throw new RuntimeException("JPty has no support for OS " + System.getProperty("os.name"));
            }
        }
        return m_jpty;
    }

    public static Pty execInPTY(String command, String[] arguments) throws JPtyException {
        return JPty.execInPTY(command, arguments, null);
    }

    public static Pty execInPTY(String command, String[] arguments, String[] environment) throws JPtyException {
        return JPty.execInPTY(command, arguments, environment, null, null);
    }

    public static Pty execInPTY(String command, String[] arguments, String[] environment, Termios termios, WinSize winsize2) throws JPtyException {
        if (command == null) {
            throw new IllegalArgumentException("Invalid command line!");
        }
        int[] master = new int[]{-1};
        byte[] name = new byte[128];
        int pid = JPty.getOrInit().forkpty(master, name, termios, winsize2);
        if (pid < 0) {
            throw new JPtyException("Failed to open PTY!", JPty.errno());
        }
        if (pid == 0) {
            String[] argv = JPty.processArgv(command, arguments);
            if (winsize2 != null && JPty.setWinSize(0, winsize2) < 0) {
                throw new JPtyException("Failed to set window size!", JPty.errno());
            }
            JPty.execve(command, argv, environment);
            throw new JPtyException("Child failed to replace process!", JPty.errno());
        }
        int masterFD = master[0];
        if (masterFD < 0) {
            throw new JPtyException("Failed to fork PTY!", -1);
        }
        if (NativeMethods.fcntl(masterFD, Constants.F_SETFL, 0) < 0) {
            throw new JPtyException("Failed to set flags for master PTY!", JPty.errno());
        }
        return new Pty(masterFD, pid);
    }

    public static int getWinSize(int fd, WinSize ws) {
        return JPty.getOrInit().getWinSize(fd, ws);
    }

    public static boolean isProcessAlive(int pid) {
        int[] stat = new int[]{-1};
        int result = JPty.waitpid(pid, stat, WNOHANG);
        return result == 0 && stat[0] < 0;
    }

    public static int setWinSize(int fd, WinSize ws) {
        return JPty.getOrInit().setWinSize(fd, ws);
    }

    public static int signal(int pid, int signal) {
        return JPty.getOrInit().kill(pid, signal);
    }

    public static int waitpid(int pid, int[] stat, int options) {
        return JPty.getOrInit().waitpid(pid, stat, options);
    }

    static int errno() {
        return NativeMethods.getLastError();
    }

    private static int execve(String command, String[] argv, String[] env) {
        return JPty.getOrInit().execve(command, argv, env);
    }

    private static String[] processArgv(String command, String[] arguments) {
        String[] argv;
        if (arguments == null) {
            argv = new String[]{command};
        } else if (!command.equals(arguments[0])) {
            argv = new String[arguments.length + 1];
            argv[0] = command;
            System.arraycopy(arguments, 0, argv, 1, arguments.length);
        } else {
            String[] result = new String[arguments.length];
            System.arraycopy(arguments, 0, result, 0, arguments.length);
            argv = result;
        }
        return argv;
    }

    static {
        triedToLoad = false;
    }

    public static interface JPtyInterface {
        public int execve(String var1, String[] var2, String[] var3);

        public int forkpty(int[] var1, byte[] var2, Termios var3, WinSize var4);

        public int getWinSize(int var1, WinSize var2);

        public int kill(int var1, int var2);

        public int setWinSize(int var1, WinSize var2);

        public int waitpid(int var1, int[] var2, int var3);
    }
}

