/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.RenderableElement;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.ShapeElement;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class Group
extends ShapeElement {
    public static final String TAG_NAME = "group";
    Rectangle2D boundingBox;
    Shape cachedShape;

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public void loaderAddChild(SVGLoaderHelper helper, SVGElement child) throws SVGElementException {
        super.loaderAddChild(helper, child);
    }

    protected boolean outsideClip(Graphics2D g) throws SVGException {
        Shape clip = g.getClip();
        if (clip == null) {
            return false;
        }
        Rectangle2D rect = this.getBoundingBox();
        return !clip.intersects(rect);
    }

    @Override
    void pick(Point2D point, boolean boundingBox, List retVec) throws SVGException {
        Point2D.Double xPoint = new Point2D.Double(point.getX(), point.getY());
        if (this.xform != null) {
            try {
                this.xform.inverseTransform(point, xPoint);
            }
            catch (NoninvertibleTransformException ex) {
                throw new SVGException(ex);
            }
        }
        for (Object aChildren : this.children) {
            SVGElement ele = (SVGElement)aChildren;
            if (!(ele instanceof RenderableElement)) continue;
            RenderableElement rendEle = (RenderableElement)ele;
            rendEle.pick(xPoint, boundingBox, retVec);
        }
    }

    @Override
    void pick(Rectangle2D pickArea, AffineTransform ltw, boolean boundingBox, List retVec) throws SVGException {
        if (this.xform != null) {
            ltw = new AffineTransform(ltw);
            ltw.concatenate(this.xform);
        }
        for (Object aChildren : this.children) {
            SVGElement ele = (SVGElement)aChildren;
            if (!(ele instanceof RenderableElement)) continue;
            RenderableElement rendEle = (RenderableElement)ele;
            rendEle.pick(pickArea, ltw, boundingBox, retVec);
        }
    }

    @Override
    public void render(Graphics2D g) throws SVGException {
        StyleAttribute styleAttrib = new StyleAttribute(this.colorOp);
        if (this.getStyle(styleAttrib.setName("display")) && styleAttrib.getStringValue().equals("none")) {
            return;
        }
        boolean ignoreClip = this.diagram.ignoringClipHeuristic();
        this.beginLayer(g);
        Shape oldClip = g.getClip();
        Graphics2D existingG = g;
        if (this.currentMask != null) {
            Rectangle2D boundingBox = this.getBoundingBox();
            g = this.currentMask.renderToImage(g, boundingBox).createGraphics();
            g.setComposite(AlphaComposite.getInstance(5));
            g.setClip(oldClip);
        }
        for (SVGElement ele : this.children) {
            if (!(ele instanceof RenderableElement)) continue;
            RenderableElement rendEle = (RenderableElement)ele;
            if (!(ele instanceof Group) && !ignoreClip && oldClip != null && !oldClip.intersects(rendEle.getBoundingBox())) continue;
            rendEle.render(g);
        }
        if (this.currentMask != null) {
            g = existingG;
            Rectangle2D boundingBox = this.getBoundingBox();
            int x = (int)boundingBox.getX();
            int y = (int)boundingBox.getY();
            g.drawImage((Image)this.currentMask.getImage(), x, y, null);
        }
        this.finishLayer(g);
    }

    @Override
    public Shape getShape() {
        if (this.cachedShape == null) {
            this.calcShape();
        }
        return this.cachedShape;
    }

    public void calcShape() {
        Area retShape = new Area();
        for (Object aChildren : this.children) {
            ShapeElement shpEle;
            Shape shape;
            SVGElement ele = (SVGElement)aChildren;
            if (!(ele instanceof ShapeElement) || (shape = (shpEle = (ShapeElement)ele).getShape()) == null) continue;
            retShape.add(new Area(shape));
        }
        this.cachedShape = this.shapeToParent(retShape);
    }

    @Override
    public Rectangle2D getBoundingBox() throws SVGException {
        if (this.boundingBox == null) {
            this.calcBoundingBox();
        }
        return this.boundingBox;
    }

    public void calcBoundingBox() throws SVGException {
        Rectangle2D retRect = null;
        for (Object aChildren : this.children) {
            RenderableElement rendEle;
            Rectangle2D bounds;
            SVGElement ele = (SVGElement)aChildren;
            if (!(ele instanceof RenderableElement) || (bounds = (rendEle = (RenderableElement)ele).getBoundingBox()) == null || bounds.getWidth() == 0.0 && bounds.getHeight() == 0.0) continue;
            if (retRect == null) {
                retRect = bounds;
                continue;
            }
            if (retRect.getWidth() == 0.0 && retRect.getHeight() == 0.0) continue;
            retRect = retRect.createUnion(bounds);
        }
        if (retRect == null) {
            retRect = new Rectangle2D.Float();
        }
        this.boundingBox = this.boundsToParent(retRect);
    }

    @Override
    public boolean updateTime(double curTime) throws SVGException {
        boolean changeState = super.updateTime(curTime);
        for (Object aChildren : this.children) {
            SVGElement ele = (SVGElement)aChildren;
            boolean updateVal = ele.updateTime(curTime);
            boolean bl = changeState = changeState || updateVal;
            if (ele instanceof ShapeElement) {
                this.cachedShape = null;
            }
            if (!(ele instanceof RenderableElement)) continue;
            this.boundingBox = null;
        }
        return changeState;
    }
}

