/*
 * Decompiled with CFR 0.152.
 */
package com.jw;

import build.BuildConstants;
import com.aem.sdesktop.ClientBranding;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.properties.LocalProperties;
import com.aem.utils.NativeFilteringUtil;
import com.aem.utils.NativeLibraryLoader;
import com.jw.AuxConfig;
import java.net.Socket;
import jwrapper.jwutils.JWSystem;
import utils.swing.customlaf.ScalingUtil;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.switches.oem.OEMSwitches;

public class Preload {
    public Preload() {
        boolean remoteAccess = false;
        if (JWSystem.getAppBundleName().equals(BuildConstants.BUNDLE_SG_SERVICE)) {
            System.out.println("[SHPreloader] Preloading for Remote Access");
            remoteAccess = true;
        } else {
            System.out.println("[SHPreloader] Preloading for Technician");
            try {
                OEMSwitches.DARK_THEME = LocalProperties.isDarkMode();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                int scalingPercentage = LocalProperties.getScalingPercentageOverride();
                if (scalingPercentage > 0) {
                    ScalingUtil.forceScalingPercentage((int)scalingPercentage);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        System.out.println("[SHPreloader] Sockets...");
        try {
            new Socket("0.0.254.254", 10000);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.println("[SHPreloader] UI...");
        try {
            Class.forName("javax.swing.JLabel").newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.println("[SHPreloader] LNF...");
        try {
            SimpleHelpFrame.setLnf();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.out.println("[SHPreloader] Native array tests...");
        try {
            AuxConfig.initAuxDownload();
            AuxConfig.blockUntilAuxDownloaded();
            NativeLibraryLoader.loadLibrary(JWSystem.getAppFolder());
            int myNativeInstance = NativeFilteringUtil.WARNING_NEW_NATIVE_ARRAY();
            NativeFilteringUtil nuf = NativeFilteringUtil.getInstance(myNativeInstance);
            nuf.workingOK();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.println("[SHPreloader] Translations...");
        try {
            Language.loadTranslations();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.println("[SHPreloader] Branding...");
        try {
            ClientBranding.loadBrandingFromCacheDir(null);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (!remoteAccess) {
            System.out.println("[SHPreloader] Tech UI...");
            try {
                Class.forName("com.aem.shelp.tech.TechHelpUi").getDeclaredMethod("preload", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        System.out.println("[SHPreloader] Done");
    }
}

