/*
 * Decompiled with CFR 0.152.
 */
package com.grahamedgecombe.jterminal;

import com.grahamedgecombe.jterminal.TerminalModel;

public abstract class AbstractTerminalModel
implements TerminalModel {
    @Override
    public void clear() {
        int rows = this.getRows();
        int columns = this.getColumns();
        for (int column = 0; column < columns; ++column) {
            for (int row = 0; row < rows; ++row) {
                this.setCell(column, row, null);
            }
        }
    }

    @Override
    public void moveCursorBack(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        int cursorColumn = this.getCursorColumn() - n;
        if (cursorColumn < 0) {
            cursorColumn = 0;
        }
        this.setCursorColumn(cursorColumn);
    }

    @Override
    public void moveCursorForward(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        int columns = this.getColumns();
        int cursorColumn = this.getCursorColumn() + n;
        if (cursorColumn >= columns) {
            cursorColumn = columns - 1;
        }
        this.setCursorColumn(cursorColumn);
    }

    @Override
    public void moveCursorDown(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        int bufferSize = this.getBufferSize();
        int cursorRow = this.getCursorRow() + n;
        if (cursorRow >= bufferSize) {
            cursorRow = bufferSize - 1;
        }
        this.setCursorRow(cursorRow);
    }

    @Override
    public void moveCursorUp(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        int cursorRow = this.getCursorRow() - n;
        if (cursorRow < 0) {
            cursorRow = 0;
        }
        this.setCursorRow(cursorRow);
    }
}

