/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.streamenc;

import com.aem.utils.streamenc.ChunkFilter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ChunkFilterInputStream
extends InputStream {
    InputStream in;
    ChunkFilter filter;
    int cptr = 0;
    int clen = 0;
    byte[] chunk = new byte[0];

    public ChunkFilterInputStream(InputStream in, ChunkFilter filter) {
        this.in = in;
        this.filter = filter;
    }

    public ChunkFilterInputStream(InputStream in, ChunkFilter[] filters) {
        this.in = in;
        for (int i = filters.length - 1; i > 0; --i) {
            this.in = new ChunkFilterInputStream(this.in, filters[i]);
        }
        this.filter = filters[0];
    }

    @Override
    public int read() throws IOException {
        if (this.readNextChunk() == -1) {
            return -1;
        }
        return 0xFF & this.chunk[this.cptr++];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.readNextChunk() == -1) {
            return -1;
        }
        int rem_clen = this.clen - this.cptr;
        int minlen = Math.min(len, rem_clen);
        System.arraycopy(this.chunk, this.cptr, b, off, minlen);
        this.cptr += minlen;
        return minlen;
    }

    public int readNextChunk() throws IOException {
        if (this.cptr < this.clen) {
            return 0;
        }
        try {
            byte[] tmp = this.readChunk();
            if (tmp == null) {
                return -1;
            }
            while (tmp.length == 0) {
                tmp = this.readChunk();
                if (tmp != null) continue;
                return -1;
            }
            this.chunk = tmp;
            this.clen = tmp.length;
            this.cptr = 0;
            return tmp.length;
        }
        catch (EOFException e) {
            return -1;
        }
    }

    public byte[] readChunk() throws IOException {
        return this.filter.readChunk(this.in);
    }
}

