/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.multiplex;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;

public class MultiplexerByteInputStream
extends InputStream {
    public static final int INFINITE_BUF = -1;
    public static final int DEFAULT_BUF = 100000;
    private final Object datas_LOCK = new Object();
    private LinkedList<byte[]> datas = new LinkedList();
    private int lenBytes = 0;
    private byte[] curData = new byte[0];
    private int curDataPtr = 0;
    private boolean isClosed = false;
    private IOException fatalerror = null;
    private boolean waitingForData = false;
    private boolean waitingForSpace = false;
    private int maximum_buf = 100000;
    private String name = "Unknown Stream";
    private boolean verboseMaxouts = false;

    public void setName(String name) {
        this.name = name;
    }

    public MultiplexerByteInputStream() {
    }

    public MultiplexerByteInputStream(int maximum_buffer, boolean verboseMaxouts) {
        this.maximum_buf = maximum_buffer;
        this.verboseMaxouts = verboseMaxouts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length() {
        Object object = this.datas_LOCK;
        synchronized (object) {
            return this.lenBytes + (this.curData.length - this.curDataPtr);
        }
    }

    private void waitUntilData() {
        while (this.lenBytes <= 0 && !this.isClosed) {
            try {
                this.waitingForData = true;
                this.datas_LOCK.wait();
                this.waitingForData = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosed() {
        this.isClosed = true;
        Object object = this.datas_LOCK;
        synchronized (object) {
            if (this.waitingForData) {
                this.datas_LOCK.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosed(IOException t) {
        this.isClosed = true;
        this.fatalerror = t;
        Object object = this.datas_LOCK;
        synchronized (object) {
            if (this.waitingForData) {
                this.datas_LOCK.notifyAll();
            }
        }
    }

    private void throwError() throws IOException {
        if (this.fatalerror != null) {
            throw new IOException(this.fatalerror.getMessage(), this.fatalerror);
        }
    }

    @Override
    public int read() throws IOException {
        byte[] dat = new byte[1];
        while (this.read(dat) == 0) {
        }
        return 0xFF & dat[0];
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int length) throws IOException {
        Object object = this.datas_LOCK;
        synchronized (object) {
            if (this.isClosed && this.lenBytes == 0) {
                this.throwError();
                return -1;
            }
            this.fetchData();
            if (this.isClosed && this.lenBytes == 0) {
                this.throwError();
                return -1;
            }
            int tmplen = this.curData.length - this.curDataPtr;
            if (tmplen <= length) {
                System.arraycopy(this.curData, this.curDataPtr, b, off, tmplen);
                this.curDataPtr += tmplen;
                return tmplen;
            }
            System.arraycopy(this.curData, this.curDataPtr, b, off, length);
            this.curDataPtr += length;
            return length;
        }
    }

    private void fetchData() {
        if (this.curDataPtr >= this.curData.length) {
            this.waitUntilData();
            if (!this.isClosed || this.lenBytes > 0) {
                this.curData = this.datas.removeFirst();
                this.lenBytes -= this.curData.length;
                this.curDataPtr = 0;
            }
            if (this.waitingForSpace) {
                this.datas_LOCK.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addData(byte[] dat) {
        if (dat.length > 0) {
            Object object = this.datas_LOCK;
            synchronized (object) {
                while (dat.length + this.lenBytes + (this.curData.length - this.curDataPtr) > this.maximum_buf && this.lenBytes > 0 && this.maximum_buf >= 0) {
                    this.waitingForSpace = true;
                    try {
                        if (this.verboseMaxouts) {
                            System.out.println("*********** InBuffer waiting for space (" + this.name + ") ************");
                        }
                        this.datas_LOCK.wait();
                        if (this.verboseMaxouts) {
                            System.out.println("*********** InBuffer started again (" + this.name + ") ************");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.waitingForSpace = false;
                }
                this.datas.addLast(dat);
                this.lenBytes += dat.length;
                if (this.waitingForData) {
                    this.datas_LOCK.notify();
                }
            }
        }
    }
}

