/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.gui.verifiers;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class CharacterSubSetDocument
extends PlainDocument {
    private char[] allowedCharacters;

    public CharacterSubSetDocument() {
        this(new char[0]);
    }

    public CharacterSubSetDocument(char[] allowedCharacters) {
        this.allowedCharacters = allowedCharacters;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            return;
        }
        char[] addedFigures = str.toCharArray();
        for (int i = addedFigures.length; i > 0; --i) {
            char c = addedFigures[i - 1];
            if (!this.include(c)) continue;
            super.insertString(offs, new String(new Character(c).toString()), a);
        }
    }

    protected boolean include(char c) {
        for (char cc : this.allowedCharacters) {
            if (cc != c) continue;
            return true;
        }
        return false;
    }
}

