/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.authentication;

import com.aem.utils.authentication.AuthenticationResult;
import com.aem.utils.authentication.RadiusAuthenticationRequest;
import com.aem.utils.authentication.ServerAuthenticationHandler;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.PAPAuthenticator;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.dictionary.Attr_NASPort;
import net.jradius.dictionary.Attr_UserName;
import net.jradius.dictionary.Attr_UserPassword;
import net.jradius.exception.RadiusException;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessChallenge;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.RadiusRequest;
import net.jradius.packet.RadiusResponse;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import utils.radius.ChallengeCapable;
import utils.radius.SHEAPTLSAuthenticator;
import utils.radius.SHEAPTTLSAuthenticator;
import utils.radius.SHPEAPAuthenticator;
import utils.radius.SHPapAuthenticator;
import utils.radius.TestLoginChallengeHandler;
import utils.switches.Switches;

public class SHRadiusAuthenticator {
    private static final Object LOAD_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AuthenticationResult authenticate(final int index, final RadiusAuthenticationRequest authenticationRequest) throws IOException, RadiusException, ServerAuthenticationHandler.CancelledException {
        RadiusAuthenticator authenticator = RadiusClient.getAuthProtocol((String)authenticationRequest.authenticationProtocol);
        System.out.println("[SHRadiusAuthenticator][" + index + "] Resolving hostname " + authenticationRequest.hostname);
        InetAddress addr = InetAddress.getByName(authenticationRequest.hostname);
        Object object = LOAD_LOCK;
        synchronized (object) {
            System.out.println("[SHRadiusAuthenticator][" + index + "] Loading attribute dictionary");
            AttributeFactory.loadAttributeDictionary((String)"net.jradius.dictionary.AttributeDictionaryImpl");
        }
        System.out.println("[SHRadiusAuthenticator][" + index + "] Creating Radius Client (" + addr + ", " + authenticationRequest.port + ")");
        try (RadiusClient radiusClient = new RadiusClient(addr, authenticationRequest.secret, authenticationRequest.port, 1813, (int)(authenticationRequest.timeoutMS / 1000L)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public RadiusResponse authenticate(AccessRequest p, RadiusAuthenticator auth, int retries) throws RadiusException {
                if (auth == null) {
                    auth = new PAPAuthenticator();
                }
                auth.setupRequest((RadiusClient)this, (RadiusPacket)p);
                auth.processRequest((RadiusPacket)p);
                while (true) {
                    RadiusResponse reply = this.transport.sendReceive((RadiusRequest)p, retries);
                    System.out.println("[SHRadiusAuthenticator][" + index + "] Received a reply of " + reply);
                    Object object = authenticationRequest.requestSempahore.finishedLock;
                    synchronized (object) {
                        if (!authenticationRequest.connected) {
                            if (authenticationRequest.requestSempahore.cancel) {
                                System.out.println("[SHRadiusAuthenticator][" + index + "] Returning as another request worked");
                                return null;
                            }
                            authenticationRequest.connected = true;
                            authenticationRequest.requestSempahore.cancel = true;
                        }
                    }
                    if (!(reply instanceof AccessChallenge)) {
                        return reply;
                    }
                    System.out.println("[SHRadiusAuthenticator][" + index + "] Received a challenge to handle");
                    authenticationRequest.challengeRequested = true;
                    if (authenticationRequest.challengeHandler instanceof TestLoginChallengeHandler) {
                        return new AccessAccept();
                    }
                    if (auth instanceof ChallengeCapable) {
                        ((ChallengeCapable)auth).processChallenge((RadiusPacket)p, (RadiusPacket)reply, authenticationRequest.challengeHandler);
                        continue;
                    }
                    auth.processChallenge((RadiusPacket)p, (RadiusPacket)reply);
                }
            }
        };){
            AttributeList attributeList = new AttributeList();
            attributeList.add((RadiusAttribute)new Attr_UserName((Serializable)((Object)authenticationRequest.username)));
            attributeList.add((RadiusAttribute)new Attr_NASPort((Serializable)Long.valueOf(1L)));
            AccessRequest request = new AccessRequest(radiusClient, attributeList);
            request.addAttribute((RadiusAttribute)new Attr_UserPassword((Serializable)((Object)authenticationRequest.password)));
            System.out.println("[SHRadiusAuthenticator][" + index + "] Attempting to authenticate " + authenticationRequest.username);
            RadiusResponse reply = radiusClient.authenticate(request, authenticator, authenticationRequest.numberOfRetries);
            if (reply == null) {
                System.out.println("[SHRadiusAuthenticator][" + index + "] This authenticator was cancelled.");
                throw new ServerAuthenticationHandler.CancelledException();
            }
            String message = null;
            Object replyValue = reply.getAttributeValue("Reply-Message");
            if (replyValue != null) {
                message = String.valueOf(replyValue);
            }
            if (reply.getCode() == 2) {
                System.out.println("[SHRadiusAuthenticator][" + index + "] RADIUS produced an AccessAccept reply");
                AuthenticationResult authenticationResult = new AuthenticationResult(true);
                return authenticationResult;
            }
            if (reply.getCode() == 3) {
                System.out.println("[SHRadiusAuthenticator][" + index + "] RADIUS produced an AccessReject reply (reason: " + message + ")");
                AuthenticationResult authenticationResult = new AuthenticationResult(message, authenticationRequest.challengeRequested);
                return authenticationResult;
            }
        }
        return new AuthenticationResult(false);
    }

    static {
        if (Switches.SLB_radiusChallengeSupport) {
            RadiusClient.registerAuthenticator((String)"pap", SHPapAuthenticator.class);
        }
        RadiusClient.registerAuthenticator((String)"eap-ttls", SHEAPTTLSAuthenticator.class);
        RadiusClient.registerAuthenticator((String)"eap-tls", SHEAPTLSAuthenticator.class);
        RadiusClient.registerAuthenticator((String)"peap", SHPEAPAuthenticator.class);
    }
}

