/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils.authentication;

import com.aem.utils.authentication.AuthenticationRequest;
import com.aem.utils.authentication.AuthenticationResult;
import com.aem.utils.authentication.SHRadiusAuthenticator;
import com.aem.utils.authentication.SHRadiusSimulator;
import com.aem.utils.authentication.ServerAuthenticationHandler;
import net.jradius.exception.TimeoutException;
import utils.radius.ChallengeHandler;

public class RadiusAuthenticationRequest
extends AuthenticationRequest {
    private final int index;
    private final boolean simulateServer;
    public final int numberOfRetries;
    public final long timeoutMS;
    public String authenticationProtocol;
    public String hostname;
    public int port;
    public String secret;
    public ChallengeHandler challengeHandler;
    public boolean challengeRequested = false;

    public RadiusAuthenticationRequest(int index, AuthenticationRequest.RequestSempahore finishedLock, int numberOfRetries, long timeoutMS, boolean simulateServer) {
        super(finishedLock);
        this.index = index;
        this.numberOfRetries = numberOfRetries;
        this.timeoutMS = timeoutMS;
        this.simulateServer = simulateServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthenticationResult authenticate() throws Exception {
        try {
            if (!this.simulateServer) {
                AuthenticationResult authenticationResult = SHRadiusAuthenticator.authenticate(this.index, this);
                return authenticationResult;
            }
            AuthenticationResult authenticationResult = SHRadiusSimulator.authenticate(this);
            return authenticationResult;
        }
        catch (Exception t) {
            if (t instanceof TimeoutException) {
                ServerAuthenticationHandler.ServerConnectException ex = new ServerAuthenticationHandler.ServerConnectException(t.getMessage());
                ex.initCause(t);
                throw ex;
            }
            throw t;
        }
        finally {
            if (this.requestSempahore != null) {
                Object object = this.requestSempahore.finishedLock;
                synchronized (object) {
                    this.requestSempahore.finishedLock.notify();
                }
            }
        }
    }
}

