/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public class StreamUtils {
    private static final byte CLASS_INT = 0;
    private static final byte CLASS_LONG = 1;
    private static final byte CLASS_BOOLEAN = 3;
    private static final byte CLASS_DOUBLE = 4;
    private static final byte CLASS_FLOAT = 5;
    private static final byte CLASS_COLLECTION = 6;
    private static final byte CLASS_STRING = 7;
    private static final byte CLASS_CHAR = 8;

    public static String readLine(InputStream in, String encoding) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int last = -1;
        int c = in.read();
        if (c == -1) {
            throw new EOFException("End of stream");
        }
        while (c != 10 && c != -1) {
            if (last != -1) {
                bout.write(last);
            }
            last = c;
            c = in.read();
        }
        if (last != -1 && last != 13) {
            bout.write(last);
        }
        if (encoding == null) {
            return new String(bout.toByteArray());
        }
        return new String(bout.toByteArray(), encoding);
    }

    public static String readLine(InputStream in) throws IOException {
        return StreamUtils.readLine(in, null);
    }

    public static Object readObjectUTF8(InputStream in) throws Exception {
        String claz = StreamUtils.readStringUTF8(in);
        Class<?> clazz = Class.forName(claz);
        Object o = clazz.newInstance();
        int fieldcount = StreamUtils.readInt(in);
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fieldcount; ++i) {
            String colname;
            byte fclaz;
            int tmp;
            String fname = StreamUtils.readStringUTF8(in);
            Field field = null;
            for (int f = 0; f < fields.length; ++f) {
                if (!fields[f].getName().equals(fname)) continue;
                field = fields[f];
                break;
            }
            if (field == null) {
                System.out.println("Field " + fname + " not found");
                tmp = in.read();
                if (tmp == -1) {
                    throw new EOFException("End of stream");
                }
                fclaz = (byte)tmp;
                if (fclaz == 0) {
                    StreamUtils.readInt(in);
                    continue;
                }
                if (fclaz == 1) {
                    StreamUtils.readLong(in);
                    continue;
                }
                if (fclaz == 3) {
                    StreamUtils.readBoolean(in);
                    continue;
                }
                if (fclaz == 4) {
                    StreamUtils.readDouble(in);
                    continue;
                }
                if (fclaz == 5) {
                    StreamUtils.readFloat(in);
                    continue;
                }
                if (fclaz == 8) {
                    StreamUtils.readChar(in);
                    continue;
                }
                if (fclaz == 7) {
                    StreamUtils.readStringUTF8(in);
                    continue;
                }
                if (fclaz == 6) {
                    colname = StreamUtils.readStringUTF8(in);
                    int colsiz = StreamUtils.readInt(in);
                    for (int z = 0; z < colsiz; ++z) {
                        StreamUtils.readStringUTF8(in);
                    }
                    continue;
                }
                throw new IllegalArgumentException("Field class " + fclaz + " not supported");
            }
            field.setAccessible(true);
            tmp = in.read();
            if (tmp == -1) {
                throw new EOFException("End of stream");
            }
            fclaz = (byte)tmp;
            try {
                if (fclaz == 0) {
                    field.setInt(o, StreamUtils.readInt(in));
                    continue;
                }
                if (fclaz == 1) {
                    field.setLong(o, StreamUtils.readLong(in));
                    continue;
                }
                if (fclaz == 3) {
                    field.setBoolean(o, StreamUtils.readBoolean(in));
                    continue;
                }
                if (fclaz == 4) {
                    field.setDouble(o, StreamUtils.readDouble(in));
                    continue;
                }
                if (fclaz == 5) {
                    field.setFloat(o, StreamUtils.readFloat(in));
                    continue;
                }
                if (fclaz == 8) {
                    field.setChar(o, StreamUtils.readChar(in));
                    continue;
                }
                if (fclaz == 7) {
                    field.set(o, StreamUtils.readStringUTF8(in));
                    continue;
                }
                if (fclaz == 6) {
                    colname = StreamUtils.readStringUTF8(in);
                    Class<?> colclazz = Class.forName(colname);
                    Collection col = (Collection)colclazz.newInstance();
                    int colsiz = StreamUtils.readInt(in);
                    for (int z = 0; z < colsiz; ++z) {
                        col.add(StreamUtils.readStringUTF8(in));
                    }
                    field.set(o, col);
                    continue;
                }
                throw new IllegalArgumentException("Field class " + fclaz + " not supported");
            }
            catch (IllegalArgumentException x) {
                System.out.println("Field " + fname + " wrong type");
            }
        }
        return o;
    }

    public static void writeObject(OutputStream out, Object o) throws Exception {
        String claz = o.getClass().getName();
        StreamUtils.writeStringUTF8(out, claz);
        Class<?> clazz = o.getClass();
        Field[] fields = clazz.getDeclaredFields();
        StreamUtils.writeInt(out, fields.length);
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setAccessible(true);
            String fname = fields[i].getName();
            StreamUtils.writeStringUTF8(out, fname);
            Class<?> fclazz = fields[i].getType();
            if (fclazz == Integer.TYPE) {
                out.write(0);
                StreamUtils.writeInt(out, fields[i].getInt(o));
                continue;
            }
            if (fclazz == Long.TYPE) {
                out.write(1);
                StreamUtils.writeLong(out, fields[i].getLong(o));
                continue;
            }
            if (fclazz == Boolean.TYPE) {
                out.write(3);
                StreamUtils.writeBoolean(out, fields[i].getBoolean(o));
                continue;
            }
            if (fclazz == Double.TYPE) {
                out.write(4);
                StreamUtils.writeDouble(out, fields[i].getDouble(o));
                continue;
            }
            if (fclazz == Float.TYPE) {
                out.write(5);
                StreamUtils.writeFloat(out, fields[i].getFloat(o));
                continue;
            }
            if (fclazz == Character.TYPE) {
                out.write(8);
                StreamUtils.writeChar(out, fields[i].getChar(o));
                continue;
            }
            if (fclazz == String.class) {
                out.write(7);
                String s = (String)fields[i].get(o);
                StreamUtils.writeStringUTF8(out, s);
                continue;
            }
            if (Collection.class.isAssignableFrom(fclazz)) {
                out.write(6);
                StreamUtils.writeStringUTF8(out, fclazz.getName());
                Collection col = (Collection)fields[i].get(o);
                StreamUtils.writeInt(out, col.size());
                for (String s : col) {
                    StreamUtils.writeStringUTF8(out, s);
                }
                continue;
            }
            throw new IllegalArgumentException("Field class " + fclazz + " not supported");
        }
    }

    public static String readAllAsStringISO88951(InputStream in) throws IOException {
        byte[] dat = StreamUtils.readAll(in);
        return new String(dat, 0, dat.length, StandardCharsets.ISO_8859_1);
    }

    public static String readAllAsStringUTF8(InputStream in) throws IOException {
        byte[] dat = StreamUtils.readAll(in);
        return new String(dat, 0, dat.length, StandardCharsets.UTF_8);
    }

    public static String readAllAsStringUTF16(InputStream in) throws IOException {
        byte[] dat = StreamUtils.readAll(in);
        return new String(dat, 0, dat.length, StandardCharsets.UTF_16LE);
    }

    public static byte[] readAll(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[65536];
        int n = 0;
        while (n != -1) {
            n = in.read(buf, 0, 65536);
            if (n <= 0) continue;
            bout.write(buf, 0, n);
        }
        return bout.toByteArray();
    }

    public static byte[] readAllAvailable(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[65536];
        int n = 0;
        try {
            while (n != -1) {
                n = in.read(buf, 0, 65536);
                if (n <= 0) continue;
                bout.write(buf, 0, n);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return bout.toByteArray();
    }

    public static void writeBytes(OutputStream out, byte[] b) throws IOException {
        StreamUtils.writeInt(out, b.length);
        out.write(b, 0, b.length);
    }

    public static void writeBytes(OutputStream out, byte[] b, int off, int len) throws IOException {
        StreamUtils.writeInt(out, len);
        out.write(b, off, len);
    }

    public static void writeStringISO88591(OutputStream out, String n) throws IOException {
        StreamUtils.writeBytes(out, n.getBytes(StandardCharsets.ISO_8859_1));
    }

    public static void writeStringUTF8(OutputStream out, String n) throws IOException {
        StreamUtils.writeBytes(out, n.getBytes(StandardCharsets.UTF_8));
    }

    public static void writeStringISO88591WithoutSize(OutputStream out, String n) throws IOException {
        out.write(n.getBytes(StandardCharsets.ISO_8859_1));
    }

    public static void writeStringUTF8WithoutSize(OutputStream out, String n) throws IOException {
        out.write(n.getBytes(StandardCharsets.UTF_8));
    }

    public static void writeLong(OutputStream out, long n) throws IOException {
        out.write((byte)(n >>> 56));
        out.write((byte)(n >>> 48));
        out.write((byte)(n >>> 40));
        out.write((byte)(n >>> 32));
        out.write((byte)(n >>> 24));
        out.write((byte)(n >>> 16));
        out.write((byte)(n >>> 8));
        out.write((byte)n);
    }

    public static void writeDouble(OutputStream out, double n) throws IOException {
        StreamUtils.writeLong(out, Double.doubleToLongBits(n));
    }

    public static void writeInt(OutputStream out, int n) throws IOException {
        out.write((byte)(n >>> 24));
        out.write((byte)(n >>> 16));
        out.write((byte)(n >>> 8));
        out.write((byte)n);
    }

    public static void writeRgbOnlyInt(OutputStream out, int n) throws IOException {
        out.write((byte)(n >>> 16));
        out.write((byte)(n >>> 8));
        out.write((byte)n);
    }

    public static void writeFloat(OutputStream out, float n) throws IOException {
        StreamUtils.writeInt(out, Float.floatToIntBits(n));
    }

    public static void writeShort(OutputStream out, short n) throws IOException {
        out.write((byte)(n >>> 8));
        out.write((byte)n);
    }

    public static void writeChar(OutputStream out, char v) throws IOException {
        out.write((byte)(0xFF & v >> 8));
        out.write((byte)(0xFF & v));
    }

    public static void writeBoolean(OutputStream out, boolean n) throws IOException {
        if (n) {
            out.write(255);
        } else {
            out.write(238);
        }
    }

    public static byte[] readBytes(InputStream in, int len) throws IOException {
        byte[] b = new byte[len];
        int red = 0;
        for (int tot = 0; tot < len; tot += red) {
            red = in.read(b, tot, len - tot);
            if (red != -1) continue;
            throw new EOFException("End of stream");
        }
        return b;
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        int len = StreamUtils.readInt(in);
        if (len < 0) {
            throw new IOException("Invalid byte array size on stream readBytes: " + len + " (" + Integer.toHexString(len) + ")");
        }
        byte[] b = new byte[len];
        int red = 0;
        for (int tot = 0; tot < len; tot += red) {
            red = in.read(b, tot, len - tot);
            if (red != -1) continue;
            throw new EOFException("End of stream");
        }
        return b;
    }

    public static String readStringISO88591(InputStream in) throws IOException {
        return new String(StreamUtils.readBytes(in), StandardCharsets.ISO_8859_1);
    }

    public static String readStringUTF8(InputStream in) throws IOException {
        return new String(StreamUtils.readBytes(in), StandardCharsets.UTF_8);
    }

    public static byte[] readNBytes(InputStream in, int maxlen) throws IOException {
        int len = StreamUtils.readInt(in);
        if (len < 0) {
            throw new IOException("Invalid data length specified (" + len + ")");
        }
        if (len > maxlen) {
            throw new IOException("Unsafe data length specified (" + len + ")");
        }
        byte[] b = new byte[len];
        int red = 0;
        for (int tot = 0; tot < len; tot += red) {
            red = in.read(b, tot, len - tot);
            if (red != -1) continue;
            throw new EOFException("End of stream");
        }
        return b;
    }

    public static String readNStringISO88591(InputStream in, int maxlen) throws IOException {
        return new String(StreamUtils.readNBytes(in, maxlen), StandardCharsets.ISO_8859_1);
    }

    public static String readNStringUTF8(InputStream in, int maxlen) throws IOException {
        return new String(StreamUtils.readNBytes(in, maxlen), StandardCharsets.UTF_8);
    }

    public static long readLong(InputStream in) throws IOException {
        long n = 0L;
        int r = 0;
        for (int i = 0; i < 8; ++i) {
            r = in.read();
            if (r == -1) {
                throw new EOFException("End of stream");
            }
            n = n << 8 | (long)r;
        }
        return n;
    }

    public static double readDouble(InputStream in) throws IOException {
        long l = StreamUtils.readLong(in);
        return Double.longBitsToDouble(l);
    }

    public static int readInt(InputStream in) throws IOException {
        int n = 0;
        int r = 0;
        for (int i = 0; i < 4; ++i) {
            r = in.read();
            if (r == -1) {
                throw new EOFException("End of stream");
            }
            n = n << 8 | r;
        }
        return n;
    }

    public static int readRgbOnlyInt(InputStream in) throws IOException {
        int n = -1;
        int r = 0;
        for (int i = 0; i < 3; ++i) {
            r = in.read();
            if (r == -1) {
                throw new EOFException("End of stream");
            }
            n = n << 8 | r;
        }
        return n;
    }

    public static float readFloat(InputStream in) throws IOException {
        int i = StreamUtils.readInt(in);
        return Float.intBitsToFloat(i);
    }

    public static short readShort(InputStream in) throws IOException {
        short n = 0;
        int r = 0;
        for (int i = 0; i < 2; ++i) {
            r = in.read();
            if (r == -1) {
                throw new EOFException("End of stream");
            }
            n = (short)(n << 8 | r);
        }
        return n;
    }

    public static char readChar(InputStream in) throws IOException {
        int a = in.read();
        int b = in.read();
        if (a == -1 || b == -1) {
            throw new EOFException("End of stream");
        }
        return (char)(a << 8 | b & 0xFF);
    }

    public static boolean readBoolean(InputStream in) throws IOException {
        int n = in.read();
        if (n == -1) {
            throw new EOFException("End of stream");
        }
        return n == 255;
    }

    public static void readAllAndDispose(InputStream in) throws IOException {
        byte[] buf = new byte[65536];
        int n = 0;
        while (n != -1) {
            n = in.read(buf, 0, 65536);
        }
    }
}

