/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class FileCopyUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File dest) throws IOException {
        if (!dest.exists()) {
            dest.createNewFile();
        }
        FileInputStream in = null;
        OutputStream out = null;
        try {
            int len;
            in = new FileInputStream(source);
            out = new FileOutputStream(dest);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static void copyFile(String file, String src, String dest) throws IOException {
        FileCopyUtil.copyFile(file, new File(src), new File(dest));
    }

    public static void copyFile(String file, File src, File dest) throws IOException {
        dest.mkdirs();
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            fin = new FileInputStream(new File(src, file));
            fout = new FileOutputStream(new File(dest, file));
            byte[] buf = new byte[75000];
            int n = 0;
            while (n != -1) {
                n = fin.read(buf);
                if (n <= 0) continue;
                fout.write(buf, 0, n);
            }
            fin.close();
            fout.close();
        }
        catch (Exception e) {
            try {
                fin.close();
            }
            catch (Exception n) {
                // empty catch block
            }
            try {
                fout.close();
            }
            catch (Exception n) {
                // empty catch block
            }
            IOException ex = new IOException("Failed to transfer " + file + " from " + src + " to " + dest);
            ex.initCause(e);
            throw ex;
        }
    }

    public static void copyFile(String file, String targetFileName, File src, File dest) throws IOException {
        dest.mkdirs();
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            fin = new FileInputStream(new File(src, file));
            fout = new FileOutputStream(new File(dest, targetFileName));
            byte[] buf = new byte[75000];
            int n = 0;
            while (n != -1) {
                n = fin.read(buf);
                if (n <= 0) continue;
                fout.write(buf, 0, n);
            }
            fin.close();
            fout.close();
        }
        catch (Exception e) {
            try {
                fin.close();
            }
            catch (Exception n) {
                // empty catch block
            }
            try {
                fout.close();
            }
            catch (Exception n) {
                // empty catch block
            }
            IOException ex = new IOException("Failed to transfer " + file + " from " + src + " to " + targetFileName + " in " + dest);
            ex.initCause(e);
            throw ex;
        }
    }

    public static void storeBytesToFile(byte[] dat, String targetFileName, String targetDirectory) throws IOException {
        new File(targetDirectory).mkdirs();
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(targetDirectory + File.separator + targetFileName);
            fout.write(dat, 0, dat.length);
            fout.close();
        }
        catch (Exception e) {
            try {
                fout.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            IOException ex = new IOException("Failed to store " + targetFileName + " in " + targetDirectory);
            ex.initCause(e);
            throw ex;
        }
    }

    public static boolean removeDirectory(File directory) {
        if (directory == null) {
            return false;
        }
        if (!directory.exists()) {
            return true;
        }
        if (!directory.isDirectory()) {
            return false;
        }
        String[] list = directory.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                File entry = new File(directory, list[i]);
                if (!(entry.isDirectory() ? !FileCopyUtil.removeDirectory(entry) : !entry.delete())) continue;
                return false;
            }
        }
        return directory.delete();
    }

    public static void fastCopyFiles(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                FileCopyUtil.fastCopyFiles(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else {
            FileCopyUtil.fastCopyFile(sourceLocation, targetLocation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fastCopyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }
}

