/*
 * Decompiled with CFR 0.152.
 */
package com.aem.utils;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;

public final class BMPFile {
    private static final int BITMAPFILEHEADER_SIZE = 14;
    private static final int BITMAPINFOHEADER_SIZE = 40;
    private static byte[] bitmapFileHeader = new byte[14];
    private static byte[] bfType = new byte[]{66, 77};
    private static int bfSize = 0;
    private static int bfReserved1 = 0;
    private static int bfReserved2 = 0;
    private static int bfOffBits = 54;
    private static byte[] bitmapInfoHeader = new byte[40];
    private static int biSize = 40;
    private static int biWidth = 0;
    private static int biHeight = 0;
    private static int biPlanes = 1;
    private static int biBitCount = 24;
    private static int biCompression = 0;
    private static int biSizeImage = 196608;
    private static int biXPelsPerMeter = 0;
    private static int biYPelsPerMeter = 0;
    private static int biClrUsed = 0;
    private static int biClrImportant = 0;
    private static int[] bitmap;
    private static OutputStream fo;

    public static synchronized void saveBitmap(String file, Image parImage, int parWidth, int parHeight) {
        try {
            fo = new BufferedOutputStream(new FileOutputStream(file));
            BMPFile.save(parImage, parWidth, parHeight);
            fo.close();
        }
        catch (Exception saveEx) {
            saveEx.printStackTrace();
        }
    }

    private static void save(Image parImage, int parWidth, int parHeight) {
        try {
            BMPFile.convertImage(parImage, parWidth, parHeight);
            BMPFile.writeBitmapFileHeader();
            BMPFile.writeBitmapInfoHeader();
            BMPFile.writeBitmap();
        }
        catch (Exception saveEx) {
            saveEx.printStackTrace();
        }
    }

    private static boolean convertImage(Image parImage, int parWidth, int parHeight) {
        bitmap = new int[parWidth * parHeight];
        PixelGrabber pg = new PixelGrabber(parImage, 0, 0, parWidth, parHeight, bitmap, 0, parWidth);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return false;
        }
        int pad = (4 - parWidth * 3 % 4) * parHeight;
        biSizeImage = parWidth * parHeight * 3 + pad;
        bfSize = biSizeImage + 14 + 40;
        biWidth = parWidth;
        biHeight = parHeight;
        return true;
    }

    private static void writeBitmap() {
        int rowIndex;
        byte[] rgb = new byte[3];
        int size = biWidth * biHeight - 1;
        int pad = 4 - biWidth * 3 % 4;
        if (pad == 4) {
            pad = 0;
        }
        int rowCount = 1;
        int padCount = 0;
        int lastRowIndex = rowIndex = size - biWidth;
        try {
            for (int j = 0; j < size; ++j) {
                int value = bitmap[rowIndex];
                rgb[0] = (byte)(value & 0xFF);
                rgb[1] = (byte)(value >> 8 & 0xFF);
                rgb[2] = (byte)(value >> 16 & 0xFF);
                fo.write(rgb);
                if (rowCount == biWidth) {
                    padCount += pad;
                    for (int i = 1; i <= pad; ++i) {
                        fo.write(0);
                    }
                    rowCount = 1;
                    lastRowIndex = rowIndex = lastRowIndex - biWidth;
                } else {
                    ++rowCount;
                }
                ++rowIndex;
            }
            bfSize += padCount - pad;
            biSizeImage += padCount - pad;
        }
        catch (Exception wb) {
            wb.printStackTrace();
        }
    }

    private static void writeBitmapFileHeader() {
        try {
            fo.write(bfType);
            fo.write(BMPFile.intToDWord(bfSize));
            fo.write(BMPFile.intToWord(bfReserved1));
            fo.write(BMPFile.intToWord(bfReserved2));
            fo.write(BMPFile.intToDWord(bfOffBits));
        }
        catch (Exception wbfh) {
            wbfh.printStackTrace();
        }
    }

    private static void writeBitmapInfoHeader() {
        try {
            fo.write(BMPFile.intToDWord(biSize));
            fo.write(BMPFile.intToDWord(biWidth));
            fo.write(BMPFile.intToDWord(biHeight));
            fo.write(BMPFile.intToWord(biPlanes));
            fo.write(BMPFile.intToWord(biBitCount));
            fo.write(BMPFile.intToDWord(biCompression));
            fo.write(BMPFile.intToDWord(biSizeImage));
            fo.write(BMPFile.intToDWord(biXPelsPerMeter));
            fo.write(BMPFile.intToDWord(biYPelsPerMeter));
            fo.write(BMPFile.intToDWord(biClrUsed));
            fo.write(BMPFile.intToDWord(biClrImportant));
        }
        catch (Exception wbih) {
            wbih.printStackTrace();
        }
    }

    private static byte[] intToWord(int parValue) {
        byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF)};
        return retValue;
    }

    private static byte[] intToDWord(int parValue) {
        byte[] retValue = new byte[]{(byte)(parValue & 0xFF), (byte)(parValue >> 8 & 0xFF), (byte)(parValue >> 16 & 0xFF), (byte)(parValue >> 24 & 0xFF)};
        return retValue;
    }
}

