/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util.notifications;

import com.aem.shelp.common.Language;
import com.aem.utils.DropDownComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.glassdialog.NarrowOptionPane;
import utils.swing.images.ImageLoader;
import utils.switches.oem.OEMSwitches;

public class NotificationPanel
extends DropDownComponent {
    private Color backgroundColor = SHStyle.PANEL_BACKGROUND_DARK;
    private Color borderColor = Color.GRAY;
    private int defaultWidth = -1;
    private static final int MAX_JOPTIONPANE_WIDTH = SimpleHelpLookAndFeel.scale((int)500);

    public NotificationPanel(JComponent contentPanel) {
        super(contentPanel);
    }

    public void setDefaultWidth(int width) {
        this.defaultWidth = width;
    }

    public void setBackground(Color c) {
        this.backgroundColor = c;
    }

    public void showYesNoQuestion(String title, String message, NotificationPanelListener listener, boolean allowCancelButton) {
        NarrowOptionPane pane = new NarrowOptionPane(message, 3, 0, ImageLoader.getImageIcon((String)"images/svg/dialogs/question.svg,48"), new String[]{Language.get("YES"), Language.get("NO")});
        JPanel wrapper = this.getJOptionPaneWrapper(pane);
        this.showMessage(title, wrapper, ImageLoader.getImageIcon((String)"images/svg/dialogs/question.svg,16"), listener, allowCancelButton);
    }

    public void showYesNoWarning(String title, String message, NotificationPanelListener listener, boolean allowCancelButton) {
        NarrowOptionPane pane = new NarrowOptionPane(message, 2, 0, ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"), new String[]{Language.get("YES"), Language.get("NO")});
        JPanel wrapper = this.getJOptionPaneWrapper(pane);
        this.showMessage(title, wrapper, ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"), listener, allowCancelButton);
    }

    public DropDownComponent.Notification showYesNoWarning(String title, String message, NotificationPanelListener listener, boolean allowCancelButton, String okText, String cancelText) {
        NarrowOptionPane pane = new NarrowOptionPane(message, 2, 0, ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"), new String[]{okText, cancelText});
        JPanel wrapper = this.getJOptionPaneWrapper(pane);
        return this.showMessage(title, wrapper, ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"), listener, allowCancelButton);
    }

    public void showYesNoError(String title, String message, NotificationPanelListener listener, boolean allowCancelButton) {
        NarrowOptionPane pane = new NarrowOptionPane(message, 0, 0, ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), new String[]{Language.get("YES"), Language.get("NO")});
        JPanel wrapper = this.getJOptionPaneWrapper(pane);
        this.showMessage(title, wrapper, ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,16"), listener, allowCancelButton);
    }

    public void showYesNoInformation(String title, String message, NotificationPanelListener listener, boolean allowCancelButton) {
        NarrowOptionPane pane = new NarrowOptionPane(message, 1, 0, ImageLoader.getImageIcon((String)"images/svg/dialogs/information.svg,48"), new String[]{Language.get("YES"), Language.get("NO")});
        JPanel wrapper = this.getJOptionPaneWrapper(pane);
        this.showMessage(title, wrapper, ImageLoader.getImageIcon((String)"images/svg/dialogs/information.svg,16"), listener, allowCancelButton);
    }

    public void showOkInformation(String title, String message, NotificationPanelListener listener, boolean allowCancelButton) {
        NarrowOptionPane pane = new NarrowOptionPane(message, 1, 0, ImageLoader.getImageIcon((String)"images/svg/dialogs/information.svg,48"), new String[]{Language.get("OK")});
        JPanel wrapper = this.getJOptionPaneWrapper(pane);
        this.showMessage(title, wrapper, ImageLoader.getImageIcon((String)"images/svg/dialogs/information.svg,16"), listener, allowCancelButton);
    }

    public void showOkError(String title, String message, NotificationPanelListener listener, boolean allowCancelButton) {
        NarrowOptionPane pane = new NarrowOptionPane(message, 0, 0, ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), new String[]{Language.get("OK")});
        JPanel wrapper = this.getJOptionPaneWrapper(pane);
        this.showMessage(title, wrapper, ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,16"), listener, allowCancelButton);
    }

    public void showOkWarning(String title, String message, NotificationPanelListener listener, boolean allowCancelButton) {
        this.showOkWarning(title, message, listener, allowCancelButton, Language.get("OK"));
    }

    public void showOkWarning(String title, String message, NotificationPanelListener listener, boolean allowCancelButton, String okText) {
        NarrowOptionPane pane = new NarrowOptionPane(message, 2, 0, ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"), new String[]{okText});
        JPanel wrapper = this.getJOptionPaneWrapper(pane);
        this.showMessage(title, wrapper, ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"), listener, allowCancelButton);
    }

    private void setBackgroundForAll(Component[] components, Color color) {
        for (Component c : components) {
            c.setBackground(color);
            if (!(c instanceof JComponent)) continue;
            this.setBackgroundForAll(((JComponent)c).getComponents(), color);
        }
    }

    private JPanel getJOptionPaneWrapper(JOptionPane pane) {
        JOptionPaneWrapper panel = new JOptionPaneWrapper(){
            int width;
            {
                this.width = MAX_JOPTIONPANE_WIDTH;
            }

            public void setMaxWidth(int width) {
                this.width = width;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = this.width;
                return dim;
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        panel.setLayout((LayoutManager)new ScaledFlowLayout());
        panel.add(pane);
        panel.setBackground(this.backgroundColor);
        pane.setBackground(this.backgroundColor);
        this.setBackgroundForAll(pane.getComponents(), this.backgroundColor);
        return panel;
    }

    public void showSimpleQuestion(String title, boolean allowCancelButton) {
        JLabel label = new JLabel(title);
        label.setIcon(ImageLoader.getImageIcon((String)"images/svg/dialogs/question.svg,16"));
        this.showMessage(title, label, ImageLoader.getImageIcon((String)"images/svg/dialogs/question.svg,16"), null, allowCancelButton);
    }

    public void showSimpleInformation(String title, boolean allowCancelButton) {
        JLabel label = new JLabel(title);
        label.setIcon(ImageLoader.getImageIcon((String)"images/svg/dialogs/information.svg,16"));
        this.showMessage(title, label, ImageLoader.getImageIcon((String)"images/svg/dialogs/information.svg,16"), null, allowCancelButton);
    }

    public DropDownComponent.Notification showSimpleInformation(String title, NotificationPanelListener listener, boolean allowCancelButton) {
        JLabel label = new JLabel(title);
        label.setIcon(ImageLoader.getImageIcon((String)"images/svg/dialogs/information.svg,16"));
        return this.showMessage(title, label, ImageLoader.getImageIcon((String)"images/svg/dialogs/information.svg,16"), listener, allowCancelButton);
    }

    public void showSimpleError(String title, boolean allowCancelButton) {
        JLabel label = new JLabel(title);
        label.setIcon(ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,16"));
        this.showMessage(title, label, ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,16"), null, allowCancelButton);
    }

    public void showSimpleWarning(String title, boolean allowCancelButton) {
        JLabel label = new JLabel(title);
        label.setIcon(ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"));
        this.showMessage(title, label, ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"), null, allowCancelButton);
    }

    public void showQuestion(String title, JComponent mainContent, boolean allowCancelButton) {
        this.showMessage(title, mainContent, ImageLoader.getImageIcon((String)"images/svg/dialogs/question.svg,16"), null, allowCancelButton);
    }

    public void showInformation(String title, JComponent mainContent, boolean allowCancelButton) {
        this.showMessage(title, mainContent, ImageLoader.getImageIcon((String)"images/svg/dialogs/information.svg,16"), null, allowCancelButton);
    }

    public void showError(String title, JComponent mainContent, boolean allowCancelButton) {
        this.showMessage(title, mainContent, ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,16"), null, allowCancelButton);
    }

    public void showWarning(String title, JComponent mainContent, boolean allowCancelButton) {
        this.showMessage(title, mainContent, ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"), null, allowCancelButton);
    }

    public DropDownComponent.Notification showMessage(String title, JComponent mainContent, Icon icon, NotificationPanelListener closeListener, boolean allowCloseButton) {
        return this.showMessage(title, mainContent, icon, closeListener, allowCloseButton, Language.get("DISMISS"));
    }

    public DropDownComponent.Notification showMessage(String title, JComponent mainContent, Icon icon, NotificationPanelListener closeListener, boolean allowCloseButton, String dismissButtonText) {
        DropDownComponent.Notification notification = this.initNotification(title, mainContent, icon, closeListener, allowCloseButton, dismissButtonText);
        this.showDropDownNotification(notification);
        return notification;
    }

    public DropDownComponent.Notification showStaticMessage(String title, JComponent mainContent, Icon icon, NotificationPanelListener closeListener, boolean allowCloseButton, String dismissButtonText) {
        DropDownComponent.Notification notification = this.initNotification(title, mainContent, icon, closeListener, allowCloseButton, dismissButtonText);
        this.showStaticNotification(notification);
        return notification;
    }

    public DropDownComponent.Notification showStaticMessage(String title, JComponent mainContent, Icon icon, NotificationPanelListener closeListener, boolean allowCloseButton, String dismissButtonText, boolean isAlarm) {
        DropDownComponent.Notification notification = this.initNotification(title, mainContent, icon, closeListener, allowCloseButton, dismissButtonText, isAlarm);
        this.showStaticNotification(notification);
        return notification;
    }

    private DropDownComponent.Notification initNotification(String title, JComponent mainContent, Icon icon, NotificationPanelListener closeListener, boolean allowCloseButton, String dismissButtonText) {
        return this.initNotification(title, mainContent, icon, closeListener, allowCloseButton, dismissButtonText, false);
    }

    private DropDownComponent.Notification initNotification(String title, JComponent mainContent, Icon icon, NotificationPanelListener closeListener, boolean allowCloseButton, String dismissButtonText, boolean isAlarm) {
        CompoundBorder borderFull = SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)this.borderColor), (Border)SHBorderFactory.createEmptyBorder((int)4, (int)4, (int)4, (int)4));
        CompoundBorder borderNotFull = SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)0, (int)1, (int)1, (int)1, (Color)this.borderColor), (Border)SHBorderFactory.createEmptyBorder((int)4, (int)4, (int)4, (int)4));
        int width = this.defaultWidth;
        JButton button1 = null;
        Component button2 = null;
        JLabel summaryLabel = new JLabel(title);
        summaryLabel.setIcon(icon);
        JPanel summaryPanel = new JPanel();
        summaryPanel.setLayout(new BorderLayout());
        if (width == -1) {
            summaryPanel.setBorder(borderFull);
        } else {
            summaryPanel.setBorder(borderNotFull);
        }
        summaryPanel.add("Center", summaryLabel);
        if (this.backgroundColor != null) {
            summaryPanel.setBackground(this.backgroundColor);
        }
        if (allowCloseButton) {
            button1 = new JButton(dismissButtonText);
            button1.setOpaque(false);
            summaryPanel.add("East", button1);
        }
        JPanel mainPanel = null;
        if (mainContent != null) {
            mainPanel = new JPanel();
            GridBagLayout gbl = new GridBagLayout();
            mainPanel.setLayout(gbl);
            if (width == -1) {
                mainPanel.setBorder(borderFull);
            } else {
                mainPanel.setBorder(borderNotFull);
            }
            if (this.backgroundColor != null) {
                mainPanel.setBackground(this.backgroundColor);
            }
            mainPanel.add(mainContent);
            gbl.setConstraints(mainContent, new GridBagConstraints(0, 0, 1, 1, 1000.0, 1.0, 10, 1, (Insets)new ScaledInsets(0, 0, 0, 0), 0, 0));
            if (allowCloseButton) {
                button2 = new JButton(dismissButtonText);
                mainPanel.add(button2);
                gbl.setConstraints(button2, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 12, 0, (Insets)new ScaledInsets(0, 0, 0, 0), 0, 0));
            }
        }
        DropDownComponent.Notification notification = this.addNotification(summaryPanel, mainPanel, SimpleHelpLookAndFeel.scale((int)30), width);
        if (allowCloseButton) {
            button1.addMouseListener(new CloseNotificationListener(notification, closeListener, 0));
            if (button2 != null) {
                button2.addMouseListener(new CloseNotificationListener(notification, closeListener, 1));
            }
        }
        JOptionPane pane = null;
        if (mainContent instanceof JOptionPane) {
            pane = (JOptionPane)mainContent;
        } else if (mainContent instanceof JOptionPaneWrapper) {
            pane = (JOptionPane)mainContent.getComponent(0);
        }
        if (pane != null) {
            pane.addPropertyChangeListener(new JOptionPaneListener(pane, notification, closeListener));
        }
        return notification;
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        OEMSwitches.DARK_THEME = true;
        Language.loadTranslations();
        JPanel test = new JPanel();
        test.setLayout(new GridLayout(1, 1));
        test.add(new JLabel("Hello"));
        test.setBorder(SHBorderFactory.createLineBorder((Color)Color.BLACK));
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        NotificationPanel notificationPanel = new NotificationPanel(test);
        frame.getContentPane().add(notificationPanel.getRootComponent());
        frame.setVisible(true);
        notificationPanel.showOkWarning(Language.get("SLOW_CAPTURE_TITLE"), Language.get("SLOW_CAPTURE_MESSAGE"), new NotificationPanelListener(){

            @Override
            public void notificationClosed(int returnCode) {
                System.out.println(returnCode);
            }
        }, true, Language.get("SLOW_CAPTURE_ACTION"));
    }

    private void setBorderColor(Color darkGray) {
        this.borderColor = darkGray;
    }

    class CloseNotificationListener
    extends MouseAdapter {
        private final NotificationPanelListener listener;
        private DropDownComponent.Notification notification;

        public CloseNotificationListener(DropDownComponent.Notification notification, NotificationPanelListener listener, int returnCode) {
            this.notification = notification;
            this.listener = listener;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            NotificationPanel.this.removeNotification(this.notification);
            if (this.listener != null) {
                this.listener.notificationClosed(0);
            }
        }
    }

    class JOptionPaneListener
    implements PropertyChangeListener {
        private JOptionPane pane;
        private DropDownComponent.Notification notification;
        private NotificationPanelListener listener;

        public JOptionPaneListener(JOptionPane pane, DropDownComponent.Notification notification, NotificationPanelListener listener) {
            this.pane = pane;
            this.notification = notification;
            this.listener = listener;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (e.getSource() == this.pane && prop.equals("value")) {
                NotificationPanel.this.removeNotification(this.notification);
                Object value = this.pane.getValue();
                if (this.listener != null) {
                    if (value instanceof Integer) {
                        int intValue = (Integer)this.pane.getValue();
                        this.listener.notificationClosed(intValue);
                    } else if (value instanceof String) {
                        if (value.equals(Language.get("YES"))) {
                            this.listener.notificationClosed(1);
                        }
                        if (value.equals(Language.get("NO"))) {
                            this.listener.notificationClosed(2);
                        }
                        if (value.equals(Language.get("CANCEL"))) {
                            this.listener.notificationClosed(3);
                        }
                        if (value.equals(Language.get("OK"))) {
                            this.listener.notificationClosed(0);
                        }
                        this.listener.notificationClosed(1);
                    }
                }
            }
        }
    }

    class JOptionPaneWrapper
    extends JPanel {
        JOptionPaneWrapper() {
        }
    }

    public static interface NotificationPanelListener {
        public static final int OK = 0;
        public static final int YES = 1;
        public static final int NO = 2;
        public static final int CANCEL = 3;

        public void notificationClosed(int var1);
    }
}

