/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util.font;

import java.awt.Font;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class GlyphIcons {
    private static final Object LOCK = new Object();
    private static Font font = null;
    public static final String OK_CIRCLED = "\ue199";
    public static final String PROBLEM_CIRCLED = "\ue198";
    public static final String OK_FILLED_CIRCLED = "\ue194";
    public static final String PROBLEM_FILLED_CIRCLED = "\ue193";
    public static final String WARNING_FILLED_CIRCLED = "\ue197";
    public static final String ADD_FILLED_CIRCLED = "\ue192";
    public static final String REMOVE_FILLED_CIRCLED = "\ue191";
    public static final String VOLUME_DOWN = "\ue184";
    public static final String FAST_BACKWARDS = "\ue172";
    public static final String SETTINGS = "\ue281";
    public static final String UP = "\ue601";
    public static final String DOWN = "\ue602";
    public static final String GLOBE = "\ue341";
    public static final String LINK = "\ue051";
    public static final String USER = "\ue004";
    public static final String TAG = "\ue066";
    public static final String CLIPBOARD = "\ue030";

    public static Font getFont() {
        if (font == null) {
            GlyphIcons.loadFont();
        }
        return font;
    }

    public static Font getFont(float size) {
        if (font == null) {
            GlyphIcons.loadFont();
        }
        return font.deriveFont(size);
    }

    private static void loadFont() {
        InputStream fin = null;
        try {
            String ttfResource = "images/glyphicons-regular.ttf";
            File file = new File(ttfResource);
            if (file.exists()) {
                try {
                    fin = new BufferedInputStream(new FileInputStream(file));
                }
                catch (Throwable throwable) {}
            } else {
                ttfResource = "images/glyphicons-regular.ttf";
                file = new File("SimpleHelp", ttfResource);
                if (file.exists()) {
                    try {
                        fin = new BufferedInputStream(new FileInputStream(file));
                    }
                    catch (Throwable throwable) {}
                } else {
                    fin = GlyphIcons.class.getResourceAsStream("/" + ttfResource);
                    if (fin == null) {
                        fin = GlyphIcons.class.getResourceAsStream(ttfResource);
                    }
                }
            }
            font = fin == null ? Font.getFont("SansSerif") : Font.createFont(0, fin);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            font = Font.getFont("SansSerif");
        }
    }
}

