/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.CentralDebugging;
import java.io.OutputStream;
import java.io.PrintStream;

public class TaggedPrintStream
extends PrintStream {
    private boolean tag = true;
    private int myIndex = index++;
    private static int index = 0;

    public TaggedPrintStream(OutputStream newOutoutStream) {
        super(newOutoutStream);
    }

    public void setEnabled(boolean enabled) {
        this.tag = enabled;
    }

    @Override
    public void print(String s) {
        Exception e;
        super.print(s);
        if (this.tag && (e = TaggedPrintStream.getExceptionIfHit(this.myIndex, s)) != null) {
            super.println();
            try {
                this.tag = false;
                e.printStackTrace(this);
            }
            finally {
                this.tag = true;
            }
        }
    }

    public static Exception getExceptionIfHit(int myIndex, String s) {
        if (CentralDebugging.SHOW_TRACE_FOR_STDOUT_FLAG != null && CentralDebugging.SHOW_TRACE_FOR_STDOUT_FLAG.length() > 0) {
            boolean hit;
            String tag = CentralDebugging.SHOW_TRACE_FOR_STDOUT_FLAG;
            boolean firstStar = tag.startsWith("*");
            boolean endStar = tag.endsWith("*");
            if (firstStar) {
                if (endStar) {
                    tag = tag.substring(1, tag.length() - 1);
                    hit = s.toLowerCase().contains(tag.toLowerCase());
                } else {
                    tag = tag.substring(1);
                    hit = s.toLowerCase().endsWith(tag.toLowerCase());
                }
            } else if (endStar) {
                tag = tag.substring(0, tag.length() - 1);
                hit = s.toLowerCase().startsWith(tag.toLowerCase());
            } else {
                hit = s.equalsIgnoreCase(tag);
            }
            if (hit) {
                return new TaggedException(myIndex + ": " + CentralDebugging.SHOW_TRACE_FOR_STDOUT_FLAG + " matched '" + s + "'");
            }
        }
        return null;
    }

    static class TaggedException
    extends Exception {
        public TaggedException(String message) {
            super(message);
        }
    }
}

