/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.CentralDebugging;
import com.aem.shelp.util.CacheDirUtil;
import com.aem.utils.FileCopyUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.jwutils.JWWmi;
import jwrapper.jwutils.wmi.JWWmiQueryResult;
import utils.files.FileUtil;
import utils.files.PermissionsUtil;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.vm.VMFork;

public class SimpleServiceUtil {
    private File serviceDir;
    private String[] elevationArgs = new String[0];
    private String password = null;
    private String username = null;
    private static String ELEVATESH_PATH = null;

    public SimpleServiceUtil(File serviceDirectory) {
        this(serviceDirectory, null, null);
    }

    public SimpleServiceUtil(File serviceDirectory, String username, String password) {
        this.serviceDir = serviceDirectory;
        System.out.println("[SimpleServiceUtil] Native libs dir is " + this.serviceDir);
        this.username = username;
        this.password = password;
        SimpleServiceUtil.getAllAccessibleNativeUtilsDir(this.serviceDir);
        this.setElevationArgs();
    }

    private void setElevationArgs() {
        String elevateSHDir = SimpleServiceUtil.getAllAccessibleNativeUtilsDir(this.serviceDir);
        this.elevationArgs = this.username == null || this.password == null ? new String[]{elevateSHDir + "elev_win.exe", "--waitforreturncode", elevateSHDir + "elev_win.exe", "--waitforreturncode"} : new String[]{elevateSHDir + "elev_win.exe", "--waitforreturncode", "--runas", this.username, this.password, elevateSHDir + "elev_win.exe", "--waitforreturncode"};
    }

    public Process launchVmForkViaService(String simpleserviceDir, VMFork fork) {
        try {
            int consoleID;
            int sessionID;
            String workingDir = new File(".").getAbsoluteFile().getCanonicalPath();
            if (workingDir.startsWith("\\\\")) {
                System.out.println("[SimpleHelpService] Found UNC path again: " + workingDir);
                File temp = File.createTempFile("mousemover", null);
                temp.delete();
                temp.mkdirs();
                workingDir = temp.getCanonicalPath();
            }
            System.out.println("[SimpleHelpService] Using a working directory of " + workingDir);
            File simpleServiceDirFile = new File(simpleserviceDir);
            simpleserviceDir = SimpleServiceUtil.getAllAccessibleNativeUtilsDir(simpleServiceDirFile);
            File serviceFile = File.createTempFile("MMoveLauncher", ".service", simpleServiceDirFile);
            String serviceName = "ShTemporaryService" + (long)(Math.random() * 1.0E8);
            System.out.println("[SimpleServiceUtil] Writing service file " + serviceFile);
            String lineSeparator = System.getProperty("line.separator");
            if (lineSeparator == null || lineSeparator.length() == 0) {
                lineSeparator = "\n";
            }
            StringBuilder configuration = new StringBuilder();
            configuration.append("NAME:").append(serviceName).append(lineSeparator);
            configuration.append("DISPLAYNAME:").append(serviceName).append(lineSeparator);
            configuration.append("DESCRIPTION:").append(serviceName).append(lineSeparator);
            configuration.append("WORKINGDIR:").append(workingDir).append(lineSeparator);
            String runInSessionSuffix = "";
            if (!OS.isWindowsPreXp() && (sessionID = JWNativeAPI.getInstance().getTsMySessionId()) != (consoleID = JWNativeAPI.getInstance().getTsConsoleSessionId())) {
                runInSessionSuffix = "--slConnectToSessionID" + sessionID;
            }
            if (OS.isWindowsPreXp()) {
                configuration.append("CMDLINE:").append(fork.forkAsCommandString(new String[0])).append(lineSeparator);
            } else {
                configuration.append("CMDLINE:\"").append(this.serviceDir).append("\\session_win.exe\" ").append(runInSessionSuffix).append(" ").append(fork.forkAsCommandString(new String[0])).append(lineSeparator);
            }
            configuration.append("AUTORESTART:no").append(lineSeparator);
            if (OS.isWindows7OrAbove()) {
                configuration.append("INTERACTIVE:no").append(lineSeparator);
            } else {
                configuration.append("INTERACTIVE:yes").append(lineSeparator);
            }
            configuration.append("RUNONCE:yes").append(lineSeparator);
            System.out.println("[SimpleServiceUtil] Service File Configuration:\n" + configuration.toString());
            PrintStream pout = new PrintStream(new BufferedOutputStream(new FileOutputStream(serviceFile)));
            pout.println(configuration.toString());
            pout.close();
            System.out.println("[SimpleServiceUtil] Setting temp directory readable now.");
            PermissionsUtil.setRecursiveFullPermissions((String)(simpleserviceDir + "*.*"));
            ArrayList<String> commands = new ArrayList<String>();
            Collections.addAll(commands, this.elevationArgs);
            if (simpleserviceDir != null) {
                commands.add(simpleserviceDir + "SimpleService.exe");
            } else {
                commands.add("SimpleService.exe");
            }
            commands.add("-install");
            commands.add(serviceFile.getAbsoluteFile().getCanonicalPath());
            String[] cmds = new String[commands.size()];
            commands.toArray(cmds);
            System.out.println("[SimpleServiceUtil] Forking with elevation.");
            new WaitAndDelete(serviceFile).start();
            return Runtime.getRuntime().exec(cmds, null, new File(simpleserviceDir));
        }
        catch (IOException x) {
            x.printStackTrace();
            return null;
        }
    }

    public void terminateShTemporaryServices() {
        JWWmiQueryResult wmiResults = JWWmi.runQuery((String)"SELECT Name FROM Win32_Service");
        if (wmiResults.hasProperties()) {
            for (Properties p : wmiResults.getProperties()) {
                String name = p.getProperty("Name");
                if (name == null || !name.startsWith("ShTemporaryService")) continue;
                ArrayList<String> commands = new ArrayList<String>();
                if (this.serviceDir != null) {
                    commands.add(new File(this.serviceDir, "SimpleService.exe").getAbsolutePath());
                } else {
                    commands.add("SimpleService.exe");
                }
                commands.add("-uninstallbyname");
                commands.add(name);
                RunCommandGetOutput.runCommand((String[])commands.toArray(new String[0]));
            }
        }
    }

    public Process doCadViaService() {
        try {
            String simpleserviceDir = SimpleServiceUtil.getAllAccessibleNativeUtilsDir(this.serviceDir);
            File serviceFile = File.createTempFile("CadLauncher", ".service", new File(simpleserviceDir));
            PrintStream pout = new PrintStream(new BufferedOutputStream(new FileOutputStream(serviceFile)));
            System.out.println("[SimpleServiceUtil] writing to service file " + serviceFile);
            String serviceName = "ShTemporaryService" + (long)(Math.random() * 1.0E8);
            pout.println("NAME:" + serviceName);
            pout.println("DISPLAYNAME:" + serviceName);
            pout.println("DESCRIPTION:" + serviceName);
            pout.println("WORKINGDIR:" + new File(".").getAbsoluteFile().getCanonicalPath());
            pout.println("CMDLINE:");
            pout.println("AUTORESTART:no");
            if (OS.isWindows7OrAbove()) {
                pout.println("INTERACTIVE:no");
            } else {
                pout.println("INTERACTIVE:yes");
            }
            pout.println("RUNONCE:yes");
            pout.println("DOCAD:yes");
            pout.close();
            System.out.println("[SimpleServiceUtil] Setting temp directory readable now.");
            PermissionsUtil.setRecursiveFullPermissions((String)(simpleserviceDir + "*.*"));
            System.out.println("[SimpleServiceUtil] finished writing to service file " + serviceFile);
            ArrayList<String> commands = new ArrayList<String>();
            Collections.addAll(commands, this.elevationArgs);
            if (this.elevationArgs.length == 0) {
                commands.add(simpleserviceDir + "SimpleService.exe");
            } else {
                commands.add("SimpleService.exe");
            }
            commands.add("-install");
            commands.add(serviceFile.getAbsoluteFile().getCanonicalPath());
            String[] cmds = new String[commands.size()];
            commands.toArray(cmds);
            System.out.println("[SimpleServiceUtil] notifying via elevated system");
            new WaitAndDelete(serviceFile).start();
            return Runtime.getRuntime().exec(cmds, null, new File(simpleserviceDir));
        }
        catch (IOException x) {
            x.printStackTrace();
            return null;
        }
        catch (Throwable x) {
            x.printStackTrace();
            return null;
        }
    }

    public static void clearElevateSHCache() {
        if (ELEVATESH_PATH == null) {
            return;
        }
        String old = ELEVATESH_PATH;
        ELEVATESH_PATH = null;
        FileUtil.deleteDir((File)new File(old));
    }

    private static String getAllAccessibleNativeUtilsDir(File nativeLibsDir) {
        if (ELEVATESH_PATH == null) {
            try {
                File tempDir = CacheDirUtil.createUniqueAccessibleTempDir("ElevateSH");
                System.out.println("[SimpleServiceUtil] Moving ElevateSH to readable directory: " + tempDir.getAbsolutePath());
                FileCopyUtil.copyFile("SimpleService.exe", nativeLibsDir, tempDir);
                FileCopyUtil.copyFile("elev_win.exe", nativeLibsDir, tempDir);
                String TEMP_PATH = tempDir.getAbsolutePath();
                if (TEMP_PATH.endsWith("/") || TEMP_PATH.endsWith("\\")) {
                    TEMP_PATH = TEMP_PATH.substring(0, TEMP_PATH.length() - 1);
                }
                TEMP_PATH = TEMP_PATH + File.separator;
                System.out.println("[SimpleServiceUtil] Setting temp directory readable now.");
                PermissionsUtil.setRecursiveFullPermissions((String)(TEMP_PATH + "*.*"));
                ELEVATESH_PATH = TEMP_PATH;
            }
            catch (Throwable t) {
                String tmp = nativeLibsDir.getAbsolutePath();
                if (tmp.endsWith("/") || tmp.endsWith("\\")) {
                    tmp = tmp.substring(0, tmp.length() - 1);
                }
                tmp = tmp + File.separator;
                System.out.println("[SimpleServiceUtil] Unable to create all-accessible dir (" + t + "), returning " + tmp);
                return tmp;
            }
        }
        return ELEVATESH_PATH;
    }

    public static void main(String[] args) throws Throwable {
        SimpleServiceUtil util = new SimpleServiceUtil(new File("."));
        util.terminateShTemporaryServices();
    }

    class WaitAndDelete
    extends Thread {
        File serviceFile;

        public WaitAndDelete(File serviceFile) {
            this.serviceFile = serviceFile;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(30000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!CentralDebugging.KEEP_SERVICE_FILES) {
                try {
                    SimpleServiceUtil.clearElevateSHCache();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                FileUtil.deleteDir((File)this.serviceFile);
            }
        }
    }
}

