/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.utils.NativeUtils;
import javax.swing.UIManager;
import utils.ostools.OS;
import utils.ostools.osx.OSXAdapter;

public class OSNotificationUtil {
    public static void playWarningSound() {
        UIManager.getLookAndFeel().provideErrorFeedback(null);
    }

    public static void notifyUser(String jframeTitle, int notifyTimes) {
        new NotifyThread(jframeTitle, notifyTimes).start();
    }

    public static void main(String[] args) throws InterruptedException {
        OSNotificationUtil.notifyUser(null, 3);
        Thread.sleep(10000L);
    }

    static class NotifyThread
    extends Thread {
        private int notifyTimes;
        private String jframeTitle;

        public NotifyThread(String jframeTitle, int notifyTimes) {
            super("NotifyThread");
            this.jframeTitle = jframeTitle;
            this.notifyTimes = notifyTimes;
        }

        @Override
        public void run() {
            if (OS.isMacOS()) {
                if (this.notifyTimes == 0) {
                    OSXAdapter.requestUserAttention((boolean)true);
                } else {
                    for (int i = 0; i < this.notifyTimes; ++i) {
                        OSXAdapter.requestUserAttention((boolean)false);
                        try {
                            Thread.sleep(3000L);
                            continue;
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else if (OS.isWindows() && NativeUtils.getInstance() != null) {
                NativeUtils.getInstance().notifyUser(this.jframeTitle, this.notifyTimes);
            }
        }
    }
}

