/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

import com.aem.CentralDebugging;
import com.aem.shelp.util.MousePositionUtil;
import java.awt.GraphicsEnvironment;
import java.awt.Point;

public class MachineInUseMonitor {
    private Point lastPoint;
    private int time;
    private long lastTime = System.currentTimeMillis();
    private long lastHeadlessCheck = 0L;
    private boolean isHeadless = false;

    public MachineInUseMonitor() {
        this(30000);
    }

    public MachineInUseMonitor(int intervaltime) {
        System.out.println("[MachineInUseMonitor] Initialising...");
        this.time = intervaltime;
        this.lastPoint = MousePositionUtil.get().getLocation();
        if (CentralDebugging.SG_IN_USE_MONITOR_DEBUG) {
            System.out.println("[MachineInUseMonitor] Last point: " + this.lastPoint);
        }
    }

    public boolean isAvailable() {
        if (CentralDebugging.SG_IN_USE_MONITOR_DEBUG) {
            System.out.println("[MachineInUseMonitor] Available: " + MousePositionUtil.get().isAvailable());
        }
        return MousePositionUtil.get().isAvailable();
    }

    public boolean isInUse() {
        if (MousePositionUtil.get().isAvailable()) {
            if (System.currentTimeMillis() - this.lastTime < (long)this.time) {
                if (CentralDebugging.SG_IN_USE_MONITOR_DEBUG) {
                    System.out.println("[MachineInUseMonitor] Default inuse: 'true'");
                }
                return true;
            }
            Point newPoint = MousePositionUtil.get().getRobustLocationSum();
            if (newPoint != null && this.lastPoint != null && !newPoint.equals(this.lastPoint)) {
                this.lastPoint = newPoint;
                this.lastTime = System.currentTimeMillis();
                if (CentralDebugging.SG_IN_USE_MONITOR_DEBUG) {
                    System.out.println("[MachineInUseMonitor] Change detected, inuse: 'true'");
                }
                return true;
            }
            if (CentralDebugging.SG_IN_USE_MONITOR_DEBUG) {
                System.out.println("[MachineInUseMonitor] No change, inuse: 'false'");
            }
            return false;
        }
        if (CentralDebugging.SG_IN_USE_MONITOR_DEBUG) {
            System.out.println("[MachineInUseMonitor] Not available, inuse: 'false'");
        }
        return false;
    }

    public static void main(String[] args) throws InterruptedException {
        Thread.sleep(5000L);
        MachineInUseMonitor min = new MachineInUseMonitor();
        for (int i = 0; i < 1000; ++i) {
            System.out.println(min.isInUse() + " - " + min.checkIfHeadless());
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean checkIfHeadless() {
        block4: {
            try {
                if (System.currentTimeMillis() - this.lastHeadlessCheck < (long)this.time) {
                    return this.isHeadless;
                }
                this.lastHeadlessCheck = System.currentTimeMillis();
                boolean bl = this.isHeadless = GraphicsEnvironment.isHeadless() || GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance();
                if (CentralDebugging.SG_IN_USE_MONITOR_DEBUG) {
                    System.out.println("[MachineInUseMonitor] Headless: " + this.isHeadless);
                }
            }
            catch (Throwable t) {
                this.isHeadless = true;
                if (!CentralDebugging.SG_IN_USE_MONITOR_DEBUG) break block4;
                System.out.println("[MachineInUseMonitor] Headless (error): " + this.isHeadless);
                t.printStackTrace();
            }
        }
        return this.isHeadless;
    }
}

