/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.util;

public abstract class FixedTimeSettingsRunner {
    private static long lastStartTime;
    private static boolean finished;
    private static final Object LOCK;
    private boolean isEnabled = false;
    private final String settingName;
    private final int maxTimeout;

    public FixedTimeSettingsRunner(String settingName) {
        this(settingName, 2000);
    }

    public FixedTimeSettingsRunner(String settingName, int maxTimeout) {
        this.settingName = settingName;
        this.maxTimeout = maxTimeout;
    }

    protected boolean isEnabled() {
        return this.isEnabled;
    }

    public void enable() {
        this.isEnabled = true;
        new EnableSettingThread().start();
    }

    public void disable() {
        this.isEnabled = false;
        new DisableSettingThread().start();
    }

    public void setEnabled(boolean enable) {
        if (enable) {
            this.enable();
        } else {
            this.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block() {
        Object object = LOCK;
        synchronized (object) {
            long timeTillTimeout = lastStartTime + (long)this.maxTimeout - System.currentTimeMillis();
            if (timeTillTimeout <= 0L) {
                return;
            }
            if (finished) {
                return;
            }
            try {
                LOCK.wait(timeTillTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected abstract void enableSetting();

    protected abstract void disableSetting();

    static {
        finished = false;
        LOCK = new Object();
    }

    class DisableSettingThread
    extends Thread {
        DisableSettingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = System.currentTimeMillis();
            lastStartTime = start;
            System.out.println("[" + FixedTimeSettingsRunner.this.settingName + "] Disabling...");
            finished = false;
            FixedTimeSettingsRunner.this.disableSetting();
            System.out.println("[" + FixedTimeSettingsRunner.this.settingName + "] Disable complete (" + (System.currentTimeMillis() - start) + ")");
            Object object = LOCK;
            synchronized (object) {
                finished = true;
                LOCK.notifyAll();
            }
        }
    }

    class EnableSettingThread
    extends Thread {
        EnableSettingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = System.currentTimeMillis();
            lastStartTime = start;
            System.out.println("[" + FixedTimeSettingsRunner.this.settingName + "] Enabling...");
            finished = false;
            FixedTimeSettingsRunner.this.enableSetting();
            System.out.println("[" + FixedTimeSettingsRunner.this.settingName + "] Enable complete (" + (System.currentTimeMillis() - start) + ")");
            Object object = LOCK;
            synchronized (object) {
                finished = true;
                LOCK.notifyAll();
            }
        }
    }
}

