/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.video;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import utils.message.Message;

public class IFrame {
    private int chunkSize;
    private int[][] chunkIndices;
    private int widthPixels;
    private int heightPixels;
    private Rectangle viewedArea;

    public IFrame(int width, int height, int chunkSize) {
        this.chunkSize = chunkSize;
        this.initChunkIndices(width, height);
    }

    public IFrame(Message message) {
        this.widthPixels = message.getNextInt();
        this.heightPixels = message.getNextInt();
        this.viewedArea = new Rectangle(message.getNextInt(), message.getNextInt(), message.getNextInt(), message.getNextInt());
        this.chunkSize = message.getNextInt();
        int indices = message.getNextInt();
        this.chunkIndices = new int[indices][];
        for (int i = 0; i < this.chunkIndices.length; ++i) {
            this.chunkIndices[i] = message.getNextIntArray();
        }
    }

    public void setScreenSize(int width, int height) {
        this.initChunkIndices(width, height);
    }

    public void setViewedSection(Rectangle viewedArea) {
        this.viewedArea = viewedArea;
    }

    public Rectangle getViewedSection() {
        return this.viewedArea;
    }

    public void setViewedSection(int x, int y, int w, int h) {
        this.setViewedSection(new Rectangle(x, y, w, h));
    }

    public Message toMessage() {
        Message message = new Message(9);
        message.append(this.widthPixels);
        message.append(this.heightPixels);
        if (this.viewedArea != null) {
            message.append(this.viewedArea.x);
            message.append(this.viewedArea.y);
            message.append(this.viewedArea.width);
            message.append(this.viewedArea.height);
        } else {
            message.append(0);
            message.append(0);
            message.append(0);
            message.append(0);
        }
        message.append(this.chunkSize);
        message.append(this.chunkIndices.length);
        for (int x = 0; x < this.chunkIndices.length; ++x) {
            message.append(this.chunkIndices[x]);
        }
        return message;
    }

    public ArrayList getAllIndices() {
        return this.getIndicesForRectangle(new Rectangle(0, 0, this.widthPixels, this.heightPixels));
    }

    public ArrayList getIndicesForRectangle(Rectangle rectangle) {
        Rectangle rect = (Rectangle)rectangle.clone();
        if (rect.x + rect.width > this.widthPixels) {
            rect.width = Math.max(0, this.widthPixels - rect.x);
        }
        if (rect.y + rect.height > this.heightPixels) {
            rect.height = Math.max(0, this.heightPixels - rect.y);
        }
        int xChunkStart = rect.x / this.chunkSize;
        int yChunkStart = rect.y / this.chunkSize;
        int chunkXEnd = (rect.x + rect.width) / this.chunkSize;
        int chunkYEnd = (rect.y + rect.height) / this.chunkSize;
        if (chunkXEnd * this.chunkSize == rect.x + rect.width) {
            --chunkXEnd;
        }
        if (chunkYEnd * this.chunkSize == rect.y + rect.height) {
            --chunkYEnd;
        }
        ArrayList<Integer> indicesList = new ArrayList<Integer>();
        for (int x = xChunkStart; x <= chunkXEnd; ++x) {
            for (int y = yChunkStart; y <= chunkYEnd; ++y) {
                indicesList.add(new Integer(this.chunkIndices[x][y]));
            }
        }
        Collections.sort(indicesList);
        return indicesList;
    }

    public void setIndexFor(int x, int y, int width, int height, int index) {
        int xChunkStart = x / this.chunkSize;
        int yChunkStart = y / this.chunkSize;
        int chunkXEnd = (x + width) / this.chunkSize;
        int chunkYEnd = (y + height) / this.chunkSize;
        if (chunkXEnd * this.chunkSize == x + width) {
            --chunkXEnd;
        }
        if (chunkYEnd * this.chunkSize == y + height) {
            --chunkYEnd;
        }
        for (int xChunk = xChunkStart; xChunk <= chunkXEnd && xChunk < this.getXChunkCount(); ++xChunk) {
            for (int yChunk = yChunkStart; yChunk <= chunkYEnd && yChunk < this.getYChunkCount(); ++yChunk) {
                this.chunkIndices[xChunk][yChunk] = index;
            }
        }
    }

    public static void main(String[] args) {
        Random random = new Random();
        IFrame iFrame = new IFrame(1024, 768, 64);
        iFrame.setIndexFor(0, 64, 64, 64, 100);
        System.out.println(iFrame.getIndexForChunk(0, 0));
    }

    private void initChunkIndices(int width, int height) {
        if (this.widthPixels == width && this.heightPixels == height) {
            return;
        }
        this.widthPixels = width;
        this.heightPixels = height;
        int xChunks = this.getXChunkCount();
        int yChunks = this.getYChunkCount();
        int[][] newIndices = new int[xChunks][yChunks];
        for (int i = 0; i < newIndices.length; ++i) {
            Arrays.fill(newIndices[i], -1);
        }
        if (this.chunkIndices != null) {
            int minX = Math.min(newIndices.length, this.chunkIndices.length);
            int minY = 0;
            if (this.chunkIndices.length > 0) {
                minY = Math.min(newIndices[0].length, this.chunkIndices[0].length);
            }
            for (int i = 0; i < minX; ++i) {
                System.arraycopy(this.chunkIndices[i], 0, newIndices[i], 0, minY);
            }
        }
        this.chunkIndices = newIndices;
    }

    private int getXChunkCount() {
        int xChunks = this.widthPixels / this.chunkSize;
        if (this.widthPixels > xChunks * this.chunkSize) {
            ++xChunks;
        }
        return xChunks;
    }

    private int getYChunkCount() {
        int yChunks = this.heightPixels / this.chunkSize;
        if (this.heightPixels > yChunks * this.chunkSize) {
            ++yChunks;
        }
        return yChunks;
    }

    public int getWidthPixels() {
        return this.widthPixels;
    }

    public int getHeightPixels() {
        return this.heightPixels;
    }

    public int getIndexForChunk(int i, int j) {
        return this.chunkIndices[i][j];
    }
}

