/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils.filters;

import com.aem.sgateway.ui.SimpleMachineGroupList;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.filters.Filter;
import com.aem.shelp.proxy.types.filters.SimpleMachineFilter;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.utils.filters.FilterLogicUtil;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;

public class MachineTestFiltersDialog
extends OKCancelDialogPanel {
    private SimpleMachineGroupList groupList;
    private JLabel southLabel = new JLabel("");

    public MachineTestFiltersDialog() {
        super(Language.get("CLOSE"));
        this.addLeftComponent(this.southLabel);
        JPanel contentPanel = this.getContentPanel();
        contentPanel.setPreferredSize(SimpleHelpLookAndFeel.scale((Dimension)new Dimension(500, 300)));
        FixedWidthPanel panel = new FixedWidthPanel((JComponent)contentPanel);
        this.setContent((FixedWidthComponent)panel);
    }

    public static void showDialog(RootPaneContainer rpc, MachineTreeModel model, Filter[] filters, SimpleMachineFilter simpleFilter) {
        ArrayList<Object> allMachines;
        int included = 0;
        int excluded = 0;
        Iterator<Machine> descendentElements = model.getDescendentElements(model.getAvailableMachinesGroup());
        if (!(simpleFilter != null && !simpleFilter.isEmpty() || filters != null && filters.length != 0)) {
            allMachines = new ArrayList<Machine>();
            while (descendentElements.hasNext()) {
                allMachines.add(descendentElements.next());
                ++included;
            }
        } else {
            FilterLogicUtil.FilterResult result = FilterLogicUtil.applyFiltersToMachines(filters, simpleFilter, descendentElements);
            allMachines = result.allMachines;
            included = result.included;
            excluded = result.excluded;
        }
        MachineTestFiltersDialog dialog = new MachineTestFiltersDialog();
        dialog.setMachinesToShow(allMachines.toArray(new Machine[0]), included, excluded);
        AbstractGlassDialog abstractGlassDialog = new AbstractGlassDialog(rpc, 500, (AbstractDialogPanel)dialog);
        abstractGlassDialog.setTitle(Language.get("FILTERED_MACHINE_LIST"));
        abstractGlassDialog.showDialog();
    }

    protected JPanel getContentPanel() {
        this.groupList = new SimpleMachineGroupList();
        JPanel result = new JPanel(new GridLayout(1, 1));
        result.add(this.groupList.getRootComponent());
        return result;
    }

    public void setMachinesToShow(Machine[] allMachines, int included, int excluded) {
        ArrayList<String[]> groupsToShow = new ArrayList<String[]>();
        ArrayList<String> machineNames = new ArrayList<String>();
        for (Machine m : allMachines) {
            groupsToShow.add(m.getName().getGroup());
            machineNames.add(m.getName().getName());
        }
        this.groupList.setGroupsToShow(groupsToShow, machineNames, null);
        this.southLabel.setText(Language.get("MACHINE_FILTERS_SOUTH_DESC", included + "", excluded + ""));
        this.southLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
    }

    public static void showTestDialog(RootPaneContainer rpc) {
        Machine[] allMachines = Machine.createRandomMachines(1000);
        MachineTestFiltersDialog dialog = new MachineTestFiltersDialog();
        dialog.setMachinesToShow(allMachines, 10, 5);
        AbstractGlassDialog abstractGlassDialog = new AbstractGlassDialog(rpc, 500, (AbstractDialogPanel)dialog);
        abstractGlassDialog.setTitle(Language.get("FILTERED_MACHINE_LIST"));
        abstractGlassDialog.showDialog();
    }
}

