/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.utils.TechGroupSummaryLabel;
import com.aem.shelp.tech.utils.TechnicianPicker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;

public class TechnicianPickerPanel {
    private final ActionListener listener;
    private String pickerTitle;
    private final String pickerEmptyText;
    private GbPanel rootComponent = new ColorPropagatingGBPanel();
    private boolean notifyAll;
    private int[] techIDs;
    private int[] groupIDs;
    private String[] techNames;
    private String[] groupNames;
    private JLabel notifyLabel;
    private JButton pickNotificationButton;
    private TechGroupSummaryLabel selectedTechsAndGroupsLabel;
    private boolean allowAllTechnicians = true;
    private Icon titleIcon;

    public TechnicianPickerPanel(boolean oneLine, String pickerTitle, String pickerEmptyText, ActionListener listener) {
        this.pickerTitle = pickerTitle;
        this.pickerEmptyText = pickerEmptyText;
        this.listener = listener;
        this.initUI(oneLine);
    }

    public void allowAllTechnicians(boolean allowAllTechnicians) {
        this.allowAllTechnicians = allowAllTechnicians;
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    private void initUI(boolean oneLine) {
        this.selectedTechsAndGroupsLabel = new TechGroupSummaryLabel(false);
        this.selectedTechsAndGroupsLabel.setTagColor(SHStyle.PANEL_BACKGROUND_BLUE_LIGHTER);
        this.notifyLabel = new JLabel(this.pickerTitle);
        this.notifyLabel.setIconTextGap(SimpleHelpLookAndFeel.scale((int)15));
        this.pickNotificationButton = new JButton(Language.get("NOTIFY_TECH_PICK_BUTTON"));
        this.pickNotificationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TechnicianPickerPanel.this.showPickerDialog();
            }
        });
        this.rootComponent.add((Component)this.notifyLabel, 0, 0, 1, 1, 0, 0, 18, 2, (Insets)new ScaledInsets(8, 0, 0, 3));
        this.rootComponent.add(this.selectedTechsAndGroupsLabel.getRootComponent(), 1, 0, 1, 1, 1, 1, 17, 1);
        this.rootComponent.add((Component)this.pickNotificationButton, 2, 0, 1, 1, 0, 0, 12, 0, (Insets)new ScaledInsets(5, 3, 0, 0));
        this.updateSummaryLabel();
    }

    public boolean isNotifyAll() {
        return this.notifyAll;
    }

    public int[] getTechIDs() {
        return this.techIDs;
    }

    public int[] getGroupIDs() {
        return this.groupIDs;
    }

    public String[] getTechNames() {
        return this.techNames;
    }

    public String[] getGroupNames() {
        return this.groupNames;
    }

    public void setEnabled(boolean enabled) {
        this.notifyLabel.setEnabled(enabled);
        this.selectedTechsAndGroupsLabel.setEnabled(enabled);
    }

    public void setSettings(boolean notifyAllTechs, int[] techIDs, int[] groupIDs, String[] groupNames, String[] techNames) {
        this.notifyAll = notifyAllTechs;
        this.techIDs = techIDs;
        this.groupIDs = groupIDs;
        this.groupNames = groupNames;
        this.techNames = techNames;
        this.updateSummaryLabel();
    }

    private void updateSummaryLabel() {
        if (this.notifyAll || this.groupNames != null && this.groupNames.length > 0 || this.techNames != null && this.techNames.length > 0) {
            this.notifyLabel.setText(this.pickerTitle);
            this.notifyLabel.setIcon(null);
        } else {
            this.notifyLabel.setText("<html>" + this.pickerTitle + " <font color=" + "#626262" + ">" + this.pickerEmptyText);
            this.notifyLabel.setIcon(this.titleIcon);
        }
        if (this.notifyAll) {
            this.selectedTechsAndGroupsLabel.setPickedNotifyAll();
        } else {
            this.selectedTechsAndGroupsLabel.setPickedTechsAndGroups(this.groupNames, this.techNames);
        }
    }

    protected void showPickerDialog() {
        TechnicianPicker dialog = this.notifyAll ? new TechnicianPicker(TechClient.LAST_INSTANCE, true) : new TechnicianPicker(TechClient.LAST_INSTANCE, this.techIDs, this.groupIDs);
        dialog.setAllowAllTechnicians(this.allowAllTechnicians);
        dialog.showDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent));
        this.notifyAll = dialog.notifyAllTechnicians();
        this.groupIDs = dialog.getChosenGroups();
        this.techIDs = dialog.getChosenTechnicians();
        this.groupNames = dialog.getGroupNames();
        this.techNames = dialog.getTechNames();
        this.updateSummaryLabel();
        if (this.listener != null) {
            this.listener.actionPerformed(null);
        }
    }

    public void setBackground(Color background) {
        this.rootComponent.setBackground(background);
        this.selectedTechsAndGroupsLabel.setBackground(background);
    }

    public void setTitleIcon(Icon titleIcon) {
        this.titleIcon = titleIcon;
        this.pickerTitle = "";
        this.updateSummaryLabel();
    }

    public int getButtonWidth() {
        return this.pickNotificationButton.getPreferredSize().width;
    }

    public void setButtonWidth(int buttonWidth) {
        SwingUtil.setWidth((JComponent)this.pickNotificationButton, (int)buttonWidth);
    }

    public int[] getSelectedGroupIDs() {
        return this.groupIDs;
    }

    public String[] getSelectedTechnicianNames() {
        return this.techNames;
    }
}

