/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import com.aem.shelp.common.Language;
import com.aem.shelp.util.progress.SHProgressAnimatedIcon;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import utils.progtools.SingleThreadNotifier;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.images.ImageLoader;

public class SavingLabel {
    private SHProgressAnimatedIcon icon = new SHProgressAnimatedIcon();
    private JLabel rootComponent = new JLabel(ImageLoader.getImageIcon((String)"images/svg/general/ok.svg,16"));
    private static final int SHOW_SAVED_TIME = 3000;
    private static int maxWidth = -1;
    private final Runnable HIDERUNNER = new Runnable(){

        @Override
        public void run() {
            SavingLabel.this.rootComponent.setVisible(false);
            SavingLabel.this.rootComponent.repaint();
        }
    };

    public SavingLabel() {
        this.rootComponent.setVisible(false);
        SwingUtil.setWidth((JComponent)this.rootComponent, (int)maxWidth);
    }

    public int getMaxWidth() {
        return maxWidth;
    }

    public JLabel getRootComponent() {
        return this.rootComponent;
    }

    public void saving() {
        this.rootComponent.setIcon(this.icon);
        this.rootComponent.setText(Language.get("SAVING") + "...");
        this.rootComponent.setVisible(true);
        this.rootComponent.repaint();
    }

    public void saved() {
        this.rootComponent.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/ok.svg,16"));
        this.rootComponent.setText(Language.get("SAVED"));
        this.rootComponent.setVisible(true);
        this.rootComponent.repaint();
        SingleThreadNotifier.runMe(this.HIDERUNNER, 3000, false);
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        SavingLabel label = new SavingLabel();
        System.out.println(label.getMaxWidth());
        System.out.println(label.getRootComponent().getPreferredSize().width);
        frame.getContentPane().add(label.getRootComponent());
        frame.setVisible(true);
        Thread.sleep(1000L);
        label.saving();
        System.out.println(label.getRootComponent().getPreferredSize().width);
        Thread.sleep(1000L);
        label.saved();
        System.out.println(label.getRootComponent().getPreferredSize().width);
    }

    static {
        JLabel test = new JLabel(Language.get("SAVING"));
        maxWidth = test.getPreferredSize().width;
        test = new JLabel(Language.get("SAVED"));
        maxWidth = Math.max(test.getPreferredSize().width, maxWidth);
    }
}

