/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.utils;

import com.aem.shelp.common.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;

public abstract class LanguagePanel {
    private ColorPropagatingGBPanel rootComponent = new ColorPropagatingGBPanel(){

        public Dimension getPreferredSize() {
            return super.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return super.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return super.getPreferredSize();
        }
    };
    private String selectedLanguage;
    private final LanguageIcon[] languages = new LanguageIcon[]{new LanguageIcon(ImageLoader.getImageIconLighter((String)"images/svg/flags/en.svg,32"), ImageLoader.getImageIconLowSaturation((String)"images/svg/flags/en.svg,32"), "en"), new LanguageIcon(ImageLoader.getImageIconLighter((String)"images/svg/flags/gb.svg,32"), ImageLoader.getImageIconLowSaturation((String)"images/svg/flags/gb.svg,32"), "gb"), new LanguageIcon(ImageLoader.getImageIconLighter((String)"images/svg/flags/da.svg,32"), ImageLoader.getImageIconLowSaturation((String)"images/svg/flags/da.svg,32"), "da"), new LanguageIcon(ImageLoader.getImageIconLighter((String)"images/svg/flags/de.svg,32"), ImageLoader.getImageIconLowSaturation((String)"images/svg/flags/de.svg,32"), "de"), new LanguageIcon(ImageLoader.getImageIconLighter((String)"images/svg/flags/es.svg,32"), ImageLoader.getImageIconLowSaturation((String)"images/svg/flags/es.svg,32"), "es"), new LanguageIcon(ImageLoader.getImageIconLighter((String)"images/svg/flags/fr.svg,32"), ImageLoader.getImageIconLowSaturation((String)"images/svg/flags/fr.svg,32"), "fr"), new LanguageIcon(ImageLoader.getImageIconLighter((String)"images/svg/flags/it.svg,32"), ImageLoader.getImageIconLowSaturation((String)"images/svg/flags/it.svg,32"), "it"), new LanguageIcon(ImageLoader.getImageIconLighter((String)"images/svg/flags/nl.svg,32"), ImageLoader.getImageIconLowSaturation((String)"images/svg/flags/nl.svg,32"), "nl"), new LanguageIcon(ImageLoader.getImageIconLighter((String)"images/svg/flags/pt.svg,32"), ImageLoader.getImageIconLowSaturation((String)"images/svg/flags/pt.svg,32"), "pt"), new LanguageIcon(ImageLoader.getImageIconLighter((String)"images/svg/flags/sv.svg,32"), ImageLoader.getImageIconLowSaturation((String)"images/svg/flags/sv.svg,32"), "sv")};

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public LanguagePanel() {
        this.initUI();
        this.selectedLanguage = "en";
        if (Language.DEFLANG_ID != null) {
            this.setSelectedLanguage(Language.DEFLANG_ID);
        }
    }

    protected void selectLanguage(String languageCode) {
        this.setSelectedLanguage(languageCode);
    }

    public void setSelectedLanguage(String language) {
        this.selectedLanguage = language;
        this.rootComponent.repaint();
    }

    private void initUI() {
        ColorPropagatingPanel contents = new ColorPropagatingPanel((LayoutManager)new ScaledFlowLayout(0, SimpleHelpLookAndFeel.scale((int)10), SimpleHelpLookAndFeel.scale((int)10)));
        for (final LanguageIcon language : this.languages) {
            LanguageLabel label = new LanguageLabel(language);
            label.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent me) {
                    LanguagePanel.this.selectLanguage(language.languageFile);
                }
            });
            contents.add((Component)label);
        }
        this.rootComponent.add((Component)contents, 0, 0, 1, 1, 1, 1, 10, 0);
        this.rootComponent.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
    }

    private class LanguageIcon {
        public Icon icon;
        public Icon dimIcon;
        public String languageFile;

        public LanguageIcon(Icon icon, Icon dimIcon, String languageFile) {
            this.icon = icon;
            this.dimIcon = dimIcon;
            this.languageFile = languageFile;
        }
    }

    public class LanguageLabel
    extends JLabel {
        private final LanguageIcon language;

        public LanguageLabel(LanguageIcon language) {
            super(language.icon);
            this.language = language;
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.language.languageFile.equals(LanguagePanel.this.selectedLanguage)) {
                this.setIcon(this.language.icon);
            } else {
                this.setIcon(this.language.dimIcon);
            }
            super.paintComponent(g);
        }
    }
}

