/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.toolbox;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.toolbox.InterpretterOption;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.tech.toolbox.ToolBoxUI;
import com.aem.shelp.tech.toolbox.ToolResourcesUI;
import com.aem.shelp.tech.utils.SHStrippedContentPanel;
import com.aem.shelp.util.swing.IconPicker;
import com.aem.utils.gui.verifiers.CharacterSubSetDocument;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.JSearchTextField;
import utils.swing.components.JWrapLabel;
import utils.swing.components.SimpleTabbedPanel;
import utils.swing.components.StrippedContentPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.dnd.FileDropListener;
import utils.swing.dnd.awt.DragAndDropHandler;
import utils.swing.dnd.awt.DropStatusListener;
import utils.swing.images.ImageLoader;
import utils.swing.layout.BorderPanel;
import utils.swing.layout.GbPanel;
import utils.switches.Switches;

public class ToolBoxItemUI
implements ActionListener,
FileDropListener,
DropStatusListener {
    private final ToolBoxUI toolBoxUI;
    private SimpleTabbedPanel rootComponent = new SimpleTabbedPanel();
    private JScrollPane notesPane = new JScrollPane();
    private JTextArea notesArea = new JTextArea();
    private JScrollPane editPane = new JScrollPane();
    private GbPanel contentComponent = new GbPanel(new ScaledInsets(3, 3, 3, 3));
    private final StrippedContentPanel singleWrapper = new SHStrippedContentPanel(this.contentComponent, false);
    private GbPanel subCommandPanel;
    private GbPanel subScriptPanel;
    private JComboBox interpretterBox;
    private JTextArea scriptArea;
    private JScrollPane scriptScrollPane;
    private JComboBox actionCombo;
    private JLabel icon;
    private JLabel nameLabel;
    private JTextField nameField;
    private JLabel osLabel;
    private JComboBox osBox;
    private ToolResourcesUI resourcesPanel;
    private JLabel resourcesLabel;
    private JLabel noResourcesLabel;
    private JLabel workingDirectoryLabel;
    private JTextField workingDirectoryField;
    private JLabel commandLabel;
    private JTextField commandField;
    private JLabel returnCodeLabel;
    private JTextField returnCodeField;
    private String[] OS_LABELS = new String[]{"Windows", "macOS", "Linux"};
    private ToolBoxItem loadedItem;
    private DragAndDropHandler handler;
    private GbPanel resourcesParentPanel;
    private JCheckBox returnCodeBox;
    private JCheckBox waitBox;

    public void setScriptContents(String scriptContents) {
        this.loadedItem.setScript(scriptContents);
        this.scriptArea.setText(scriptContents);
    }

    public JComponent getRootComponent() {
        return this.rootComponent.getRootComponent();
    }

    public ToolBoxItemUI(ToolBoxUI toolBoxUI) {
        this.toolBoxUI = toolBoxUI;
        this.initUI();
    }

    private void initUI() {
        JComponent[] allLabels;
        this.rootComponent.useSmallFonts();
        this.rootComponent.addTab(Language.get("TB_CONFIG"), ImageLoader.getImageIcon((String)"images/svg/computing/sliders.svg,16"), this.editPane);
        this.rootComponent.addTab(Language.get("TB_NOTES"), ImageLoader.getImageIcon((String)"images/svg/general/page.svg,16"), this.notesPane);
        this.notesPane.setViewportView(this.notesArea);
        this.notesPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.editPane.setViewportView((Component)this.contentComponent);
        this.editPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.icon = new JLabel();
        this.icon.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
        this.icon.setOpaque(true);
        this.icon.setBorder(SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createLineBorder((Color)SHStyle.BORDER_COLOR), (Border)SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5)));
        this.icon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                ToolBoxItemUI.this.showIconPicker();
            }
        });
        this.nameLabel = new JLabel(Language.get("TOOLBOX_NAME"));
        this.osLabel = new JLabel(Language.get("TOOLBOX_OS"));
        this.workingDirectoryLabel = new JLabel(Language.get("TOOLBOX_WORKING_DIR"));
        this.commandLabel = new JLabel(Language.get("TOOLBOX_COMMAND_LINE"));
        this.resourcesLabel = new JLabel(Language.get("TOOLBOX_RESOURCES"));
        this.returnCodeLabel = new JLabel(Language.get("TOOLBOX_RETURN_CODE"));
        this.noResourcesLabel = new JLabel(Language.get("TOOLBOX_NO_RESOURCES"));
        JLabel actionLabel = new JLabel(Language.get("TOOLBOX_ACTION"));
        JLabel emptyLabel = new JLabel();
        JLabel interpretterLabel = new JLabel(Language.get("TOOLBOX_INTERPRETTER"));
        JLabel scriptContentsLabel = new JLabel(Language.get("TOOLBOX_SCRIPT_CONTENTS"));
        for (JLabel jLabel : allLabels = new JLabel[]{this.nameLabel, this.osLabel, this.workingDirectoryLabel, this.commandLabel, this.resourcesLabel, this.returnCodeLabel, emptyLabel, actionLabel, scriptContentsLabel, interpretterLabel}) {
            jLabel.setHorizontalAlignment(4);
        }
        this.nameField = new JTextField();
        this.osBox = new JComboBox<String>(this.OS_LABELS);
        this.osBox.setSelectedIndex(0);
        this.osBox.addActionListener(this);
        this.workingDirectoryField = new JSearchTextField(Language.get("TOOLBOX_WORKING_DIRECT_DEFAULT"));
        this.commandField = new JTextField();
        this.resourcesPanel = new ToolResourcesUI();
        this.returnCodeField = new JSearchTextField("0");
        JButton choose = new JButton(Language.get("CHOOSE"));
        choose.addActionListener(new CommandAction(this.commandField));
        SwingUtil.setWidth((JComponent)this.returnCodeField, (int)SimpleHelpLookAndFeel.scale((int)50));
        this.returnCodeField.setDocument(new CharacterSubSetDocument(new char[]{','}){

            @Override
            protected boolean include(char c) {
                if (super.include(c)) {
                    return true;
                }
                return Character.isDigit(c);
            }
        });
        JWrapLabel resourcesDesc = new JWrapLabel("<html>" + Language.get("TOOLBOX_RESOURCES_DESC"));
        resourcesDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        JWrapLabel commandDesc = new JWrapLabel("<html>" + Language.get("TOOLBOX_RUN_COMMAND_DESC"));
        commandDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        JWrapLabel jWrapLabel = new JWrapLabel("<html>" + Language.get("TOOLBOX_WORKING_DIR_DESC"));
        jWrapLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        JWrapLabel returnCodeDesc = new JWrapLabel("<html>" + Language.get("TOOLBOX_RETURN_CODE_DESC"));
        returnCodeDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.actionCombo = new JComboBox<String>(new String[]{Language.get("TOOLBOX_RUN_COMMAND"), Language.get("TOOLBOX_EXECUTE_SCRIPT")});
        this.actionCombo.setSelectedIndex(0);
        this.actionCombo.addActionListener(this);
        JPanel resourcesContainer = new JPanel(new BorderLayout());
        resourcesContainer.add((Component)this.noResourcesLabel, "North");
        resourcesContainer.add((Component)this.resourcesPanel.getRootComponent(), "North");
        int Y = 0;
        GbPanel namePanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        namePanel.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3));
        namePanel.add((Component)this.nameLabel, 0, Y, 1, 1, 0, 0, 13, 0);
        namePanel.add((Component)this.nameField, 1, Y++, 1, 1, 1, 0, 17, 2);
        namePanel.add((Component)this.osLabel, 0, Y, 1, 1, 0, 0, 13, 0);
        namePanel.add((Component)this.osBox, 1, Y++, 1, 1, 0, 0, 17, 2);
        namePanel.add((Component)this.icon, 2, 0, 1, 2, 0, 0, 10, 1);
        this.resourcesParentPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        this.resourcesParentPanel.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)0, (int)3, (int)3));
        Y = 0;
        this.resourcesParentPanel.add((Component)this.resourcesLabel, 0, Y, 1, 1, 0, 0, 12, 0);
        this.resourcesParentPanel.add((Component)resourcesDesc, 1, Y++, 1, 1, 1, 0, 17, 2);
        this.resourcesParentPanel.add((Component)resourcesContainer, 1, Y++, 1, 1, 0, 0, 17, 1);
        this.handler = new DragAndDropHandler(this);
        this.handler.setStatusListener(this);
        this.handler.addDragAndDropToComponent(resourcesContainer);
        this.handler.addDragAndDropToComponent(this.resourcesPanel.getRootComponent());
        this.handler.addDragAndDropToComponent((Component)this.resourcesParentPanel);
        this.handler.addDragAndDropToComponent((Component)resourcesDesc);
        this.dragExit();
        ColorPropagatingGBPanel commandPanel = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
        commandPanel.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3));
        Y = 0;
        commandPanel.add(actionLabel, 0, Y, 1, 1, 0, 0, 13, 0);
        commandPanel.add(this.actionCombo, 1, Y++, 1, 1, 1, 0, 17, 2);
        this.subCommandPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        int YY = 0;
        this.subCommandPanel.add((Component)commandDesc, 1, YY++, 1, 1, 1, 0, 17, 2);
        BorderPanel bp = new BorderPanel((Insets)new ScaledInsets(0, 0, 0, 0));
        if (Switches.SH_showToolboxCommonTools) {
            SHButtonUI.makeButtonSegmentedRight((AbstractButton)choose);
            bp.addEast((JComponent)choose);
        }
        bp.addCenter((JComponent)this.commandField);
        this.subCommandPanel.add((Component)this.commandLabel, 0, YY, 1, 1, 0, 0, 13, 0);
        this.subCommandPanel.add((Component)bp, 1, YY++, 1, 1, 1, 0, 17, 2);
        this.subScriptPanel = new GbPanel(new ScaledInsets(3, 3, 3, 3));
        YY = 0;
        this.scriptArea = new JTextArea();
        this.scriptArea.setEditable(false);
        this.scriptArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent m) {
                ToolBoxItemUI.this.toolBoxUI.switchToScriptView(ToolBoxItemUI.this.loadedItem.getScript(), (InterpretterOption)ToolBoxItemUI.this.interpretterBox.getSelectedItem());
            }
        });
        this.scriptScrollPane = new JScrollPane(this.scriptArea);
        this.interpretterBox = new JComboBox();
        this.interpretterBox.addActionListener(this);
        this.subScriptPanel.add((Component)interpretterLabel, 0, YY, 1, 1, 0, 0, 13, 0);
        this.subScriptPanel.add((Component)this.interpretterBox, 1, YY++, 1, 1, 1, 0, 17, 2);
        this.subScriptPanel.add((Component)scriptContentsLabel, 0, YY, 1, 1, 0, 0, 18, 0, (Insets)new ScaledInsets(8, 3, 3, 3));
        this.subScriptPanel.add((Component)this.scriptScrollPane, 1, YY++, 1, 1, 1, 0, 17, 2);
        SwingUtil.setHeight((JComponent)this.scriptScrollPane, (int)SimpleHelpLookAndFeel.scale((int)100));
        commandPanel.add((Component)this.subCommandPanel, 0, Y++, 2, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        commandPanel.add((Component)this.subScriptPanel, 0, Y++, 2, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(0, 0, 0, 0));
        commandPanel.add((Component)jWrapLabel, 1, Y++, 1, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(3, 3, 3, 3));
        commandPanel.add(this.workingDirectoryLabel, 0, Y, 1, 1, 0, 0, 13, 0);
        commandPanel.add(this.workingDirectoryField, 1, Y++, 1, 1, 1, 0, 17, 2);
        ColorPropagatingGBPanel returnCodePanel = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
        returnCodePanel.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3));
        this.waitBox = new JCheckBox(Language.get("TOOLBOX_WAIT_FINISH"));
        this.waitBox.addActionListener(this);
        returnCodePanel.add((Component)returnCodeDesc, 1, Y++, 1, 1, 1, 0, 17, 2);
        this.returnCodeBox = new JCheckBox(Language.get("TOOLBOX_RETURN_CODE_MSG"));
        this.returnCodeBox.addActionListener(this);
        returnCodePanel.add(emptyLabel, 0, Y, 1, 1, 0, 0, 13, 0);
        returnCodePanel.add(this.waitBox, 1, Y++, 1, 1, 1, 0, 17, 2);
        returnCodePanel.add(this.returnCodeBox, 1, Y++, 1, 1, 1, 0, 17, 2);
        returnCodePanel.add(this.returnCodeLabel, 0, Y, 1, 1, 0, 0, 13, 0);
        returnCodePanel.add(this.returnCodeField, 1, Y++, 1, 1, 1, 0, 17, 2);
        SwingUtil.setSizesToWidest((JComponent[])allLabels);
        this.singleWrapper.addContent((JComponent)namePanel, null);
        this.singleWrapper.addContent((JComponent)this.resourcesParentPanel, null);
        this.singleWrapper.addContent((JComponent)((Object)commandPanel), null);
        this.singleWrapper.addContent((JComponent)((Object)returnCodePanel), null);
        this.singleWrapper.addVerticalFiller();
        this.singleWrapper.setBackgroundColours();
        this.updateInterpretterBox();
        this.updateVisible();
    }

    private void showIconPicker() {
        String newIcon = IconPicker.showPickerDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent.getRootComponent()));
        if (newIcon != null) {
            this.loadedItem.setIconFieldName(newIcon);
            this.icon.setIcon(this.loadedItem.getIcon(48));
        }
    }

    private void updateVisible() {
        this.returnCodeLabel.setVisible(this.returnCodeBox.isSelected() && this.waitBox.isSelected());
        this.returnCodeField.setVisible(this.returnCodeBox.isSelected() && this.waitBox.isSelected());
        this.returnCodeBox.setEnabled(this.waitBox.isSelected());
        this.subCommandPanel.setVisible(this.actionCombo.getSelectedIndex() == 0);
        this.subScriptPanel.setVisible(this.actionCombo.getSelectedIndex() == 1);
        this.rootComponent.getRootComponent().repaint();
    }

    public void load(ToolBoxItem item, boolean isImported) {
        this.loadedItem = item;
        this.nameField.setText(item.getName());
        this.icon.setIcon(item.getIcon(48));
        this.notesArea.setText(item.getNotes());
        switch (item.getTargetOperatingSystem()) {
            case 0: {
                this.osBox.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.osBox.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.osBox.setSelectedIndex(2);
            }
        }
        this.updateInterpretterBox();
        this.workingDirectoryField.setText(item.getWorkingDirectory());
        this.commandField.setText(item.getCommandLine());
        this.resourcesPanel.load(item, isImported);
        if (item.getSuccessReturnCodes() != null && item.getSuccessReturnCodes().length() > 0) {
            this.returnCodeBox.setSelected(true);
            this.returnCodeField.setText(item.getSuccessReturnCodes());
        } else {
            this.returnCodeBox.setSelected(false);
            this.returnCodeField.setText("");
        }
        this.waitBox.setSelected(item.waitForProcessToFinish());
        for (Component c : this.contentComponent.getComponents()) {
            if (!(c instanceof JTextField) && !(c instanceof JComboBox)) continue;
            c.setEnabled(!isImported);
        }
        if (item.getType() == 0) {
            this.actionCombo.setSelectedIndex(0);
        } else {
            this.actionCombo.setSelectedIndex(1);
        }
        this.scriptArea.setText(item.getScript());
        boolean found = false;
        if (item.getScriptInterpretterID() != null) {
            for (int i = 0; i < this.interpretterBox.getModel().getSize() - 1; ++i) {
                InterpretterOption option = (InterpretterOption)this.interpretterBox.getModel().getElementAt(i);
                if (!option.id.equals(item.getScriptInterpretterID())) continue;
                found = true;
                this.interpretterBox.setSelectedItem(option);
                break;
            }
        }
        if (!found) {
            if (item.getScriptInterpretterCommand() != null) {
                this.interpretterBox.setSelectedItem(this.interpretterBox.getModel().getElementAt(this.interpretterBox.getModel().getSize() - 1));
                this.interpretterBox.getEditor().setItem(item.getScriptInterpretterCommand());
            } else {
                this.interpretterBox.setSelectedIndex(0);
            }
        }
        this.updateVisible();
    }

    public void save(ToolBoxItem item) {
        item.setName(this.nameField.getText());
        item.setWorkingDirectory(this.workingDirectoryField.getText());
        item.setCommandLine(this.commandField.getText());
        switch (this.osBox.getSelectedIndex()) {
            case 0: {
                item.setTargetOperatingSystem(0);
                break;
            }
            case 1: {
                item.setTargetOperatingSystem(1);
                break;
            }
            case 2: {
                item.setTargetOperatingSystem(2);
            }
        }
        if (this.returnCodeBox.isSelected()) {
            item.setSuccessReturnCodes(this.returnCodeField.getText());
        } else {
            item.setSuccessReturnCodes("");
        }
        if (this.actionCombo.getSelectedIndex() == 0) {
            item.setType((byte)0);
        } else {
            item.setType((byte)1);
        }
        item.setScript(this.scriptArea.getText());
        item.setNotes(this.notesArea.getText());
        if (this.interpretterBox.getSelectedItem() instanceof String) {
            item.setScriptInterpretter((String)this.interpretterBox.getSelectedItem(), "");
        } else {
            InterpretterOption option = (InterpretterOption)this.interpretterBox.getSelectedItem();
            item.setScriptInterpretter(option.interpretterCommand, option.id);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.returnCodeBox || e.getSource() == this.waitBox || e.getSource() == this.actionCombo) {
            this.updateVisible();
        } else if (e.getSource() == this.osBox) {
            this.updateInterpretterBox();
        } else if (e.getSource() == this.interpretterBox) {
            if (this.interpretterBox.getSelectedItem() instanceof String) {
                this.interpretterBox.setEditable(true);
            } else {
                InterpretterOption option = (InterpretterOption)this.interpretterBox.getSelectedItem();
                if (option.isCustom()) {
                    this.interpretterBox.setEditable(true);
                } else {
                    this.interpretterBox.setEditable(false);
                }
            }
        }
    }

    private void updateInterpretterBox() {
        switch (this.osBox.getSelectedIndex()) {
            case 0: {
                this.interpretterBox.setModel(new DefaultComboBoxModel<InterpretterOption>(InterpretterOption.WINDOWS_INTERPRETTERS));
                break;
            }
            case 1: {
                this.interpretterBox.setModel(new DefaultComboBoxModel<InterpretterOption>(InterpretterOption.LINUX_INTERPRETTERS));
                break;
            }
            case 2: {
                this.interpretterBox.setModel(new DefaultComboBoxModel<InterpretterOption>(InterpretterOption.MACOS_INTERPRETTERS));
            }
        }
    }

    @Override
    public void filesDropped(File[] files) {
        this.dragExit();
        this.resourcesPanel.addResources(files);
    }

    @Override
    public void dragEnter() {
        this.resourcesParentPanel.setBorder((Border)new DashedBorder());
    }

    @Override
    public void dragExit() {
        this.resourcesParentPanel.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
    }

    @Override
    public void dragOver() {
        this.dragEnter();
    }

    class CommandAction
    implements ActionListener {
        JTextField field;

        public CommandAction(JTextField field) {
            this.field = field;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CommonCommand val;
            Vector<CommonCommand> vec = new Vector<CommonCommand>();
            if (ToolBoxItemUI.this.osBox.getSelectedIndex() == 0) {
                vec.add(new CommonCommand(Language.get("COMMON_COMMAND_WIN_UPDATE"), "wuauclt.exe /detectnow /updatenow"));
                vec.add(new CommonCommand(Language.get("COMMON_COMMAND_CHECKDISK"), "chkdsk C: /F /R"));
                vec.add(new CommonCommand(Language.get("COMMON_COMMAND_SYSTEMFILES"), "sfc /scannow"));
                vec.add(new CommonCommand(Language.get("COMMON_COMMAND_DISK_CLEANUP"), "cleanmgr /dC"));
                vec.add(new CommonCommand(Language.get("COMMON_COMMAND_TASK_MANAGER"), "taskmgr"));
                vec.add(new CommonCommand(Language.get("COMMON_COMMAND_RESTART"), "shutdown /r"));
                vec.add(new CommonCommand(Language.get("COMMON_COMMAND_RESTART_F"), "shutdown /f /r /t 0"));
                vec.add(new CommonCommand(Language.get("COMMON_COMMAND_SHUTDOWN"), "shutdown /s"));
                vec.add(new CommonCommand(Language.get("COMMON_COMMAND_SHUTDOWN_F"), "shutdown /f /s /t 0"));
            } else if (ToolBoxItemUI.this.osBox.getSelectedIndex() == 1) {
                vec.add(new CommonCommand(Language.get("COMMON_COMMAND_RESTART"), "shutdown -r 0"));
                vec.add(new CommonCommand(Language.get("COMMON_COMMAND_SHUTDOWN"), "shutdown -h 0"));
                vec.add(new CommonCommand(Language.get("COMMON_COMMAND_OSX_REPAIR_PERMS"), "diskutil repairvolume /"));
                vec.add(new CommonCommand(Language.get("COMMON_COMMAND_OPEN_APP"), "open -a Calculator.app"));
            } else {
                vec.add(new CommonCommand(Language.get("COMMON_COMMAND_RESTART"), "shutdown -r 0"));
                vec.add(new CommonCommand(Language.get("COMMON_COMMAND_SHUTDOWN"), "shutdown -h 0"));
            }
            JList list = new JList(vec);
            BorderPanel bp = new BorderPanel();
            JScrollPane pane = new JScrollPane(list);
            pane.setPreferredSize(SimpleHelpLookAndFeel.scale((Dimension)new Dimension(500, 200)));
            pane.setHorizontalScrollBarPolicy(31);
            bp.add((Component)pane);
            if (SHGlassOptionPane.showConfirmDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)ToolBoxItemUI.this.getRootComponent()), (JComponent)bp, (String)Language.get("CHOOSE_COMMAND"), (String)Language.get("CHOOSE")) && (val = (CommonCommand)list.getSelectedValue()) != null) {
                this.field.setText(val.cmd);
                this.field.repaint();
            }
        }
    }

    class CommonCommand {
        String desc;
        String cmd;

        public CommonCommand(String desc, String cmd) {
            this.desc = desc;
            this.cmd = cmd;
        }

        public String toString() {
            return " " + this.desc + "    ";
        }
    }

    private class DashedBorder
    extends AbstractBorder {
        private DashedBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new ScaledInsets(5, 5, 5, 5);
        }

        @Override
        public void paintBorder(Component comp, Graphics g, int x, int y, int w, int h) {
            int width = SimpleHelpLookAndFeel.scale((int)3);
            Graphics2D gg = (Graphics2D)g;
            gg.setColor(SHStyle.OK_TEXT_COLOR);
            gg.setStroke(new BasicStroke(width, 0, 1, 0.0f, new float[]{SimpleHelpLookAndFeel.scale((int)5)}, 0.0f));
            gg.drawRoundRect(x + 1, y + 1, w - width - 1, h - width - 1, SimpleHelpLookAndFeel.scale((int)5), SimpleHelpLookAndFeel.scale((int)5));
        }
    }
}

