/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.software;

import com.aem.shelp.common.Language;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.software.AbstractSoftwareTable;
import com.aem.shelp.tech.software.AbstractSoftwareTableCellRenderer;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import utils.software.windows.WindowsHotFix;
import utils.software.windows.WindowsSoftware;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.simplelist.jtable.TableStructure;

public class WindowsHotfixTable
extends AbstractSoftwareTable<WindowsHotFix> {
    public WindowsHotfixTable(AccessPanelListener accessPanelListener) {
        super(accessPanelListener);
    }

    @Override
    protected TableCellRenderer createTableRenderer() {
        return new HotfixRenderer();
    }

    @Override
    protected TableStructure getTableStructure() {
        TableStructure ts = TableStructure.createTableStructure(WindowsHotFix.class, new String[]{"installedOn", "hotFixID", "description", "caption"}, new String[]{Language.get("SOFTWARE_INSTALL"), Language.get("SOFTWARE_HOTFIX_ID"), Language.get("SOFTWARE_APP_DESCRIPTION"), Language.get("SOFTWARE_CAPTION")});
        ts.setMaxWidths(new int[]{SimpleHelpLookAndFeel.scale((int)100), SimpleHelpLookAndFeel.scale((int)150), -1, -1});
        return ts;
    }

    public void load(WindowsSoftware software) {
        ArrayList<WindowsHotFix> applications = software.getHotFixesArray();
        this.list.startBatch();
        try {
            this.list.setListContents(applications);
        }
        finally {
            this.list.endBatch();
        }
    }

    public class HotfixRenderer
    extends AbstractSoftwareTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 0) {
                label.setFont(SHStyle.smallerFont);
            } else {
                label.setFont(UIManager.getFont("Label.font"));
            }
            if (column == 0) {
                long time = (Long)value;
                label.setText(WindowsHotfixTable.this.dateFormatter.formatDate(time));
            }
            return label;
        }
    }
}

