/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.software;

import com.aem.shelp.common.Language;
import com.aem.shelp.tech.access.AccessPanelListener;
import com.aem.shelp.tech.software.AbstractSoftwareTable;
import com.aem.shelp.tech.software.AbstractSoftwareTableCellRenderer;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import utils.software.macos.OSXSoftware;
import utils.software.macos.OSXUpdate;
import utils.software.windows.WindowsUpdate;
import utils.swing.customlaf.SHStyle;
import utils.swing.simplelist.jtable.TableStructure;

public class OSXUpdatesTable
extends AbstractSoftwareTable<OSXUpdate> {
    public OSXUpdatesTable(AccessPanelListener accessPanelListener) {
        super(accessPanelListener);
    }

    @Override
    protected TableCellRenderer createTableRenderer() {
        return null;
    }

    @Override
    protected TableStructure getTableStructure() {
        return TableStructure.createTableStructure(WindowsUpdate.class, new String[]{"id", "name", "updateVersion", "isRecommended", "restartRequired", "sizeBytes"}, new String[]{Language.get("SOFTWARE_UPDATE_ID"), Language.get("SOFTWARE_APP_NAME"), Language.get("SOFTWARE_APP_VERSION"), Language.get("SOFTWARE_UPDATE_RECOMMENDED"), Language.get("SOFTWARE_UPDATE_RESTART"), Language.get("SOFTWARE_UPDATE_SIZE")});
    }

    public void load(OSXSoftware software) {
        ArrayList applications = software.getUpdatesArray();
        this.list.startBatch();
        try {
            this.list.setListContents(applications);
        }
        finally {
            this.list.endBatch();
        }
    }

    public class SoftwareRenderer
    extends AbstractSoftwareTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 0) {
                label.setFont(SHStyle.smallerFont);
            } else {
                label.setFont(UIManager.getFont("Label.font"));
            }
            if (column == 0) {
                long time = (Long)value;
                label.setText(OSXUpdatesTable.this.dateFormatter.formatDate(time));
            } else if (column == 6) {
                byte arch = (Byte)value;
                if (arch == 1) {
                    label.setText("64 bit");
                } else if (arch == 2) {
                    label.setText("32 bit");
                } else {
                    label.setText("");
                }
            } else if (column == 7) {
                byte type = (Byte)value;
                if (type == 2) {
                    label.setText("Intel");
                } else if (type == 1) {
                    label.setText("PPC");
                } else {
                    label.setText("");
                }
            } else if (column == 8) {
                byte obtained = (Byte)value;
                if (obtained == 1) {
                    label.setText("Apple");
                } else if (obtained == 2) {
                    label.setText("App Store");
                } else if (obtained == 3) {
                    label.setText("Developer");
                } else {
                    label.setText("");
                }
            }
            return label;
        }
    }
}

