/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.properties;

import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.TechUi;
import com.aem.shelp.tech.admin.PasswordDialog;
import com.aem.shelp.tech.utils.LanguagePanel;
import com.aem.shelp.tech.utils.SHStrippedContentPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;
import jwrapper.jwutils.JWInstallApp;
import jwrapper.jwutils.JWSystem;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.avatar.AvatarPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;
import utils.swing.pagedproperties.PageListener;
import utils.swing.pagedproperties.PropertiesPage;

public class TechAccountProperties
extends PropertiesPage
implements ActionListener {
    private JButton changePasswordButton;
    private JButton logoutButton;
    private JButton reconnectButton_debug;
    private TransientTechUser techUser;
    private TechClient client;
    private AvatarPanel avatarPanel;
    private TechUi techui;
    private JLabel emailDesc;
    private final Object AVATAR_LOCK = new Object();
    private TechAvatarFetchThread avatarFetchThread = null;
    private AvatarPanel.AvatarChangeListener avatarChangeListener = new AvatarPanel.AvatarChangeListener(){

        @Override
        public void avatarChanged(byte[] imageBytes) {
            ((TechAccountProperties)TechAccountProperties.this).techUser.avatarBytes = imageBytes;
            try {
                TechAccountProperties.this.client.setAvatarImage(((TechAccountProperties)TechAccountProperties.this).techUser.username, imageBytes);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    };
    private JLabel emailLabel;
    private JLabel displayNameLabel;
    private JLabel usernameLabel;

    public TechAccountProperties(PageListener listener, TechUi techui) {
        super(listener);
        this.techui = techui;
        this.initUI();
    }

    public void hideLogoutButton() {
        this.logoutButton.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTechClient(TechClient client) {
        this.client = client;
        if (client != null) {
            this.techUser = client.getTechUser();
            this.changePasswordButton.setVisible(this.techUser.techUserCanChangePassword());
            this.avatarPanel.setVisible(!this.techUser.isServerAdmin() && !this.techUser.isAnonymousLogin);
            this.usernameLabel.setText(this.techUser.username);
            this.displayNameLabel.setText(this.techUser.displayName);
            boolean showEmail = this.techUser.emailAddress != null && this.techUser.emailAddress.trim().length() != 0;
            this.emailLabel.setVisible(showEmail);
            this.emailDesc.setVisible(showEmail);
            this.emailLabel.setText(this.techUser.emailAddress);
            if (this.techUser != null && !this.techUser.isServerAdmin()) {
                this.avatarPanel.setAvatarLoading();
                Object object = this.AVATAR_LOCK;
                synchronized (object) {
                    if (this.avatarFetchThread != null) {
                        this.avatarFetchThread.die();
                    }
                    this.avatarFetchThread = new TechAvatarFetchThread(this.techUser);
                    this.avatarFetchThread.start();
                }
            }
            this.repaint();
        }
    }

    private void initUI() {
        GbPanel panel = new GbPanel();
        SHStrippedContentPanel contentsPanel = new SHStrippedContentPanel(panel);
        GbPanel mainWrapper = new GbPanel();
        mainWrapper.add((Component)panel, 0, 0, 1, 1, 1, 1, 11, 1);
        JScrollPane pane = new JScrollPane((Component)mainWrapper);
        pane.setBorder(SHBorderFactory.createEmptyBorder());
        this.setLayout(new GridLayout(1, 1));
        this.add(pane);
        ColorPropagatingPanel subPanel = new ColorPropagatingPanel();
        subPanel.setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)10, (int)10, (int)0));
        GbPanelWrapper availabilityWrapper = new GbPanelWrapper((Container)subPanel, (Insets)new ScaledInsets(5, 5, 5, 5));
        JLabel usernameDesc = new JLabel(Language.get("ADMIN_LOGIN_NAME") + " ");
        usernameDesc.setHorizontalAlignment(4);
        usernameDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.usernameLabel = new JLabel();
        JLabel displayNameDesc = new JLabel(Language.get("ADMIN_TECH_NAME") + " ");
        displayNameDesc.setHorizontalAlignment(4);
        displayNameDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.displayNameLabel = new JLabel();
        this.emailDesc = new JLabel(Language.get("EMAIL_ADDRESS") + " ");
        this.emailDesc.setHorizontalAlignment(4);
        this.emailDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.emailLabel = new JLabel();
        this.changePasswordButton = new JButton(Language.get("ADMIN_PASSWORD"), ImageLoader.getImageIcon((String)"images/svg/general/lock.svg,16"));
        this.changePasswordButton.addActionListener(this);
        this.logoutButton = new JButton(Language.get("LOGOUT"), ImageLoader.getImageIcon((String)"images/svg/computing/power-off.svg,16"));
        this.logoutButton.addActionListener(this);
        this.reconnectButton_debug = new JButton(Language.get("RECONNECT"));
        this.reconnectButton_debug.addActionListener(this);
        this.avatarPanel = new AvatarPanel(100, 100, null, ImageLoader.getAsImage((String)"images/svg/users/technician.svg,48"), this.avatarChangeListener, ImageLoader.getImageIconDisabled((String)"images/svg/general/cancel.svg,16"));
        this.avatarPanel.setBorder(SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createLineBorder((Color)SHStyle.BORDER_COLOR), (Border)SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)3, (int)3)));
        int Y = 0;
        ColorPropagatingGBPanel buttonsPanel = new ColorPropagatingGBPanel(new ScaledInsets(5, 5, 5, 5));
        buttonsPanel.add(this.changePasswordButton, 0, 0, 1, 1, 1, 0, 10, 1);
        buttonsPanel.add(this.logoutButton, 0, 1, 1, 1, 1, 0, 10, 1);
        buttonsPanel.add(new JPanel(), 0, 2, 1, 1, 1, 1, 10, 1);
        SHButtonUI.makeButtonRed((JButton)this.logoutButton);
        availabilityWrapper.add((Component)usernameDesc, 1, Y, 1, 1, 0, 0, 13, 0);
        availabilityWrapper.add((Component)this.usernameLabel, 2, Y++, 1, 1, 100, 0, 17, 2);
        if (CentralDebugging.SHOW_RECONNECT_IN_TECH_UI_DEBUG) {
            availabilityWrapper.add((Component)this.reconnectButton_debug, 3, Y++, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(3, 3, 3, 0));
        }
        availabilityWrapper.add((Component)displayNameDesc, 1, Y, 1, 1, 0, 0, 13, 0);
        availabilityWrapper.add((Component)this.displayNameLabel, 2, Y++, 1, 1, 100, 0, 17, 2);
        availabilityWrapper.add((Component)this.emailDesc, 1, Y, 1, 1, 0, 0, 13, 0);
        availabilityWrapper.add((Component)this.emailLabel, 2, Y++, 1, 1, 100, 0, 17, 2);
        availabilityWrapper.add((Component)new JPanel(), 1, Y++, 2, 1, 100, 100, 17, 2);
        availabilityWrapper.add((Component)((Object)this.avatarPanel), 0, 0, 1, Y, 0, 0, 11, 0, (Insets)new ScaledInsets(0, 10, 0, 20));
        availabilityWrapper.add((Component)((Object)buttonsPanel), 3, 0, 1, Y, 0, 0, 12, 1, (Insets)new ScaledInsets(0, 0, 0, 0));
        contentsPanel.addContent((JComponent)subPanel, Language.get("TECH_UI_ACCOUNT_DETAILS"));
        final JButton restartButton = new JButton(Language.get("SWITCH_LANGUAGE"));
        restartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JWSystem.forkVirtualApp((String)JWSystem.getMyAppName(), null, null, (boolean)false, (boolean)true);
                    Thread.sleep(1000L);
                    System.exit(0);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        restartButton.setEnabled(false);
        GbPanel restartButtonPanel = new GbPanel();
        restartButtonPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)5));
        restartButtonPanel.add((Component)restartButton, 0, 0, 1, 1, 1, 1, 10, 0);
        ColorPropagatingPanel languagePanel = new ColorPropagatingPanel((LayoutManager)new BorderLayout());
        LanguagePanel languageChangePanel = new LanguagePanel(){

            @Override
            protected void selectLanguage(String languageCode) {
                super.selectLanguage(languageCode);
                try {
                    JWInstallApp.setChosenLanguage((String)languageCode);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                restartButton.setEnabled(true);
            }
        };
        languagePanel.add((Component)languageChangePanel.getRootComponent(), (Object)"West");
        languagePanel.add((Component)restartButtonPanel, (Object)"East");
        contentsPanel.addContent((JComponent)languagePanel, Language.get("TECH_UI_LANGUAGE"));
        contentsPanel.addVerticalFiller();
        contentsPanel.setBackgroundColours();
    }

    @Override
    public void load(Object loadFromObject) {
    }

    @Override
    public void save(Object saveToObject) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PasswordDialog dialog;
        Object o = e.getSource();
        if (o == this.logoutButton) {
            this.techui.logoutTechnician(true);
        } else if (o == this.reconnectButton_debug) {
            try {
                this.techui.reconnectTechnician();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else if (o == this.changePasswordButton && (dialog = new PasswordDialog((RootPaneContainer)((Object)this.getRootPane().getParent()), false, this.techUser.username, null, false)).isOK()) {
            String newPassword = new String(dialog.getSetPassword());
            try {
                if (this.client.setTechnicianPassword(newPassword)) {
                    SHGlassOptionPane.showMessageDialog((RootPaneContainer)((RootPaneContainer)((Object)this.getRootPane().getParent())), (String)Language.get("PASSWORD_CHANGED_MESSAGE"), (String)Language.get("PASSWORD_CHANGED_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/ok.svg,48"), (String)Language.get("CLOSE"));
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)((RootPaneContainer)((Object)this.getRootPane().getParent())), (String)t.getMessage(), (String)Language.get("CONFIG_SAVE_ERROR"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
            }
        }
    }

    @Override
    public boolean checkIfValid() {
        return true;
    }

    class TechAvatarFetchThread
    extends Thread {
        private TransientTechUser user;
        private boolean die;

        public TechAvatarFetchThread(TransientTechUser user) {
            super("TechAvatarFetchThread");
            this.die = false;
            this.user = user;
        }

        public void die() {
            this.die = true;
        }

        @Override
        public void run() {
            byte[] avatar;
            try {
                avatar = ((TechAccountProperties)TechAccountProperties.this).techUser.avatarBytes == null ? TechAccountProperties.this.client.getAvatarImage(this.user.username) : ((TechAccountProperties)TechAccountProperties.this).techUser.avatarBytes;
            }
            catch (Exception e) {
                System.out.println("[TechAvatarFetchThread] Unable to fetch avatar for user " + this.user.username);
                e.printStackTrace();
                byte[] dummy = new byte[]{};
                TechAccountProperties.this.avatarPanel.setAvatarImage(dummy);
                return;
            }
            if (!this.die) {
                this.user.avatarBytes = avatar;
                TechAccountProperties.this.avatarPanel.setAvatarImage(avatar);
            }
        }
    }
}

