/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.properties;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.properties.TechProperties;
import com.aem.shelp.proxy.config.TransientTechUser;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.utils.SHStrippedContentPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;
import utils.swing.pagedproperties.PageListener;
import utils.swing.pagedproperties.PropertiesPage;

public class SessionPreferencesPanel
extends PropertiesPage
implements ActionListener {
    JLabel description;
    JLabel note;
    JCheckBox useUDPBox;
    JCheckBox useDirectBox;
    private TransientTechUser user;

    public SessionPreferencesPanel(PageListener listener) {
        super(listener);
        this.initUI();
    }

    public void setTechClient(TechClient client) {
        this.user = client.getTechUser();
    }

    private void initUI() {
        GbPanel panel = new GbPanel();
        SHStrippedContentPanel contentsPanel = new SHStrippedContentPanel(panel);
        GbPanel mainWrapper = new GbPanel();
        mainWrapper.add((Component)panel, 0, 0, 1, 1, 1, 1, 11, 1);
        JScrollPane pane = new JScrollPane((Component)mainWrapper);
        pane.setBorder(SHBorderFactory.createEmptyBorder());
        this.setLayout(new GridLayout(1, 1));
        this.add(pane);
        ColorPropagatingPanel mainPanel = new ColorPropagatingPanel();
        GbPanelWrapper borderWrapper = new GbPanelWrapper((Container)mainPanel);
        this.description = new JLabel(Language.get("TECH_PROP_DESC"));
        this.note = new JLabel(Language.get("TECH_PROP_NOTE"));
        this.useUDPBox = new JCheckBox(Language.get("TECH_PROP_USE_UDP"));
        this.useDirectBox = new JCheckBox(Language.get("TECH_PROP_USE_DIRECT"));
        int Y = 0;
        this.useUDPBox.addActionListener(this);
        this.useDirectBox.addActionListener(this);
        borderWrapper.add((Component)this.description, 0, Y++, 1, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(3, 3, 10, 3));
        borderWrapper.add((Component)this.useUDPBox, 0, Y++, 1, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(3, 3, 3, 3));
        borderWrapper.add((Component)this.useDirectBox, 0, Y++, 1, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(0, 20, 3, 3));
        borderWrapper.add((Component)this.note, 0, Y++, 1, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(10, 3, 3, 3));
        Y = 0;
        this.updateEnabled();
        contentsPanel.addContent((JComponent)mainPanel, Language.get("TECH_SESSION_TITLE"));
        contentsPanel.addVerticalFiller();
        contentsPanel.setBackgroundColours();
    }

    private void updateEnabled() {
        if (this.user == null || this.user.getPermissions().canUseUDP()) {
            this.useUDPBox.setEnabled(true);
            this.useDirectBox.setEnabled(this.useUDPBox.isSelected());
        } else {
            this.useUDPBox.setEnabled(false);
            this.useDirectBox.setEnabled(false);
        }
    }

    @Override
    public void load(Object loadFromObject) {
        Properties props = (Properties)loadFromObject;
        this.useUDPBox.setSelected(Boolean.parseBoolean(props.getProperty(TechProperties.PROP_UDP, "true")));
        this.useDirectBox.setSelected(Boolean.parseBoolean(props.getProperty(TechProperties.PROP_DIRECT, "true")));
        this.updateEnabled();
    }

    @Override
    public void save(Object saveToObject) {
        Properties props = (Properties)saveToObject;
        props.setProperty(TechProperties.PROP_UDP, Boolean.toString(this.useUDPBox.isSelected()));
        props.setProperty(TechProperties.PROP_DIRECT, Boolean.toString(this.useDirectBox.isSelected()));
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        super.contentChanged(true);
        this.updateEnabled();
    }

    @Override
    public boolean checkIfValid() {
        return true;
    }
}

