/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.portforward;

import aurelienribon.slidinglayout.DoTransition;
import aurelienribon.slidinglayout.SLAnimator;
import aurelienribon.slidinglayout.SLConfig;
import aurelienribon.slidinglayout.SLKeyframe;
import aurelienribon.slidinglayout.SLPanel;
import aurelienribon.slidinglayout.SLSide;
import aurelienribon.slidinglayout.SLTransition;
import com.aem.shelp.common.Language;
import com.aem.shelp.tech.portforward.CommonTCPPorts;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import utils.swing.SwingUtil;
import utils.swing.components.JSearchTextField;
import utils.swing.components.JWrapTextPaneLabel;
import utils.swing.components.SHJTable;
import utils.swing.components.messagefields.MessageFieldHandler;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.PanelGlassDialog;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.renderers.AlignTableCellRendererWrapper;
import utils.swing.renderers.BorderedTableCellRendererWrapper;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;
import utils.swing.simplelist.wrapper.filter.FilterWrapper;

public class NewServicePanel
extends PanelGlassDialog
implements ListSelectionListener,
MessageFieldHandler.FilterListener {
    public JPanel rootComponent = new JPanel(new BorderLayout());
    private JPanel targetPickerPanel = new JPanel(new BorderLayout(5, 5));
    private JLabel label = new JLabel();
    private JSearchTextField searchTextField;
    private SHJTable portTable;
    private SimpleList<CommonTCPPorts.TCPPort> portList;
    private FilterWrapper<CommonTCPPorts.TCPPort> filterWrapper;
    private SimpleTableModel tableModel;
    private BorderedTableCellRendererWrapper portRenderer;
    private JToggleButton customButton = new JToggleButton(Language.get("CUSTOM"));
    private boolean showCustomPanel;
    private GbPanel customPanel = new GbPanel(new ScaledInsets(5, 5, 5, 5));
    private JTextField nameField;
    private JTextField portField;
    private final SLPanel containerSliding = new SLPanel();
    private SLConfig mainConfig;
    private SLConfig groupsConfig;
    private final int mode_CONFIG = 0;
    private final int mode_GROUPS = 1;
    float modeTime = 0.5f;
    private int modeCurrent = 0;

    public NewServicePanel(RootPaneContainer rpc) {
        super(rpc, Language.get("NEW_SERVICE"), 470, Language.get("CONNECT"), Language.get("CANCEL"));
        this.initUI();
        this.addLeftComponent(this.customButton);
        this.customButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewServicePanel.this.setShowCustomPanel(NewServicePanel.this.customButton.isSelected());
            }
        });
        this.setContentPanel(this.rootComponent);
        this.rootComponent.setPreferredSize(SimpleHelpLookAndFeel.scaledDimension((int)400, (int)470));
        this.showDialog();
    }

    private void switchToNewView(SLConfig myConfig, int myMode, Component myComponent) {
        if (this.modeCurrent != myMode) {
            SLSide mySide = myMode > this.modeCurrent ? SLSide.BOTTOM : SLSide.TOP;
            SLTransition trans = this.containerSliding.createTransition().push(new SLKeyframe(myConfig, 0.5f).setStartSide(mySide, myComponent));
            new DoTransition(trans).start();
            this.modeCurrent = myMode;
        }
    }

    private void switchToCustomView() {
        this.switchToNewView(this.groupsConfig, 1, (Component)this.customPanel);
    }

    private void switchToNormalView() {
        this.switchToNewView(this.mainConfig, 0, this.targetPickerPanel);
    }

    private void initUI() {
        this.nameField = TextField.getTextFieldForType((int)0, (String)"Remote Desktop");
        this.portField = TextField.getTextFieldForType((int)1, (String)"3389");
        SwingUtil.setWidth((JComponent)this.portField, (int)SimpleHelpLookAndFeel.scale((int)100));
        JLabel nameLabel = new JLabel(Language.get("PF_SERVICE_NAME"));
        JLabel portLabel = new JLabel(Language.get("PF_SERVICE_PORT"));
        nameLabel.setHorizontalAlignment(4);
        portLabel.setHorizontalAlignment(4);
        KeyAdapter changeListener = new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                NewServicePanel.this.updateEnabled();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                NewServicePanel.this.updateEnabled();
            }
        };
        this.nameField.addKeyListener(changeListener);
        this.portField.addKeyListener(changeListener);
        this.customPanel.add((Component)nameLabel, 0, 0, 1, 1, 0, 1, 13, 2);
        this.customPanel.add((Component)this.nameField, 1, 0, 1, 1, 1, 1, 10, 2);
        this.customPanel.add((Component)portLabel, 0, 1, 1, 1, 0, 1, 13, 2);
        this.customPanel.add((Component)this.portField, 1, 1, 1, 1, 1, 1, 10, 2);
        this.mainConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.targetPickerPanel);
        this.groupsConfig = new SLConfig(this.containerSliding).gap(0, 0);
        this.groupsConfig.col(1.0f).row(1.0f).row(100);
        this.groupsConfig.place(0, 0, this.targetPickerPanel);
        this.groupsConfig.place(1, 0, (Component)this.customPanel);
        this.containerSliding.setTweenManager(SLAnimator.createTweenManager());
        this.containerSliding.initialize(this.mainConfig);
        this.portList = new SimpleList();
        this.filterWrapper = new FilterWrapper<CommonTCPPorts.TCPPort>(this.portList);
        TableStructure ts = TableStructure.createTableStructure(CommonTCPPorts.TCPPort.class, new String[]{"getPortAsString", "name"}, new String[]{Language.get("PORT"), Language.get("DESCRIPTION")});
        ts.setMinWidths(new int[]{SimpleHelpLookAndFeel.scale((int)60), -1});
        ts.setMaxWidths(new int[]{SimpleHelpLookAndFeel.scale((int)60), -1});
        ts.setAlignment(new int[]{2, 2});
        this.tableModel = new SimpleTableModel(this.filterWrapper, ts);
        this.portTable = new SHJTable();
        this.portTable.setRowHeight(SimpleHelpLookAndFeel.scale((int)26));
        this.portTable.getSelectionModel().addListSelectionListener(this);
        this.tableModel.assignToTable(this.portTable);
        this.portRenderer = new BorderedTableCellRendererWrapper(this.portTable.getDefaultRenderer(Object.class));
        this.portTable.setDefaultRenderer(Object.class, this.portRenderer);
        TableCellRenderer headerRenderer = this.portTable.getTableHeader().getDefaultRenderer();
        headerRenderer = new BorderedTableCellRendererWrapper(new AlignTableCellRendererWrapper(headerRenderer, 2));
        this.portTable.getTableHeader().setDefaultRenderer(headerRenderer);
        ts.initTableDimensions(this.portTable);
        this.searchTextField = new JSearchTextField(Language.get("SEARCH_TREE_TEXT"));
        this.searchTextField.addIcon(ImageLoader.getImageIcon((String)"images/svg/general/cancel.svg,16"), true, true, "CLEAR");
        this.searchTextField.addIcon(ImageLoader.getImageIcon((String)"images/svg/general/magnifying-glass.svg,16"), false, false, "SEARCH");
        this.searchTextField.setFilterListener(this);
        JScrollPane tableScroller = new JScrollPane(this.portTable);
        JPanel paddedPanel = new JPanel(new GridLayout(1, 1));
        paddedPanel.add(this.searchTextField);
        paddedPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)15, (int)0));
        JPanel filterTable = new JPanel(new BorderLayout());
        filterTable.add((Component)paddedPanel, "North");
        filterTable.add((Component)tableScroller, "Center");
        JWrapTextPaneLabel pickServiceLabel = new JWrapTextPaneLabel(Language.get("PF_PICK_SERVICE_TITLE"));
        pickServiceLabel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)10, (int)0));
        this.targetPickerPanel.add((Component)pickServiceLabel, "North");
        this.targetPickerPanel.add((Component)filterTable, "Center");
        this.rootComponent.add((Component)this.containerSliding, "Center");
        Collections.addAll(this.portList, CommonTCPPorts.PORTS);
    }

    public void setFilter(String filter, boolean immediately) {
        this.filterWrapper.setCaseSensitive(false);
        this.filterWrapper.setFilterText(filter);
    }

    public void updateEnabled() {
        this.setOkEnabled(this.isValid());
    }

    protected boolean isValid() {
        if (this.showCustomPanel) {
            if (this.nameField.getText().length() == 0) {
                return false;
            }
            try {
                int port = Integer.parseInt(this.portField.getText());
                return port >= 0 && port <= 65536;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return this.portTable.getSelectedRowCount() > 0;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateEnabled();
    }

    public void setShowCustomPanel(boolean showCustomPanel) {
        this.showCustomPanel = showCustomPanel;
        if (showCustomPanel) {
            this.switchToCustomView();
        } else {
            this.switchToNormalView();
        }
        this.updateEnabled();
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        new NewServicePanel((RootPaneContainer)frame);
    }

    public CommonTCPPorts.TCPPort getSelectedPort() {
        if (this.showCustomPanel) {
            return new CommonTCPPorts.TCPPort(Integer.parseInt(this.portField.getText()), this.nameField.getText(), null);
        }
        return (CommonTCPPorts.TCPPort)this.filterWrapper.get(this.portTable.getSelectedRow());
    }
}

