/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.invitations;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.invitations.InvitationConfiguration;
import com.aem.shelp.tech.invitations.InvitationRepositoryGlassDialog;
import com.aem.shelp.tech.invitations.InvitationStandardGlassDialog;
import com.aem.shelp.util.PleaseWaitDialog;
import javax.swing.Icon;
import javax.swing.RootPaneContainer;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;

public class InvitationClient {
    private PleaseWaitDialog pleaseWaitDialog;
    private CancelDownloadListener cancelDownloadListener = new CancelDownloadListener();
    private RootPaneContainer rpc;
    private TechClient client;

    public InvitationClient(RootPaneContainer rpc, TechClient client, String hostname) {
        this.rpc = rpc;
        this.client = client;
    }

    public void showInvitationRepository() {
        this.pleaseWaitDialog = new PleaseWaitDialog(this.rpc, Language.get("PLEASE_WAIT_TITLE"), Language.get("INVITE_DOWNLOAD") + "...", this.cancelDownloadListener);
        new InvitationDownloaderThread().start();
    }

    public void showDefaultInvitation() {
        new InvitationStandardGlassDialog(this.rpc, this.client);
    }

    class CancelDownloadListener
    implements PleaseWaitDialog.PleaseWaitCancelListener {
        CancelDownloadListener() {
        }

        @Override
        public void cancelled() {
            if (InvitationClient.this.pleaseWaitDialog != null) {
                InvitationClient.this.pleaseWaitDialog.hideDialog();
            }
        }
    }

    class InvitationDownloaderThread
    extends Thread {
        InvitationDownloaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TechClient.EditableInvitationWrapper[] invitations = null;
            InvitationConfiguration configuration = null;
            try {
                invitations = InvitationClient.this.client.getAllInvitations();
                configuration = InvitationClient.this.client.getInvitationConfiguration();
            }
            catch (Exception e) {
                e.printStackTrace();
                String message = e.getMessage();
                if (message == null) {
                    message = "";
                }
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)InvitationClient.this.rpc, (String)(Language.get("INVITE_ERROR") + "\n" + message), (String)Language.get("INVITE_ERROR_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
            }
            finally {
                if (InvitationClient.this.pleaseWaitDialog != null) {
                    InvitationClient.this.pleaseWaitDialog.hideDialog();
                }
            }
            if (invitations == null || configuration == null) {
                return;
            }
            InvitationRepositoryGlassDialog dialog = new InvitationRepositoryGlassDialog(InvitationClient.this.rpc, invitations, configuration, InvitationClient.this.client);
        }
    }
}

