/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.history;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.history.SearchConfig;
import com.aem.shelp.proxy.history.HistoryMetrics;
import com.aem.shelp.proxy.techclient.TechClientSource;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.history.TimelineModel;
import com.aem.shelp.tech.history.TimelineSlider;
import com.aem.shelp.tech.history.metrics.MetricsHeader;
import com.aem.shelp.tech.reporting.ReportRequest;
import com.aem.shelp.tech.reporting.ReportResult;
import com.aem.shelp.tech.utils.MachinesPickerPanel;
import com.aem.shelp.tech.utils.SHStrippedContentPanel;
import com.aem.shelp.tech.utils.TechnicianPickerPanel;
import com.aem.shelp.util.ErrorDialogs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import utils.ostools.OSDirs;
import utils.progtools.SaverUtil;
import utils.progtools.StackTracer;
import utils.swing.SafeJFileChooser;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.components.FixedSizePanel;
import utils.swing.components.JSearchTextField;
import utils.swing.components.JSmartPopupMenu;
import utils.swing.components.JWrapLabel;
import utils.swing.components.StrippedContentPanel;
import utils.swing.components.messagefields.MessageFieldHandler;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class HistorySearchPanel
implements ActionListener,
TimelineModel.TimelineSelectionListener,
MessageFieldHandler.FilterListener,
SaverUtil.SaveListener {
    private final HistoryFilterChangeListener listener;
    private GbPanel rootComponent = new ColorPropagatingGBPanel();
    private JToggleButton searchButton;
    private JToggleButton metricsButton;
    private JButton addFilterButton;
    private JButton reportButton;
    private MetricsHeader metricsHeader;
    private GbPanel filtersPanel;
    private ColorPropagatingGBPanel typeFilter;
    private JCheckBox supportBox;
    private JCheckBox accessBox;
    private JCheckBox presentationBox;
    private ColorPropagatingGBPanel textFilter;
    private JSearchTextField messageTextField;
    private ColorPropagatingGBPanel technicianFilter;
    private TechnicianPickerPanel technicianPickerPanel;
    private ColorPropagatingGBPanel machineFilter;
    private MachinesPickerPanel machinesPickerPanel;
    private ColorPropagatingGBPanel timePanel;
    private TimelineSlider slider;
    private JPanel centrePanel;
    private SaverUtil changeNotifier = new SaverUtil("HistorySearchPanel", 500, this, false);
    TechClientSource tcsource;
    static String lastSaveLocation = OSDirs.getDesktopDir().getAbsolutePath();

    public HistorySearchPanel(HistoryFilterChangeListener listener, TechClientSource tcsource) {
        this.listener = listener;
        this.tcsource = tcsource;
        this.initUI();
    }

    public SearchConfig getSearchConfig() {
        SearchConfig config = new SearchConfig();
        config.setStartTime(this.slider.getModel().getSelectionStartTime());
        config.setEndTime(this.slider.getModel().getSelectionEndTime());
        if (this.textFilter.isVisible()) {
            config.setTextFilter(this.messageTextField.getText());
        }
        if (this.machineFilter.isVisible()) {
            config.setMachineIDs(this.machinesPickerPanel.getSelectedMachinesIDs());
        }
        if (this.technicianFilter.isVisible()) {
            config.setTechnicianGroups(this.technicianPickerPanel.getSelectedGroupIDs());
            config.setTechnicianNameFilters(this.technicianPickerPanel.getSelectedTechnicianNames());
        }
        if (this.typeFilter.isVisible()) {
            config.setSessionTypes(this.supportBox.isSelected(), this.accessBox.isSelected(), this.presentationBox.isSelected());
        }
        return config;
    }

    public void setMachineTreeModel(MachineTreeModel model) {
        this.machinesPickerPanel.setMachineTreeModel(model);
    }

    public void initUI() {
        this.rootComponent.setBorder(SHStyle.BUTTON_BAR_BORDER);
        ColorPropagatingPanel leftPanel = new ColorPropagatingPanel((LayoutManager)new BorderLayout());
        JPanel leftButtonsPanel = new JPanel(new GridLayout(1, 2));
        this.searchButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/general/magnifying-glass.svg,28"));
        this.metricsButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/charts/bar.svg,28"));
        SHButtonUI.makeButtonSegmentedLeft((AbstractButton)this.searchButton);
        SHButtonUI.makeButtonSegmentedRight((AbstractButton)this.metricsButton);
        this.searchButton.addActionListener(this);
        this.metricsButton.addActionListener(this);
        this.searchButton.setSelected(true);
        leftButtonsPanel.add(this.searchButton);
        leftButtonsPanel.add(this.metricsButton);
        leftPanel.add((Component)leftButtonsPanel, "North");
        this.centrePanel = new ColorPropagatingPanel((LayoutManager)new GridLayout(1, 1));
        this.filtersPanel = new ColorPropagatingGBPanel();
        this.timePanel = new ColorPropagatingGBPanel();
        this.timePanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)8, (int)0, (int)8));
        TimelineModel model = new TimelineModel(System.currentTimeMillis() - 5184000000L, System.currentTimeMillis(), 0);
        this.slider = new TimelineSlider(model);
        model.addTimelineListener(this);
        this.timePanel.add(this.slider.getRootComponent(), 0, 0, 1, 1, 1, 1, 11, 1);
        SwingUtil.setHeight((JComponent)((Object)this.timePanel), (int)this.searchButton.getPreferredSize().height);
        this.machineFilter = new ColorPropagatingGBPanel();
        this.machineFilter.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)8, (int)0, (int)5));
        this.machinesPickerPanel = new MachinesPickerPanel(true, "", Language.get("HISTORY_FILTER_MACHINES_NONE"), this);
        this.machinesPickerPanel.setTitleIcon(ImageLoader.getImageIconLighter((String)"images/svg/technology/screen.svg,16"));
        this.machineFilter.add(this.machinesPickerPanel.getRootComponent(), 0, 0, 1, 1, 1, 1, 10, 1);
        this.machineFilter.setVisible(false);
        this.technicianFilter = new ColorPropagatingGBPanel();
        this.technicianFilter.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)8, (int)0, (int)5));
        this.technicianPickerPanel = new TechnicianPickerPanel(true, Language.get("HISTORY_FILTER_TECHNICIAN2"), Language.get("NOTIFY_TECH_NONE"), this);
        this.technicianPickerPanel.setTitleIcon(ImageLoader.getImageIconLighter((String)"images/svg/users/technician.svg,16"));
        this.technicianFilter.add(this.technicianPickerPanel.getRootComponent(), 0, 0, 1, 1, 1, 1, 10, 1);
        this.technicianFilter.setVisible(false);
        int buttonWidth = Math.max(this.machinesPickerPanel.getButtonWidth(), this.technicianPickerPanel.getButtonWidth());
        this.machinesPickerPanel.setButtonWidth(buttonWidth);
        this.technicianPickerPanel.setButtonWidth(buttonWidth);
        this.textFilter = new ColorPropagatingGBPanel();
        this.textFilter.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)0, (int)5));
        this.messageTextField = new JSearchTextField(Language.get("FILTER") + "...");
        this.messageTextField.addIcon(ImageLoader.getImageIcon((String)"images/svg/general/cancel.svg,16"), true, true, "CLEAR");
        this.messageTextField.setFilterListener(this);
        this.textFilter.add(this.messageTextField, 0, 0, 1, 1, 1, 1, 10, 1);
        this.textFilter.setVisible(false);
        this.typeFilter = new ColorPropagatingGBPanel();
        this.typeFilter.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)0, (int)5));
        this.supportBox = new JCheckBox(Language.get("SUPPORTSESSION"));
        this.supportBox.setIconTextGap(SimpleHelpLookAndFeel.scale((int)10));
        this.accessBox = new JCheckBox(Language.get("ACCESSSESSION"));
        this.accessBox.setIconTextGap(SimpleHelpLookAndFeel.scale((int)10));
        this.presentationBox = new JCheckBox(Language.get("PRESENTATIONSESSION"));
        this.presentationBox.setIconTextGap(SimpleHelpLookAndFeel.scale((int)10));
        this.supportBox.setSelected(true);
        this.accessBox.setSelected(true);
        this.presentationBox.setSelected(true);
        this.typeFilter.add(this.supportBox, 0, 0, 1, 1, 1, 1, 17, 1);
        this.typeFilter.add(this.accessBox, 1, 0, 1, 1, 1, 1, 17, 1);
        this.typeFilter.add(this.presentationBox, 2, 0, 1, 1, 1, 1, 17, 1);
        this.supportBox.addActionListener(this);
        this.accessBox.addActionListener(this);
        this.presentationBox.addActionListener(this);
        this.typeFilter.setVisible(false);
        SwingUtil.setSizesToTallest((JComponent[])new JComponent[]{this.typeFilter, this.textFilter, this.technicianFilter, this.machineFilter});
        int Y = 0;
        this.filtersPanel.add((Component)((Object)this.timePanel), 0, Y++, 0, 1, 1, 0, 10, 1);
        this.filtersPanel.add((Component)((Object)this.typeFilter), 0, Y++, 0, 1, 1, 0, 10, 1);
        this.filtersPanel.add((Component)((Object)this.machineFilter), 0, Y++, 0, 1, 1, 0, 10, 1);
        this.filtersPanel.add((Component)((Object)this.technicianFilter), 0, Y++, 0, 1, 1, 0, 10, 1);
        this.filtersPanel.add((Component)((Object)this.textFilter), 0, Y++, 0, 1, 1, 0, 10, 1);
        this.filtersPanel.add((Component)new FixedSizePanel(0, 0), 0, Y++, 0, 1, 1, 1, 10, 1);
        this.metricsHeader = new MetricsHeader();
        this.metricsHeader.getRootComponent().setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)5, (int)0, (int)5));
        SwingUtil.setHeight((JComponent)this.metricsHeader.getRootComponent(), (int)SimpleHelpLookAndFeel.scale((int)100));
        this.centrePanel.add((Component)this.filtersPanel);
        ColorPropagatingPanel rightPanel = new ColorPropagatingPanel((LayoutManager)new BorderLayout());
        JPanel rightButtonsPanel = new JPanel(new GridLayout(1, 2));
        this.addFilterButton = new JButton(ImageLoader.getImageIcon((String)"images/svg/general/funnel.svg,28"));
        this.reportButton = new JButton(ImageLoader.getImageIcon((String)"images/svg/arrows/share.svg,28"));
        SHButtonUI.makeButtonSegmentedLeft((AbstractButton)this.addFilterButton);
        SHButtonUI.makeButtonSegmentedRight((AbstractButton)this.reportButton);
        this.addFilterButton.addActionListener(this);
        this.reportButton.addActionListener(this);
        rightButtonsPanel.add(this.addFilterButton);
        rightButtonsPanel.add(this.reportButton);
        rightPanel.add((Component)rightButtonsPanel, "North");
        this.rootComponent.add((Component)leftPanel, 0, 0, 1, 1, 0, 1, 10, 1);
        this.rootComponent.add((Component)this.centrePanel, 1, 0, 1, 1, 1, 1, 10, 1);
        this.rootComponent.add((Component)rightPanel, 2, 0, 1, 1, 0, 1, 10, 1);
        this.rootComponent.setBackground(SHStyle.BUTTON_BAR_BACKGROUND);
        this.metricsHeader.setBackground(SHStyle.BUTTON_BAR_BACKGROUND);
        this.switchToSearchButton();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            this.changeNotifier.queueSave();
        } else if (e.getSource() == this.searchButton) {
            this.switchToSearchButton();
        } else if (e.getSource() == this.metricsButton) {
            this.switchToMetricsButton();
        } else if (e.getSource() == this.addFilterButton) {
            this.configureFilters();
        } else if (e.getSource() == this.reportButton) {
            new Thread(){

                @Override
                public void run() {
                    HistorySearchPanel.this.showHistoryPanelReportDialog(SwingUtil.getRootPaneContainer((Component)HistorySearchPanel.this.rootComponent));
                }
            }.start();
        } else {
            this.changeNotifier.queueSave();
        }
    }

    private void configureFilters() {
        FilterListPanel filterListPanel = new FilterListPanel(this.machineFilter.isVisible(), this.technicianFilter.isVisible(), this.textFilter.isVisible(), this.typeFilter.isVisible());
        JSmartPopupMenu menu = new JSmartPopupMenu();
        menu.setBackground(SHStyle.PANEL_BACKGROUND_WHITE);
        menu.add((Component)((Object)filterListPanel));
        menu.show(this.addFilterButton, this.addFilterButton.getPreferredSize().width - filterListPanel.getPreferredSize().width - 1, this.addFilterButton.getPreferredSize().height + 1);
    }

    private void switchToMetricsButton() {
        this.centrePanel.removeAll();
        this.centrePanel.add(this.metricsHeader.getRootComponent());
        this.centrePanel.revalidate();
        this.centrePanel.repaint();
        this.searchButton.setSelected(false);
        this.metricsButton.setSelected(true);
    }

    private void switchToSearchButton() {
        this.centrePanel.removeAll();
        this.centrePanel.add((Component)this.filtersPanel);
        this.centrePanel.revalidate();
        this.centrePanel.repaint();
        this.searchButton.setSelected(true);
        this.metricsButton.setSelected(false);
    }

    @Override
    public void timelineChanged(long startTime, long endTime) {
        this.changeNotifier.queueSave();
    }

    public GbPanel getRootComponent() {
        return this.rootComponent;
    }

    public void setFilter(String filter, boolean immediately) {
        this.changeNotifier.queueSave();
    }

    @Override
    public void performSave() {
        this.listener.historyFilterChanged();
    }

    public void setMetrics(HistoryMetrics metrics) {
        this.metricsHeader.initWith(metrics);
    }

    public void setModelTimeRange(long oldestTime, long currentTimeMillis) {
        this.slider.getModel().setTotalDuration(oldestTime, currentTimeMillis);
    }

    public void setSliderToShowAllData() {
        this.slider.getModel().setSliderToShowAllData();
    }

    public void filterForSpecificSession(AbstractSession abstractSession) {
        this.messageTextField.setText(abstractSession.getSessionID());
        this.textFilter.setVisible(true);
        this.changeNotifier.queueSaveIn(100L);
    }

    public void showHistoryPanelReportDialog(RootPaneContainer rpc) {
        HistoryPanelReportDialog requestDialog = new HistoryPanelReportDialog();
        requestDialog.showDialog(rpc);
        if (requestDialog.isOK()) {
            ReportRequest config = new ReportRequest();
            SearchConfig search = this.getSearchConfig();
            search.roundStartAndEndTimesToStartAndEndOfMonth();
            search.setDescendingOrder();
            config.reportOnHistory(search);
            config.notify = requestDialog.notifyWhenDone.isSelected();
            if (requestDialog.sessionReport.isSelected()) {
                config.reportType = 2;
            } else if (requestDialog.techniciansReport.isSelected()) {
                config.reportType = 3;
                if (requestDialog.type.getSelectedIndex() == 1) {
                    config.setPDF();
                }
            }
            File targetDir = new File(requestDialog.reportSaveDirectory.getText());
            if (!targetDir.exists()) {
                targetDir.mkdirs();
            }
            File reportFile = new File(targetDir, config.getReportFileName(0));
            try {
                int count = 1;
                while (reportFile.exists()) {
                    reportFile = new File(targetDir, config.getReportFileName(++count));
                }
                ReportResult result = this.tcsource.getTechClient().requestReport(config);
                result.exportTo(reportFile);
            }
            catch (Throwable t) {
                String reason = StackTracer.getStacktrace((Throwable)t);
                t.printStackTrace();
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)rpc, (String)Language.get("REPORT_ERROR_MESSAGE"), (String)Language.get("REPORT_ERROR_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
                ErrorDialogs.ErrorGlassDialog dialog = new ErrorDialogs.ErrorGlassDialog(rpc, Language.get("REPORT_ERROR_TITLE"), null, true, true);
                String msg = t.getMessage();
                if (msg == null) {
                    dialog.setText(Language.get("REPORT_ERROR_MESSAGE"), Language.get("REPORT_ERROR_MESSAGE") + ".<BR>(" + t.getClass().getSimpleName() + ")", reason);
                } else {
                    dialog.setText(Language.get("REPORT_ERROR_MESSAGE"), Language.get("REPORT_ERROR_MESSAGE") + ".<BR>(" + t.getClass().getSimpleName() + "," + msg + ")", reason);
                }
                dialog.setVisible(true);
            }
        }
    }

    class FilterListPanel
    extends ColorPropagatingPanel
    implements ActionListener {
        private JCheckBox machineFilterBox;
        private JCheckBox technicianFilterBox;
        private JCheckBox textFieldBox;
        private JCheckBox typeFilterBox;

        public FilterListPanel(boolean showMachines, boolean showTechnicians, boolean showText, boolean showType) {
            super((LayoutManager)new GridLayout(0, 1, SimpleHelpLookAndFeel.scale((int)10), SimpleHelpLookAndFeel.scale((int)10)));
            this.initUI(showMachines, showTechnicians, showText, showType);
            this.setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)10, (int)10, (int)10));
        }

        private void initUI(boolean showMachines, boolean showTechnicians, boolean showText, boolean showType) {
            this.machineFilterBox = new JCheckBox(Language.get("HISTORY_FILTER_MACHINE"));
            this.technicianFilterBox = new JCheckBox(Language.get("HISTORY_FILTER_TECHNICIAN"));
            this.textFieldBox = new JCheckBox(Language.get("HISTORY_FILTER_TEXT"));
            this.typeFilterBox = new JCheckBox(Language.get("HISTORY_FILTER_TYPE"));
            this.machineFilterBox.setSelected(showMachines);
            this.technicianFilterBox.setSelected(showTechnicians);
            this.textFieldBox.setSelected(showText);
            this.typeFilterBox.setSelected(showType);
            this.machineFilterBox.setIconTextGap(SimpleHelpLookAndFeel.scale((int)15));
            this.technicianFilterBox.setIconTextGap(SimpleHelpLookAndFeel.scale((int)15));
            this.textFieldBox.setIconTextGap(SimpleHelpLookAndFeel.scale((int)15));
            this.typeFilterBox.setIconTextGap(SimpleHelpLookAndFeel.scale((int)15));
            this.machineFilterBox.addActionListener(this);
            this.technicianFilterBox.addActionListener(this);
            this.textFieldBox.addActionListener(this);
            this.typeFilterBox.addActionListener(this);
            this.add(this.typeFilterBox);
            this.add(this.machineFilterBox);
            this.add(this.technicianFilterBox);
            this.add(this.textFieldBox);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.machineFilterBox) {
                HistorySearchPanel.this.machineFilter.setVisible(this.machineFilterBox.isSelected());
            } else if (e.getSource() == this.technicianFilterBox) {
                HistorySearchPanel.this.technicianFilter.setVisible(this.technicianFilterBox.isSelected());
            } else if (e.getSource() == this.textFieldBox) {
                HistorySearchPanel.this.textFilter.setVisible(this.textFieldBox.isSelected());
            } else if (e.getSource() == this.typeFilterBox) {
                HistorySearchPanel.this.typeFilter.setVisible(this.typeFilterBox.isSelected());
            }
            HistorySearchPanel.this.filtersPanel.repaint();
        }
    }

    public static interface HistoryFilterChangeListener {
        public void historyFilterChanged();
    }

    static class HistoryPanelReportDialog
    extends OKCancelDialogPanel
    implements KeyListener {
        private JTextField reportSaveDirectory;
        private JButton directoryPicker;
        private JRadioButton sessionReport;
        private JRadioButton techniciansReport;
        private JCheckBox notifyWhenDone;
        private RootPaneContainer rpc;
        private JComboBox type;

        public HistoryPanelReportDialog() {
            super(Language.get("REQUEST_REPORT"), Language.get("CANCEL"));
            JPanel contentPanel = this.getContentPanel();
            contentPanel.setPreferredSize(SimpleHelpLookAndFeel.scale((Dimension)new Dimension(500, 300)));
            FixedWidthPanel panel = new FixedWidthPanel((JComponent)contentPanel);
            this.setContent((FixedWidthComponent)panel);
            this.reportSaveDirectory.addKeyListener(this);
        }

        public void showDialog(RootPaneContainer rpc) {
            this.rpc = rpc;
            AbstractGlassDialog abstractGlassDialog = new AbstractGlassDialog(rpc, 500, (AbstractDialogPanel)this);
            abstractGlassDialog.setTitle(Language.get("HISTORY_REPORT"));
            abstractGlassDialog.showDialog();
        }

        protected JPanel getContentPanel() {
            this.sessionReport = new JRadioButton();
            this.techniciansReport = new JRadioButton();
            this.notifyWhenDone = new JCheckBox(Language.get("REPORT_NOTIFY_DONE"));
            ButtonGroup group = new ButtonGroup();
            group.add(this.sessionReport);
            group.add(this.techniciansReport);
            this.sessionReport.setSelected(true);
            JLabel inventoryReportTitle = new JLabel(Language.get("REPORT_SESSION_TITLE"));
            JLabel usageReportTitle = new JLabel(Language.get("REPORT_TECHNICIANS_TITLE"));
            JWrapLabel inventoryReportDesc = new JWrapLabel("<html>" + Language.get("REPORT_SESSION_DESC"));
            JWrapLabel usageReportDesc = new JWrapLabel("<html>" + Language.get("REPORT_TECHNICIANS_DESC"));
            MouseAdapter choice1 = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    HistoryPanelReportDialog.this.sessionReport.setSelected(true);
                }
            };
            MouseAdapter choice2 = new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    HistoryPanelReportDialog.this.techniciansReport.setSelected(true);
                }
            };
            inventoryReportTitle.addMouseListener(choice1);
            inventoryReportDesc.addMouseListener(choice1);
            usageReportTitle.addMouseListener(choice2);
            usageReportDesc.addMouseListener(choice2);
            inventoryReportDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            usageReportDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            ColorPropagatingGBPanel main = new ColorPropagatingGBPanel();
            SHStrippedContentPanel singleWrapper = new SHStrippedContentPanel(main, false);
            singleWrapper.setTopBottomPadding(2);
            ColorPropagatingGBPanel options = new ColorPropagatingGBPanel(new ScaledInsets(3, 3, 3, 3));
            options.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)20, (int)0, (int)0));
            int Y = 0;
            options.add(this.sessionReport, 0, Y, 1, 1, 0, 0, 11, 1);
            options.add(inventoryReportTitle, 1, Y++, 1, 1, 1, 0, 11, 1);
            options.add((Component)inventoryReportDesc, 1, Y++, 1, 1, 1, 0, 11, 1, (Insets)new ScaledInsets(0, 3, 10, 3));
            options.add(this.techniciansReport, 0, Y, 1, 1, 0, 0, 11, 1);
            options.add(usageReportTitle, 1, Y++, 1, 1, 0, 0, 11, 1);
            options.add((Component)usageReportDesc, 1, Y++, 1, 1, 0, 0, 11, 1, (Insets)new ScaledInsets(0, 3, 10, 3));
            singleWrapper.addContent((JComponent)((Object)options), Language.get("HISTORY_REPORT_TYPE_TITLE"), false);
            ColorPropagatingGBPanel settings = new ColorPropagatingGBPanel(new ScaledInsets(5, 5, 5, 5));
            this.reportSaveDirectory = new JTextField(lastSaveLocation);
            this.directoryPicker = new JButton(ImageLoader.getImageIcon((String)"images/svg/general/magnifying-glass.svg,16"));
            SHButtonUI.makeButtonSegmentedRight((AbstractButton)this.directoryPicker);
            this.directoryPicker.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File directory = SafeJFileChooser.saveDirectory((Component)((Component)((Object)HistoryPanelReportDialog.this.rpc)), (File)new File(HistoryPanelReportDialog.this.reportSaveDirectory.getText()));
                    if (directory != null) {
                        HistoryPanelReportDialog.this.reportSaveDirectory.setText(directory.getAbsolutePath());
                    }
                }
            });
            SwingUtil.setSizesToTallest((JComponent[])new JComponent[]{this.reportSaveDirectory, this.directoryPicker});
            settings.add(new JLabel(Language.get("SAVE_REPORT_TO")), 0, 0, 1, 1, 0, 1, 13, 0);
            settings.add(this.reportSaveDirectory, 1, 0, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(5, 5, 5, 0));
            settings.add(this.directoryPicker, 2, 0, 1, 1, 0, 1, 17, 2, (Insets)new ScaledInsets(5, 0, 5, 5));
            this.type = new JComboBox<String>(new String[]{"CSV", "PDF"});
            this.type.setEnabled(false);
            this.type.setPreferredSize(new Dimension(this.type.getPreferredSize().width, this.reportSaveDirectory.getPreferredSize().height));
            settings.add(new JLabel(Language.get("REPORT_FORMAT")), 0, 1, 1, 1, 0, 1, 13, 0);
            settings.add(this.type, 1, 1, 1, 1, 0, 1, 17, 0);
            settings.add(this.notifyWhenDone, 1, 2, 1, 1, 0, 1, 17, 0, (Insets)new ScaledInsets(5, 0, 5, 5));
            StrippedContentPanel.TitledSection section = singleWrapper.addContent((JComponent)((Object)settings), Language.get("REPORT_OPTIONS_TITLE"), false);
            section.setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)0, (int)0, (int)0));
            singleWrapper.addVerticalFiller();
            singleWrapper.setBackgroundColours();
            TypeListener listener = new TypeListener();
            this.sessionReport.addActionListener(listener);
            this.techniciansReport.addActionListener(listener);
            JPanel userPanel = new JPanel();
            userPanel.setLayout(new GridLayout(1, 1));
            userPanel.add((Component)((Object)main));
            return userPanel;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.setOkEnabled(this.reportSaveDirectory.getText().length() > 0);
        }

        class TypeListener
        implements ActionListener {
            TypeListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object o = e.getSource();
                HistoryPanelReportDialog.this.type.setEnabled(true);
                if (o != HistoryPanelReportDialog.this.techniciansReport) {
                    HistoryPanelReportDialog.this.type.setSelectedIndex(0);
                    HistoryPanelReportDialog.this.type.setEnabled(false);
                }
                HistoryPanelReportDialog.this.type.invalidate();
                HistoryPanelReportDialog.this.type.revalidate();
                HistoryPanelReportDialog.this.type.repaint();
            }
        }
    }
}

