/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.hierarchy.ui;

import com.aem.CentralDebugging;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.tech.access.HierarchyPanelListener;
import com.aem.shelp.tech.access.contents.ContentsMetrics;
import com.aem.shelp.tech.access.model.subgroups.FilterResultsGroup;
import com.aem.shelp.tech.access.model.subgroups.RunToolMachineGroup;
import com.aem.shelp.tech.hierarchy.model.AbstractModelChangeListener;
import com.aem.shelp.tech.hierarchy.model.AbstractTreeModel;
import com.aem.shelp.tech.hierarchy.model.TreeElement;
import com.aem.shelp.tech.hierarchy.model.TreeGroup;
import com.aem.shelp.tech.hierarchy.ui.AbstractGroupPanel;
import com.aem.shelp.tech.hierarchy.ui.SelectionUtil;
import com.aem.shelp.tech.hierarchy.utils.TreeSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import utils.progtools.RunOnSilentThreadLock;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.components.ScrollablePanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;

public abstract class AbstractGroupsList<TG extends TreeGroup<TG, TE>, TE extends TreeElement>
implements AbstractModelChangeListener<TG, TE> {
    private HashMap<TG, AbstractGroupPanel<TG, TE>> groupToPanelMap = new HashMap();
    protected ArrayList<AbstractGroupPanel<TG, TE>> groupPanelList = new ArrayList();
    private final boolean singleGroupPanelMode = false;
    private AbstractGroupPanel<TG, TE> singleGroupPanel;
    protected RunOnSilentThreadLock paintedLock = new RunOnSilentThreadLock(50, 1000);
    protected ArrayList<TE> paintedMachines = new ArrayList();
    protected ArrayList<TE> tempPaintedMachines = new ArrayList();
    protected long tempPaintedMachinesHashSum = 0L;
    protected long paintedMachinesHashSum = 0L;
    protected MultiPanelContainer newRootContentsComponent = new MultiPanelContainer();
    protected JScrollPane rootScrollPane;
    protected NoContentsInfoPanel rootComponent = new NoContentsInfoPanel(this.getNoContentText(), this.getNoContentIcon(), false);
    protected HierarchyPanelListener<TG, TE> hierarchyPanelListener;
    private TG[] coreShowingGroups;
    private AbstractTreeModel<TG, TE> groupInterface;
    private boolean isVisible;
    private ContentsMetrics stats;
    private SelectionUtil<TG, TE> machineSelectionModel;

    public ArrayList<TE> getPaintedElements() {
        return this.paintedMachines;
    }

    private AbstractGroupPanel<TG, TE> getGroupPanelFor(TG group) {
        return this.groupToPanelMap.get(group);
    }

    private void registerGroupPanelFor(TG group, AbstractGroupPanel<TG, TE> panel) {
        this.groupToPanelMap.put(group, panel);
        this.groupPanelList.add(panel);
    }

    private void clearGroupPanels() {
        this.singleGroupPanel = null;
        this.groupToPanelMap.clear();
        this.groupPanelList.clear();
    }

    public void clearPaintedElements() {
        this.paintedMachinesHashSum = 0L;
        this.paintedMachines.clear();
    }

    public void justPainted(TE machine) {
        this.tempPaintedMachines.add(machine);
        this.tempPaintedMachinesHashSum += (long)machine.hashCode();
    }

    protected abstract void elementsHaveBeenPainted(RunOnSilentThreadLock var1, AbstractTreeModel<TG, TE> var2, AbstractGroupsList<TG, TE> var3);

    protected abstract Icon getNoContentIcon();

    protected abstract String getNoContentText();

    public AbstractGroupsList(HierarchyPanelListener<TG, TE> hierarchyPanelListener) {
        this.hierarchyPanelListener = hierarchyPanelListener;
        this.machineSelectionModel = new SelectionUtil(this);
        this.rootScrollPane = new JScrollPane(this.newRootContentsComponent);
        this.rootScrollPane.getViewport().setScrollMode(0);
        this.rootScrollPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.rootScrollPane.getViewport().setBackground(this.getBackground());
        this.rootComponent.setContentsPanel(this.rootScrollPane);
        this.rootComponent.setSubText(this.getNoContentSubText());
    }

    protected abstract String getNoContentSubText();

    public SelectionUtil<TG, TE> getSelectionModel() {
        return this.machineSelectionModel;
    }

    public void clearSelectionsNotInGroup(AbstractGroupPanel<TG, TE> exception) {
        this.hierarchyPanelListener.setBatchSelection(true);
        for (AbstractGroupPanel<TG, TE> panel : this.groupToPanelMap.values()) {
            if (panel == exception) continue;
            panel.clearSelection();
        }
        this.hierarchyPanelListener.setBatchSelection(false);
    }

    public int indexOfGroupPanel(AbstractGroupPanel<TG, TE> panel) {
        return this.groupPanelList.indexOf(panel);
    }

    public void selectAllExceptIn(AbstractGroupPanel<TG, TE> groupPanel) {
        for (AbstractGroupPanel<TG, TE> panel : this.groupPanelList) {
            if (groupPanel == null || panel == groupPanel) continue;
            panel.selectAllElements();
        }
    }

    public void selectMachinesInGroupsBetween(AbstractGroupPanel<TG, TE> anchorGroupPanel, AbstractGroupPanel<TG, TE> leadGroupPanel) {
        boolean start = false;
        boolean selectAfterAnchorRow = true;
        for (AbstractGroupPanel<TG, TE> panel : this.groupPanelList) {
            if (panel == anchorGroupPanel || panel == leadGroupPanel) {
                if (!start) {
                    if (panel == leadGroupPanel) {
                        selectAfterAnchorRow = false;
                    }
                    start = true;
                    continue;
                }
                anchorGroupPanel.selectElements(selectAfterAnchorRow);
                return;
            }
            if (!start) continue;
            panel.selectAllElements();
        }
    }

    protected boolean shouldBeShowingGroup(TG childGroup) {
        for (TG group : this.coreShowingGroups) {
            if (!((TreeGroup)childGroup).isDescendentOf(group)) continue;
            return true;
        }
        return false;
    }

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    protected void addHeading() {
    }

    public void initUI(AbstractTreeModel<TG, TE> groupInterface, TG[] groups) {
        this.newRootContentsComponent.removeAll();
        this.addHeading();
        if (this.hierarchyPanelListener.getTechClient() != null) {
            this.hierarchyPanelListener.getTechClient().clearMachineSubscriptions();
        }
        this.clearPaintedElements();
        this.groupInterface = groupInterface;
        this.coreShowingGroups = groups;
        this.clearGroupPanels();
        this.stats = new ContentsMetrics();
        this.recursiveAddGroups(groupInterface, (TreeGroup[])groups, null);
        this.subscribeToVisibleElements();
        if (this.hierarchyPanelListener.getTechClient() != null) {
            this.hierarchyPanelListener.getTechClient().sendSubscribeList();
        }
        this.hierarchyPanelListener.notifyOfContentsStatsChange(this.stats);
        this.rootComponent.setHasContents(this.newRootContentsComponent.getSubComponentCount() > 0);
        this.newRootContentsComponent.revalidate();
        this.newRootContentsComponent.repaint();
    }

    private void recursiveAddGroups(AbstractTreeModel<TG, TE> groupInterface, TG[] groups, Boolean showMachineIcons) {
        if (groups == null) {
            return;
        }
        for (TG group : groups) {
            AbstractGroupPanel<TG, TE> abstractGroupPanel;
            if (showMachineIcons == null) {
                showMachineIcons = this.shouldShowIconsFor(group);
            }
            if ((abstractGroupPanel = this.getGroupPanelFor(group)) == null && ((TreeGroup)group).getElementCount() > 0) {
                this.addGroupPanel(groupInterface, group, showMachineIcons);
            }
            TreeGroup[] childrenGroup = groupInterface.getGroupsIn((TreeGroup)group);
            this.recursiveAddGroups(groupInterface, childrenGroup, showMachineIcons);
        }
    }

    private Boolean shouldShowIconsFor(TG group) {
        if (group != null && (group instanceof FilterResultsGroup || group instanceof RunToolMachineGroup)) {
            return true;
        }
        return false;
    }

    private AbstractGroupPanel<TG, TE> addGroupPanel(AbstractTreeModel<TG, TE> groupInterface, TG group, boolean showMachineIcons) {
        AbstractGroupPanel<TG, TE> groupPanel = this.createGroupPanel(groupInterface, group, this.hierarchyPanelListener, this.newRootContentsComponent.getSubComponentCount() == 0, this, showMachineIcons);
        if (this.groupPanelList.size() > 0) {
            AbstractGroupPanel<TG, TE> previousGroupHeader = this.groupPanelList.get(this.groupPanelList.size() - 1);
            previousGroupHeader.getGroupHeader().setVisible(true);
            previousGroupHeader.rootComponent.repaint();
            groupPanel.getGroupHeader().setVisible(true);
        }
        this.newRootContentsComponent.addSubComponent(groupPanel.getRootComponent());
        this.rootComponent.setHasContents(true);
        this.registerGroupPanelFor(group, groupPanel);
        this.newRootContentsComponent.revalidate();
        this.newRootContentsComponent.repaint();
        ++this.stats.groupCount;
        this.stats.machineCount += ((TreeGroup)group).getElementCount();
        return groupPanel;
    }

    public void subscribeToVisibleElements() {
        for (AbstractGroupPanel<TG, TE> groupPanel : this.groupPanelList) {
            if (groupPanel.getGroup() == null) continue;
            this.elementsAreShowing(((TreeGroup)groupPanel.getGroup()).getElements());
        }
    }

    protected abstract void elementsAreShowing(List<TE> var1);

    protected abstract AbstractGroupPanel<TG, TE> createGroupPanel(AbstractTreeModel<TG, TE> var1, TG var2, HierarchyPanelListener var3, boolean var4, AbstractGroupsList<TG, TE> var5, boolean var6);

    protected abstract Color getBackground();

    @Override
    public void groupsRemoved(TG parentGroup, TG[] removedChildren, int[] removedIndices) {
    }

    @Override
    public void groupsAdded(TG parentGroup, TG[] insertedChildren, int[] insertedIndices) {
    }

    @Override
    public void filterProcessorChanged() {
    }

    @Override
    public void machinesChanged(TG parent, TE[] inserted, TE[] removed, TE[] updated, Machine.MachineChanges updateResults) {
        if (!this.isVisible) {
            return;
        }
        boolean groupPanelCreated = false;
        AbstractGroupPanel<TG, TE> groupPanel = this.getGroupPanelFor(parent);
        if (groupPanel == null && inserted != null && inserted.length > 0) {
            boolean shouldBeShowingGroup = this.shouldBeShowingGroup(parent);
            if (!shouldBeShowingGroup) {
                return;
            }
            boolean showIconsForGroup = this.shouldShowIconsFor(parent);
            groupPanel = this.addGroupPanel(this.groupInterface, parent, showIconsForGroup);
            groupPanelCreated = true;
        }
        if (groupPanel != null) {
            this.addToGroupPanel(groupPanel, (TreeGroup)parent, (TreeElement[])inserted, (TreeElement[])removed, (TreeElement[])updated, updateResults);
            if (!groupPanelCreated && inserted != null) {
                this.elementsAreShowing(Arrays.asList(inserted));
            }
            if (updated != null && updateResults.availableCount > 0) {
                this.elementsAreShowing(Arrays.asList(updated));
            }
            this.hierarchyPanelListener.getTechClient().sendSubscribeList();
            if (groupPanel.isEmpty()) {
                this.groupToPanelMap.remove(parent);
                this.groupPanelList.remove(groupPanel);
                this.newRootContentsComponent.removeSubComponent(groupPanel.getRootComponent());
                this.rootComponent.setHasContents(this.newRootContentsComponent.getSubComponentCount() > 0);
            }
            if (inserted != null && !groupPanelCreated) {
                this.stats.machineCount += inserted.length;
            }
            if (removed != null) {
                this.stats.machineCount -= removed.length;
            }
            this.hierarchyPanelListener.notifyOfContentsStatsChange(this.stats);
            if (updateResults != null) {
                ((TreeGroup)parent).getGroupStats().updateWith(updateResults);
                groupPanel.getGroupHeader().updateWithNewStats();
            }
        }
    }

    protected abstract void addToGroupPanel(AbstractGroupPanel<TG, TE> var1, TG var2, TE[] var3, TE[] var4, TE[] var5, Machine.MachineChanges var6);

    public void setVisible(boolean b) {
        this.isVisible = b;
    }

    public void notifySelectionChange() {
        TreeSelection<TG, TE> selection = this.initTreeSelection();
        for (AbstractGroupPanel<TG, TE> panel : this.groupPanelList) {
            TreeElement[] groupSelection = panel.getSelectedElements();
            if (groupSelection == null || groupSelection.length <= 0) continue;
            selection.addMachines((TreeGroup)panel.group, groupSelection);
        }
        this.notifySelectionChange(selection);
    }

    protected abstract void notifySelectionChange(TreeSelection<TG, TE> var1);

    public void ensureMachineIsSelected(TG group, TE machine) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable((TreeGroup)group, (TreeElement)machine){
                final /* synthetic */ TreeGroup val$group;
                final /* synthetic */ TreeElement val$machine;
                {
                    this.val$group = treeGroup;
                    this.val$machine = treeElement;
                }

                @Override
                public void run() {
                    AbstractGroupsList.this.ensureMachineIsSelected(this.val$group, this.val$machine);
                }
            });
            return;
        }
        AbstractGroupPanel<TG, TE> groupPanel = this.getGroupPanelFor(group);
        System.out.println("[AbstractGroupList] Selecting element " + machine + " in group " + group);
        if (groupPanel != null) {
            Container parent;
            groupPanel.ensureElementIsSelected(group, machine);
            Rectangle groupPanelBounds = groupPanel.rootComponent.getBounds();
            int y = 0;
            for (parent = groupPanel.rootComponent; parent != this.newRootContentsComponent; parent = parent.getParent()) {
                y += parent.getBounds().y;
            }
            groupPanelBounds.y = y += parent.getBounds().y;
            this.newRootContentsComponent.scrollRectToVisible(groupPanelBounds);
        } else {
            System.out.println("[AbstractGroupList] The group panel for " + group + " does not exist");
        }
        this.rootScrollPane.repaint();
    }

    protected abstract TreeSelection<TG, TE> initTreeSelection();

    class MultiPanelContainer
    extends ScrollablePanel {
        private final ArrayList<GbPanel> subPanels = new ArrayList();
        private GbPanelWrapper wrapper = new GbPanelWrapper((Container)this);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeAll() {
            ArrayList<GbPanel> arrayList = this.subPanels;
            synchronized (arrayList) {
                for (GbPanel panel : this.subPanels) {
                    panel.removeAll();
                }
                this.subPanels.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getSubComponentCount() {
            int total = 0;
            ArrayList<GbPanel> arrayList = this.subPanels;
            synchronized (arrayList) {
                for (GbPanel panel : this.subPanels) {
                    total += panel.getComponentCount();
                }
            }
            return total;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSubComponent(JComponent subComponent) {
            ArrayList<GbPanel> arrayList = this.subPanels;
            synchronized (arrayList) {
                GbPanel panel;
                if (this.subPanels.size() == 0) {
                    panel = this.newPanel();
                } else {
                    panel = this.subPanels.get(this.subPanels.size() - 1);
                    if (panel.getComponentCount() == 500) {
                        panel = this.newPanel();
                    }
                }
                panel.add((Component)subComponent, 0, panel.getComponentCount(), 1, 1, 1, 1, 11, 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private GbPanel newPanel() {
            String debug = "[MultiPanelContainer] Creating new panel container ( ";
            ArrayList<GbPanel> arrayList = this.subPanels;
            synchronized (arrayList) {
                for (GbPanel panel : this.subPanels) {
                    debug = debug + panel.getComponentCount() + " ";
                }
                System.out.println(debug + ")");
                GbPanel panel = new GbPanel();
                this.subPanels.add(panel);
                this.wrapper.add((Component)panel, 0, this.getComponentCount(), 1, 1, 1, 0, 11, 1);
                return panel;
            }
        }

        @Override
        public void paintChildren(Graphics g) {
            if (CentralDebugging.SHOW_ACCESS_SUBSCRIPTIONS) {
                System.out.println("[Subscriptions][AbstractGroupList] Clearing tmp painted machines");
            }
            AbstractGroupsList.this.tempPaintedMachines = new ArrayList();
            AbstractGroupsList.this.tempPaintedMachinesHashSum = 0L;
            super.paintChildren(g);
            if (AbstractGroupsList.this.tempPaintedMachinesHashSum == AbstractGroupsList.this.paintedMachinesHashSum) {
                if (CentralDebugging.SHOW_ACCESS_SUBSCRIPTIONS) {
                    System.out.println("[Subscriptions][AbstractGroupList] Painted machine lists match");
                }
                return;
            }
            if (AbstractGroupsList.this.tempPaintedMachines.size() <= AbstractGroupsList.this.paintedMachines.size() && AbstractGroupsList.this.paintedMachines.containsAll(AbstractGroupsList.this.tempPaintedMachines)) {
                return;
            }
            if (CentralDebugging.SHOW_ACCESS_SUBSCRIPTIONS) {
                for (TreeElement m : AbstractGroupsList.this.tempPaintedMachines) {
                    System.out.println("[Subscriptions][AbstractGroupList] tempPaintedMachines: " + m);
                }
            }
            AbstractGroupsList.this.paintedMachines = AbstractGroupsList.this.tempPaintedMachines;
            AbstractGroupsList.this.paintedMachinesHashSum = AbstractGroupsList.this.tempPaintedMachinesHashSum;
            AbstractGroupsList.this.elementsHaveBeenPainted(AbstractGroupsList.this.paintedLock, AbstractGroupsList.this.groupInterface, AbstractGroupsList.this);
        }

        private void relayoutGBLComponents(GbPanel parent) {
            int ii = 0;
            while (ii < parent.getComponentCount()) {
                Component c = parent.getComponent(ii);
                GridBagConstraints constraints = parent.getGridBagLayout().getConstraints(c);
                constraints.gridy = ii++;
                parent.getGridBagLayout().setConstraints(c, constraints);
            }
        }

        private void relayoutGBLComponents(JPanel parent, GbPanelWrapper parentWrapper) {
            int ii = 0;
            while (ii < parent.getComponentCount()) {
                Component c = parent.getComponent(ii);
                GridBagConstraints constraints = parentWrapper.gbl.getConstraints(c);
                constraints.gridy = ii++;
                parentWrapper.gbl.setConstraints(c, constraints);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSubComponent(JComponent rootComponent) {
            ArrayList<GbPanel> arrayList = this.subPanels;
            synchronized (arrayList) {
                for (int i = this.subPanels.size() - 1; i >= 0; --i) {
                    GbPanel panel = this.subPanels.get(i);
                    Component[] children = panel.getComponents();
                    for (int j = 0; j < children.length; ++j) {
                        Component child = children[j];
                        if (!(child instanceof JComponent) || !((JComponent)child).equals(rootComponent)) continue;
                        panel.remove((Component)rootComponent);
                        if (panel.getComponentCount() == 0) {
                            this.subPanels.remove(panel);
                            this.relayoutGBLComponents(this, this.wrapper);
                            this.revalidate();
                            this.repaint();
                            continue;
                        }
                        this.relayoutGBLComponents(panel);
                        panel.revalidate();
                        panel.repaint();
                    }
                }
            }
        }
    }
}

