/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.customer;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.SupportSession;
import com.aem.shelp.tech.customer.AdditionalCustomerInfoPanel;
import com.aem.shelp.tech.customer.CustomerListListener;
import com.aem.shelp.tech.customer.CustomerTypePanelList;
import com.aem.shelp.tech.customer.OSIconLoader;
import com.aem.shelp.util.ElapsedTimeFormatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import utils.swing.ExponentialSlider;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;
import utils.switches.oem.OEMSwitches;

public class CustomerTypePanel
extends ColorPropagatingPanel
implements ActionListener,
CustomerListListener {
    private static final ElapsedTimeFormatter timeFormatter = new ElapsedTimeFormatter();
    private static final Color TERMINATING = new Color(202, 76, 74);
    private JLabel os;
    private JLabel waitingFor;
    private Border unselectedBorder;
    private Border selectedBorder;
    private JLabel[] detailsLabels;
    private int height;
    private int nameWidth = SimpleHelpLookAndFeel.scale((int)250);
    private JButton actionButton;
    private boolean isHovered = false;
    private boolean isSelected;
    private Color selectedBackground = OEMSwitches.DARK_THEME ? new Color(83, 96, 111) : new Color(230, 235, 245);
    private Customer customer;
    private ArrayList<String> detailsToShow;
    private JPanel actionPanel;
    private Color unselectedBackground = SHStyle.PANEL_BACKGROUND_MEDIUM;
    private boolean isSession;
    private SupportSession session;
    private CustomerTypePanelList list;
    private static final boolean DEBUG = false;
    private GbPanel detailsPanel = new GbPanel(new ScaledInsets(2, 2, 2, 2));
    private static AdditionalCustomerInfoPanel infoPanel = new AdditionalCustomerInfoPanel();
    private boolean terminate = false;
    private boolean viewOnly;
    private int mode;
    int drawX = 0;
    BufferedImage drawImage = null;
    private CustomerListListener customerListListener;

    public CustomerTypePanel(CustomerTypePanelList list, Customer customer, SupportSession session, ArrayList<String> detailsToShow, CustomerListListener customerListListener, boolean isSession) {
        super((LayoutManager)new BorderLayout(SimpleHelpLookAndFeel.scale((int)5), SimpleHelpLookAndFeel.scale((int)5)));
        this.customerListListener = customerListListener;
        this.list = list;
        this.setFocusable(true);
        this.customer = customer;
        this.isSession = isSession;
        this.session = session;
        this.detailsToShow = detailsToShow;
        this.setOpaque(true);
        this.unselectedBorder = SHBorderFactory.createCompoundBorder((Border)SHStyle.lightTopBorder, (Border)SHStyle.darkBottomBorder);
        this.selectedBorder = SHBorderFactory.createCompoundBorder((Border)SHStyle.darkTopBorder, (Border)SHStyle.darkBottomBorder);
        if (!isSession) {
            this.actionButton = new JButton(Language.get("CONNECT"));
        } else {
            this.actionButton = new JButton(Language.get("KILL_SESSION"));
            SHButtonUI.makeButtonRed((JButton)this.actionButton);
        }
        this.os = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = SimpleHelpLookAndFeel.scale((int)24);
                return dim;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.os.setBorder(SHBorderFactory.createLineBorder((Color)new Color(0, 0, 0, 0)));
        JLabel primaryLabel = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = CustomerTypePanel.this.nameWidth;
                return dim;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.actionButton.addActionListener(this);
        this.waitingFor = new JLabel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                dim.width = SimpleHelpLookAndFeel.scale((int)100);
                return dim;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.waitingFor.setFont(SHStyle.smallerFont);
        this.waitingFor.setForeground(OEMSwitches.DARK_THEME ? SHStyle.EXAMPLE_TEXT_COLOR_DARKER : SHStyle.EXAMPLE_TEXT_COLOR);
        this.waitingFor.setHorizontalTextPosition(4);
        this.waitingFor.setHorizontalAlignment(4);
        int labelCount = Math.max(detailsToShow.size(), 1);
        this.detailsLabels = new JLabel[labelCount];
        for (int i = 0; i < labelCount; ++i) {
            if (i == 0) {
                this.detailsLabels[i] = primaryLabel;
                continue;
            }
            this.detailsLabels[i] = new JLabel(){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dim = super.getPreferredSize();
                    dim.width = SimpleHelpLookAndFeel.scale((int)20);
                    return dim;
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
            this.detailsLabels[i].setForeground(OEMSwitches.DARK_THEME ? SHStyle.EXAMPLE_TEXT_COLOR_DARKER : SHStyle.EXAMPLE_TEXT_COLOR);
        }
        int X = 0;
        this.detailsPanel.add((Component)this.os, X++, 0, 1, 1, 0, 0, 10, 1);
        for (int i = 0; i < this.detailsLabels.length; ++i) {
            int widthWeight = 1;
            if (i == 0 && this.detailsLabels.length != 1) {
                widthWeight = 0;
            }
            this.detailsPanel.add((Component)this.detailsLabels[i], X++, 0, 1, 1, widthWeight, 0, 17, 1);
        }
        this.actionPanel = new JPanel();
        this.actionPanel.setLayout(new BorderLayout());
        this.actionPanel.add((Component)this.actionButton, "East");
        this.actionPanel.setVisible(false);
        SwingUtil.setWidth((JComponent)this.actionPanel, (int)SimpleHelpLookAndFeel.scale((int)100));
        this.detailsPanel.add((Component)this.waitingFor, X++, 0, 1, 1, 0, 0, 13, 1);
        this.detailsPanel.add((Component)this.actionPanel, X++, 0, 1, 1, 0, 1, 13, 1);
        this.add((Component)this.detailsPanel, "North");
        this.initWith(customer);
        this.isSelected = false;
        this.setBackground(this.unselectedBackground);
        this.setBorder(this.unselectedBorder);
        this.actionPanel.setBackground(this.unselectedBackground);
        this.height = SimpleHelpLookAndFeel.scale((int)30);
    }

    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.height = this.height;
        return dim;
    }

    public Dimension getMaximumSize() {
        Dimension dim = super.getMaximumSize();
        dim.height = this.height;
        return dim;
    }

    public Dimension getMinimumSize() {
        Dimension dim = super.getMinimumSize();
        dim.height = this.height;
        return dim;
    }

    public void initWith(Customer customer) {
        this.os.setIcon(OSIconLoader.getOSIcon(customer.getOsBaseType(), customer.getOsVariant(), customer.getOsSummary()));
        if (this.detailsToShow.size() == 0) {
            this.detailsLabels[0].setText(customer.getRemoteUsername());
        } else {
            for (int i = 0; i < this.detailsToShow.size(); ++i) {
                String detail = this.detailsToShow.get(i);
                if (this.session != null && detail.equals(Language.get("TECHNICIAN"))) {
                    this.detailsLabels[i].setText(this.session.getTechnicianDisplayName());
                    continue;
                }
                this.detailsLabels[i].setText(customer.getValue(this.detailsToShow.get(i), true));
            }
        }
        if (this.session != null) {
            this.setWaitingForRounded(this.session.getIncrementedElapsedTime());
        } else {
            this.setWaitingForRounded(customer.getWaitingFor());
        }
    }

    public void setSelected(boolean b) {
        this.isSelected = b;
        if (b) {
            infoPanel.setBackground(this.selectedBackground);
            this.actionPanel.setBackground(this.selectedBackground);
            this.setBackground(this.selectedBackground);
            this.setBorder(this.selectedBorder);
            this.height = CustomerTypePanel.infoPanel.getRootComponent().getPreferredSize().height + SimpleHelpLookAndFeel.scale((int)30);
            this.actionPanel.setVisible(false);
            this.waitingFor.setVisible(true);
            infoPanel.removeFromParent();
            infoPanel.initWith(this.customer, this.isSession, this.customerListListener.getTechGroupPermissions());
            infoPanel.setCustomerListListener(this);
            infoPanel.getRootComponent().setVisible(b);
            this.add(infoPanel.getRootComponent(), "Center");
        } else {
            infoPanel.getRootComponent().setVisible(b);
            this.setBackground(this.unselectedBackground);
            this.setBorder(this.unselectedBorder);
            this.actionPanel.setBackground(this.unselectedBackground);
            this.height = SimpleHelpLookAndFeel.scale((int)30);
        }
        this.revalidate();
        this.repaint();
    }

    public void setHover(final boolean isHovered) {
        if (this.isHovered == isHovered) {
            return;
        }
        this.isHovered = isHovered;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean isSession = CustomerTypePanel.this.isSession;
                if (!CustomerTypePanel.this.isSelected) {
                    if (isSession) {
                        if (CustomerTypePanel.this.session != null && CustomerTypePanel.this.list.getTech().canTerminateSession(CustomerTypePanel.this.session)) {
                            CustomerTypePanel.this.actionPanel.setVisible(isHovered);
                            CustomerTypePanel.this.waitingFor.setVisible(!isHovered);
                        } else {
                            CustomerTypePanel.this.actionPanel.setVisible(false);
                            CustomerTypePanel.this.waitingFor.setVisible(true);
                        }
                    } else {
                        CustomerTypePanel.this.actionPanel.setVisible(isHovered);
                        CustomerTypePanel.this.waitingFor.setVisible(!isHovered);
                    }
                } else {
                    CustomerTypePanel.this.actionPanel.setVisible(false);
                    CustomerTypePanel.this.waitingFor.setVisible(true);
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.actionButton) {
            if (!this.isSession) {
                this.doConnect(0, false);
            } else {
                this.doTerminate();
            }
        }
    }

    public void doTerminate() {
        this.terminate = true;
        Dimension size = this.getSize();
        BufferedImage image = new BufferedImage(size.width, size.height, 1);
        Graphics2D g = image.createGraphics();
        this.paint(g);
        g.dispose();
        this.actionPanel.setEnabled(false);
        new SlideThread(image, true).start();
    }

    public void doConnect(int mode, boolean viewOnly) {
        this.mode = mode;
        this.viewOnly = viewOnly;
        Dimension size = this.getSize();
        BufferedImage image = new BufferedImage(size.width, size.height, 1);
        Graphics2D g = image.createGraphics();
        this.paint(g);
        g.dispose();
        this.actionPanel.setEnabled(false);
        new SlideThread(image).start();
    }

    public void paint(Graphics g) {
        if (this.drawImage == null) {
            super.paint(g);
        } else {
            if (this.terminate) {
                g.setColor(TERMINATING);
            } else {
                g.setColor(Color.LIGHT_GRAY);
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.drawImage, this.drawX, 0, null);
        }
    }

    public Customer getCustomer() {
        return this.customer;
    }

    private void setWaitingForRounded(long ms) {
        ms = Math.max(1000L, ms);
        this.waitingFor.setText(timeFormatter.getFormattedTime(ms));
    }

    public void updateCustomerInfo() {
        if (this.session != null) {
            this.setWaitingForRounded(this.session.getIncrementedElapsedTime());
        } else {
            this.setWaitingForRounded(this.customer.getWaitingFor());
        }
        this.waitingFor.repaint();
    }

    @Override
    public void connectToCustomer(Customer customer, int mode, boolean viewOnly) {
        this.doConnect(mode, viewOnly);
    }

    @Override
    public void terminateCustomerOrSession(Customer customer) {
        this.doTerminate();
    }

    public void terminateSession(SupportSession customer) {
        this.doTerminate();
    }

    @Override
    public TechGroupPermissions getTechGroupPermissions() {
        return this.customerListListener.getTechGroupPermissions();
    }

    class SlideThread
    extends Thread {
        private boolean slideLeft;

        public SlideThread(BufferedImage image) {
            this(image, false);
        }

        public SlideThread(BufferedImage image, boolean slideLeft) {
            CustomerTypePanel.this.drawImage = image;
            this.slideLeft = slideLeft;
        }

        @Override
        public void run() {
            int width = CustomerTypePanel.this.getWidth();
            ExponentialSlider es = new ExponentialSlider((double)width, 300L, 1.0, false);
            for (int i = 0; i < es.getPositionCount(); ++i) {
                CustomerTypePanel.this.drawX = !this.slideLeft ? es.getPositionForStepRounded(i) : -es.getPositionForStepRounded(i);
                if (CustomerTypePanel.this.getParent() != null) {
                    CustomerTypePanel.this.getParent().repaint();
                }
                try {
                    Thread.sleep(es.get25fpsSleep());
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            new SquishThread().run();
        }
    }

    class SquishThread
    extends Thread {
        @Override
        public void run() {
            ExponentialSlider es = new ExponentialSlider((double)CustomerTypePanel.this.height, 1000L, 10.0, true);
            int originalHeight = CustomerTypePanel.this.height;
            for (int i = 0; i < es.getPositionCount(); ++i) {
                CustomerTypePanel.this.height = originalHeight - es.getPositionForStepRounded(i);
                if (CustomerTypePanel.this.height <= 0) {
                    CustomerTypePanel.this.height = 0;
                }
                ((JComponent)CustomerTypePanel.this.getParent()).revalidate();
                CustomerTypePanel.this.getParent().repaint();
                try {
                    Thread.sleep(es.get25fpsSleep());
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (CustomerTypePanel.this.terminate) {
                CustomerTypePanel.this.customerListListener.terminateCustomerOrSession(CustomerTypePanel.this.customer);
            } else {
                CustomerTypePanel.this.customerListListener.connectToCustomer(CustomerTypePanel.this.customer, CustomerTypePanel.this.mode, CustomerTypePanel.this.viewOnly);
            }
            CustomerTypePanel.this.getParent().remove((Component)((Object)CustomerTypePanel.this));
        }
    }
}

