/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.customer;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.SupportSession;
import java.util.ArrayList;
import java.util.HashMap;

public class CustomerModel {
    private ArrayList<Customer> allCustomers = new ArrayList();
    private ArrayList<Customer> filteredCustomers = new ArrayList();
    private String filter = null;
    private HashMap<String, SupportSession> customerIDToSupportSession = new HashMap();
    private ArrayList<String> detailsToShow = null;
    private ArrayList<String> allDetails = null;
    private ArrayList<String> coreDetails;
    private ArrayList<CustomerModelListener> listeners = new ArrayList();
    private boolean isSessions;

    public CustomerModel(boolean isSessions) {
        this.isSessions = isSessions;
    }

    public SupportSession getSessionFor(Customer customer) {
        return this.customerIDToSupportSession.get(customer.getCustomerID());
    }

    public synchronized void setSessions(SupportSession[] sessions) {
        Customer[] newCustomers = new Customer[sessions.length];
        for (int i = 0; i < sessions.length; ++i) {
            newCustomers[i] = sessions[i].getCustomer();
            this.customerIDToSupportSession.put(newCustomers[i].getCustomerID(), sessions[i]);
        }
        this.setCustomers(newCustomers);
    }

    public synchronized void setCustomers(Customer[] customers) {
        int i;
        boolean customersAddedOrRemoved = false;
        for (i = this.allCustomers.size() - 1; i >= 0; --i) {
            Customer o = this.allCustomers.get(i);
            boolean keep = false;
            for (int j = 0; j < customers.length; ++j) {
                if (!o.equals(customers[j])) continue;
                keep = true;
                break;
            }
            if (keep) continue;
            this.allCustomers.remove(i);
            this.customerIDToSupportSession.remove(o.getCustomerID());
            customersAddedOrRemoved = true;
        }
        for (i = 0; i < customers.length; ++i) {
            if (customers[i] == null) continue;
            int index = this.allCustomers.indexOf(customers[i]);
            if (index == -1) {
                this.allCustomers.add(customers[i]);
                customersAddedOrRemoved = true;
                continue;
            }
            this.allCustomers.set(index, customers[i]);
        }
        if (customersAddedOrRemoved) {
            this.notifySizeChange();
        }
        this.filterCustomers();
        if (this.allCustomers.size() > 0) {
            this.extractValidDetailOptions();
            if (this.detailsToShow == null) {
                this.detailsToShow = new ArrayList();
                if (this.coreDetails != null) {
                    for (i = 0; i < this.coreDetails.size(); ++i) {
                        this.detailsToShow.add(this.coreDetails.get(i));
                    }
                }
            }
        }
    }

    public synchronized void removeCustomer(Customer customer) {
        this.allCustomers.remove(customer);
        this.customerIDToSupportSession.remove(customer.getCustomerID());
        this.filterCustomers();
        this.notifySizeChange();
    }

    private synchronized void filterCustomers() {
        if (this.filter == null || this.filter.length() == 0) {
            this.filteredCustomers = new ArrayList<Customer>(this.allCustomers);
            return;
        }
        this.filteredCustomers.clear();
        for (int i = 0; i < this.allCustomers.size(); ++i) {
            Customer customr = this.allCustomers.get(i);
            if (customr == null || !customr.toString().toLowerCase().contains(this.filter)) continue;
            this.filteredCustomers.add(customr);
        }
    }

    public synchronized boolean setFilter(String filter) {
        if (this.filter != filter) {
            this.filter = filter;
            this.filterCustomers();
            return true;
        }
        return false;
    }

    public synchronized int getSize() {
        return this.filteredCustomers.size();
    }

    public synchronized Customer getCustomer(int index) {
        return this.filteredCustomers.get(index);
    }

    public synchronized int getUnfilteredSize() {
        return this.allCustomers.size();
    }

    public synchronized Customer getUnfilteredCustomer(int i) {
        return this.allCustomers.get(i);
    }

    public void setCoreDetails(String[] detailNames) {
        if (this.coreDetails == null) {
            this.coreDetails = new ArrayList();
        } else {
            this.coreDetails.clear();
        }
        for (int i = 0; i < detailNames.length; ++i) {
            this.coreDetails.add(detailNames[i]);
        }
    }

    public ArrayList<String> getSelectedDetailsToShow() {
        return this.detailsToShow;
    }

    public ArrayList<String> getAllDetails() {
        return this.allDetails;
    }

    private void extractValidDetailOptions() {
        ArrayList<Object> list = this.coreDetails != null ? new ArrayList<String>(this.coreDetails) : new ArrayList();
        if (this.isSessions) {
            list.add(Language.get("TECHNICIAN"));
        }
        for (int i = 0; i < this.getUnfilteredSize(); ++i) {
            Customer customer = this.getUnfilteredCustomer(i);
            if (customer == null) continue;
            String[] keys = customer.getDetailsKeys();
            for (int j = 0; j < keys.length; ++j) {
                if (list.contains(keys[j])) continue;
                list.add(keys[j]);
            }
        }
        this.allDetails = list;
    }

    public void notifySizeChange() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).customerModelSizeChanged();
        }
    }

    public void addCustomerModelListener(CustomerModelListener listener) {
        this.listeners.add(listener);
    }

    public void setSelectedDetailsToShow(ArrayList<String> selectedColumns) {
        this.detailsToShow = selectedColumns;
    }

    public static interface CustomerModelListener {
        public void customerModelSizeChanged();
    }
}

