/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.authentication;

import com.aem.SafeResourceBundle;
import com.aem.shelp.common.Language;
import com.aem.shelp.util.font.GlyphIcons;
import com.aem.shelp.util.progress.SHProgressAnimatedIcon;
import com.aem.shelp.util.progress.SHProgressIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import utils.files.FileUtil;
import utils.progtools.SaverUtil;
import utils.progtools.URIUtil;
import utils.swing.SwingUtil;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthGbPanel;
import utils.swing.dialog.glassdialog.PanelGlassDialog;
import utils.swing.icons.InfiniteCircularProgressIcon;
import utils.swing.layout.GbPanel;
import utils.switches.oem.OEMSwitches;

public class TOTPRegistrationPanel
implements KeyListener,
SaverUtil.SaveListener,
ActionListener {
    private static final String QR_FORMAT = "https://chart.googleapis.com/chart?chs=%dx%d&chld=M%%7C0&cht=qr&chl=%s";
    private static final String CHL_PART = "otpauth://totp/%s@%s%%3Fsecret%%3D%s%%26digits=%d%%26issuer=%s";
    private final String secretCode;
    private final int codeLength;
    private final String username;
    private final String host;
    private final String issuer;
    private GbPanel rootComponent = new FixedWidthGbPanel(new ScaledInsets(5, 5, 5, 5)){

        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            preferredSize.height = SimpleHelpLookAndFeel.scale((int)300);
            return preferredSize;
        }
    };
    private JTextField codeEntryField;
    private JLabel validationLabel;
    private JButton closeButton;
    private SaverUtil serverRequestor = new SaverUtil("Server Code Query", 500, this, false);
    private String code;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public TOTPRegistrationPanel(String secretCode, int codeLength, String username, String host, String issuer) {
        this.secretCode = secretCode;
        this.codeLength = codeLength;
        this.username = username;
        this.host = host;
        this.issuer = issuer;
        this.initUI();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            TOTPRegistrationPanel tOTPRegistrationPanel = this;
            synchronized (tOTPRegistrationPanel) {
                this.code = null;
                this.notify();
                return;
            }
        }
        this.setChecking();
        this.serverRequestor.queueSave();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performSave() {
        try {
            String text = this.codeEntryField.getText().trim();
            TOTPRegistrationPanel tOTPRegistrationPanel = this;
            synchronized (tOTPRegistrationPanel) {
                this.code = text.replace(" ", "");
                if (this.code.length() == 0) {
                    this.setNothing();
                } else {
                    this.notify();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEnteredCode() {
        TOTPRegistrationPanel tOTPRegistrationPanel = this;
        synchronized (tOTPRegistrationPanel) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return this.code;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        TOTPRegistrationPanel tOTPRegistrationPanel = this;
        synchronized (tOTPRegistrationPanel) {
            this.code = null;
            this.notify();
            return;
        }
    }

    public void initUI() {
        this.rootComponent.setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)5, (int)5, (int)5));
        JLabel title = new JLabel(Language.get("TOTP_TITLE"));
        title.setFont(SHStyle.largeFont);
        JLabel message = new JLabel("<html>" + Language.get("TOTP_MESSAGE"));
        JLabel qrCode = new JLabel();
        qrCode.setBorder(SHBorderFactory.createLineBorder((Color)Color.lightGray));
        SwingUtil.setSize((JComponent)qrCode, (int)SimpleHelpLookAndFeel.scale((int)150), (int)SimpleHelpLookAndFeel.scale((int)150));
        JPanel codeEntryPanel = this.getCodeEntryPanel();
        int Y = 0;
        this.rootComponent.add((Component)title, 0, Y++, 2, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(3, 3, 10, 3));
        this.rootComponent.add((Component)message, 0, Y++, 2, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(3, 3, 20, 3));
        this.rootComponent.add((Component)new NumberedPanel(1, "<html>" + Language.get("TOTP_CONFIGURE", "<B>" + this.secretCode + "</B>")), 0, Y, 1, 1, 1, 0, 18, 2, (Insets)new ScaledInsets(5, 5, 15, 5));
        this.rootComponent.add((Component)qrCode, 1, Y++, 1, 3, 0, 0, 10, 1);
        this.rootComponent.add((Component)new NumberedPanel(2, Language.get("TOTP_CODE")), 0, Y++, 1, 1, 1, 0, 17, 2);
        this.rootComponent.add((Component)codeEntryPanel, 0, Y++, 1, 1, 1, 0, 11, 2);
        this.closeButton = new JButton(Language.get("CANCEL"));
        this.closeButton.addActionListener(this);
        JPanel buttonsPanel = new JPanel(new BorderLayout());
        buttonsPanel.add((Component)this.closeButton, "South");
        this.rootComponent.add((Component)buttonsPanel, 0, Y, 2, 1, 1, 1, 10, 0);
        Font f = GlyphIcons.getFont(20.0f);
        this.validationLabel.setFont(f);
        new QRCodeThread(qrCode);
    }

    private JPanel getCodeEntryPanel() {
        GbPanel codeEntryPanel = new GbPanel(new ScaledInsets(5, 5, 5, 5));
        TextField textField = new TextField(null, null, 1);
        textField.setExampleValue("123456");
        textField.setLengthConstraints(this.codeLength, this.codeLength);
        this.codeEntryField = (JTextField)textField.getComponent();
        this.codeEntryField.addKeyListener(this);
        this.validationLabel = new JLabel();
        SwingUtil.setWidth((JComponent)this.codeEntryField, (int)SimpleHelpLookAndFeel.scale((int)200));
        SwingUtil.setWidth((JComponent)this.validationLabel, (int)SimpleHelpLookAndFeel.scale((int)20));
        int X = 0;
        JPanel leftBuffer = new JPanel();
        SwingUtil.setWidth((JComponent)leftBuffer, (int)SimpleHelpLookAndFeel.scale((int)21));
        codeEntryPanel.add((Component)leftBuffer, X++, 0, 1, 1, 0, 1, 17, 1);
        codeEntryPanel.add((Component)this.codeEntryField, X++, 0, 1, 1, 0, 1, 17, 1);
        codeEntryPanel.add((Component)this.validationLabel, X++, 0, 1, 1, 0, 1, 17, 1);
        codeEntryPanel.add((Component)new JPanel(), X++, 0, 1, 1, 1, 1, 17, 1);
        return codeEntryPanel;
    }

    public void setChecking() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InfiniteCircularProgressIcon circularInfinite = SHProgressIcons.getCircularInfinite(16);
                circularInfinite.setUpdateComponent((Component)TOTPRegistrationPanel.this.validationLabel);
                circularInfinite.switchOn();
                TOTPRegistrationPanel.this.validationLabel.setText("");
                TOTPRegistrationPanel.this.validationLabel.setIcon((Icon)circularInfinite);
                TOTPRegistrationPanel.this.validationLabel.repaint();
            }
        });
    }

    public void setNothing() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TOTPRegistrationPanel.this.validationLabel.setIcon(null);
                TOTPRegistrationPanel.this.validationLabel.setText("");
                TOTPRegistrationPanel.this.validationLabel.repaint();
            }
        });
    }

    public void setOK() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TOTPRegistrationPanel.this.validationLabel.setForeground(SHStyle.JPANEL_BACKGROUND_COLOR_BLUE_DARKER);
                TOTPRegistrationPanel.this.validationLabel.setIcon(null);
                TOTPRegistrationPanel.this.validationLabel.setText("\ue194");
                TOTPRegistrationPanel.this.validationLabel.repaint();
            }
        });
    }

    public void setError() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TOTPRegistrationPanel.this.validationLabel.setForeground(SHStyle.ERROR_TEXT_COLOR);
                TOTPRegistrationPanel.this.validationLabel.setText("\ue193");
                TOTPRegistrationPanel.this.validationLabel.setIcon(null);
                TOTPRegistrationPanel.this.validationLabel.repaint();
            }
        });
    }

    public String getQRBarcodeURL(int width, int height, String user, String host, String issuer) {
        String query = URIUtil.createQueryString((String[])new String[]{"secret", "digits", "issuer"}, (String[])new String[]{this.secretCode, Integer.toString(this.codeLength), issuer});
        query = "?" + query;
        String chlUrl = "otpauth://totp/" + user + "@" + host;
        chlUrl = chlUrl + query;
        try {
            chlUrl = URIUtil.urlEncodeSingleURLQueryKeyValue((String)chlUrl);
            chlUrl = URIUtil.escapeAllReservedPercentEncodingCharacters((String)chlUrl);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return String.format(QR_FORMAT, width, height, chlUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getQRCodeImage() throws IOException {
        URL url = new URL(this.getQRBarcodeURL(SimpleHelpLookAndFeel.scale((int)150), SimpleHelpLookAndFeel.scale((int)150), this.username, this.host, this.issuer));
        URLConnection conn = url.openConnection();
        BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
        try {
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
        finally {
            FileUtil.robustClose((InputStream)in);
        }
    }

    public static void main(String[] args) throws Exception {
        OEMSwitches.DARK_THEME = true;
        SafeResourceBundle.addReplaceString("SimpleHelp", "George's", null);
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        TOTPRegistrationPanel reg = new TOTPRegistrationPanel("CF5O5GS2PVLTWPWMHC55F3MIQ6IIOCOX", 6, "George", "simple-help.com", "It's a test");
        System.out.println(reg.getQRBarcodeURL(100, 100, "john", "example.com", "ACME's Co"));
        frame.setVisible(true);
        PanelGlassDialog glassDialog = new PanelGlassDialog((RootPaneContainer)frame, Language.get("GROUP_APP"), 650, null, null);
        glassDialog.setContentPanel((JComponent)reg.getRootComponent());
        glassDialog.showDialog(false);
    }

    private class NumberedPanel
    extends JPanel {
        public NumberedPanel(int number, String msg) {
            JLabel numLabel = new JLabel(Integer.toString(number) + ". ");
            JPanel numberPanel = new JPanel(new BorderLayout());
            numberPanel.add((Component)numLabel, "North");
            JLabel messageLabel = new JLabel(msg);
            this.setLayout(new BorderLayout(5, 5));
            this.add((Component)numberPanel, "West");
            this.add((Component)messageLabel, "Center");
        }
    }

    class QRCodeThread
    extends Thread {
        private final JLabel qrCode;
        private boolean die = false;

        public void die() {
            this.die = true;
        }

        public QRCodeThread(JLabel qrCode) {
            this.qrCode = qrCode;
            this.start();
        }

        @Override
        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QRCodeThread.this.qrCode.setHorizontalAlignment(0);
                    QRCodeThread.this.qrCode.setIcon(new SHProgressAnimatedIcon());
                }
            });
            try {
                final BufferedImage image = TOTPRegistrationPanel.this.getQRCodeImage();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        QRCodeThread.this.qrCode.setBorder(SHBorderFactory.createEmptyBorder());
                        QRCodeThread.this.qrCode.setIcon(new ImageIcon(image));
                        QRCodeThread.this.qrCode.repaint();
                    }
                });
            }
            catch (Throwable t) {
                this.qrCode.setVisible(false);
                TOTPRegistrationPanel.this.rootComponent.repaint();
                t.printStackTrace();
            }
        }
    }
}

