/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.appprofile.ui;

import com.aem.profiles.keysets.GroupAccessKeyset;
import com.aem.profiles.model.AppProfile;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.TechServerConfig;
import com.aem.shelp.tech.appprofile.GroupPermissionsPanel;
import com.aem.shelp.tech.appprofile.MonitoringPermissionsPanel;
import com.aem.shelp.tech.appprofile.ProfileAccountsConfig;
import com.aem.shelp.tech.appprofile.ProfileAccountsPanel;
import com.aem.shelp.tech.appprofile.ProfileUIListener;
import com.aem.shelp.tech.appprofile.TechConsoleRestrictionsPanel;
import com.aem.shelp.tech.appprofile.TechGroupsPanel;
import com.aem.shelp.tech.appprofile.ui.AbstractProfileUI;
import com.aem.shelp.tech.utils.SHStrippedContentPanel;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import utils.swing.SwingUtil;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class GroupAccessProfileUI
extends AbstractProfileUI {
    private TechGroupsPanel groupsPanel;
    private ProfileAccountsPanel accountsPanel;
    private GroupPermissionsPanel groupPermissionsPanel;
    private MonitoringPermissionsPanel monitoringPermissionsPanel;
    private TechConsoleRestrictionsPanel techConsoleRestrictionsPanel;

    public GroupAccessProfileUI(AppProfile appProfile, ProfileUIListener uiListener, RootPaneContainer rpc, TechClient client) {
        super(appProfile, uiListener, rpc, client);
    }

    @Override
    public AbstractProfileUI.AppProfileTab[] getTabs() {
        ProfileAccountsConfig pconfig = new ProfileAccountsConfig(TechServerConfig.INSTANCE);
        this.accountsPanel = new ProfileAccountsPanel(this.rpc, this.client, this.getAppProfile(), pconfig);
        this.groupsPanel = new TechGroupsPanel(this.client, pconfig);
        this.groupPermissionsPanel = new GroupPermissionsPanel(this.rpc, this.client, this.getAppProfile(), pconfig);
        this.monitoringPermissionsPanel = new MonitoringPermissionsPanel(this.rpc, this.client, this.getAppProfile(), pconfig);
        this.techConsoleRestrictionsPanel = new TechConsoleRestrictionsPanel(this.rpc, this.client, this.getAppProfile(), pconfig);
        GbPanel generalPanel = new GbPanel();
        SHStrippedContentPanel contentPanel = new SHStrippedContentPanel(generalPanel, false);
        contentPanel.addContent(this.groupsPanel.getRootComponent(), Language.get("MACHINE_GROUPS"));
        contentPanel.addContent((JComponent)((Object)this.accountsPanel), Language.get("USER_ACCOUNTS"));
        contentPanel.addVerticalFiller();
        contentPanel.setBackgroundColours();
        ArrayList<JComponent> buttons = new ArrayList<JComponent>();
        buttons.addAll(this.groupsPanel.getButtons());
        buttons.addAll(this.accountsPanel.getButtons());
        SwingUtil.setSizesToWidest(buttons);
        GbPanel restrictionsPanel = new GbPanel();
        SHStrippedContentPanel contentPanel2 = new SHStrippedContentPanel(restrictionsPanel, false);
        contentPanel2.addContent((JComponent)((Object)this.techConsoleRestrictionsPanel), Language.get("GROUP_PROFILE_TC_REST"));
        contentPanel2.addContent((JComponent)((Object)this.groupPermissionsPanel), Language.get("SESSION_RESTRICTIONS"));
        contentPanel2.addContent((JComponent)((Object)this.monitoringPermissionsPanel), Language.get("MONITORING_RESTRICTIONS"));
        contentPanel2.addVerticalFiller();
        contentPanel2.setBackgroundColours();
        return new AbstractProfileUI.AppProfileTab[]{new AbstractProfileUI.AppProfileTab(Language.get("GROUP_PROFILE_TAB_GENERAL"), ImageLoader.getImageIcon((String)"images/svg/users/group.svg,16"), (JComponent)generalPanel), new AbstractProfileUI.AppProfileTab(Language.get("GROUP_PROFILE_TAB_RESTRICTIONS"), ImageLoader.getImageIcon((String)"images/svg/computing/sliders.svg,16"), (JComponent)restrictionsPanel)};
    }

    @Override
    public void loadFromProfile(AppProfile appProfile) {
        this.resetTabs();
        this.accountsPanel.loadFromProfile(appProfile);
        this.groupsPanel.loadFromProfile(appProfile);
        this.groupPermissionsPanel.loadFromProfile(appProfile);
        this.monitoringPermissionsPanel.loadFromProfile(appProfile);
        this.techConsoleRestrictionsPanel.loadFromProfile(appProfile);
        Properties launchProperties = appProfile.getLaunchProperties();
        if (launchProperties == null) {
            launchProperties = new Properties();
        }
        if (launchProperties.getProperty(GroupAccessKeyset.ENABLED) == null) {
            launchProperties.setProperty(GroupAccessKeyset.ENABLED, "true");
            appProfile.setLaunchProperties(launchProperties);
        }
        this.uiListener.save(appProfile);
    }
}

