/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.appprofile;

import com.aem.profiles.model.AppProfile;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.appprofile.ProfileAccountsConfig;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.BorderPanel;
import utils.swing.layout.GbPanel;

public class MonitoringPermissionsPanel
extends BorderPanel
implements ActionListener,
ProfileAccountsConfig.ProfileAccountsReadyListener {
    private AppProfile profile;
    private ProfileAccountsConfig pconfig;
    private TechClient client;
    private RootPaneContainer rpc;
    private JCheckBox viewData;
    private JCheckBox viewScreenshots;
    private JCheckBox viewMetrics;
    private JCheckBox doFileCopy;
    private boolean loadedConfig = false;

    public MonitoringPermissionsPanel(RootPaneContainer rpc, TechClient client, AppProfile profile, ProfileAccountsConfig config) {
        this.profile = profile;
        this.pconfig = config;
        this.client = client;
        this.rpc = rpc;
        config.addProfileAccountsReadyListener(this);
        GbPanel gb = new GbPanel(new ScaledInsets(3, 3, 3, 5));
        gb.setOpaque(false);
        this.viewData = new JCheckBox(Language.get("ADMIN_GROUP_VIEW_MONITORING"));
        this.viewScreenshots = new JCheckBox(Language.get("ADMIN_GROUP_VIEW_SCREENSHOTS"));
        this.viewMetrics = new JCheckBox(Language.get("ADMIN_GROUP_VIEW_METRICS"));
        this.doFileCopy = new JCheckBox(Language.get("ADMIN_GROUP_COPY_MONITORING"));
        this.viewData.addActionListener(this);
        this.viewScreenshots.addActionListener(this);
        this.viewMetrics.addActionListener(this);
        this.doFileCopy.addActionListener(this);
        this.viewData.setOpaque(false);
        this.viewScreenshots.setOpaque(false);
        this.viewMetrics.setOpaque(false);
        this.doFileCopy.setOpaque(false);
        int N = 0;
        gb.add((Component)this.viewData, 0, N++, 1, 1, 0, 1, 17, 0);
        gb.add((Component)this.viewScreenshots, 0, N++, 1, 1, 0, 1, 17, 0);
        gb.add((Component)this.viewMetrics, 0, N++, 1, 1, 0, 1, 17, 0);
        gb.add((Component)this.doFileCopy, 0, N++, 1, 1, 0, 1, 17, 0);
        this.addWest((JComponent)gb);
    }

    private void loadProfile() {
        TechGroup tg = this.pconfig.getOrCreateGroupForAppProfile(this.profile);
        this.viewData.setSelected(tg.getPermissions().canViewMonitoring());
        this.viewScreenshots.setSelected(tg.getPermissions().canViewScreenshots());
        this.viewMetrics.setSelected(tg.getPermissions().canViewMetrics());
        this.doFileCopy.setSelected(tg.getPermissions().canCopyFiles());
    }

    public void loadFromProfile(AppProfile appProfile) {
        this.profile = appProfile;
        if (this.loadedConfig) {
            this.loadProfile();
        }
    }

    @Override
    public void profileAccountsReady() {
        this.loadedConfig = true;
        if (this.profile != null) {
            this.loadFromProfile(this.profile);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.profile == null) {
            return;
        }
        if (this.pconfig == null) {
            return;
        }
        TechGroup tg = this.pconfig.getOrCreateGroupForAppProfile(this.profile);
        if (tg == null) {
            return;
        }
        tg.getPermissions().setCanViewMonitoring(this.viewData.isSelected());
        tg.getPermissions().setCanViewScreenshots(this.viewScreenshots.isSelected());
        tg.getPermissions().setCanViewMetrics(this.viewMetrics.isSelected());
        tg.getPermissions().setCanCopyFiles(this.doFileCopy.isSelected());
        this.pconfig.saveAsync();
    }
}

