/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.appprofile;

import com.aem.profiles.model.AppProfile;
import com.aem.shelp.common.Language;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.util.feedback.MassFeedbackPanel;
import com.aem.shelp.util.feedback.MassJobListener;
import com.aem.shelp.util.feedback.MassStatus;
import com.jcraft.jsch.JSchException;
import com.jw.SHJWUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import utils.files.FileUtil;
import utils.osstats.winutils.WMIRegistry;
import utils.osstats.winutils.WMIResults;
import utils.osstats.winutils.WmicUtil;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.progtools.StackTracer;
import utils.ssh.RobustSSH;
import utils.ssh.SSHResponse;
import utils.stream.StreamPiper;
import utils.string.CharStack;
import utils.swing.JFixedWidthPasswordField;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.GlassDialog;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.BorderPanel;
import utils.swing.layout.CardPanel;
import utils.swing.layout.GbPanel;
import utils.swing.layout.VariableLinePanel;
import utils.switches.Switches;
import utils.sync.SyncCounter;
import utils.sync.ThreadPool;

public class MassDeployPanel
extends BorderPanel
implements ActionListener {
    private GlassDialog close;
    private boolean showClose = false;
    private final JLabel title;
    private final CardPanel cards = new CardPanel();
    private final JLabel choice = new JLabel(Language.get("MASS_DEPLOY_CHOICE"));
    private final JComboBox choicef = new JComboBox<String>(new String[]{Language.get("MASS_DEPLOY_SSH"), Language.get("MASS_DEPLOY_WMI")});
    private final JLabel installMessage = new JLabel("");
    private final JButton install = new JButton(Language.get("INSTALL"));
    private final JButton uninstall = new JButton(Language.get("REMOVE"));
    private final JButton closeb = new JButton(Language.get("CLOSE"));
    private final JLabel explain = new JLabel("<html>" + Language.get("MASS_DEPLOY_EXPLAIN") + "</html>");
    private final JLabel user = new JLabel(Language.get("USERNAME"));
    private final JTextField userf = new JTextField();
    private final JLabel pass = new JLabel(Language.get("PASSWORD"));
    private final JFixedWidthPasswordField passf = new JFixedWidthPasswordField();
    private final JLabel hosts = new JLabel(Language.get("HOSTS"));
    private final JTextArea hostsf = new JTextArea();
    private final VariableLinePanel buttons = new VariableLinePanel(1, true, false);
    private final AppProfile app;
    private final TechClient client;
    private final int concurrency = 20;
    private static Icon ERROR;
    private static Icon OK;
    private static final String RA_NAME;
    private static final String RA_ESCAPED;
    private final SyncCounter live = new SyncCounter();
    private static MassDeployPanel main_mdp;
    private static final HashMap<String, File> sources;
    private static final Object source_LOCK;

    private static String escapeSpaces(String s) {
        char[] tmp;
        StringBuffer sb = new StringBuffer();
        for (char c : tmp = s.toCharArray()) {
            if (c == ' ') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public MassDeployPanel(TechClient client, AppProfile app, boolean showClose) {
        this.client = client;
        this.showClose = showClose;
        this.app = app;
        ERROR = ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48");
        OK = ImageLoader.getImageIcon((String)"images/svg/dialogs/ok.svg,48");
        BorderPanel bp = new BorderPanel();
        this.title = new JLabel(app.getName());
        this.title.setHorizontalAlignment(0);
        this.title.setFont(SHStyle.largeFont);
        SwingUtil.padWithEmptyBorder((JComponent)this.title, (int)9);
        bp.addNorth((JComponent)this.title);
        GbPanel main = new GbPanel(new ScaledInsets(3, 6, 3, 3));
        int Y = 0;
        main.add((Component)this.choice, 0, Y, 1, 1, 1, 1, 13, 0);
        main.add((Component)this.choicef, 1, Y++, 1, 1, 100, 1, 17, 2);
        main.add((Component)this.explain, 1, Y++, 1, 1, 100, 1, 17, 2);
        main.add((Component)this.user, 0, Y, 1, 1, 1, 1, 13, 0);
        main.add((Component)this.userf, 1, Y++, 1, 1, 100, 1, 17, 2);
        main.add((Component)this.pass, 0, Y, 1, 1, 1, 1, 13, 0);
        main.add((Component)this.passf, 1, Y++, 1, 1, 100, 1, 17, 2);
        main.add((Component)this.hosts, 0, Y, 1, 1, 1, 1, 12, 0, (Insets)new ScaledInsets(9, 3, 3, 3));
        main.add((Component)new JScrollPane(this.hostsf), 1, Y++, 1, 1, 100, 1000, 11, 1);
        bp.addCenter((JComponent)main);
        this.buttons.setGridSpacing(new ScaledInsets(3, 3, 3, 3));
        this.buttons.add((Component)this.installMessage);
        this.buttons.add((Component)this.uninstall);
        this.buttons.add((Component)this.install);
        if (showClose) {
            this.buttons.add((Component)this.closeb);
            this.closeb.addActionListener(this);
        }
        this.uninstall.addActionListener(this);
        this.install.addActionListener(this);
        this.choicef.addActionListener(this);
        bp.addSouth((JComponent)this.buttons);
        this.cards.add((Component)bp);
        this.addCenter(this.cards);
    }

    public void addCloseListener(ActionListener listener) {
        this.closeb.removeActionListener(this);
        this.closeb.addActionListener(listener);
    }

    public static void showDialog(RootPaneContainer rpc, TechClient client, AppProfile app) {
        if (main_mdp == null) {
            main_mdp = new MassDeployPanel(client, app, true);
            main_mdp.setPreferredSize(SimpleHelpLookAndFeel.scale((Dimension)new Dimension(700, 400)));
        }
        String name = "";
        if (app != null) {
            name = app.getName();
        }
        MassDeployPanel.main_mdp.close = SHGlassOptionPane.showBorderlessDialog((RootPaneContainer)rpc, (JComponent)((Object)main_mdp), (String)Language.get("MASS_DEPLOY_TITLE", name), (int)700);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.closeb) {
            this.close.setVisible(false);
            this.passf.setText("");
        } else if (o == this.choicef) {
            if (this.choicef.getSelectedIndex() == 1 && !OS.isWindows7OrAbove()) {
                this.installMessage.setForeground(SHStyle.ERROR_TEXT_COLOR);
                this.installMessage.setText(Language.get("MASS_DEPLOY_WINDOWS_ONLY") + "  ");
                this.uninstall.setEnabled(false);
                this.install.setEnabled(false);
            } else {
                this.installMessage.setText("");
                this.uninstall.setEnabled(true);
                this.install.setEnabled(true);
            }
        } else if (o == this.install || o == this.uninstall) {
            final MassFeedbackPanel mfp = new MassFeedbackPanel(Language.get("DEPLOYING") + " " + this.app.getName());
            mfp.setAllowCancel(true);
            final boolean mustInstall = o == this.install;
            final boolean wmi = this.choicef.getSelectedIndex() != 0;
            final String masterUser = this.userf.getText();
            final String masterPass = this.passf.getText();
            mfp.setMassJobListener(new MassJobListener(){

                @Override
                public void retry(ArrayList<String> jobIds) {
                    String[] lines = new String[jobIds.size()];
                    jobIds.toArray(lines);
                    new MassDeploySet(wmi, mfp, MassDeployPanel.this.client, mustInstall, MassDeployPanel.this.app, lines, masterUser, masterPass, 20).start();
                }

                @Override
                public void closed() {
                    MassDeployPanel.this.closeb.doClick();
                }

                @Override
                public void cancelled() {
                    MassDeployPanel.this.closeb.doClick();
                }
            });
            this.cards.showTemporaryCard((Component)((Object)mfp));
            new MassDeploySet(wmi, mfp, this.client, mustInstall, this.app, this.hostsf.getText().trim().split("\n"), masterUser, masterPass, 20).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void massDeploySSH(MassFeedbackPanel mfp, TechClient client, boolean install, AppProfile app, String[] hostlines, String masterUser, String masterPass, int concurrency) {
        Object object = source_LOCK;
        synchronized (object) {
            sources.clear();
        }
        ThreadPool tp = null;
        if (concurrency > 1) {
            tp = new ThreadPool(concurrency);
        }
        for (int i = 0; i < hostlines.length; ++i) {
            String line = hostlines[i];
            CharStack cs = new CharStack(line);
            String host = cs.popUntil(",", true).trim();
            String user = masterUser;
            String pass = masterPass;
            if (!cs.isEmpty()) {
                user = cs.popUntil(",", true).trim();
            }
            if (!cs.isEmpty()) {
                pass = cs.popUntil(",", true).trim();
            }
            DeploySshJob job = new DeploySshJob(mfp);
            if (!install) {
                job.uninstall = true;
            }
            job.id = line;
            job.host = host;
            job.user = user;
            job.pass = pass;
            job.app = app;
            job.shhost = client.getHost();
            job.shport = client.getPort();
            if (tp == null) {
                job.run();
                continue;
            }
            tp.run(job);
        }
        if (tp != null) {
            tp.joinAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File grabSource(String host, int port, String arch, String suffix, AppProfile app) throws IOException {
        String key = arch + "_" + suffix;
        Object object = source_LOCK;
        synchronized (object) {
            File source = sources.get(key);
            if (source != null) {
                return source;
            }
            String accessName = URLEncoder.encode(RA_NAME);
            String profilesUrl = SHJWUtil.getUpdateURLProtocol() + "://" + host + ":" + port + "/access/" + accessName + "-" + arch + "-offline." + suffix + "?hostname=http%3A%2F%2F" + host + "%3A" + port + "&app=" + app.getID();
            System.out.println("Downloading offline installer from " + profilesUrl);
            BufferedInputStream in = new BufferedInputStream(new URL(profilesUrl).openStream());
            source = new File(OemBranding.OEM_APPLICATION_NAME + "_" + arch + "_mass_deploy." + suffix);
            BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(source));
            StreamPiper.pipe((InputStream)in, (OutputStream)fout, (boolean)true, (boolean)false, (boolean)false);
            System.out.println("Installer downloaded");
            ((InputStream)in).close();
            ((OutputStream)fout).close();
            sources.put(key, source);
            return source;
        }
    }

    private static void massDeployWMI(MassFeedbackPanel mfp, TechClient client, boolean install, AppProfile app, String[] hostlines, String masterUser, String masterPass, int concurrency) throws IOException {
        File source;
        masterUser = masterUser.trim();
        masterPass = masterPass.trim();
        try {
            String accessName = URLEncoder.encode(OemBranding.OEM_ACCESS_APP_NAME);
            String profilesUrl = SHJWUtil.getUpdateURLProtocol() + "://" + client.getHost() + ":" + client.getPort() + "/access/" + accessName + "-windows32-offline.exe?hostname=http%3A%2F%2F" + client.getHost() + "%3A" + client.getPort() + "&app=" + app.getID();
            System.out.println("Downloading offline installer from " + profilesUrl);
            BufferedInputStream in = new BufferedInputStream(new URL(profilesUrl).openStream());
            source = new File(OemBranding.OEM_APPLICATION_NAME + "_mass_deploy.exe");
            Properties[] fout = new BufferedOutputStream(new FileOutputStream(source));
            StreamPiper.pipe((InputStream)in, (OutputStream)fout, (boolean)true, (boolean)false, (boolean)false);
            System.out.println("Installer downloaded");
            ((InputStream)in).close();
            fout.close();
        }
        catch (IOException x) {
            MassStatus status = new MassStatus("preconfig_error", Language.get("MDP_INSTALLER_SETUP_FAILED"), ERROR, true);
            mfp.jobCompleted("MDP_INSTALLER_SETUP", Language.get("MDP_INSTALLER_SETUP"), StackTracer.getStacktrace((Throwable)x), status);
            throw x;
        }
        System.out.println("Checking available drives");
        HashMap<String, String> taken = new HashMap<String, String>();
        WMIResults wmiResults = WMIRegistry.getProvider().queryWMI("SELECT * from Win32_LogicalDisk");
        if (wmiResults.hasProperties()) {
            Properties[] resultRows = wmiResults.getProperties();
            System.out.println("[MassDeployPanel] WMI query returned " + resultRows.length + " drives");
            for (Properties row : resultRows) {
                String drive;
                String driveWithColon = row.getProperty("DeviceID");
                if (driveWithColon.length() != 2 || !driveWithColon.endsWith(":") || taken.containsKey(drive = "" + driveWithColon.charAt(0))) continue;
                taken.put(drive, drive);
                System.out.println("[MassDeployPanel] Drive " + drive + " is occupied");
            }
        }
        Object drives_LOCK = new Object();
        LinkedList<String> drives = new LinkedList<String>();
        for (int N = 3; N <= 26; ++N) {
            String drive = "" + (char)(N + 64);
            if (taken.containsKey(drive) || new File(drive + ":").exists()) {
                System.out.println("Will not use drive " + drive);
                continue;
            }
            drives.add(drive);
        }
        System.out.println("Done, " + drives.size() + " free drives available");
        if (drives.size() == 0) {
            System.out.println("Unable to run - no free drive letters available?");
            MassStatus status = new MassStatus("no_drive_letters", Language.get("MDP_DRIVE_LETTERS_NONE"), ERROR, true);
            mfp.jobCompleted("check drive letter", Language.get("MDP_CHECK_DRIVE_LETTER"), "Drive Letters Taken: " + taken.size(), status);
            return;
        }
        ThreadPool tp = null;
        if (concurrency > 1) {
            tp = new ThreadPool(concurrency);
        }
        for (int i = 0; i < hostlines.length; ++i) {
            String line = hostlines[i];
            CharStack cs = new CharStack(line);
            String host = cs.popUntil(",", true).trim();
            String user = masterUser;
            String pass = masterPass;
            if (!cs.isEmpty()) {
                user = cs.popUntil(",", true).trim();
            }
            if (!cs.isEmpty()) {
                pass = cs.popUntil(",", true).trim();
            }
            DeployWmiJob job = new DeployWmiJob(mfp);
            if (!install) {
                job.uninstall = true;
            }
            job.id = line;
            job.source = source;
            job.host = host;
            job.user = user;
            job.pass = pass;
            job.drives = drives;
            job.drives_LOCK = drives_LOCK;
            if (tp == null) {
                job.run();
                continue;
            }
            tp.run(job);
        }
        if (tp != null) {
            tp.joinAll();
        }
    }

    static {
        RA_NAME = OemBranding.OEM_ACCESS_APP_NAME;
        RA_ESCAPED = MassDeployPanel.escapeSpaces(RA_NAME);
        sources = new HashMap();
        source_LOCK = new Object();
    }

    static class DeploySshJob
    implements Runnable {
        File source;
        String id;
        String host;
        String user;
        String pass;
        AppProfile app;
        String shhost;
        int shport;
        LinkedList<String> drives;
        Object drives_LOCK;
        boolean uninstall = false;
        final MassFeedbackPanel mfp;
        final StringBuffer log = new StringBuffer();

        DeploySshJob(MassFeedbackPanel mfp) {
            this.mfp = mfp;
        }

        void log(String s) {
            this.log.append(s).append('\n');
            System.out.println(s);
        }

        void log(SSHResponse resp) {
            this.log("Command: " + resp.origCommand);
            this.log("Retcode: " + resp.exitCode);
            this.log("Stdout: " + resp.response);
            this.log("Stderr: " + resp.error);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                File source;
                RobustSSH ssh = new RobustSSH(this.host, 22, this.user, this.pass);
                boolean root = this.user.equals("root");
                if (!root) {
                    this.log("Assuming sudo privileges");
                    ssh.setRootPass(this.pass);
                } else {
                    this.log("Assuming superuser privileges by default");
                }
                ssh.setLogging(true);
                SSHResponse response = ssh.run("/", "uname", "Uname to determine OS");
                this.log(response);
                this.log("uname returned " + response.response);
                boolean macos = false;
                if (response.response.toLowerCase().contains("darwin")) {
                    this.log("MacOS");
                    macos = true;
                } else {
                    this.log("Linux");
                }
                boolean linux = !macos;
                response = ssh.run("/", "uname -m", "Uname to determine Arch");
                this.log(response);
                this.log("uname returned " + response.response);
                boolean arm = false;
                boolean bit64 = true;
                if (response.response.toLowerCase().contains("arm")) {
                    arm = true;
                    bit64 = false;
                } else if (response.response.toLowerCase().contains("64")) {
                    this.log("64-bit system");
                } else {
                    this.log("32-bit system");
                    bit64 = false;
                }
                if (macos) {
                    if (!bit64) {
                        MassStatus status = new MassStatus("macos32_error", Language.get("MDP_MACOS32_OLD"), ERROR, true);
                        this.mfp.jobCompleted(this.id, Language.get("MDP_INSTALL_ACCESS_ON") + " " + this.host, "", status);
                        throw new IOException("MacOS 32 not supported");
                    }
                    source = MassDeployPanel.grabSource(this.shhost, this.shport, "macos64", "dmg", this.app);
                } else {
                    source = arm ? MassDeployPanel.grabSource(this.shhost, this.shport, "linux32arm", "tar", this.app) : (bit64 ? MassDeployPanel.grabSource(this.shhost, this.shport, "linux64", "tar", this.app) : MassDeployPanel.grabSource(this.shhost, this.shport, "linux32", "tar", this.app));
                }
                if (linux) {
                    ssh.pushFile(source, "/opt/sh_mass_deploy.tar", "755");
                    response = ssh.runsudo("/opt", "tar -xf sh_mass_deploy.tar", "extract mass deploy installer");
                    this.log(response);
                    if (this.uninstall) {
                        response = ssh.runscriptsudo("/opt", "./" + RA_ESCAPED + "-*-offline uninstall", "launch uninstaller");
                        this.log(response);
                    } else {
                        response = ssh.runscriptsudo("/opt", "./" + RA_ESCAPED + "-*-offline", "launch installer");
                        this.log(response);
                    }
                } else {
                    ssh.pushFile(source, "/tmp/sh_mass_deploy.dmg", "755");
                    String[] files = ssh.run((String)"/tmp", (String)"ls -1 /Volumes", (String)"list volumes").response.split("\n");
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (String file : files) {
                        map.put(file, file);
                    }
                    response = ssh.run("/tmp", "hdiutil mount sh_mass_deploy.dmg -nobrowse", "mount mass deploy DMG");
                    this.log(response);
                    files = ssh.run((String)"/tmp", (String)"ls -1 /Volumes", (String)"list volumes").response.split("\n");
                    String volname = "Access";
                    for (String file : files) {
                        if (map.containsKey(file)) continue;
                        volname = MassDeployPanel.escapeSpaces(file);
                        this.log("Got '" + volname + "' as mounted DMG name");
                        break;
                    }
                    response = ssh.runscript("/tmp", "cp -r /Volumes/" + volname + "/*.app /tmp/", "copy .app to /tmp");
                    this.log(response);
                    response = ssh.runscript("/tmp", "hdiutil unmount /Volumes/" + volname, "unmount mass deploy DMG");
                    this.log(response);
                    if (this.uninstall) {
                        response = ssh.runscriptsudo("/tmp", "/tmp/" + RA_ESCAPED + "*.app/Contents/MacOS/osxwrapper uninstall", "launch the installer app");
                        this.log(response);
                    } else {
                        response = ssh.runscriptsudo("/tmp", "/tmp/" + RA_ESCAPED + "*.app/Contents/MacOS/osxwrapper", "launch the installer app");
                        this.log(response);
                    }
                }
                MassStatus status = new MassStatus("install_ok", Language.get("MDP_INSTALL_OK"), OK, false);
                this.mfp.jobCompleted(this.id, Language.get("MDP_INSTALL_ACCESS_ON") + " " + this.host, "", status);
                return;
            }
            catch (JSchException x) {
                String str = x.getMessage() + "";
                if (str.toLowerCase().contains("authentication")) {
                    MassStatus status = new MassStatus("ssh authentication fail", Language.get("MDP_SSH_AUTH_FAILED"), ERROR, true);
                    this.mfp.jobCompleted(this.id, Language.get("MDP_SSH_OPEN", this.host), StackTracer.getStacktrace((Throwable)x), status);
                    return;
                }
                if (str.toLowerCase().contains("connectexception")) {
                    MassStatus status = new MassStatus("ssh connect fail", Language.get("MDP_SSH_CONNECT_FAILED"), ERROR, true);
                    this.mfp.jobCompleted(this.id, Language.get("MDP_SSH_OPEN", this.host), StackTracer.getStacktrace((Throwable)x), status);
                    return;
                }
                if (str.toLowerCase().contains("unknownhost")) {
                    MassStatus status = new MassStatus("ssh dns fail", Language.get("MDP_SSH_DNS_FAILED"), ERROR, true);
                    this.mfp.jobCompleted(this.id, Language.get("MDP_SSH_OPEN", this.host), StackTracer.getStacktrace((Throwable)x), status);
                    return;
                }
                MassStatus status = new MassStatus("ssh general fail", Language.get("MDP_SSH_FAILED"), ERROR, true);
                this.mfp.jobCompleted(this.id, Language.get("MDP_SSH_OPEN", this.host), StackTracer.getStacktrace((Throwable)x), status);
                return;
            }
            catch (Exception x) {
                x.printStackTrace();
                MassStatus status = new MassStatus("ssh install unknown fail", Language.get("MDP_UNKNOWN_FAILURE"), ERROR, true);
                this.mfp.jobCompleted(this.id, Language.get("MDP_INSTALL_ACCESS_ON") + " " + this.host, StackTracer.getStacktrace((Throwable)x), status);
            }
        }
    }

    static class DeployWmiJob
    implements Runnable {
        File source;
        String id;
        String host;
        String user;
        String pass;
        LinkedList<String> drives;
        Object drives_LOCK;
        boolean uninstall = false;
        final MassFeedbackPanel mfp;
        final StringBuffer log = new StringBuffer();

        DeployWmiJob(MassFeedbackPanel mfp) {
            this.mfp = mfp;
        }

        void log(String s) {
            this.log.append(s).append('\n');
            System.out.println(s);
        }

        String quoteIfNotQuoted(String s) {
            if (Switches.SH_quoteWmicForMassDeploy) {
                if (!s.startsWith("\"")) {
                    s = "\"" + s;
                }
                if (!s.endsWith("\"")) {
                    s = s + "\"";
                }
            }
            return s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String mydrive;
            while (true) {
                Object object = this.drives_LOCK;
                synchronized (object) {
                    if (this.drives.size() > 0) {
                        mydrive = this.drives.removeFirst();
                        break;
                    }
                }
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {}
            }
            this.log("Using drive " + mydrive + " to remote install on " + this.host);
            try {
                MassStatus status;
                this.log("Mapping " + this.host + " to " + mydrive + ":");
                Object response = RunCommandGetOutput.runCommand((String[])new String[]{"net", "use", mydrive + ":", "\\\\" + this.host + "\\C$", "/user:" + this.user, this.pass});
                this.log("Map complete");
                this.log("Retcode:" + response.returnCode);
                this.log("Stdout:" + response.stdout);
                this.log("Stderr:" + response.stderr);
                if (response.returnCode != 0) {
                    MassStatus status2 = new MassStatus("map_drive_error", Language.get("MDP_MAP_DRIVE_ERROR"), ERROR, true);
                    this.mfp.jobCompleted(this.id, Language.get("MDP_ATTEMPT_MAP_DRIVE") + " " + this.host, "Retcode: " + response.returnCode + "\nStdout: " + response.stdout + "\nStderr: " + response.stderr, status2);
                    throw new IOException("Failed to map drive " + mydrive + " to " + this.host);
                }
                try {
                    File target = new File(mydrive + ":\\" + OemBranding.OEM_APPLICATION_NAME + "_mass_deploy.exe");
                    if (target.exists()) {
                        target.delete();
                    }
                    try {
                        String[] wmicx;
                        this.log("Copying " + this.source + " to " + target);
                        FileUtil.copyFast((File)this.source, (File)target);
                        if (!this.uninstall) {
                            this.log("Launching for install");
                            wmicx = new String[]{"/node:" + this.quoteIfNotQuoted(this.host), "/user:" + this.quoteIfNotQuoted(this.user), "/password:" + this.quoteIfNotQuoted(this.pass), "PROCESS", "call", "create", "C:\\" + target.getName()};
                        } else {
                            this.log("Launching for uninstall");
                            wmicx = new String[]{"/node:" + this.quoteIfNotQuoted(this.host), "/user:" + this.quoteIfNotQuoted(this.user), "/password:" + this.quoteIfNotQuoted(this.pass), "PROCESS", "call", "create", "C:\\" + target.getName() + " /S GU_gu_virt_app=JWRAPPER_UNINSTALLER GU_JWAutoUninstall=yes"};
                        }
                        this.log("Launching wmi");
                        response = WmicUtil.launchWmicCommandGetResponse((String[])wmicx);
                        this.log("WMI stdout: " + response.stdout);
                        this.log("WMI stderr: " + response.stderr);
                        if (response.returnCode != 0) {
                            MassStatus status3 = new MassStatus("launch_wmi_command_error", Language.get("MDP_LAUNCH_WMI_ERROR"), ERROR, true);
                            this.mfp.jobCompleted(this.id, Language.get("MDP_ATTEMPT_LAUNCH_WMI") + " " + this.host, "Retcode: " + response.returnCode + "\nStdout: " + response.stdout + "\nStderr: " + response.stderr, status3);
                            throw new IOException("Failed to launch installer via WMI");
                        }
                        this.log("Launch OK");
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                        this.log("Clearing mapped drive " + mydrive);
                        response = RunCommandGetOutput.runCommand((String[])new String[]{"net", "use", mydrive + ":", "/delete"});
                        this.log("Unmap complete");
                        this.log("Stdout:" + response.stdout);
                        this.log("Stderr:" + response.stderr);
                        if (response.returnCode != 0) {
                            MassStatus status4 = new MassStatus("unmap_drive_error", Language.get("MDP_UNMAP_DRIVE_ERROR"), ERROR, true);
                            this.mfp.jobCompleted(this.id, Language.get("MDP_ATTEMPT_UNMAP_DRIVE") + " " + this.host, "Retcode: " + response.returnCode + "\nStdout: " + response.stdout + "\nStderr: " + response.stderr, status4);
                            throw new IOException("Failed to unmap drive " + mydrive);
                        }
                        this.log("Returning drive slot " + mydrive + " to pool");
                        Object object = this.drives_LOCK;
                        synchronized (object) {
                            this.drives.addLast(mydrive);
                        }
                        return;
                    }
                    this.log("Clearing mapped drive " + mydrive);
                }
                catch (Throwable throwable) {
                    this.log("Clearing mapped drive " + mydrive);
                    response = RunCommandGetOutput.runCommand((String[])new String[]{"net", "use", mydrive + ":", "/delete"});
                    this.log("Unmap complete");
                    this.log("Stdout:" + response.stdout);
                    this.log("Stderr:" + response.stderr);
                    if (response.returnCode != 0) {
                        MassStatus status5 = new MassStatus("unmap_drive_error", Language.get("MDP_UNMAP_DRIVE_ERROR"), ERROR, true);
                        this.mfp.jobCompleted(this.id, Language.get("MDP_ATTEMPT_UNMAP_DRIVE") + " " + this.host, "Retcode: " + response.returnCode + "\nStdout: " + response.stdout + "\nStderr: " + response.stderr, status5);
                        throw new IOException("Failed to unmap drive " + mydrive);
                    }
                    throw throwable;
                }
                response = RunCommandGetOutput.runCommand((String[])new String[]{"net", "use", mydrive + ":", "/delete"});
                this.log("Unmap complete");
                this.log("Stdout:" + response.stdout);
                this.log("Stderr:" + response.stderr);
                if (response.returnCode != 0) {
                    status = new MassStatus("unmap_drive_error", Language.get("MDP_UNMAP_DRIVE_ERROR"), ERROR, true);
                    this.mfp.jobCompleted(this.id, Language.get("MDP_ATTEMPT_UNMAP_DRIVE") + " " + this.host, "Retcode: " + response.returnCode + "\nStdout: " + response.stdout + "\nStderr: " + response.stderr, status);
                    throw new IOException("Failed to unmap drive " + mydrive);
                }
                status = new MassStatus("install_ok", Language.get("MDP_INSTALL_OK"), OK, false);
                this.mfp.jobCompleted(this.id, Language.get("MDP_INSTALL_ACCESS_ON") + " " + this.host, "", status);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            finally {
                this.log("Returning drive slot " + mydrive + " to pool");
                Object object = this.drives_LOCK;
                synchronized (object) {
                    this.drives.addLast(mydrive);
                }
            }
        }
    }

    private class MassDeploySet
    extends Thread {
        final boolean wmi;
        final MassFeedbackPanel mfp;
        final TechClient client;
        final boolean install;
        final AppProfile app;
        final String[] hostlines;
        final String masterUser;
        final String masterPass;
        final int concurrency;

        MassDeploySet(boolean wmi, MassFeedbackPanel mfp, TechClient client, boolean install, AppProfile app, String[] hostlines, String masterUser, String masterPass, int concurrency) {
            this.wmi = wmi;
            this.mfp = mfp;
            this.client = client;
            this.install = install;
            this.app = app;
            this.hostlines = hostlines;
            this.masterUser = masterUser;
            this.masterPass = masterPass;
            this.concurrency = concurrency;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            MassDeployPanel.this.live.increment();
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MassDeploySet.this.mfp.markJobsRunning();
                    }
                });
                if (!this.wmi) {
                    MassDeployPanel.massDeploySSH(this.mfp, this.client, this.install, this.app, this.hostlines, this.masterUser, this.masterPass, this.concurrency);
                } else {
                    MassDeployPanel.massDeployWMI(this.mfp, this.client, this.install, this.app, this.hostlines, this.masterUser, this.masterPass, this.concurrency);
                }
                MassDeployPanel.this.live.decrement();
                if (!MassDeployPanel.this.live.isZero()) return;
            }
            catch (IOException x) {
                try {
                    x.printStackTrace();
                    MassDeployPanel.this.live.decrement();
                    if (!MassDeployPanel.this.live.isZero()) return;
                }
                catch (Throwable throwable) {
                    MassDeployPanel.this.live.decrement();
                    if (!MassDeployPanel.this.live.isZero()) throw throwable;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MassDeploySet.this.mfp.allJobsComplete();
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                return;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            return;
        }
    }
}

