/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts.details.triggers;

import com.aem.CentralDebugging;
import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.tech.alerts.alerts.details.AlertModifyListener;
import com.aem.shelp.tech.alerts.alerts.details.triggers.TriggerPickerDialog;
import com.aem.shelp.tech.alerts.alerts.details.triggers.TriggersListPanel;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import utils.swing.SwingUtil;
import utils.swing.borders.ImprovedRoundRectBorder;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.switches.oem.OEMSwitches;

public class TriggerGroupPanel
extends ColorPropagatingPanel
implements MouseListener {
    private static int maxConjunctionWidth;
    private TriggersListPanel.TriggerGroup triggerGroup;
    private static final Color backgroundColor;
    private static final Color backgroundColorDarker;
    private static final Color backgroundColorDarkest;
    private ArrayList<AlertModifyListener> listeners = new ArrayList();
    private boolean isConjunction;
    private GbPanel contentPanel;
    private static final ArrayList<TriggerGroupRow> rowsWithEditButtonsShowing;
    private TriggersListPanel triggersListPanel;

    public TriggersListPanel.TriggerGroup getTriggerGroup() {
        return this.triggerGroup;
    }

    public void removeAlert(Alert alert) {
        Component[] comps;
        if (CentralDebugging.ALERT_COROLLARY) {
            System.out.println("[AlertCorollary] Searching to remove " + alert.getID() + " (" + alert.isCorollaryFor() + ")");
        }
        for (Component comp : comps = this.contentPanel.getComponents()) {
            if (CentralDebugging.ALERT_COROLLARY) {
                System.out.println("[AlertCorollary] Comp: " + comp);
            }
            if (!(comp instanceof TriggerGroupRow)) continue;
            TriggerGroupRow tg = (TriggerGroupRow)comp;
            if (tg.trigger != null) {
                if (CentralDebugging.ALERT_COROLLARY) {
                    System.out.println("[AlertCorollary] Trigger: " + tg.trigger.getID() + " (" + tg.trigger.isCorollaryFor() + ")");
                }
                if (!tg.trigger.getID().equals(alert.getID())) continue;
                if (CentralDebugging.ALERT_COROLLARY) {
                    System.out.println("[AlertCorollary] Removing");
                }
                this.triggerGroup.triggers.remove(tg.trigger);
                this.removeRow(tg);
                this.notifyChanged();
                continue;
            }
            if (!CentralDebugging.ALERT_COROLLARY) continue;
            System.out.println("[AlertCorollary] Trigger: " + tg.trigger);
        }
    }

    public TriggerGroupPanel(AlertModifyListener modify, TriggersListPanel.TriggerGroup triggerGroup, TriggersListPanel triggersListPanel, boolean isConjunction) {
        super((LayoutManager)new GridLayout(1, 1));
        this.isConjunction = isConjunction;
        this.triggersListPanel = triggersListPanel;
        this.triggerGroup = triggerGroup;
        this.addAlertModifyListener(modify);
        this.initUI();
    }

    public void addAlertModifyListener(AlertModifyListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void notifyChanged() {
        for (AlertModifyListener listener : this.listeners) {
            listener.alertModified();
        }
    }

    private void initUI() {
        ImprovedRoundRectBorder border = new ImprovedRoundRectBorder(backgroundColorDarkest, this.getBackground(), backgroundColor);
        border.setRadius(2);
        border.setWidth(1);
        this.setBorder(border);
        this.contentPanel = new GbPanel();
        this.contentPanel.setBackground(backgroundColor);
        this.add((Component)this.contentPanel);
        int Y = 0;
        boolean usingPlaceholder = false;
        for (Alert trigger : this.triggerGroup.triggers) {
            TriggerGroupRow row = new TriggerGroupRow(trigger);
            row.setShowConjunction(Y > 0);
            this.contentPanel.add((Component)row, 0, Y++, 1, 1, 1, 1, 17, 2);
        }
        if (Y == 0) {
            usingPlaceholder = true;
            TriggerGroupRow placeHolder = new TriggerGroupRow(true);
            placeHolder.setShowConjunction(false);
            this.contentPanel.add((Component)placeHolder, 0, Y++, 1, 1, 1, 1, 17, 2);
        }
        TriggerGroupRow row = new TriggerGroupRow(null);
        row.setShowConjunction(!usingPlaceholder && Y > 0);
        this.contentPanel.add((Component)row, 0, Y++, 1, 1, 1, 1, 17, 2);
    }

    public void addNewRow(TriggerGroupRow newRow) {
        TriggerGroupRow newItemRow = (TriggerGroupRow)this.contentPanel.getComponent(this.contentPanel.getComponentCount() - 1);
        this.contentPanel.remove((Component)newItemRow);
        TriggerGroupRow lastEntry = (TriggerGroupRow)this.contentPanel.getComponent(this.contentPanel.getComponentCount() - 1);
        if (lastEntry.isPlaceholder()) {
            this.contentPanel.remove((Component)lastEntry);
        }
        newRow.setShowConjunction(this.contentPanel.getComponentCount() > 0);
        this.contentPanel.add((Component)newRow, 0, this.contentPanel.getComponentCount(), 1, 1, 1, 1, 17, 2);
        newItemRow.setShowConjunction(true);
        this.contentPanel.add((Component)newItemRow, 0, this.contentPanel.getComponentCount(), 1, 1, 1, 1, 17, 2);
        this.notifyChanged();
    }

    public void setIsConjunction(boolean isConjunction) {
        this.isConjunction = isConjunction;
    }

    public void addThreshold(Alert alert) {
        TriggerGroupRow newRow = new TriggerGroupRow(alert);
        this.addNewRow(newRow);
        this.triggerGroup.triggers.add(alert);
        this.contentPanel.revalidate();
        this.contentPanel.repaint();
        this.notifyChanged();
    }

    public void removeRow(TriggerGroupRow triggerGroupRow) {
        this.contentPanel.remove((Component)triggerGroupRow);
        if (this.contentPanel.getComponentCount() == 1) {
            this.triggersListPanel.removeTriggerGroup(this.triggerGroup);
        } else {
            boolean first = true;
            for (Component c : this.contentPanel.getComponents()) {
                if (c instanceof TriggerGroupRow) {
                    ((TriggerGroupRow)c).setShowConjunction(!first);
                }
                first = false;
            }
            this.contentPanel.revalidate();
            this.contentPanel.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseExited(MouseEvent e) {
        ArrayList<TriggerGroupRow> arrayList = rowsWithEditButtonsShowing;
        synchronized (arrayList) {
            for (Component c : this.contentPanel.getComponents()) {
                if (c instanceof TriggerGroupRow) {
                    TriggerGroupRow row = (TriggerGroupRow)c;
                    row.hideButtons();
                    row.repaint();
                }
                rowsWithEditButtonsShowing.remove(c);
            }
        }
    }

    static {
        backgroundColor = SHStyle.PANEL_BACKGROUND_BLUE_LIGHTER;
        backgroundColorDarker = !OEMSwitches.DARK_THEME ? new Color(200, 220, 240) : new Color(130, 144, 164);
        backgroundColorDarkest = new Color(190, 210, 240);
        rowsWithEditButtonsShowing = new ArrayList();
        JLabel AND = new JLabel(Language.get("ALERT_AND"));
        JLabel OR = new JLabel(Language.get("ALERT_OR"));
        maxConjunctionWidth = Math.max(AND.getPreferredSize().width, OR.getPreferredSize().width);
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof MouseEvent && rowsWithEditButtonsShowing.size() > 0) {
                    ArrayList arrayList = rowsWithEditButtonsShowing;
                    synchronized (arrayList) {
                        MouseEvent e = (MouseEvent)event;
                        for (int i = rowsWithEditButtonsShowing.size() - 1; i >= 0; --i) {
                            TriggerGroupRow row = (TriggerGroupRow)rowsWithEditButtonsShowing.get(i);
                            if (row.contains(e.getPoint())) continue;
                            row.hideButtons();
                            rowsWithEditButtonsShowing.remove(i);
                        }
                    }
                }
            }
        }, 16L);
    }

    class TriggerGroupRow
    extends JPanel
    implements MouseListener,
    ActionListener {
        private final boolean isPlaceholder;
        private Alert trigger;
        private JLabel triggerLabel;
        private JLabel removeLabel;
        private JLabel conjunctionLabel;
        private JButton addButton;
        private MouseListener removeLabelListener;

        public TriggerGroupRow(boolean isPlaceholder) {
            this(null, isPlaceholder);
        }

        public TriggerGroupRow(Alert trigger) {
            this(trigger, false);
        }

        private void update() {
            this.triggerLabel.setText(this.trigger.getName());
        }

        public TriggerGroupRow(Alert trigger, boolean isPlaceholder) {
            super(new BorderLayout());
            this.removeLabelListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    TriggerGroupRow.this.removePressed();
                }
            };
            this.isPlaceholder = isPlaceholder;
            this.trigger = trigger;
            this.setBackground(backgroundColor);
            if (trigger != null) {
                this.triggerLabel = new JLabel(trigger.getName()){

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension dim = super.getPreferredSize();
                        dim.width = 1;
                        return dim;
                    }
                };
                this.removeLabel = new JLabel(ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,16"));
                this.removeLabel.setCursor(Cursor.getPredefinedCursor(12));
                this.removeLabel.addMouseListener(this.removeLabelListener);
                this.removeLabel.setVisible(false);
                this.add((Component)this.triggerLabel, "Center");
                this.add((Component)this.removeLabel, "East");
                this.addMouseListener(this);
            } else if (isPlaceholder) {
                this.triggerLabel = new JLabel(Language.get("NO_THRESHOLDS")){

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension dim = super.getPreferredSize();
                        dim.width = 1;
                        return dim;
                    }
                };
                this.triggerLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR_LIGHTEST);
                this.add((Component)this.triggerLabel, "Center");
            } else {
                JPanel buttonPanel = new JPanel(new BorderLayout());
                buttonPanel.setBackground(backgroundColor);
                this.addButton = new JButton(Language.get("ALERT_TRIGGER"), ImageLoader.getImageIcon((String)"images/svg/general/add.svg,12"));
                this.addButton.setFont(SHStyle.smallerFont);
                this.addButton.setMargin((Insets)new ScaledInsets(3, 5, 3, 5));
                buttonPanel.add((Component)this.addButton, "West");
                this.add((Component)buttonPanel, "Center");
                this.addButton.addActionListener(this);
            }
            this.conjunctionLabel = TriggersListPanel.getConjunctionLabel(true);
            SwingUtil.setWidth((JComponent)this.conjunctionLabel, (int)maxConjunctionWidth);
            this.add((Component)this.conjunctionLabel, "West");
            this.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)0, (int)5, (int)5));
            SwingUtil.setHeight((JComponent)this, (int)SimpleHelpLookAndFeel.scale((int)30));
        }

        public void setShowConjunction(boolean showConjunction) {
            if (showConjunction) {
                this.conjunctionLabel.setText(Language.get(TriggerGroupPanel.this.isConjunction ? Language.get("ALERT_AND") : Language.get("ALERT_OR")));
            } else {
                this.conjunctionLabel.setText("");
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.editPressed();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            e.consume();
            this.setBackground(backgroundColorDarker);
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.removeLabel.setVisible(true);
            this.removeLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,16"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseExited(MouseEvent e) {
            Point p = (Point)e.getPoint().clone();
            Object source = e.getSource();
            SwingUtilities.convertPointToScreen(p, (JComponent)source);
            SwingUtilities.convertPointFromScreen(p, this.removeLabel);
            if (this.removeLabel.contains(p)) {
                return;
            }
            e.consume();
            this.hideButtons();
            ArrayList arrayList = rowsWithEditButtonsShowing;
            synchronized (arrayList) {
                rowsWithEditButtonsShowing.remove(this);
            }
            this.setBackground(backgroundColor);
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.removeLabel.setVisible(false);
        }

        private void hideButtons() {
        }

        private void removePressed() {
            this.hideButtons();
            ((TriggerGroupPanel)TriggerGroupPanel.this).triggerGroup.triggers.remove(this.trigger);
            TriggerGroupPanel.this.removeRow(this);
            if (CentralDebugging.ALERT_COROLLARY) {
                System.out.println("[AlertCorollary] Removing any corollary for master " + this.trigger.getID() + " (" + this.trigger.getName() + ")");
            }
            TriggerGroupPanel.this.triggersListPanel.removeCorollaryIfExists(this.trigger);
            TriggerGroupPanel.this.notifyChanged();
        }

        private void editPressed() {
            this.hideButtons();
            RootPaneContainer rpc = SwingUtil.getRootPaneContainer((Component)this.getRootPane());
            if (this.trigger.isCorollaryFor().length() > 0 && 0 != SHGlassOptionPane.showChoiceConfirmDialog((RootPaneContainer)rpc, (String)Language.get("ALERT_CRLEDIT_QUESTION"), (String)Language.get("ALERT_CRLEDIT_TITLE"), (Icon)ImageLoader.getImageIcon((String)Icons.ALERTS_DIALOG), (String[])new String[]{Language.get("YES"), Language.get("NO"), Language.get("CANCEL")})) {
                return;
            }
            TriggerPickerDialog dialog = new TriggerPickerDialog(TriggerGroupPanel.this.triggersListPanel.getTechClient(), TriggerGroupPanel.this.triggersListPanel.getMachineTreeModel(), rpc, this.trigger);
            dialog.showDialog();
            if (dialog.isOKResult()) {
                this.trigger.setIsCorollaryFor("");
                int index = ((TriggerGroupPanel)TriggerGroupPanel.this).triggerGroup.triggers.indexOf(this.trigger);
                ((TriggerGroupPanel)TriggerGroupPanel.this).triggerGroup.triggers.remove(index);
                if (CentralDebugging.ALERT_COROLLARY) {
                    System.out.println("[AlertCorollary] Before edit " + this.trigger.getID());
                }
                this.trigger = dialog.getConfiguredAlert();
                if (CentralDebugging.ALERT_COROLLARY) {
                    System.out.println("[AlertCorollary] After edit " + this.trigger.getID());
                }
                ((TriggerGroupPanel)TriggerGroupPanel.this).triggerGroup.triggers.add(index, this.trigger);
                TriggerGroupPanel.this.triggersListPanel.updateCorollaryIfExists(this.trigger);
                this.update();
                TriggerGroupPanel.this.notifyChanged();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.addButton) {
                RootPaneContainer rpc = SwingUtil.getRootPaneContainer((Component)this.getRootPane());
                if (rpc == null) {
                    rpc = SwingUtil.getRootPaneContainer((Component)this.addButton);
                }
                this.hideButtons();
                TriggerPickerDialog dialog = new TriggerPickerDialog(TriggerGroupPanel.this.triggersListPanel.getTechClient(), TriggerGroupPanel.this.triggersListPanel.getMachineTreeModel(), rpc);
                dialog.showDialog();
                if (dialog.isOKResult()) {
                    Alert result = dialog.getConfiguredAlert();
                    if (result.isUsingDefaultName()) {
                        result.setName(result.getDefaultName());
                    } else {
                        result.setUsingDefaultName(false);
                    }
                    if (result != null) {
                        TriggerGroupPanel.this.addThreshold(result);
                        TriggerGroupPanel.this.triggersListPanel.threshholdAdded(TriggerGroupPanel.this.triggerGroup);
                        if (dialog.mustCreatePair()) {
                            Alert corollary = result.createCorollary();
                            if (CentralDebugging.ALERT_COROLLARY) {
                                System.out.println("[AlertCorollary] Created corollary " + corollary.getID() + " for master " + result.getID() + " (" + result.getName() + ")");
                            }
                            corollary.setIsCorollaryFor(result.getID());
                            if (result.isUsingDefaultName()) {
                                corollary.setUsingDefaultName(true);
                                corollary.setName(corollary.getDefaultName());
                            } else {
                                corollary.setUsingDefaultName(false);
                            }
                            TriggerGroupPanel.this.triggersListPanel.corollaryCreated(corollary, TriggerGroupPanel.this.triggerGroup);
                        }
                    }
                    TriggerGroupPanel.this.notifyChanged();
                }
            }
        }

        public boolean isPlaceholder() {
            return this.isPlaceholder;
        }
    }
}

