/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts.alerts;

import com.aem.sgateway.ui.SimpleMachineGroupList;
import com.aem.shelp.common.Language;
import com.aem.shelp.images.Icons;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.alerts.AbstractAlertsDetailsPanel;
import com.aem.shelp.tech.alerts.AlertPanelListener;
import com.aem.shelp.tech.alerts.ResourceContainerGroup;
import com.aem.shelp.tech.alerts.alerts.details.AlertConfigPanel;
import com.aem.shelp.tech.alerts.alerts.details.AlertHistorySubPanel;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import utils.loggingframework.targets.TargetUIListener;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.switches.Switches;

public class AlertDetailsPanel
extends AbstractAlertsDetailsPanel
implements SimpleMachineGroupList.ButtonClickListener,
TargetUIListener {
    private GbPanel infoPanelContainer;
    private AlertConfigPanel infoPanel;
    private NoContentsInfoPanel machinesInfoPanel;
    private GbPanel triggeredMachinesPanel;
    private SimpleMachineGroupList triggeredMachinesGroupList;
    private AlertHistoryPanel historyPanel;
    private JScrollPane infoPanelScrollPane;
    private JToggleButton infoViewButton;
    private JToggleButton historyButton;
    private JToggleButton triggeredMachinesButton;
    private ResourceContainer selectedAlert = null;
    private boolean allowSaving = true;
    private boolean saveQueued = false;

    @Override
    public void setTechClient(TechClient client) {
        super.setTechClient(client);
        this.historyPanel.setTechClient(client);
        this.infoPanel.setTechClient(client);
        this.infoPanel.setMachineTreeModel(this.machineModel);
        boolean canManageAlerts = client.getPermissions().canManageAlerts();
        this.deleteButton.setVisible(canManageAlerts);
        this.saveButton.setVisible(canManageAlerts);
        this.activeButton.setVisible(canManageAlerts);
        this.activeLabel.setVisible(canManageAlerts);
    }

    public AlertDetailsPanel(MachineTreeModel machineModel, AlertPanelListener alertPanelListener) {
        super(machineModel, alertPanelListener);
    }

    @Override
    public void alertModified() {
        this.saveStateToAlert();
        if (this.allowSaving) {
            this.saveQueued = false;
            super.alertModified();
        } else {
            this.saveQueued = true;
        }
    }

    public void alertChanged(LocatedAlert la) {
        if (this.alert != null && la.getID().equals(this.alert.getID())) {
            ((LocatedAlert)this.alert).setAlert(la.getAlert());
            ArrayList<String> triggeredMachines = ((LocatedAlert)this.alert).getTriggeredMachines();
            this.infoPanel.reloadChanges(triggeredMachines);
            this.initTriggeredMachines(triggeredMachines);
        }
    }

    protected void saveStateToAlert() {
        this.infoPanel.saveConfiguredAlert();
    }

    @Override
    protected void initUI() {
        this.infoPanelContainer = new GbPanel();
        this.infoPanel = new AlertConfigPanel(this, this.machineModel);
        this.triggeredMachinesPanel = new GbPanel(new ScaledInsets(0, 0, 0, 0));
        this.triggeredMachinesGroupList = new SimpleMachineGroupList(null, null, null, Language.get("VIEW_MACHINE"), this){

            @Override
            protected Icon getMachineIcon() {
                return ImageLoader.getImageIcon((String)Icons.MACHINE_TRIGGERED);
            }
        };
        this.infoPanelContainer.add((Component)((Object)this.infoPanel), 0, 0, 1, 1, 1, 1, 17, 1);
        this.triggeredMachinesPanel.add((Component)this.triggeredMachinesGroupList.getRootComponent(), 0, 0, 1, 1, 1, 1, 10, 1);
        this.triggeredMachinesGroupList.setScrollPaneBorder(SHBorderFactory.createEmptyBorder());
        this.infoViewButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/general/spanner-dark.svg,16"));
        this.infoViewButton.setToolTipText(Language.get("ALERT_VIEW_TOOLTIP"));
        this.triggeredMachinesButton = new JToggleButton(ImageLoader.getImageIcon((String)Icons.ALERT_TRIGGERED_MACHINES_ON));
        this.triggeredMachinesButton.setToolTipText(Language.get("ALERT_MACHINES_TOOLTIP"));
        this.historyButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/general/clock-simple.svg,16"));
        this.historyButton.setToolTipText(Language.get("ALERT_HISTORY_TOOLTIP"));
        this.infoPanelScrollPane = new JScrollPane((Component)this.infoPanelContainer);
        this.infoPanelScrollPane.setHorizontalScrollBarPolicy(31);
        this.infoPanelScrollPane.setBorder(SHBorderFactory.createEmptyBorder());
        this.infoPanelScrollPane.getVerticalScrollBar().setUnitIncrement(SHStyle.SCROLL_UNIT_INCREMENT);
        this.infoPanelScrollPane.getVerticalScrollBar().setBlockIncrement(SHStyle.SCROLL_BLOCK_INCREMENT);
        this.machinesInfoPanel = new NoContentsInfoPanel(Language.get("ALERTS_NO_MACHINES_TRIGGERED"), null, false);
        this.machinesInfoPanel.setContentsPanel((JComponent)this.triggeredMachinesPanel);
        this.historyPanel = new AlertHistoryPanel();
        super.setViewButtons(new AbstractButton[]{this.infoViewButton, this.historyButton, this.triggeredMachinesButton}, new JComponent[]{this.infoPanelScrollPane, this.historyPanel, this.machinesInfoPanel});
        super.initUI();
    }

    public void setAllowSaving(boolean allowSaving) {
        this.allowSaving = allowSaving;
        if (allowSaving && this.saveQueued) {
            this.alertModified();
        }
    }

    public void switchToAlertConfigTab() {
        this.handleViewSwitch(this.infoViewButton);
    }

    @Override
    protected void initUIForSingleAlert(ResourceContainer alertContainer) {
        super.initUIForSingleAlert(this.alert);
        LocatedAlert alert = (LocatedAlert)alertContainer;
        ArrayList<String> triggeredMachines = alert.getTriggeredMachines();
        this.infoPanel.initInfoPanelWith(alert, triggeredMachines);
        this.initTriggeredMachines(triggeredMachines);
        if (this.historyButton.isSelected() && (this.selectedAlert == null || !this.selectedAlert.getID().equals(alertContainer.getID()))) {
            this.loadHistory();
        }
        this.selectedAlert = alertContainer;
    }

    private void initTriggeredMachines(ArrayList<String> triggeredMachines) {
        ArrayList<String[]> groupsToShow = new ArrayList<String[]>();
        ArrayList<String> machineNames = new ArrayList<String>();
        ArrayList<String> ids = new ArrayList<String>();
        for (String id : triggeredMachines) {
            Machine machine = (Machine)this.machineModel.getElementWithID(id);
            if (machine == null) continue;
            groupsToShow.add(machine.getName().getGroup());
            machineNames.add(machine.getName().getName());
            ids.add(machine.getID());
        }
        this.machinesInfoPanel.setHasContents(triggeredMachines.size() > 0);
        this.triggeredMachinesGroupList.setGroupsToShow(groupsToShow, machineNames, ids);
    }

    @Override
    public void buttonClicked(Object machineID) {
        this.alertPanelListener.showMachineInUI((String)machineID);
    }

    @Override
    public void targetUIComplete() {
    }

    @Override
    public void targetUIIncomplete() {
    }

    @Override
    public void targetChanged() {
        this.alertModified();
    }

    public void groupsChanged(ResourceContainerGroup parentGroup, ResourceContainerGroup[] insertedChildren, int[] insertedIndices) {
    }

    @Override
    protected void notifyViewChange(AbstractButton source, JComponent viewPanel) {
        if (source == this.historyButton) {
            this.loadHistory();
        }
    }

    private void loadHistory() {
        String alertID = this.alert.getID();
        System.out.println("[AlertDetailsPanel] Loading history for " + alertID);
        if (Switches.SH_subAlertHistoryPanel) {
            this.historyPanel.historySubPanel.showAlertHistory(alertID);
        }
    }

    class AlertHistoryPanel
    extends JPanel {
        public AlertHistorySubPanel historySubPanel;

        public AlertHistoryPanel() {
            super(new GridLayout(1, 1));
            this.historySubPanel = new AlertHistorySubPanel(AlertDetailsPanel.this.alertPanelListener);
            this.add(this.historySubPanel.getRootComponent());
        }

        public void setTechClient(TechClient client) {
            this.historySubPanel.setTechClient(client);
        }
    }
}

