/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.alerts;

import com.aem.CentralDebugging;
import com.aem.nodelink.utils.ThreadPool;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.properties.LocalProperties;
import com.aem.shelp.common.properties.TechProperties;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.tech.TechUIInterfaceAPI;
import com.aem.shelp.tech.access.AccessStyle;
import com.aem.shelp.tech.access.contents.ContentsMetrics;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.alerts.AbstractAlertsDetailsPanel;
import com.aem.shelp.tech.alerts.AlertPanelListener;
import com.aem.shelp.tech.alerts.ResourceContainerGroup;
import com.aem.shelp.tech.alerts.alerts.AlertContentsPanel;
import com.aem.shelp.tech.alerts.alerts.AlertDetailsPanel;
import com.aem.shelp.tech.alerts.alerts.AlertHierarchyPanel;
import com.aem.shelp.tech.alerts.alerts.model.AlertModelChangeAdapter;
import com.aem.shelp.tech.alerts.alerts.model.AlertTreeModel;
import com.aem.shelp.tech.alerts.alerts.utils.AlertSelection;
import com.aem.shelp.tech.alerts.events.AlertContentsPanelInterface;
import com.aem.shelp.tech.alerts.events.server.ServerEventsContentsPanel;
import com.aem.shelp.tech.alerts.events.server.ServerEventsDetailsPanel;
import com.aem.shelp.tech.alerts.events.server.ServerEventsHierarchyPanel;
import com.aem.shelp.tech.alerts.events.server.model.ServerEventsTreeModel;
import com.aem.shelp.tech.hierarchy.model.AbstractTreeModel;
import com.aem.shelp.tech.hierarchy.model.TreeNodeFilterProcessor;
import com.aem.shelp.tech.hierarchy.ui.AbstractHierarchyPanel;
import com.aem.shelp.tech.hierarchy.utils.TreeSelection;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import utils.loggingframework.events.EventRepository;
import utils.swing.SwingUtil;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.HierarchyPanel;

public class AlertsPanel
implements AlertPanelListener,
HierarchyPanel.HierarchyResizeListener,
ActionListener {
    private HierarchyPanel rootComponent = new HierarchyPanel(this);
    private AlertHierarchyPanel alertsHierarchyPanel;
    private ServerEventsHierarchyPanel serverEventsHierarchyPanel;
    private ServerEventsTreeModel serverEventsModel;
    private AlertTreeModel alertModel;
    private AlertContentsPanel alertContentsPanel;
    private ServerEventsContentsPanel serverEventsContentsPanel;
    private ServerEventsDetailsPanel serverEventsDetailsPanel;
    private JScrollPane eventsDetailsScrollPane;
    private AlertDetailsPanel alertDetailsPanel;
    private JScrollPane alertDetailsScrollPane;
    private AlertContentsPanelInterface currentContentsPanel;
    private AbstractAlertsDetailsPanel currentDetailsPanel;
    private boolean isBatchSelection = false;
    private TechClient client;
    private TechUIInterfaceAPI techUiInterface;
    private MachineTreeModel machineModel;
    private JToggleButton alertsButton;
    private JToggleButton eventsButton;
    private JButton newGroupButton;
    private JPanel treesPanel;
    private CardLayout treesLayout;
    private AbstractHierarchyPanel<ResourceContainerGroup, ResourceContainer> currentHierarchyPanel;
    private GbPanel buttonsTopPanel;
    SaveXMLThread currentSaveThread = null;
    Object SAVE_LOCK = new Object();
    ThreadPool tp = new ThreadPool("AlertSave", 1, 100, 5);

    public JComponent getRootComponent() {
        return this.rootComponent.getRootComponent();
    }

    public AlertsPanel(AlertTreeModel alertsModel, ServerEventsTreeModel serverEventsModel, MachineTreeModel machineModel, TechUIInterfaceAPI techUiInterface) {
        this.alertModel = alertsModel;
        this.serverEventsModel = serverEventsModel;
        this.machineModel = machineModel;
        this.techUiInterface = techUiInterface;
        this.initUI();
        this.alertModel.addModelChangeListener(new SaveStateListener());
        this.rootComponent.setDetailsPanelMinimumHeight(this.serverEventsDetailsPanel.getButtonBarHeight());
    }

    public AbstractTreeModel<ResourceContainerGroup, ResourceContainer> getModelForCurrentHierarchy() {
        if (this.currentHierarchyPanel == this.alertsHierarchyPanel) {
            return this.alertModel;
        }
        return this.serverEventsModel;
    }

    public void alertChanged(LocatedAlert la) {
        this.alertDetailsPanel.alertChanged(la);
    }

    public void setTechClient(TechClient client) {
        this.client = client;
        this.alertDetailsPanel.setTechClient(client);
        this.serverEventsDetailsPanel.setTechClient(client);
        this.alertContentsPanel.setTechClient(client);
        boolean showButtons = client.getTechUser().getPermissions().canViewAllAlerts() && client.getTechUser().getPermissions().canManageServerEvents();
        this.buttonsTopPanel.setVisible(showButtons);
        this.alertsButton.setVisible(showButtons);
        this.eventsButton.setVisible(showButtons);
        this.treesPanel.removeAll();
        if (client.getTechUser().getPermissions().canViewAllAlerts()) {
            this.treesPanel.add((Component)this.alertsHierarchyPanel.getRootComponent(), "Alerts");
        }
        if (client.getTechUser().getPermissions().canManageServerEvents()) {
            this.treesPanel.add((Component)this.serverEventsHierarchyPanel.getRootComponent(), "Events");
        }
        this.newGroupButton.setVisible(client.getTechUser().getPermissions().canManageAlerts());
        this.alertDetailsPanel.updateUIWithPermissions(client.getPermissions());
        new LoadConfigurationThread().start();
    }

    @Override
    public void saveHierarchyPosition(int unscaledLeft, int unscaledCentre, boolean min, boolean max, boolean isUserResizing) {
        if (CentralDebugging.HIERARCHY_SAVING) {
            System.out.println("[AlertsPanel][HierarchySaving] " + unscaledLeft + "," + unscaledCentre + "," + min + "," + max + "," + isUserResizing);
        }
        LocalProperties.INSTANCE.setPropNoSave(LocalProperties.PROP_ALERT_HIERARCHY, unscaledLeft + "," + unscaledCentre);
        LocalProperties.INSTANCE.setPropAndSaveIn(LocalProperties.PROP_ALERT_MIN_MAX, min + "," + max, 1000);
        TechProperties.INSTANCE.setPropNoSave(TechProperties.DEPRECATED_PROP_ALERT_HIERARCHY, unscaledLeft + "," + unscaledCentre);
        TechProperties.INSTANCE.setPropAndSaveIn(TechProperties.DEPRECATED_PROP_ALERT_MIN_MAX, min + "," + max, 3000);
        if (isUserResizing) {
            this.alertDetailsPanel.userResizing();
        }
    }

    private void loadAndSetHierarchyLayoutSize() {
        String[] sizes;
        String minMax;
        String property;
        String isVisible = TechProperties.INSTANCE.getProp(TechProperties.ALERT_PANEL_DETAILS_VISIBLE);
        if (isVisible != null && !Boolean.parseBoolean(isVisible)) {
            this.setDetailsPanelVisiblity(false);
        }
        if ((property = LocalProperties.INSTANCE.getProp(LocalProperties.PROP_ALERT_HIERARCHY)) == null) {
            property = TechProperties.INSTANCE.getProp(TechProperties.DEPRECATED_PROP_ALERT_HIERARCHY);
        }
        if ((minMax = LocalProperties.INSTANCE.getProp(LocalProperties.PROP_ALERT_MIN_MAX)) == null) {
            minMax = TechProperties.INSTANCE.getProp(TechProperties.DEPRECATED_PROP_ALERT_MIN_MAX);
        }
        System.out.println("[AlertsPanel] Layout sizes are " + property + " [" + minMax + "]");
        if (property != null && (sizes = property.split(",")).length == 2) {
            try {
                int leftSize = Integer.parseInt(sizes[0]);
                int centreSize = Integer.parseInt(sizes[1]);
                this.rootComponent.setDividerLocations(SimpleHelpLookAndFeel.scale((int)leftSize), SimpleHelpLookAndFeel.scale((int)centreSize));
            }
            catch (Throwable t) {
                System.out.println("[AlertsPanel] Unable to load hierarchy size configuration '" + property + "'");
            }
        }
        if (minMax != null && (sizes = minMax.split(",")).length == 2) {
            try {
                boolean min = Boolean.parseBoolean(sizes[0]);
                boolean max = Boolean.parseBoolean(sizes[1]);
                max = false;
                this.alertDetailsPanel.setMinMax(min, max);
            }
            catch (Throwable t) {
                System.out.println("[AlertsPanel] Unable to load hierarchy size configuration '" + property + "'");
            }
        }
    }

    private void initUI() {
        this.alertsHierarchyPanel = new AlertHierarchyPanel(this.alertModel, this);
        this.serverEventsHierarchyPanel = new ServerEventsHierarchyPanel(this.serverEventsModel, this);
        this.alertsHierarchyPanel.showButtonBar(false);
        this.serverEventsHierarchyPanel.showButtonBar(false);
        this.alertContentsPanel = new AlertContentsPanel(this.alertModel, this);
        this.alertModel.addModelChangeListener(this.alertContentsPanel);
        this.serverEventsContentsPanel = new ServerEventsContentsPanel(this.serverEventsModel, this);
        this.serverEventsModel.addModelChangeListener(this.serverEventsContentsPanel);
        this.alertDetailsPanel = new AlertDetailsPanel(this.machineModel, this);
        this.alertDetailsPanel.setModel(this.alertModel);
        this.alertModel.addModelChangeListener(this.alertDetailsPanel);
        this.alertDetailsScrollPane = new JScrollPane(this.alertDetailsPanel.getRootComponent());
        this.alertDetailsScrollPane.setBorder(null);
        this.serverEventsDetailsPanel = new ServerEventsDetailsPanel(this.machineModel, this);
        this.serverEventsDetailsPanel.setModel(this.serverEventsModel);
        this.serverEventsModel.addModelChangeListener(this.serverEventsDetailsPanel);
        this.eventsDetailsScrollPane = new JScrollPane(this.serverEventsDetailsPanel.getRootComponent());
        this.eventsDetailsScrollPane.setBorder(null);
        this.rootComponent.getContentsPanel().setLayout(new GridLayout(1, 1));
        this.rootComponent.getDetailsPanel().setLayout(new GridLayout(1, 1));
        this.rootComponent.getHierarchyPanel().setLayout(new GridLayout(1, 1));
        JPanel hierarchySwitcherPanel = new JPanel(new BorderLayout());
        this.alertsButton = new JToggleButton(Language.get("MONITORING_ALERTS_TAB"));
        this.eventsButton = new JToggleButton(Language.get("EVENT_ALERTS_TAB"));
        this.newGroupButton = new JButton(ImageLoader.getImageIcon((String)"images/svg/general/add.svg,16"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.alertsButton);
        group.add(this.eventsButton);
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((AbstractButton[])new AbstractButton[]{this.alertsButton, this.eventsButton});
        this.alertsButton.addActionListener(this);
        this.eventsButton.addActionListener(this);
        this.newGroupButton.addActionListener(this);
        this.buttonsTopPanel = new GbPanel(new ScaledInsets(2, 3, 2, 5));
        this.buttonsTopPanel.add((Component)this.alertsButton, 0, 0, 1, 1, 1, 1, 13, 0, (Insets)new ScaledInsets(0, 3, 0, 0));
        this.buttonsTopPanel.add((Component)this.eventsButton, 1, 0, 1, 1, 1, 1, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 3));
        this.buttonsTopPanel.add((Component)this.newGroupButton, 2, 0, 1, 1, 0, 1, 13, 0);
        SwingUtil.setSizesToTallest((JComponent[])new JComponent[]{this.alertsButton, this.eventsButton, this.newGroupButton});
        this.buttonsTopPanel.setBackground(SHStyle.PANEL_BACKGROUND_DARK);
        this.buttonsTopPanel.setBorder((Border)SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)AccessStyle.GROUP_TITLE_BORDER_TOP), (Border)SHBorderFactory.createEmptyBorder((int)3, (int)0, (int)3, (int)0)));
        this.treesLayout = new CardLayout();
        this.treesPanel = new JPanel(this.treesLayout);
        this.treesPanel.add((Component)this.alertsHierarchyPanel.getRootComponent(), "Alerts");
        this.treesPanel.add((Component)this.serverEventsHierarchyPanel.getRootComponent(), "Events");
        hierarchySwitcherPanel.add((Component)this.treesPanel, "Center");
        hierarchySwitcherPanel.add((Component)this.buttonsTopPanel, "North");
        this.rootComponent.getHierarchyPanel().add(hierarchySwitcherPanel);
        this.showAlertsPanels();
    }

    private void showAlertsPanels() {
        if (this.currentHierarchyPanel == this.alertsHierarchyPanel) {
            return;
        }
        this.alertsButton.setSelected(true);
        this.eventsButton.setSelected(false);
        this.treesLayout.show(this.treesPanel, "Alerts");
        this.newGroupButton.setToolTipText(this.alertsHierarchyPanel.getAddButtonTooltip());
        this.currentHierarchyPanel = this.alertsHierarchyPanel;
        this.currentContentsPanel = this.alertContentsPanel;
        this.currentDetailsPanel = this.alertDetailsPanel;
        this.rootComponent.getContentsPanel().removeAll();
        this.rootComponent.getDetailsPanel().removeAll();
        this.rootComponent.getContentsPanel().add(this.alertContentsPanel.getRootComponent());
        this.rootComponent.getDetailsPanel().add(this.alertDetailsScrollPane);
        this.rootComponent.getRootComponent().revalidate();
        this.rootComponent.getRootComponent().repaint();
        this.setSelectedGroups((Object)null, new ResourceContainerGroup[]{(ResourceContainerGroup)this.alertModel.getAvailableMachinesGroup()});
    }

    private void showServerEventsPanels() {
        if (this.currentHierarchyPanel == this.serverEventsHierarchyPanel) {
            return;
        }
        this.alertsButton.setSelected(false);
        this.eventsButton.setSelected(true);
        this.treesLayout.show(this.treesPanel, "Events");
        this.newGroupButton.setToolTipText(this.serverEventsHierarchyPanel.getAddButtonTooltip());
        this.currentHierarchyPanel = this.serverEventsHierarchyPanel;
        this.currentContentsPanel = this.serverEventsContentsPanel;
        this.currentDetailsPanel = this.serverEventsDetailsPanel;
        this.rootComponent.getContentsPanel().removeAll();
        this.rootComponent.getDetailsPanel().removeAll();
        this.rootComponent.getContentsPanel().add(this.serverEventsContentsPanel.getRootComponent());
        this.rootComponent.getDetailsPanel().add(this.eventsDetailsScrollPane);
        this.rootComponent.getRootComponent().revalidate();
        this.rootComponent.getRootComponent().repaint();
        this.setSelectedGroups((Object)null, new ResourceContainerGroup[]{(ResourceContainerGroup)this.serverEventsModel.getAvailableMachinesGroup()});
    }

    @Override
    public void setSelectedElements(Object source, TreeSelection<ResourceContainerGroup, ResourceContainer> selection, boolean updateUI) {
        if (this.isBatchSelection) {
            return;
        }
        this.currentContentsPanel.setSelectedAlerts((AlertSelection)selection);
        if (selection == null || selection.getMachineCount() == 0) {
            this.currentDetailsPanel.initUIWithNoSelection();
        } else if (selection.getMachineCount() == 1) {
            this.currentDetailsPanel.setSelectedAlert(selection);
        } else {
            this.currentDetailsPanel.setSelectedAlerts(selection);
        }
    }

    public void setSelectedGroups(Object source, ResourceContainerGroup[] selectedGroups) {
        if (source != this.currentContentsPanel) {
            this.currentContentsPanel.setSelectedGroups(selectedGroups);
        }
        if (source != this.currentHierarchyPanel) {
            this.currentHierarchyPanel.setSelectedGroups(selectedGroups);
        }
        TreeNodeFilterProcessor<ResourceContainerGroup, ResourceContainer> selectedFilterProcessor = null;
        if (selectedGroups.length > 0) {
            selectedFilterProcessor = this.getModelForCurrentHierarchy().getFilterAncestor(selectedGroups[0]);
        }
        this.currentDetailsPanel.setAncestorFilterProcessor(selectedFilterProcessor);
    }

    @Override
    public void setSelectedGroup(Object source, ResourceContainerGroup selectedGroup) {
        if (source != this.currentContentsPanel) {
            this.currentContentsPanel.setSelectedGroup(selectedGroup);
        }
        if (source != this.currentHierarchyPanel) {
            this.currentHierarchyPanel.setSelectedGroup(selectedGroup);
        }
    }

    @Override
    public TechClient getTechClient() {
        return this.client;
    }

    public String saveStateToXML() {
        StringBuffer xml = new StringBuffer();
        this.alertModel.saveToXML(xml);
        return xml.toString();
    }

    @Override
    public void notifyOfContentsStatsChange(ContentsMetrics stats) {
        if (this.currentContentsPanel != null) {
            this.currentContentsPanel.updateUIWithMetrics(stats);
        }
    }

    @Override
    public void setElementName(ResourceContainerGroup parent, ResourceContainer machine, MachineName newAlertName) {
        boolean restoreSelection = this.currentContentsPanel.isAlertSelected(machine);
        this.getModelForCurrentHierarchy().renameElement(parent, machine, newAlertName);
        if (restoreSelection) {
            this.currentContentsPanel.ensureAlertIsSelected(parent, machine);
        }
        this.tp.runAsync(new AlertUpdate(machine));
    }

    public void moveElements(ResourceContainer[] machines, ResourceContainerGroup group) {
        System.out.println("[AlertPanel] Moving " + machines.length + " alerts to " + group);
        String[] newPath = this.alertModel.getGroupPath(group);
        for (ResourceContainer c : machines) {
            c.getName().setGroup(newPath);
        }
        this.tp.runAsync(new AlertUpdate(machines));
    }

    @Override
    public boolean isDetailsPanelVisible() {
        return this.rootComponent.isDetailsPanelVisible();
    }

    @Override
    public void setDetailsPanelVisiblity(boolean isVisible) {
        this.rootComponent.setDetailsPanelVisible(isVisible);
        this.currentContentsPanel.setDetailsPanelIsShowing(isVisible);
        TechProperties.INSTANCE.setPropAndSave(TechProperties.ALERT_PANEL_DETAILS_VISIBLE, Boolean.toString(isVisible));
    }

    @Override
    public void setContentsPanelVisible(boolean visible) {
        this.rootComponent.setContentsPanelVisible(visible);
    }

    @Override
    public void setHierarchyPanelVisible(boolean visible) {
        this.rootComponent.setHierarchyPanelVisible(visible);
    }

    @Override
    public void setBatchSelection(boolean isBatchSelection) {
        this.isBatchSelection = isBatchSelection;
    }

    public void hierarchyResized(int leftSplitLocation, int centreSplitLocation) {
        if (centreSplitLocation > 0) {
            int unscaledLeft = SimpleHelpLookAndFeel.unscale((int)leftSplitLocation);
            int unscaledCentre = SimpleHelpLookAndFeel.unscale((int)centreSplitLocation);
            LocalProperties.INSTANCE.setPropAndSaveIn(LocalProperties.PROP_ALERT_HIERARCHY, unscaledLeft + "," + unscaledCentre, 1000);
            TechProperties.INSTANCE.setPropAndSaveIn(TechProperties.DEPRECATED_PROP_ALERT_HIERARCHY, unscaledLeft + "," + unscaledCentre, 3000);
        }
    }

    @Override
    public void renameSelectedNode(ResourceContainerGroup nodeValue) {
        this.alertsHierarchyPanel.renameSelectedNode(nodeValue);
    }

    @Override
    public void alertDeleted(ResourceContainer la) {
        this.tp.runAsync(new AlertsDelete(new ResourceContainer[]{la}));
    }

    public void alertsDeleted(ResourceContainer[] alerts) {
        this.tp.runAsync(new AlertsDelete(alerts));
    }

    @Override
    public void alertUpdated(ResourceContainer la) {
        this.tp.runAsync(new AlertUpdate(la));
    }

    @Override
    public void alertCreated(ResourceContainer alert) {
        this.client.newAlert(alert);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AlertsPanel.this.alertDetailsPanel.switchToAlertConfigTab();
            }
        });
    }

    @Override
    public void ensureElementSelected(ResourceContainerGroup group, ResourceContainer element) {
        this.currentContentsPanel.ensureAlertIsSelected(group, element);
    }

    @Override
    public void ensureElementSelected(String elementID) {
        ResourceContainerGroup group;
        ResourceContainer rc = (ResourceContainer)this.alertModel.getElementWithID(elementID);
        if (rc != null && (group = (ResourceContainerGroup)this.alertModel.getGroup(rc.getName().getGroup(), false)) != null) {
            this.ensureElementSelected(group, rc);
        }
    }

    @Override
    public void setDetailsPanelState(boolean min, boolean max) {
        this.rootComponent.setDetailsPanelState(min, max, this.alertDetailsPanel.getButtonBarHeight() + 1);
        if (min) {
            this.alertDetailsPanel.setShowOnlyButtonBar(true);
        } else {
            this.alertDetailsPanel.setShowOnlyButtonBar(false);
        }
    }

    @Override
    public void showMachineInUI(String machineID) {
        Machine machine = (Machine)this.machineModel.getElementWithID(machineID);
        this.techUiInterface.showMachine(machine);
    }

    @Override
    public void removeAlerts(final ResourceContainer[] alerts) {
        boolean isOK = SHGlassOptionPane.showOkCancelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this.rootComponent.getRootComponent()), (String)Language.get("ALERT_DELETE_ENTIRE_MSG_ALL"), (String)Language.get("ALERT_DELETE_ENTIRE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/general/trash.svg,48"), (String)Language.get("DELETE"), (String)Language.get("CANCEL"));
        if (!isOK) {
            return;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                AlertsPanel.this.alertModel.removeElements(alerts);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            new Thread(task).start();
        } else {
            task.run();
        }
        this.alertDetailsPanel.initUIWithNoSelection();
        this.alertsDeleted(alerts);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.eventsButton) {
            this.showServerEventsPanels();
        } else if (e.getSource() == this.alertsButton) {
            this.showAlertsPanels();
        } else if (e.getSource() == this.newGroupButton) {
            this.currentHierarchyPanel.addNewGroup();
        }
    }

    class AlertUpdate
    implements Runnable {
        ResourceContainer[] alerts;

        AlertUpdate(ResourceContainer alert) {
            this.alerts = new ResourceContainer[]{alert};
        }

        AlertUpdate(ResourceContainer[] alert) {
            this.alerts = alert;
        }

        @Override
        public void run() {
            AlertsPanel.this.client.updateAlerts(this.alerts);
        }
    }

    class AlertsDelete
    implements Runnable {
        ResourceContainer[] alerts;

        AlertsDelete(ResourceContainer[] alerts) {
            this.alerts = alerts;
        }

        @Override
        public void run() {
            System.out.println("[Alerts] Deleting " + this.alerts.length + " alerts");
            AlertsPanel.this.client.deleteAlerts(this.alerts);
        }
    }

    private class LoadConfigurationThread
    extends Thread {
        private LoadConfigurationThread() {
        }

        @Override
        public void run() {
            String accessPanelConfigXML = TechProperties.INSTANCE.getProp(TechProperties.ALERT_PANEL_CONFIG);
            try {
                AlertsPanel.this.alertModel.loadFromXML(accessPanelConfigXML);
            }
            catch (Throwable t) {
                System.out.println("[AlertPanel] Load of alert panel state failed: " + t.getMessage());
                t.printStackTrace();
            }
            AlertsPanel.this.loadAndSetHierarchyLayoutSize();
            try {
                if (EventRepository.INSTANCE.getEmailTemplateSize() == 0) {
                    AlertsPanel.this.client.getTemplateEmailsForEvents(EventRepository.INSTANCE.getAllEventInstances());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class SaveStateListener
    extends AlertModelChangeAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void filterProcessorChanged() {
            Object object = AlertsPanel.this.SAVE_LOCK;
            synchronized (object) {
                if (AlertsPanel.this.currentSaveThread == null) {
                    AlertsPanel.this.currentSaveThread = new SaveXMLThread();
                }
            }
        }
    }

    class SaveXMLThread
    extends Thread {
        public SaveXMLThread() {
            super("Alert Panel Save Thread");
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            System.out.println("[AlertPanel] Requested state save.");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Object object = AlertsPanel.this.SAVE_LOCK;
            synchronized (object) {
                String xml = AlertsPanel.this.saveStateToXML();
                TechProperties.INSTANCE.setPropAndSave(TechProperties.ALERT_PANEL_CONFIG, xml);
                AlertsPanel.this.currentSaveThread = null;
            }
        }
    }
}

