/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.technicians;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.proxy.types.filters.SimpleMachineFilter;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.admin.subsections.AdminSection;
import com.aem.shelp.tech.utils.MachinePickerTree;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextLayout;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import utils.progtools.SaverUtil;
import utils.swing.SwingUtil;
import utils.swing.components.JSearchTextField;
import utils.swing.components.NoContentsInfoPanel;
import utils.swing.components.SHJTable;
import utils.swing.components.messagefields.MessageFieldHandler;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledFlowLayout;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.renderers.BorderedTableCellRendererWrapper;
import utils.swing.simplelist.EventList;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;
import utils.swing.simplelist.wrapper.SortWrapper;
import utils.swing.simplelist.wrapper.filter.FilterWrapper;

public class MachinePermissionsUI
extends MouseAdapter
implements MessageFieldHandler.FilterListener,
SaverUtil.SaveListener,
ListSelectionListener,
ActionListener {
    private AdminSection.RequestSaveListener saveListener;
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private JPanel topPanel = new JPanel(new BorderLayout());
    private JSearchTextField searchTextField;
    private JButton addTechnician = new JButton(Language.get("ADD_GROUP_PERMISSION"), ImageLoader.getImageIcon((String)"images/svg/general/add.svg,16"));
    private SHJTable groupsTable;
    private SimpleTableModel tableModel;
    private SimpleList<GroupPermissionWrapper> groupPermissionList = new SimpleList();
    private SortWrapper<GroupPermissionWrapper> sortWrapper = new SortWrapper<GroupPermissionWrapper>(this.groupPermissionList, new Comparator<GroupPermissionWrapper>(){

        @Override
        public int compare(GroupPermissionWrapper o1, GroupPermissionWrapper o2) {
            return o1.groupKey.compareTo(o2.groupKey);
        }
    });
    private GroupFilterWrapper filterWrapper = new GroupFilterWrapper(this.sortWrapper);
    private TableCellRenderer groupRenderer;
    private NoContentsInfoPanel noContentsPanel;
    private GbPanel contentsPanel = new GbPanel();
    private JCheckBox groupCanControlSessions = new JCheckBox(Language.get("ADMIN_GROUP_CAN_CONTROL"));
    private JCheckBox groupCanStartSessionsWithControl = new JCheckBox(Language.get("ADMIN_GROUP_START_CONTROL"));
    private JCheckBox groupMustRequestControl = new JCheckBox(Language.get("ADMIN_GROUP_MUST_REQUEST_CONTROL"));
    private JCheckBox groupMustRequestScreen = new JCheckBox(Language.get("ADMIN_GROUP_MUST_REQUEST_SCREEN"));
    private JCheckBox groupMustRequestConnection = new JCheckBox(Language.get("ADMIN_GROUP_MUST_REQUEST_CONNECTION"));
    private JCheckBox groupMustLockScreen = new JCheckBox(Language.get("ADMIN_GROUP_MUST_LOCK_DESKTOP"));
    private JCheckBox groupCanRecord = new JCheckBox(Language.get("ADMIN_GROUP_CAN_RECORD"));
    private JCheckBox groupMustAlwaysUploadRecordings = new JCheckBox(Language.get("ADMIN_GROUP_MUST_UPLOAD"));
    private JCheckBox groupMustAlwaysRecord = new JCheckBox(Language.get("ADMIN_GROUP_MUST_RECORD"));
    private final SaverUtil deferredFilterSetter = new SaverUtil("Technician Table Filter Setter", 500, this, false);
    private String lastFilter;
    private GroupPermissionWrapper selectedWrapper;
    private MachineTreeModel machineTreeModel;
    private TechGroup selectedGroup;

    public MachinePermissionsUI(ActionListener validationListener) {
        this.initUI(validationListener);
    }

    public boolean actionPerformed(TechGroup selectedGroup, ActionEvent e) {
        if (e.getSource() == this.groupCanControlSessions) {
            this.selectedWrapper.permissions.canControlSessions = this.groupCanControlSessions.isSelected();
        } else if (e.getSource() == this.groupCanStartSessionsWithControl) {
            this.selectedWrapper.permissions.canStartWithControlEnabled = this.groupCanStartSessionsWithControl.isSelected();
        } else if (e.getSource() == this.groupMustRequestControl) {
            this.selectedWrapper.permissions.mustRequestControl = this.groupMustRequestControl.isSelected();
        } else if (e.getSource() == this.groupMustRequestScreen) {
            this.selectedWrapper.permissions.mustRequestScreen = this.groupMustRequestScreen.isSelected();
        } else if (e.getSource() == this.groupMustRequestConnection) {
            this.selectedWrapper.permissions.mustRequestConnection = this.groupMustRequestConnection.isSelected();
        } else if (e.getSource() == this.groupMustLockScreen) {
            this.selectedWrapper.permissions.mustLockMachineOnLogout = this.groupMustLockScreen.isSelected();
        } else if (e.getSource() == this.groupCanRecord) {
            this.selectedWrapper.permissions.canRecord = this.groupCanRecord.isSelected();
        } else if (e.getSource() == this.groupMustAlwaysUploadRecordings) {
            this.selectedWrapper.permissions.mustAlwaysUploadRecordings = this.groupMustAlwaysUploadRecordings.isSelected();
        } else if (e.getSource() == this.groupMustAlwaysRecord) {
            this.selectedWrapper.permissions.mustAlwaysRecord = this.groupMustAlwaysRecord.isSelected();
        } else {
            return false;
        }
        return true;
    }

    public void setMachineTreeModel(MachineTreeModel model) {
        this.machineTreeModel = model;
    }

    public JComponent getRootComponent() {
        return this.rootComponent;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SimpleMachineFilter filter = new SimpleMachineFilter();
        MachinePickerTree tree = new MachinePickerTree(filter, true, true);
        tree.showMachines(false);
        tree.setPaintTicks(false);
        tree.setMachineTreeModel(this.machineTreeModel);
        MachinePickerTree machinePickerTree = tree;
        machinePickerTree.getClass();
        MachinePickerTree.MachinePickerDialog mpd = new MachinePickerTree.MachinePickerDialog(machinePickerTree, true);
        mpd.showDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent));
        String[] group = tree.getSelectedGroup();
        if (group != null) {
            final GroupPermissionWrapper wrapper = new GroupPermissionWrapper();
            wrapper.groupKey = MachineName.toGroupString(group);
            this.groupPermissionList.add(wrapper);
            this.selectedGroup.getPermissions().putGroupPermission(group, wrapper.permissions);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int index = MachinePermissionsUI.this.filterWrapper.indexOf(wrapper);
                    if (index >= 0) {
                        MachinePermissionsUI.this.groupsTable.getSelectionModel().setSelectionInterval(index, index);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(TechGroup selectedGroup) {
        this.selectedGroup = selectedGroup;
        HashMap<String, TechGroupPermissions.GroupPermission> groupPermissionMap = selectedGroup.getPermissions().getGroupPermissionMap();
        this.groupPermissionList.startBatch();
        try {
            this.groupPermissionList.clear();
            for (String groupKey : groupPermissionMap.keySet()) {
                TechGroupPermissions.GroupPermission groupPermission = groupPermissionMap.get(groupKey);
                GroupPermissionWrapper wrapper = new GroupPermissionWrapper();
                wrapper.permissions = groupPermission;
                wrapper.groupKey = groupKey;
                this.groupPermissionList.add(wrapper);
            }
        }
        finally {
            this.groupPermissionList.endBatch();
        }
        this.noContentsPanel.setHasContents(false);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        GroupPermissionWrapper groupPermissionWrapper;
        int row;
        int column = this.groupsTable.columnAtPoint(e.getPoint());
        if (column == 1 && (row = this.groupsTable.getSelectedRow()) >= 0 && this.groupPermissionList.remove(groupPermissionWrapper = (GroupPermissionWrapper)this.filterWrapper.get(row))) {
            this.selectedGroup.getPermissions().getGroupPermissionMap().remove(groupPermissionWrapper.groupKey);
            this.saveListener.requestImmediateSave();
        }
    }

    public void setRequestSaveListener(AdminSection.RequestSaveListener listener) {
        this.saveListener = listener;
    }

    private void initUI(ActionListener validationListener) {
        TableStructure ts = TableStructure.createTableStructure(GroupPermissionWrapper.class, new String[]{"", ""}, new String[]{"", ""});
        ts.setMinWidths(SimpleHelpLookAndFeel.scale((int[])new int[]{-1, 24}));
        ts.setMaxWidths(SimpleHelpLookAndFeel.scale((int[])new int[]{-1, 24}));
        this.tableModel = new SimpleTableModel(this.filterWrapper, ts);
        this.groupsTable = new SHJTable();
        this.groupsTable.setRowHeight(SimpleHelpLookAndFeel.scale((int)30));
        this.groupsTable.getSelectionModel().addListSelectionListener(this);
        this.groupsTable.getSelectionModel().setSelectionMode(0);
        this.groupsTable.addMouseListener(this);
        this.tableModel.assignToTable(this.groupsTable);
        GroupTableRenderer renderer = new GroupTableRenderer();
        this.groupsTable.setDefaultRenderer(Object.class, renderer);
        this.groupsTable.setDefaultRenderer(Boolean.class, renderer);
        this.groupRenderer = new BorderedTableCellRendererWrapper(this.groupsTable.getDefaultRenderer(Object.class), SHBorderFactory.createEmptyBorder((int)4, (int)5, (int)4, (int)0));
        this.groupsTable.setDefaultRenderer(Object.class, this.groupRenderer);
        this.groupsTable.setTableHeader(null);
        ts.initTableDimensions(this.groupsTable);
        this.searchTextField = new JSearchTextField(Language.get("SEARCH_TREE_TEXT"));
        this.searchTextField.addIcon(ImageLoader.getImageIcon((String)"images/svg/general/cancel.svg,16"), true, true, "CLEAR");
        this.searchTextField.addIcon(ImageLoader.getImageIcon((String)"images/svg/general/magnifying-glass.svg,16"), false, false, "SEARCH");
        this.searchTextField.setFilterListener(this);
        JScrollPane tableScroller = new JScrollPane(this.groupsTable);
        tableScroller.setBorder(SHBorderFactory.createEmptyBorder());
        JPanel buttons = new JPanel(new BorderLayout());
        buttons.add((Component)this.addTechnician, "East");
        int buffer = 10;
        JPanel paddedPanel = new JPanel(new BorderLayout(SimpleHelpLookAndFeel.scale((int)buffer), 0));
        paddedPanel.setBorder(SHBorderFactory.createEmptyBorder((int)buffer, (int)buffer, (int)buffer, (int)buffer));
        paddedPanel.add((Component)this.searchTextField, "Center");
        paddedPanel.add((Component)buttons, "East");
        this.addTechnician.addActionListener(this);
        this.topPanel.add((Component)paddedPanel, "North");
        this.topPanel.add((Component)tableScroller, "Center");
        tableScroller.setBorder(SHBorderFactory.createMatteBorder((int)1, (int)0, (int)1, (int)0, (Color)SHStyle.BORDER_COLOR));
        SwingUtil.setHeight((JComponent)this.topPanel, (int)300);
        this.noContentsPanel = new NoContentsInfoPanel(Language.get("PERMISSIONS_NO_CONTENTS"), null, false);
        this.noContentsPanel.setContentsPanel((JComponent)this.contentsPanel);
        this.rootComponent.add((Component)this.topPanel, "North");
        this.rootComponent.add((Component)this.noContentsPanel, "Center");
        int Y = 0;
        JLabel titleLabel = new JLabel(Language.get("PERMISSIONS_MACHINE_TITLE"));
        titleLabel.setFont(SHStyle.largeFont);
        JLabel descLabel = new JLabel(Language.get("PERMISSIONS_MACHINE_DESC"));
        descLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.contentsPanel.add((Component)titleLabel, 0, Y++, 1, 1, 1, 0, 10, 1, (Insets)new ScaledInsets(10, 10, 0, 0));
        this.contentsPanel.add((Component)descLabel, 0, Y++, 1, 1, 1, 0, 10, 1, (Insets)new ScaledInsets(5, 10, 10, 0));
        this.groupCanStartSessionsWithControl.addActionListener(validationListener);
        this.groupCanControlSessions.addActionListener(validationListener);
        this.groupMustRequestControl.addActionListener(validationListener);
        this.groupMustRequestScreen.addActionListener(validationListener);
        this.groupMustRequestConnection.addActionListener(validationListener);
        this.groupMustLockScreen.addActionListener(validationListener);
        this.groupMustAlwaysUploadRecordings.addActionListener(validationListener);
        this.groupMustAlwaysRecord.addActionListener(validationListener);
        this.groupCanRecord.addActionListener(validationListener);
        ActionListener enabledActionListeners = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MachinePermissionsUI.this.updateEnabled();
            }
        };
        this.groupCanStartSessionsWithControl.addActionListener(enabledActionListeners);
        this.groupCanControlSessions.addActionListener(enabledActionListeners);
        this.groupMustRequestControl.addActionListener(enabledActionListeners);
        this.groupMustRequestScreen.addActionListener(enabledActionListeners);
        this.groupMustRequestConnection.addActionListener(enabledActionListeners);
        this.groupMustLockScreen.addActionListener(enabledActionListeners);
        this.groupMustAlwaysUploadRecordings.addActionListener(enabledActionListeners);
        this.groupMustAlwaysRecord.addActionListener(enabledActionListeners);
        this.groupCanRecord.addActionListener(enabledActionListeners);
        ScaledInsets insets = new ScaledInsets(5, 30, 0, 0);
        ScaledInsets indented = new ScaledInsets(5, 50, 0, 0);
        this.contentsPanel.add((Component)this.groupMustRequestScreen, 0, Y++, 1, 1, 1, 0, 10, 1, (Insets)insets);
        this.contentsPanel.add((Component)this.groupCanControlSessions, 0, Y++, 1, 1, 1, 0, 10, 1, (Insets)insets);
        this.contentsPanel.add((Component)this.groupCanStartSessionsWithControl, 0, Y++, 1, 1, 1, 0, 10, 1, (Insets)indented);
        this.contentsPanel.add((Component)this.groupMustRequestControl, 0, Y++, 1, 1, 1, 0, 10, 1, (Insets)indented);
        this.contentsPanel.add((Component)new JPanel(), 0, Y++, 1, 1, 1, 0, 10, 1);
        this.contentsPanel.add((Component)this.groupMustRequestConnection, 0, Y++, 1, 1, 1, 0, 10, 1, (Insets)insets);
        this.contentsPanel.add((Component)this.groupMustLockScreen, 0, Y++, 1, 1, 1, 0, 10, 1, (Insets)insets);
        this.contentsPanel.add((Component)new JPanel(), 0, Y++, 1, 1, 1, 0, 10, 1);
        this.contentsPanel.add((Component)this.groupCanRecord, 0, Y++, 1, 1, 1, 0, 10, 1, (Insets)insets);
        this.contentsPanel.add((Component)this.groupMustAlwaysRecord, 0, Y++, 1, 1, 1, 0, 10, 1, (Insets)indented);
        this.contentsPanel.add((Component)this.groupMustAlwaysUploadRecordings, 0, Y++, 1, 1, 1, 0, 10, 1, (Insets)indented);
        this.contentsPanel.add((Component)new JPanel(), 0, Y++, 1, 1, 1, 1, 10, 1);
    }

    public void setFilter(String filter, boolean immediately) {
        this.filterWrapper.setCaseSensitive(false);
        this.lastFilter = filter;
        this.deferredFilterSetter.queueSave();
    }

    @Override
    public void performSave() {
        this.filterWrapper.setFilterText(this.lastFilter);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int row = this.groupsTable.getSelectedRow();
        if (row != -1 && !this.groupPermissionList.isInBatchMode()) {
            GroupPermissionWrapper groupPermissionWrapper = (GroupPermissionWrapper)this.filterWrapper.get(row);
            this.setSelectedWrapper(groupPermissionWrapper);
            this.noContentsPanel.setHasContents(true);
        }
    }

    private void setSelectedWrapper(GroupPermissionWrapper groupPermissionWrapper) {
        this.selectedWrapper = groupPermissionWrapper;
        this.groupCanStartSessionsWithControl.setSelected(this.selectedWrapper.permissions.canStartWithControlEnabled);
        this.groupCanControlSessions.setSelected(this.selectedWrapper.permissions.canControlSessions);
        this.groupMustRequestControl.setSelected(this.selectedWrapper.permissions.mustRequestControl);
        this.groupMustRequestScreen.setSelected(this.selectedWrapper.permissions.mustRequestScreen);
        this.groupMustRequestConnection.setSelected(this.selectedWrapper.permissions.mustRequestConnection);
        this.groupMustLockScreen.setSelected(this.selectedWrapper.permissions.mustLockMachineOnLogout);
        this.groupCanRecord.setSelected(this.selectedWrapper.permissions.canRecord);
        this.groupMustAlwaysRecord.setSelected(this.selectedWrapper.permissions.mustAlwaysRecord);
        this.groupMustAlwaysUploadRecordings.setSelected(this.selectedWrapper.permissions.mustAlwaysUploadRecordings);
        this.updateEnabled();
    }

    private void updateEnabled() {
        this.groupCanStartSessionsWithControl.setEnabled(this.groupCanControlSessions.isSelected());
        this.groupMustRequestControl.setEnabled(this.groupCanControlSessions.isSelected());
        this.groupMustAlwaysRecord.setEnabled(this.groupCanRecord.isSelected());
        this.groupMustAlwaysUploadRecordings.setEnabled(this.groupCanRecord.isSelected());
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        MachinePermissionsUI ui = new MachinePermissionsUI(null);
        frame.getContentPane().add(ui.rootComponent);
        for (int i = 0; i < 10; ++i) {
            GroupPermissionWrapper wrapper = new GroupPermissionWrapper();
            wrapper.groupKey = "Group " + i + "/Group 2";
            wrapper.permissions = new TechGroupPermissions.GroupPermission();
            ui.groupPermissionList.add(wrapper);
        }
        frame.setVisible(true);
    }

    class GroupFilterWrapper
    extends FilterWrapper<GroupPermissionWrapper> {
        public GroupFilterWrapper(EventList<GroupPermissionWrapper> list) {
            super(list);
        }
    }

    static class GroupPermissionWrapper {
        String groupKey;
        TechGroupPermissions.GroupPermission permissions = new TechGroupPermissions.GroupPermission();

        GroupPermissionWrapper() {
        }
    }

    class GroupTableRenderer
    extends DefaultTableCellRenderer {
        GroupsPanel panel = new GroupsPanel();

        GroupTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            switch (column) {
                case 0: {
                    String groupKey = ((GroupPermissionWrapper)value).groupKey;
                    String[] groups = MachineName.parseGroups(groupKey);
                    this.panel.setBackground(label.getBackground());
                    this.panel.setTechGroups(groups);
                    this.panel.setForeground(label.getForeground());
                    return this.panel;
                }
                case 1: {
                    if (isSelected) {
                        label.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,16"));
                    } else {
                        label.setIcon(ImageLoader.getImageIconDisabled((String)"images/svg/general/remove.svg,16"));
                    }
                    label.setText(null);
                }
            }
            return label;
        }
    }

    public static class GroupsPanel
    extends JPanel {
        private String[] groups;

        public GroupsPanel() {
            super((LayoutManager)new ScaledFlowLayout(0, SimpleHelpLookAndFeel.scale((int)5), 0));
        }

        public void setTechGroups(String[] groups) {
            this.groups = groups;
        }

        @Override
        public void paintComponent(Graphics g) {
            int smallerPadding;
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.setColor(super.getForeground());
            super.paintComponent(g);
            Icon groupIcon = ImageLoader.getImageIcon((String)"images/svg/general/machine-group.svg,16");
            Icon rightArrow = ImageLoader.getImageIcon((String)"images/svg/arrows/blue-right.svg,10");
            int iconGroupY = (this.getHeight() - groupIcon.getIconHeight()) / 2;
            int arrowY = (this.getHeight() - rightArrow.getIconHeight()) / 2;
            int padding = SimpleHelpLookAndFeel.scale((int)10);
            int x = smallerPadding = SimpleHelpLookAndFeel.scale((int)5);
            for (int i = 0; i < this.groups.length; ++i) {
                String group = this.groups[i];
                if (i > 0) {
                    rightArrow.paintIcon(this, g, x, arrowY);
                    x += rightArrow.getIconWidth() + padding;
                }
                groupIcon.paintIcon(this, g, x, iconGroupY);
                g.setFont(super.getFont());
                TextLayout tl = new TextLayout(group, g.getFont(), g.getFontMetrics().getFontRenderContext());
                tl.draw(g2d, x += groupIcon.getIconWidth() + smallerPadding, ((float)this.getHeight() + tl.getAscent()) / 2.0f);
                x = (int)((double)x + (tl.getBounds().getWidth() + (double)padding));
            }
        }
    }
}

