/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.technicians;

import com.aem.shelp.common.Language;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.TechGroupPermissions;
import com.aem.shelp.proxy.config.TechGroup;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.access.model.machine.MachineTreeModel;
import com.aem.shelp.tech.admin.subsections.AdminSection;
import com.aem.shelp.tech.admin.subsections.technicians.AdminGroups;
import com.aem.shelp.tech.admin.subsections.technicians.MachinePermissionsUI;
import com.aem.shelp.util.swing.RequestAccessTimeoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import utils.swing.SwingUtil;
import utils.swing.components.JSearchTextField;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;

public class GroupPermissionsUI
implements ActionListener {
    private JPanel rootComponent = new JPanel(new BorderLayout());
    private GbPanel generalPermissionsPanel = new GbPanel();
    private JPanel machineSpecificPermissionsPanel = new JPanel(new GridLayout());
    private MachinePermissionsUI machinePermissionsUI;
    private AdminGroups.ValidationListener validationListener;
    private TechClient techClient;
    private ArrayList<PermissionsRow> rows;
    private AdminSection.RequestSaveListener saveListener;
    private JComboBox permissionsChoiceBox = new JComboBox<String>(new String[]{Language.get("PERMISSIONS_GENERAL"), Language.get("PERMISSIONS_MACHINE")});
    private JPanel adminContainer = new JPanel();
    private JPanel connectTypeContainer = new JPanel();
    private JPanel controlContainer = new JPanel();
    private JPanel terminateContainer = new JPanel();
    private JPanel installContainer = new JPanel();
    private JPanel recordContainer = new JPanel();
    private JPanel sessionContainer = new JPanel();
    private JPanel endSessionContainer = new JPanel();
    private JPanel historyContainer = new JPanel();
    private JPanel monitoringContainer = new JPanel();
    private JPanel toolsContainer = new JPanel();
    private JPanel alertsContainer = new JPanel();
    private JPanel networkContainer = new JPanel();
    private JCheckBox administratorBox;
    private JCheckBox groupAllowSH;
    private JCheckBox groupAllowSG;
    private JCheckBox groupAllowPresent;
    private JCheckBox groupCanAppTunnels;
    private JCheckBox groupCanControlSessions;
    private JCheckBox groupStartSessionsWithControl;
    private JCheckBox groupMustRequestControl;
    private JCheckBox groupMustRequestScreen;
    private JCheckBox groupMustRequestConnection;
    private RequestAccessTimeoutPanel timeoutPanel;
    private JCheckBox groupAllowInstallPersistent;
    private JCheckBox groupAllowManageServices;
    private JCheckBox groupCanRemoveCustomers;
    private JCheckBox groupCanViewOtherConnectedSessions;
    private JCheckBox groupCanTerminateSessions;
    private JCheckBox groupCanPortForward;
    private JCheckBox groupCanFileTransfer;
    private JCheckBox groupCanDiagnostics;
    private JCheckBox groupCanChat;
    private JCheckBox groupCanCaptureAudio;
    private JCheckBox groupCanEchoText;
    private JCheckBox groupMustLock;
    private JCheckBox canRecord;
    private JCheckBox canUpload;
    private JCheckBox groupCanManageRecordings;
    private JCheckBox groupMustAlwaysUploadRecordings;
    private JCheckBox groupMustAlwaysRecord;
    private JLabel groupDefaultRecordingPasswordLabel;
    private JSearchTextField groupDefaultRecordingPasswordField;
    private JCheckBox canManageMonitoring;
    private JCheckBox canViewMonitoring;
    private JCheckBox canViewScreenshots;
    private JCheckBox canViewMetrics;
    private JCheckBox canCopyFiles;
    private JCheckBox canRunToolsInAccess;
    private JCheckBox canRunToolsInSessions;
    private JCheckBox canManageAlerts;
    private JCheckBox canManageServerEvents;
    private JCheckBox canViewAllAlerts;
    private JCheckBox canViewOwnHistory;
    private JCheckBox canViewGroupHistory;
    private JCheckBox canViewAllHistory;
    private JCheckBox canUseUDP;
    private JComboBox sessionTypeBox = new JComboBox<String>(new String[]{Language.get("TRANSPORT_ANY"), Language.get("TCP"), Language.get("SESSION_UDP_VIA_SERVER"), Language.get("SESSION_UDP_DIRECT")});
    private JButton switchAll;

    public JPanel getRootComponent() {
        return this.rootComponent;
    }

    public GroupPermissionsUI(AdminGroups.ValidationListener validationListener) {
        this.validationListener = validationListener;
        this.initUI();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updatePermissionsSelection();
    }

    private void updatePermissionsSelection() {
        this.rootComponent.remove((Component)this.generalPermissionsPanel);
        this.rootComponent.remove(this.machineSpecificPermissionsPanel);
        if (this.permissionsChoiceBox.getSelectedIndex() == 0) {
            this.rootComponent.add((Component)this.generalPermissionsPanel, "Center");
        } else {
            this.rootComponent.add((Component)this.machineSpecificPermissionsPanel, "Center");
        }
        this.rootComponent.revalidate();
        this.rootComponent.repaint();
    }

    public void setMachineTreeModel(MachineTreeModel model) {
        this.machinePermissionsUI.setMachineTreeModel(model);
    }

    public void setRequestSaveListener(AdminSection.RequestSaveListener listener) {
        this.saveListener = listener;
        this.machinePermissionsUI.setRequestSaveListener(listener);
    }

    private void initUI() {
        this.machinePermissionsUI = new MachinePermissionsUI(this.validationListener);
        this.machineSpecificPermissionsPanel.add(this.machinePermissionsUI.getRootComponent());
        this.permissionsChoiceBox.addActionListener(this);
        JPanel borderedPanel = new JPanel(new GridLayout(1, 1));
        borderedPanel.add(this.permissionsChoiceBox);
        borderedPanel.setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)10, (int)10, (int)10));
        this.rootComponent.add((Component)borderedPanel, "North");
        this.permissionsChoiceBox.setSelectedIndex(0);
        this.updatePermissionsSelection();
        this.canRecord = new JCheckBox(Language.get("ADMIN_GROUP_CAN_RECORD"));
        this.canUpload = new JCheckBox(Language.get("ADMIN_GROUP_CAN_UPLOAD"));
        this.groupAllowInstallPersistent = new JCheckBox(Language.get("ADMIN_GROUP_INSTALL_PERSISTENT"));
        this.groupAllowManageServices = new JCheckBox(Language.get("ADMIN_GROUP_MANAGE_PERSISTENT"));
        this.groupCanManageRecordings = new JCheckBox(Language.get("ADMIN_GROUP_MANAGE_RECORDINGS"));
        this.groupMustAlwaysUploadRecordings = new JCheckBox(Language.get("ADMIN_GROUP_MUST_UPLOAD"));
        this.groupMustAlwaysRecord = new JCheckBox(Language.get("ADMIN_GROUP_MUST_RECORD"));
        this.groupDefaultRecordingPasswordLabel = new JLabel(Language.get("ADMIN_GROUP_RECORD_PASSWORD"));
        this.groupDefaultRecordingPasswordField = new JSearchTextField(Language.get("ADMIN_GROUP_RECORD_PASSWORD_NONE"));
        SwingUtil.setWidth((JComponent)this.groupDefaultRecordingPasswordField, (int)SimpleHelpLookAndFeel.scale((int)200));
        this.administratorBox = new JCheckBox(Language.get("ADMIN_GROUP_ADMIN"));
        this.groupAllowSH = new JCheckBox(Language.get("ADMIN_GROUP_SEE_SH"));
        this.groupAllowSG = new JCheckBox(Language.get("ADMIN_GROUP_SEE_SG"));
        this.groupAllowPresent = new JCheckBox(Language.get("ADMIN_GROUP_CAN_PRESENT"));
        this.groupCanViewOtherConnectedSessions = new JCheckBox(Language.get("ADMIN_GROUP_CAN_VIEW_CONNECTED"));
        this.groupCanTerminateSessions = new JCheckBox(Language.get("ADMIN_GROUP_CAN_TERMINATE"));
        this.groupCanRemoveCustomers = new JCheckBox(Language.get("ADMIN_GROUP_CAN_REMOVE"));
        this.groupCanPortForward = new JCheckBox(Language.get("ADMIN_GROUP_CAN_PORT_FORWARD"));
        this.groupCanFileTransfer = new JCheckBox(Language.get("ADMIN_GROUP_CAN_FILE_TRANSFER"));
        this.groupCanDiagnostics = new JCheckBox(Language.get("ADMIN_GROUP_CAN_DIAGNOSTICS"));
        this.groupCanChat = new JCheckBox(Language.get("GROUP_ACCESS_ALLOW_CHAT"));
        this.groupCanAppTunnels = new JCheckBox(Language.get("ADMIN_GROUP_CAN_APP_TUNNEL"));
        this.groupCanCaptureAudio = new JCheckBox(Language.get("ADMIN_GROUP_CAN_CAPTURE_AUDIO"));
        this.groupCanEchoText = new JCheckBox(Language.get("ALLOW_TECH_ECHOING"));
        this.groupCanControlSessions = new JCheckBox(Language.get("ADMIN_GROUP_CAN_CONTROL"));
        this.groupStartSessionsWithControl = new JCheckBox(Language.get("ADMIN_GROUP_START_CONTROL"));
        this.groupMustRequestControl = new JCheckBox(Language.get("ADMIN_GROUP_MUST_REQUEST_CONTROL"));
        this.groupMustRequestScreen = new JCheckBox(Language.get("ADMIN_GROUP_MUST_REQUEST_SCREEN"));
        this.groupMustRequestConnection = new JCheckBox(Language.get("ADMIN_GROUP_MUST_REQUEST_CONNECTION"));
        this.timeoutPanel = new RequestAccessTimeoutPanel();
        this.timeoutPanel.getRootComponent().setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)20, (int)0, (int)0));
        this.groupMustLock = new JCheckBox(Language.get("ADMIN_GROUP_MUST_LOCK_DESKTOP"));
        this.canViewOwnHistory = new JCheckBox(Language.get("ADMIN_GROUP_VIEW_OWN_HISTORY"));
        this.canViewGroupHistory = new JCheckBox(Language.get("ADMIN_GROUP_VIEW_GROUP_HISTORY"));
        this.canViewAllHistory = new JCheckBox(Language.get("ADMIN_GROUP_VIEW_ALL_HISTORY"));
        this.canManageMonitoring = new JCheckBox(Language.get("ADMIN_GROUP_MANAGE_MONITORING"));
        this.canViewMonitoring = new JCheckBox(Language.get("ADMIN_GROUP_VIEW_MONITORING"));
        this.canViewScreenshots = new JCheckBox(Language.get("ADMIN_GROUP_VIEW_SCREENSHOTS"));
        this.canViewMetrics = new JCheckBox(Language.get("ADMIN_GROUP_VIEW_METRICS"));
        this.canCopyFiles = new JCheckBox(Language.get("ADMIN_GROUP_COPY_MONITORING"));
        this.canRunToolsInAccess = new JCheckBox(Language.get("ADMIN_GROUP_TOOLS_ACCESS"));
        this.canRunToolsInSessions = new JCheckBox(Language.get("ADMIN_GROUP_TOOLS_SESSION"));
        this.canManageAlerts = new JCheckBox(Language.get("ADMIN_GROUP_MANAGE_ALERTS"));
        this.canManageServerEvents = new JCheckBox(Language.get("ADMIN_GROUP_MANAGE_SERVER_EVENTS"));
        this.canViewAllAlerts = new JCheckBox(Language.get("ADMIN_GROUP_VIEW_ALL_ALERTS"));
        this.canUseUDP = new JCheckBox(Language.get("ALLOW_UDP"));
        GbPanel sessionsPanel = new GbPanel(new ScaledInsets(3, 0, 3, 3));
        sessionsPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)20, (int)0, (int)0));
        int Y = 0;
        sessionsPanel.add((Component)new JLabel(Language.get("ADMIN_GROUP_PREFERRED_SESSION")), 0, Y, 1, 1, 0, 0, 17, 2);
        sessionsPanel.add((Component)this.sessionTypeBox, 1, Y++, 2, 1, 0, 0, 17, 0);
        this.switchAll = new JButton(Language.get("ADMIN_GROUP_SWITCH_SESSIONS"));
        sessionsPanel.add((Component)this.switchAll, 1, Y++, 1, 1, 0, 0, 17, 0);
        this.rows = new ArrayList();
        this.rows.add(new PermissionsRow(Language.get("ADMIN_GROUP_ADMIN_TITLE"), Language.get("ADMIN_GROUP_ADMIN_DESC"), new JComponent[]{this.administratorBox}, this.adminContainer));
        if (OemBranding.OEM_IS_SH) {
            this.rows.add(new PermissionsRow(Language.get("ADMIN_GROUP_SEE_TITLE"), Language.get("ADMIN_GROUP_SEE_DESC"), new JComponent[]{this.groupAllowSH, this.groupAllowSG, this.groupAllowPresent, this.groupCanAppTunnels}, this.connectTypeContainer));
        } else {
            this.rows.add(new PermissionsRow(Language.get("ADMIN_GROUP_SEE_TITLE"), Language.get("ADMIN_GROUP_SEE_DESC"), new JComponent[]{this.groupAllowSH, this.groupAllowSG}, this.connectTypeContainer));
        }
        this.rows.add(new PermissionsRow(Language.get("ADMIN_GROUP_CONTROL_TITLE"), Language.get("ADMIN_GROUP_CONTROL_DESC"), new JComponent[]{this.groupCanControlSessions, this.groupStartSessionsWithControl, this.groupMustRequestControl, this.groupMustRequestScreen, new JLabel(" "), this.groupMustRequestConnection, this.timeoutPanel.getRootComponent()}, this.controlContainer));
        this.rows.add(new PermissionsRow(Language.get("ADMIN_GROUP_TERMINATE_TITLE"), Language.get("ADMIN_GROUP_TERMINATE_DESC"), new JComponent[]{this.groupCanRemoveCustomers, this.groupCanViewOtherConnectedSessions, this.groupCanTerminateSessions}, this.terminateContainer));
        this.rows.add(new PermissionsRow(Language.get("ADMIN_GROUP_INSTALL_TITLE"), Language.get("ADMIN_GROUP_INSTALL_DESC2"), new JComponent[]{this.groupAllowInstallPersistent, this.groupAllowManageServices}, this.installContainer));
        JPanel recordingPanel = new JPanel(new BorderLayout(5, 5));
        recordingPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)20, (int)0, (int)0));
        recordingPanel.add((Component)this.groupDefaultRecordingPasswordLabel, "West");
        recordingPanel.add((Component)this.groupDefaultRecordingPasswordField, "Center");
        this.rows.add(new PermissionsRow(Language.get("ADMIN_GROUP_RECORD_TITLE"), Language.get("ADMIN_GROUP_RECORD_DESC"), new JComponent[]{this.canRecord, this.canUpload, this.groupCanManageRecordings, this.groupMustAlwaysRecord, this.groupMustAlwaysUploadRecordings, recordingPanel}, this.recordContainer));
        this.rows.add(new PermissionsRow(Language.get("ADMIN_GROUP_SESSION_TITLE"), Language.get("ADMIN_GROUP_SESSION_DESC"), new JComponent[]{this.groupCanPortForward, this.groupCanFileTransfer, this.groupCanDiagnostics, this.groupCanChat, this.groupCanCaptureAudio, this.groupCanEchoText}, this.sessionContainer));
        this.rows.add(new PermissionsRow(Language.get("ADMIN_GROUP_END_OF_SESSION_TITLE"), Language.get("ADMIN_GROUP_END_OF_SESSION_DESC"), new JComponent[]{this.groupMustLock}, this.endSessionContainer));
        this.rows.add(new PermissionsRow(Language.get("ADMIN_GROUP_HISTORY_TITLE"), Language.get("ADMIN_GROUP_HISTORY_DESC"), new JComponent[]{this.canViewOwnHistory, this.canViewGroupHistory, this.canViewAllHistory}, this.historyContainer));
        this.rows.add(new PermissionsRow(Language.get("ADMIN_GROUP_MONITORING_TITLE"), Language.get("ADMIN_GROUP_MONITORING_DESC"), new JComponent[]{this.canManageMonitoring, this.canViewMonitoring, this.canViewScreenshots, this.canViewMetrics, this.canCopyFiles}, this.monitoringContainer));
        this.rows.add(new PermissionsRow(Language.get("ADMIN_GROUP_TOOLS_TITLE"), Language.get("ADMIN_GROUP_TOOLS_DESC"), new JComponent[]{this.canRunToolsInAccess, this.canRunToolsInSessions}, this.toolsContainer));
        this.rows.add(new PermissionsRow(Language.get("ADMIN_GROUP_ALERTS_TITLE"), Language.get("ADMIN_GROUP_ALERTS_DESC"), new JComponent[]{this.canManageAlerts, this.canManageServerEvents, this.canViewAllAlerts}, this.alertsContainer));
        this.rows.add(new PermissionsRow(Language.get("TECH_SESSION_TITLE"), Language.get("ADMIN_GROUP_NETWORK_DESC"), new JComponent[]{this.canUseUDP, sessionsPanel}, this.networkContainer));
        this.groupDefaultRecordingPasswordField.addKeyListener(this.validationListener);
        this.timeoutPanel.addActionListener(this.validationListener);
        this.sessionTypeBox.addActionListener(this.validationListener);
        this.switchAll.addActionListener(this.validationListener);
        this.buildUI(this.rows);
    }

    private void buildUI(ArrayList<PermissionsRow> rows) {
        int Y = 0;
        for (PermissionsRow row : rows) {
            row.descLabel = (JLabel)new JWrapLabel("<html>" + row.description);
            row.descLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
            row.titleLabel = new JLabel(row.title);
            row.titleLabel.setFont(SHStyle.mediumFont);
            this.generalPermissionsPanel.add((Component)row.titleLabel, 0, Y++, 2, 1, 0, 0, 18, 3, (Insets)new ScaledInsets(5, 15, 0, 0));
            int numberOfComponents = row.permissionComponents.length;
            for (int i = 0; i < numberOfComponents; ++i) {
                JComponent component = row.permissionComponents[i];
                if (component instanceof AbstractButton) {
                    component.setBorder(SHBorderFactory.createEmptyBorder());
                    ((AbstractButton)component).addActionListener(this.validationListener);
                    ((AbstractButton)component).setVerticalAlignment(1);
                } else if (component instanceof JComboBox) {
                    ((JComboBox)component).addActionListener(this.validationListener);
                }
                ScaledInsets insets = new ScaledInsets(5, 30, 0, 0);
                if (i == numberOfComponents - 1) {
                    insets = new ScaledInsets(5, 30, 30, 0);
                }
                this.generalPermissionsPanel.add((Component)row.permissionComponents[i], 0, Y, 1, 1, 0, 0, 18, 3, (Insets)insets);
                if (i == 0 && row.description != null) {
                    this.generalPermissionsPanel.add((Component)row.descLabel, 1, Y, 1, numberOfComponents, 100, 0, 18, 2, (Insets)insets);
                }
                ++Y;
            }
        }
    }

    public void load(TechGroup selectedGroup) {
        try {
            if (this.saveListener != null) {
                this.saveListener.disableSaves();
            }
            TechGroupPermissions permissions = selectedGroup.getPermissions();
            this.groupAllowInstallPersistent.setSelected(permissions.canInstallPersistentConnection());
            this.groupAllowManageServices.setSelected(permissions.canManagePersistentConnections());
            this.groupAllowSG.setSelected(permissions.canRemoteAccess());
            this.groupAllowSH.setSelected(permissions.canRemoteSupport());
            this.administratorBox.setSelected(permissions.canAdminServer());
            this.groupAllowPresent.setSelected(permissions.canPresent());
            this.groupCanViewOtherConnectedSessions.setSelected(permissions.canViewOtherConnectedSessions());
            this.groupCanTerminateSessions.setSelected(permissions.canTerminateOtherUsersSessions());
            this.groupCanRemoveCustomers.setSelected(permissions.canRemoveCustomersFromQueue());
            this.groupCanManageRecordings.setSelected(permissions.canManageRecordings());
            this.groupMustAlwaysUploadRecordings.setSelected(permissions.mustAlwaysUpload());
            this.groupDefaultRecordingPasswordField.setText(selectedGroup.getDefaultVideoPassword());
            this.groupMustAlwaysRecord.setSelected(permissions.mustAlwaysRecord());
            this.groupCanPortForward.setSelected(permissions.canUsePortForwarding());
            this.groupCanFileTransfer.setSelected(permissions.canUseFileTransfer());
            this.groupCanDiagnostics.setSelected(permissions.canUseDiagnostics());
            this.groupCanChat.setSelected(permissions.canUseChat());
            this.groupCanAppTunnels.setSelected(permissions.canUseAppTunnels());
            this.groupCanCaptureAudio.setSelected(permissions.canCaptureAudio());
            this.groupCanEchoText.setSelected(permissions.canEchoText());
            this.groupCanControlSessions.setSelected(permissions.canControlSessions());
            this.groupStartSessionsWithControl.setSelected(permissions.canStartSessionsWithControl());
            this.groupMustRequestControl.setSelected(permissions.mustRequestControl());
            this.groupMustRequestScreen.setSelected(permissions.mustRequestScreen());
            this.groupMustRequestConnection.setSelected(permissions.mustRequestConnection());
            this.timeoutPanel.setTimeout(selectedGroup.getRequestAccessTimeout());
            this.groupMustLock.setSelected(permissions.mustLockMachineOnLogout());
            this.canUpload.setSelected(permissions.canUpload());
            this.canRecord.setSelected(permissions.canRecord());
            this.canViewOwnHistory.setSelected(permissions.canViewOwnHistory());
            this.canViewGroupHistory.setSelected(permissions.canViewGroupHistory());
            this.canViewAllHistory.setSelected(permissions.canViewAllHistory());
            this.canManageMonitoring.setSelected(permissions.canManageMonitoring());
            this.canViewMonitoring.setSelected(permissions.canViewMonitoring());
            this.canViewScreenshots.setSelected(permissions.canViewScreenshots());
            this.canViewMetrics.setSelected(permissions.canViewMetrics());
            this.canCopyFiles.setSelected(permissions.canCopyFiles());
            this.canRunToolsInAccess.setSelected(permissions.canRunTools());
            this.canRunToolsInSessions.setSelected(permissions.canRunToolsInSessions());
            this.canManageAlerts.setSelected(permissions.canManageAlerts());
            this.canManageServerEvents.setSelected(permissions.canManageServerEvents());
            this.canViewAllAlerts.setSelected(permissions.canViewAllAlerts());
            this.canUseUDP.setSelected(permissions.canUseUDP());
            if (permissions.canUseAnyNetworkConnection()) {
                this.sessionTypeBox.setSelectedIndex(0);
            } else if (permissions.mustUseTCP()) {
                this.sessionTypeBox.setSelectedIndex(1);
            } else if (permissions.mustUseUDP()) {
                this.sessionTypeBox.setSelectedIndex(2);
            } else if (permissions.mustUseUDPDirect()) {
                this.sessionTypeBox.setSelectedIndex(3);
            }
            this.machinePermissionsUI.load(selectedGroup);
        }
        finally {
            if (this.saveListener != null) {
                this.saveListener.enableSaves();
            }
        }
    }

    public void checkEnabled(TechGroup selectedGroup) {
        this.groupAllowSG.setEnabled(selectedGroup != null);
        this.groupAllowSH.setEnabled(selectedGroup != null);
        this.administratorBox.setEnabled(selectedGroup != null);
        this.groupCanViewOtherConnectedSessions.setEnabled(selectedGroup != null);
        this.groupCanTerminateSessions.setEnabled(selectedGroup != null && this.groupCanViewOtherConnectedSessions.isSelected());
        this.groupCanRemoveCustomers.setEnabled(selectedGroup != null);
        this.groupCanPortForward.setEnabled(selectedGroup != null);
        this.groupCanFileTransfer.setEnabled(selectedGroup != null);
        this.groupCanDiagnostics.setEnabled(selectedGroup != null);
        this.groupCanChat.setEnabled(selectedGroup != null);
        this.groupCanAppTunnels.setEnabled(selectedGroup != null);
        this.groupCanCaptureAudio.setEnabled(selectedGroup != null);
        this.groupCanEchoText.setEnabled(selectedGroup != null);
        this.groupMustLock.setEnabled(selectedGroup != null);
        this.groupCanControlSessions.setEnabled(selectedGroup != null);
        this.groupMustRequestControl.setEnabled(selectedGroup != null && this.groupCanControlSessions.isSelected());
        this.groupStartSessionsWithControl.setEnabled(selectedGroup != null && this.groupCanControlSessions.isSelected() && !this.groupMustRequestControl.isSelected());
        this.groupMustRequestScreen.setEnabled(selectedGroup != null);
        this.groupMustRequestConnection.setEnabled(selectedGroup != null);
        this.timeoutPanel.setEnabled(selectedGroup != null && this.groupMustRequestConnection.isSelected());
        this.groupAllowPresent.setEnabled(selectedGroup != null);
        this.groupAllowInstallPersistent.setEnabled(selectedGroup != null);
        this.groupAllowManageServices.setEnabled(selectedGroup != null);
        this.canRecord.setEnabled(selectedGroup != null);
        this.canUpload.setEnabled(selectedGroup != null && this.canRecord.isSelected());
        this.groupCanManageRecordings.setEnabled(selectedGroup != null && this.canRecord.isSelected());
        this.groupDefaultRecordingPasswordField.setEnabled(selectedGroup != null && this.canRecord.isSelected());
        this.groupMustAlwaysUploadRecordings.setEnabled(selectedGroup != null);
        this.groupMustAlwaysRecord.setEnabled(selectedGroup != null);
        this.canViewOwnHistory.setEnabled(selectedGroup != null);
        this.canViewGroupHistory.setEnabled(selectedGroup != null);
        this.canViewAllHistory.setEnabled(selectedGroup != null);
        this.canManageMonitoring.setEnabled(selectedGroup != null);
        this.canViewMonitoring.setEnabled(selectedGroup != null);
        this.canViewScreenshots.setEnabled(selectedGroup != null);
        this.canViewMetrics.setEnabled(selectedGroup != null);
        this.canCopyFiles.setEnabled(selectedGroup != null);
        this.canRunToolsInAccess.setEnabled(selectedGroup != null);
        this.canRunToolsInSessions.setEnabled(selectedGroup != null);
        this.canManageAlerts.setEnabled(selectedGroup != null);
        this.canManageServerEvents.setEnabled(selectedGroup != null);
        this.canViewAllAlerts.setEnabled(selectedGroup != null);
        this.canUseUDP.setEnabled(selectedGroup != null);
        this.sessionTypeBox.setEnabled(selectedGroup != null && this.canUseUDP.isSelected());
        this.switchAll.setEnabled(selectedGroup != null && this.canUseUDP.isSelected());
        boolean isProfileApp = selectedGroup != null && selectedGroup.getAssociatedAppProfileID() != null;
        this.showPermission(this.administratorBox, !isProfileApp);
        this.showPermission(this.groupAllowSH, !isProfileApp);
        this.showPermission(this.groupAllowSG, !isProfileApp);
        this.showPermission(this.groupAllowPresent, !isProfileApp);
        this.showPermission(this.groupCanRemoveCustomers, !isProfileApp);
        this.showPermission(this.groupAllowInstallPersistent, !isProfileApp);
        this.showPermission(this.groupAllowManageServices, !isProfileApp);
        this.showPermission(this.canRecord, !isProfileApp);
        this.showPermission(this.canUpload, !isProfileApp);
        this.showPermission(this.groupCanManageRecordings, !isProfileApp);
        this.showPermission(this.groupMustAlwaysUploadRecordings, !isProfileApp);
        this.showPermission(this.groupMustAlwaysRecord, !isProfileApp);
        this.showPermission(this.groupCanPortForward, !isProfileApp);
        this.showPermission(this.groupCanDiagnostics, !isProfileApp);
        this.showPermission(this.groupCanChat, !isProfileApp);
        this.showPermission(this.groupCanAppTunnels, !isProfileApp);
        this.showPermission(this.groupCanCaptureAudio, !isProfileApp);
        this.showPermission(this.groupCanEchoText, !isProfileApp);
        this.showPermission(this.groupMustLock, !isProfileApp);
        this.showPermission(this.canViewOwnHistory, !isProfileApp);
        this.showPermission(this.canViewGroupHistory, !isProfileApp);
        this.showPermission(this.canViewAllHistory, !isProfileApp);
        this.showPermission(this.canManageMonitoring, !isProfileApp);
        this.showPermission(this.canRunToolsInAccess, !isProfileApp);
        this.showPermission(this.canRunToolsInSessions, !isProfileApp);
        this.showPermission(this.canManageAlerts, !isProfileApp);
        this.showPermission(this.canManageServerEvents, !isProfileApp);
        this.showPermission(this.canViewAllAlerts, !isProfileApp);
        this.showTitleAndDescription(this.historyContainer, !isProfileApp);
        this.showTitleAndDescription(this.toolsContainer, !isProfileApp);
        this.showTitleAndDescription(this.alertsContainer, !isProfileApp);
        this.showTitleAndDescription(this.installContainer, !isProfileApp);
        this.showTitleAndDescription(this.connectTypeContainer, !isProfileApp);
    }

    private void showTitleAndDescription(JPanel container, boolean show) {
        for (PermissionsRow row : this.rows) {
            if (row.container != container) continue;
            row.descLabel.setVisible(show);
            row.titleLabel.setVisible(show);
            return;
        }
    }

    private void showPermission(JCheckBox box, boolean show) {
        if (show) {
            box.setVisible(true);
        } else {
            box.setVisible(false);
            box.setSelected(false);
        }
    }

    public boolean actionPerformed(final TechGroup selectedGroup, ActionEvent e) {
        if (e.getSource().equals(this.canUseUDP)) {
            selectedGroup.getPermissions().setCanUseUDP(this.canUseUDP.isSelected());
        } else if (e.getSource().equals(this.sessionTypeBox)) {
            switch (this.sessionTypeBox.getSelectedIndex()) {
                case 0: {
                    selectedGroup.getPermissions().setCanUseAnyNetworkConnection();
                    break;
                }
                case 1: {
                    selectedGroup.getPermissions().setMustUseTCP();
                    break;
                }
                case 2: {
                    selectedGroup.getPermissions().setMustUseUDP();
                    break;
                }
                case 3: {
                    selectedGroup.getPermissions().setMustUseUDPDirect();
                }
            }
        } else {
            if (e.getSource().equals(this.switchAll)) {
                new Thread(){

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                GroupPermissionsUI.this.switchAll.setEnabled(false);
                            }
                        });
                        try {
                            try {
                                GroupPermissionsUI.this.techClient.switchTechnicianPreferencesToUse(GroupPermissionsUI.this.sessionTypeBox.getSelectedIndex(), selectedGroup.getGroupID());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    GroupPermissionsUI.this.switchAll.setEnabled(true);
                                }
                            });
                            throw throwable;
                        }
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                }.start();
                return false;
            }
            if (e.getSource().equals(this.groupAllowInstallPersistent)) {
                selectedGroup.getPermissions().setCanInstallPersistentConnection(this.groupAllowInstallPersistent.isSelected());
            } else if (e.getSource().equals(this.groupAllowManageServices)) {
                selectedGroup.getPermissions().setCanManagePersistentConnections(this.groupAllowManageServices.isSelected());
            } else if (e.getSource().equals(this.groupCanManageRecordings)) {
                selectedGroup.getPermissions().setCanManageRecordings(this.groupCanManageRecordings.isSelected());
            } else if (e.getSource().equals(this.groupMustAlwaysUploadRecordings)) {
                selectedGroup.getPermissions().setMustAlwaysUploadRecordings(this.groupMustAlwaysUploadRecordings.isSelected());
            } else if (e.getSource().equals(this.groupMustAlwaysRecord)) {
                selectedGroup.getPermissions().setMustAlwaysRecord(this.groupMustAlwaysRecord.isSelected());
            } else if (e.getSource().equals(this.groupAllowSG)) {
                selectedGroup.getPermissions().setCanRemoteAccess(this.groupAllowSG.isSelected());
            } else if (e.getSource().equals(this.groupAllowSH)) {
                selectedGroup.getPermissions().setCanRemoteSupport(this.groupAllowSH.isSelected());
            } else if (e.getSource().equals(this.administratorBox)) {
                selectedGroup.getPermissions().setCanAdminServer(this.administratorBox.isSelected());
            } else if (e.getSource().equals(this.groupCanTerminateSessions)) {
                selectedGroup.getPermissions().setCanTerminateOtherUsersSessions(this.groupCanTerminateSessions.isSelected());
            } else if (e.getSource().equals(this.groupCanViewOtherConnectedSessions)) {
                selectedGroup.getPermissions().setCanViewOtherConnectedSessions(this.groupCanViewOtherConnectedSessions.isSelected());
            } else if (e.getSource().equals(this.groupCanRemoveCustomers)) {
                selectedGroup.getPermissions().setCanRemoveCustomersFromQueue(this.groupCanRemoveCustomers.isSelected());
            } else if (e.getSource().equals(this.groupCanPortForward)) {
                selectedGroup.getPermissions().setCanUsePortForwarding(this.groupCanPortForward.isSelected());
            } else if (e.getSource().equals(this.groupCanFileTransfer)) {
                selectedGroup.getPermissions().setCanUseFileTransfer(this.groupCanFileTransfer.isSelected());
            } else if (e.getSource().equals(this.groupCanDiagnostics)) {
                selectedGroup.getPermissions().setCanUseDiagnostics(this.groupCanDiagnostics.isSelected());
            } else if (e.getSource().equals(this.groupCanChat)) {
                selectedGroup.getPermissions().setCanUseChat(this.groupCanDiagnostics.isSelected());
            } else if (e.getSource().equals(this.groupCanAppTunnels)) {
                selectedGroup.getPermissions().setCanUseAppTunnels(this.groupCanAppTunnels.isSelected());
            } else if (e.getSource().equals(this.groupCanCaptureAudio)) {
                selectedGroup.getPermissions().setCanCaptureAudio(this.groupCanCaptureAudio.isSelected());
            } else if (e.getSource().equals(this.groupCanEchoText)) {
                selectedGroup.getPermissions().setCanEchoText(this.groupCanEchoText.isSelected());
            } else if (e.getSource().equals(this.groupMustLock)) {
                selectedGroup.getPermissions().setMustLockMachineOnLogout(this.groupMustLock.isSelected());
            } else if (e.getSource().equals(this.groupMustRequestConnection)) {
                selectedGroup.getPermissions().setMustRequestConnection(this.groupMustRequestConnection.isSelected());
            } else if (e.getSource().equals(this.groupCanControlSessions)) {
                selectedGroup.getPermissions().setCanControlSessions(this.groupCanControlSessions.isSelected());
            } else if (e.getSource().equals(this.groupStartSessionsWithControl)) {
                selectedGroup.getPermissions().setCanStartSessionsWithControl(this.groupStartSessionsWithControl.isSelected());
            } else if (e.getSource().equals(this.groupMustRequestControl)) {
                selectedGroup.getPermissions().setMustRequestControl(this.groupMustRequestControl.isSelected());
            } else if (e.getSource().equals(this.groupMustRequestScreen)) {
                selectedGroup.getPermissions().setMustRequestScreen(this.groupMustRequestScreen.isSelected());
            } else if (e.getSource().equals(this.groupAllowPresent)) {
                selectedGroup.getPermissions().setCanPresent(this.groupAllowPresent.isSelected());
            } else if (e.getSource().equals(this.canRecord)) {
                selectedGroup.getPermissions().setCanRecord(this.canRecord.isSelected());
            } else if (e.getSource().equals(this.canUpload)) {
                selectedGroup.getPermissions().setCanUpload(this.canUpload.isSelected());
            } else if (e.getSource().equals(this.canViewOwnHistory)) {
                selectedGroup.getPermissions().setCanViewOwnHistory(this.canViewOwnHistory.isSelected());
            } else if (e.getSource().equals(this.canViewGroupHistory)) {
                selectedGroup.getPermissions().setCanViewGroupHistory(this.canViewGroupHistory.isSelected());
            } else if (e.getSource().equals(this.canViewAllHistory)) {
                selectedGroup.getPermissions().setCanViewAllHistory(this.canViewAllHistory.isSelected());
            } else if (e.getSource().equals(this.canManageMonitoring)) {
                selectedGroup.getPermissions().setCanManageMonitoring(this.canManageMonitoring.isSelected());
            } else if (e.getSource().equals(this.canViewMonitoring)) {
                selectedGroup.getPermissions().setCanViewMonitoring(this.canViewMonitoring.isSelected());
            } else if (e.getSource().equals(this.canViewScreenshots)) {
                selectedGroup.getPermissions().setCanViewScreenshots(this.canViewScreenshots.isSelected());
            } else if (e.getSource().equals(this.canViewMetrics)) {
                selectedGroup.getPermissions().setCanViewMetrics(this.canViewMetrics.isSelected());
            } else if (e.getSource().equals(this.canCopyFiles)) {
                selectedGroup.getPermissions().setCanCopyFiles(this.canCopyFiles.isSelected());
            } else if (e.getSource().equals(this.canRunToolsInAccess)) {
                selectedGroup.getPermissions().setCanRunTools(this.canRunToolsInAccess.isSelected());
            } else if (e.getSource().equals(this.canRunToolsInSessions)) {
                selectedGroup.getPermissions().setCanRunToolsInSessions(this.canRunToolsInSessions.isSelected());
            } else if (e.getSource().equals(this.canManageAlerts)) {
                selectedGroup.getPermissions().setCanManageAlerts(this.canManageAlerts.isSelected());
            } else if (e.getSource().equals(this.canViewAllAlerts)) {
                selectedGroup.getPermissions().setCanViewAllAlerts(this.canViewAllAlerts.isSelected());
            } else if (e.getSource().equals(this.canManageServerEvents)) {
                selectedGroup.getPermissions().setCanManageServerEvents(this.canManageServerEvents.isSelected());
            } else if (this.timeoutPanel.eventIsFromPanel(e)) {
                selectedGroup.setRequestAccessTimeout(this.timeoutPanel.getTimeout());
            } else {
                this.machinePermissionsUI.actionPerformed(selectedGroup, e);
            }
        }
        return true;
    }

    public void handleKeyPress(TechGroup selectedGroup, Object source) {
        if (source.equals(this.groupDefaultRecordingPasswordField)) {
            String password = this.groupDefaultRecordingPasswordField.getText();
            selectedGroup.setDefaultVideoPassword(password);
        }
    }

    public void setTechClient(TechClient techClient) {
        this.techClient = techClient;
    }

    class PermissionsRow {
        private final JPanel container;
        String description;
        JComponent[] permissionComponents;
        private String title;
        private JLabel titleLabel;
        private JLabel descLabel;

        public PermissionsRow(String title, String description, JComponent[] components, JPanel container) {
            this.title = title;
            this.description = description;
            this.permissionComponents = components;
            this.container = container;
        }
    }
}

