/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.technicians;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.LazyEncryptedPassword;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.tech.admin.listeners.ValidationKeyListener;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.admin.subsections.ssl.SSLUploadDialog;
import com.aem.shelp.util.PleaseWaitDialog;
import com.aem.utils.gui.verifiers.DigitDocument;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.RoundBorderPanel;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanelWrapper;

public class AdminLDAP
extends SubSection
implements ValidationKeyListener.ValidationInterface,
ActionListener {
    JCheckBox enableBox;
    JLabel ldapHostnameLabel;
    JTextField ldapHostnameField;
    JLabel ldapPortLabel;
    JTextField ldapPortField;
    JLabel authenticationLabel;
    JTextField authenticationField;
    JButton manageSSLCertificates;
    JCheckBox enableSSL;
    JCheckBox isAD;
    JLabel ldapUsernameLabel;
    JTextField ldapUsernameField;
    JLabel ldapPasswordLabel;
    JPasswordField ldapPasswordField;
    JButton testLDAPConnection;
    JLabel groupObjectLabel;
    JLabel userIDAttributeLabel;
    JLabel userMemberAttributeLabel;
    JTextField groupObjectField;
    JTextField userIDAttributeField;
    JTextField userMemberAttributeField;
    private JWrapLabel authenticationDesc;
    PleaseWaitDialog pleaseWaitDialog;
    private JWrapLabel ldapSearchDesc;
    private RoundBorderPanel ldapConfiguration;
    private JLabel filtersLabel;

    @Override
    protected void initUI() {
        this.initLdapTab(this.rootComponent);
    }

    private void initLdapTab(JPanel ldapPanel) {
        this.groupObjectLabel = new JLabel(Language.get("LDAP_GROUP_OBJECT"));
        this.userIDAttributeLabel = new JLabel(Language.get("LDAP_USER_ATTRIBUTE"));
        this.userMemberAttributeLabel = new JLabel(Language.get("LDAP_MEMBER_ATTRIBUTE"));
        this.groupObjectField = TextField.getTextFieldForType((int)0, (String)"group");
        this.userIDAttributeField = TextField.getTextFieldForType((int)0, (String)"uid,sAMAccountName,userPrincipalName,mail");
        this.userMemberAttributeField = TextField.getTextFieldForType((int)0, (String)"memberof");
        this.groupObjectField.addKeyListener(this.validateListener);
        this.userIDAttributeField.addKeyListener(this.validateListener);
        this.userMemberAttributeField.addKeyListener(this.validateListener);
        this.authenticationDesc = new JWrapLabel("<html>" + Language.get("LDAP_AUTH_DESC") + "</html>");
        this.authenticationLabel = new JLabel(Language.get("LDAP_AUTH"));
        this.authenticationField = new JTextField();
        this.authenticationField.addKeyListener(this.validateListener);
        this.isAD = new JCheckBox(Language.get("LDAP_IS_AD"));
        this.enableSSL = new JCheckBox(Language.get("LDAP_ENABLE_SSL"));
        this.manageSSLCertificates = new JButton(Language.get("MANAGE_SSL"));
        this.isAD.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.enableSSL.setBackground(SHStyle.PANEL_BACKGROUND_DARKER);
        this.isAD.addActionListener(this.validateListener);
        this.enableSSL.addActionListener(this.validateListener);
        this.manageSSLCertificates.addActionListener(this);
        GbPanelWrapper mainLdap = new GbPanelWrapper((Container)ldapPanel);
        this.enableBox = new JCheckBox(Language.get("LDAP_ENABLE"));
        this.ldapConfiguration = new RoundBorderPanel();
        GbPanelWrapper wrapper = new GbPanelWrapper((Container)this.ldapConfiguration, (Insets)new ScaledInsets(3, 3, 3, 3));
        this.ldapHostnameLabel = new JLabel(Language.get("LDAP_HOSTNAME"));
        this.ldapHostnameField = new JTextField();
        this.ldapPortLabel = new JLabel(Language.get("LDAP_PORT"));
        this.ldapPortField = new JTextField();
        this.ldapPortField.setDocument(new DigitDocument(false));
        this.ldapSearchDesc = new JWrapLabel("<html>" + Language.get("LDAP_SEARCH_DESC") + "</html>");
        this.ldapSearchDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.authenticationDesc.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.ldapUsernameLabel = new JLabel(Language.get("LDAP_SEARCH_USERNAME"));
        this.ldapPasswordLabel = new JLabel(Language.get("LDAP_SEARCH_PASSWORD"));
        this.ldapUsernameField = new JTextField();
        this.ldapPasswordField = new JPasswordField();
        SwingUtil.setWidth((JComponent)this.ldapHostnameField, (int)SimpleHelpLookAndFeel.scale((int)200));
        SwingUtil.setWidth((JComponent)this.ldapPortField, (int)SimpleHelpLookAndFeel.scale((int)60));
        SwingUtil.setWidth((JComponent)this.ldapUsernameField, (int)SimpleHelpLookAndFeel.scale((int)200));
        SwingUtil.setWidth((JComponent)this.authenticationField, (int)SimpleHelpLookAndFeel.scale((int)150));
        SwingUtil.setWidth((JComponent)this.ldapPasswordField, (int)SimpleHelpLookAndFeel.scale((int)200));
        SwingUtil.setWidth((JComponent)this.groupObjectField, (int)SimpleHelpLookAndFeel.scale((int)200));
        SwingUtil.setWidth((JComponent)this.userIDAttributeField, (int)SimpleHelpLookAndFeel.scale((int)200));
        SwingUtil.setWidth((JComponent)this.userMemberAttributeField, (int)SimpleHelpLookAndFeel.scale((int)200));
        this.testLDAPConnection = new JButton(Language.get("LDAP_TEST_CONNECTION"));
        this.testLDAPConnection.addActionListener(this);
        this.enableBox.addActionListener(this);
        this.ldapPortField.addKeyListener(this.validateListener);
        this.enableBox.addActionListener(this.validateListener);
        this.ldapHostnameField.addKeyListener(this.validateListener);
        this.ldapUsernameField.addKeyListener(this.validateListener);
        this.ldapPasswordField.addKeyListener(this.validateListener);
        this.ldapSearchDesc.setVerticalAlignment(1);
        this.authenticationDesc.setVerticalAlignment(1);
        int Y = 0;
        wrapper.add((Component)this.ldapHostnameLabel, 0, Y, 1, 1, 0, 0, 13, 0);
        wrapper.add((Component)this.ldapHostnameField, 1, Y, 1, 1, 0, 0, 17, 0);
        wrapper.add((Component)this.ldapPortLabel, 2, Y, 1, 1, 0, 0, 13, 0);
        wrapper.add((Component)this.ldapPortField, 3, Y, 1, 1, 0, 0, 17, 0);
        wrapper.add((Component)this.testLDAPConnection, 4, Y, 1, 1, 0, 0, 13, 0);
        wrapper.add((Component)RoundBorderPanel.getPaddyPanel(true), 0, ++Y, 4, 1, 0, 0, 13, 0, (Insets)new ScaledInsets(5, 0, 0, 0));
        wrapper.add((Component)this.ldapUsernameLabel, 0, ++Y, 1, 1, 0, 0, 13, 0);
        wrapper.add((Component)this.ldapUsernameField, 1, Y, 1, 1, 0, 0, 17, 0);
        wrapper.add((Component)this.ldapSearchDesc, 2, Y, 3, 2, 1, 1, 11, 1);
        wrapper.add((Component)this.ldapPasswordLabel, 0, ++Y, 1, 1, 0, 0, 13, 0);
        wrapper.add((Component)this.ldapPasswordField, 1, Y, 1, 1, 0, 0, 17, 0);
        wrapper.add((Component)RoundBorderPanel.getPaddyPanel(true), 0, ++Y, 4, 1, 0, 0, 13, 0, (Insets)new ScaledInsets(5, 0, 0, 0));
        wrapper.add((Component)this.authenticationLabel, 0, ++Y, 1, 1, 0, 0, 13, 0);
        wrapper.add((Component)this.authenticationField, 1, Y, 1, 1, 0, 0, 10, 2);
        wrapper.add((Component)this.authenticationDesc, 2, Y, 3, 1, 1, 1, 10, 1);
        wrapper.add((Component)this.enableSSL, 1, ++Y, 1, 1, 0, 0, 10, 2);
        wrapper.add((Component)this.manageSSLCertificates, 1, ++Y, 1, 1, 0, 0, 10, 2);
        wrapper.add((Component)RoundBorderPanel.getPaddyPanel(true), 0, ++Y, 4, 1, 0, 0, 13, 0, (Insets)new ScaledInsets(5, 0, 0, 0));
        wrapper.add((Component)this.isAD, 1, ++Y, 1, 1, 0, 0, 10, 2);
        this.filtersLabel = new JLabel(Language.get("LDAP_FILTER_SETTINGS"));
        this.filtersLabel.setFont(SHStyle.mediumFont);
        int n = ++Y;
        wrapper.add((Component)this.filtersLabel, 0, n, 1, 1, 0, 0, 17, 0, (Insets)new ScaledInsets(5, 0, 3, 0));
        wrapper.add((Component)this.groupObjectLabel, 0, ++Y, 1, 1, 0, 0, 13, 0);
        wrapper.add((Component)this.groupObjectField, 1, Y, 1, 1, 0, 0, 10, 2);
        wrapper.add((Component)this.userIDAttributeLabel, 0, ++Y, 1, 1, 0, 0, 13, 0);
        wrapper.add((Component)this.userIDAttributeField, 1, Y, 1, 1, 0, 0, 10, 2);
        wrapper.add((Component)this.userMemberAttributeLabel, 0, ++Y, 1, 1, 0, 0, 13, 0);
        wrapper.add((Component)this.userMemberAttributeField, 1, Y, 1, 1, 0, 0, 10, 2);
        ++Y;
        this.ldapConfiguration.setVisible(false);
        int Y2 = 0;
        JLabel desc = new JLabel(Language.get("LDAP_CONFIGURATION_DESC"));
        mainLdap.add((Component)desc, 0, Y2++, 1, 1, 1, 1, 17, 0, (Insets)new ScaledInsets(0, 0, 3, 0));
        mainLdap.add((Component)this.enableBox, 0, Y2++, 1, 1, 1, 1, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 0));
        mainLdap.add((Component)this.ldapConfiguration, 0, Y2++, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(0, 0, 3, 0));
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_LDAP");
    }

    @Override
    public void loadFrom(ServerConfig config) {
        this.enableBox.setSelected(config.ldapEnable);
        this.ldapConfiguration.setVisible(config.ldapEnable);
        this.ldapHostnameField.setText(config.ldapHostname);
        this.ldapUsernameField.setText(config.ldapUsername);
        this.ldapPasswordField.setText(config.ldapPassword.getDecryptedPassword());
        this.ldapPortField.setText(Integer.toString(config.ldapPort));
        this.authenticationField.setText(config.ldapAuthentication);
        this.enableSSL.setSelected(config.ldapEnableSSL);
        this.isAD.setSelected(config.ldapIsAD);
        this.groupObjectField.setText(config.getLDAPGroupClass());
        this.userIDAttributeField.setText(config.getLDAPLogin());
        this.userMemberAttributeField.setText(config.getLDAPMemberAttribute());
    }

    @Override
    public void saveTo(ServerConfig config) {
        config.ldapEnable = this.enableBox.isSelected();
        config.ldapHostname = this.ldapHostnameField.getText();
        try {
            config.ldapPort = Integer.parseInt(this.ldapPortField.getText());
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
        }
        config.ldapUsername = this.ldapUsernameField.getText();
        if (config.ldapPassword == null) {
            config.ldapPassword = new LazyEncryptedPassword(new String(this.ldapPasswordField.getPassword()));
        } else {
            config.ldapPassword.setDecryptedPassword(new String(this.ldapPasswordField.getPassword()));
        }
        config.ldapAuthentication = this.authenticationField.getText();
        config.ldapEnableSSL = this.enableSSL.isSelected();
        config.ldapIsAD = this.isAD.isSelected();
        config.setLDAPGroupClass(this.groupObjectField.getText());
        config.setLDAPLoginAttribute(this.userIDAttributeField.getText());
        config.setLDAPMemberAttribute(this.userMemberAttributeField.getText());
    }

    @Override
    public void checkEnabled() {
        this.ldapHostnameLabel.setEnabled(this.enableBox.isSelected());
        this.ldapHostnameField.setEnabled(this.enableBox.isSelected());
        this.ldapPortLabel.setEnabled(this.enableBox.isSelected());
        this.ldapPortField.setEnabled(this.enableBox.isSelected());
        this.ldapPasswordField.setEnabled(this.enableBox.isSelected());
        this.ldapPasswordLabel.setEnabled(this.enableBox.isSelected());
        this.ldapUsernameField.setEnabled(this.enableBox.isSelected());
        this.ldapUsernameLabel.setEnabled(this.enableBox.isSelected());
        this.authenticationDesc.setEnabled(this.enableBox.isSelected());
        this.authenticationLabel.setEnabled(this.enableBox.isSelected());
        this.authenticationField.setEnabled(this.enableBox.isSelected());
        this.ldapSearchDesc.setEnabled(this.enableBox.isSelected());
        this.enableSSL.setEnabled(this.enableBox.isSelected());
        this.manageSSLCertificates.setEnabled(this.enableSSL.isSelected() && this.enableBox.isSelected());
        this.testLDAPConnection.setEnabled(this.enableBox.isSelected());
        this.isAD.setEnabled(this.enableBox.isSelected());
        this.filtersLabel.setVisible(!this.isAD.isSelected());
        this.groupObjectLabel.setVisible(!this.isAD.isSelected());
        this.userIDAttributeLabel.setVisible(!this.isAD.isSelected());
        this.userMemberAttributeLabel.setVisible(!this.isAD.isSelected());
        this.groupObjectField.setVisible(!this.isAD.isSelected());
        this.userIDAttributeField.setVisible(!this.isAD.isSelected());
        this.userMemberAttributeField.setVisible(!this.isAD.isSelected());
    }

    public ArrayList checkAndMarkValid() {
        ArrayList<JTextField> list = new ArrayList<JTextField>();
        int oldSize = list.size();
        if (this.enableBox.isSelected()) {
            if (this.ldapHostnameField.getText().length() == 0) {
                list.add(this.ldapHostnameField);
            } else {
                this.ldapHostnameField.setBorder(UIManager.getBorder("TextField.border"));
            }
            if (this.ldapPortField.getText().length() == 0 || !AdminLDAP.isValidPortField(this.ldapPortField.getText())) {
                list.add(this.ldapPortField);
            } else {
                this.ldapPortField.setBorder(UIManager.getBorder("TextField.border"));
            }
            if (this.authenticationField.getText().length() == 0) {
                list.add(this.authenticationField);
            } else {
                this.authenticationField.setBorder(UIManager.getBorder("TextField.border"));
            }
            if (this.ldapUsernameField.getText().length() == 0) {
                list.add(this.ldapUsernameField);
            } else {
                this.ldapUsernameField.setBorder(UIManager.getBorder("TextField.border"));
            }
            if (this.ldapPasswordField.getPassword().length == 0) {
                list.add(this.ldapPasswordField);
            } else {
                this.ldapPasswordField.setBorder(UIManager.getBorder("TextField.border"));
            }
        } else {
            this.ldapHostnameField.setBorder(UIManager.getBorder("TextField.border"));
            this.ldapPortField.setBorder(UIManager.getBorder("TextField.border"));
            this.authenticationField.setBorder(UIManager.getBorder("TextField.border"));
            this.ldapPasswordField.setBorder(UIManager.getBorder("TextField.border"));
            this.ldapUsernameField.setBorder(UIManager.getBorder("TextField.border"));
        }
        int diff = list.size() - oldSize;
        this.testLDAPConnection.setEnabled(this.enableBox.isSelected() && diff == 0);
        return list;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block9: {
            if (e.getSource().equals(this.testLDAPConnection)) {
                try {
                    this.pleaseWaitDialog = new PleaseWaitDialog(SwingUtil.getRootPaneContainer((Component)this.rootComponent), Language.get("PLEASE_WAIT_TITLE"), Language.get("PLEASE_WAIT_LDAP"));
                    new TestLDAPThread().start();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    if (this.pleaseWaitDialog != null) {
                        this.pleaseWaitDialog.setVisible(false);
                    }
                    break block9;
                }
            }
            if (e.getSource() == this.enableBox) {
                this.ldapConfiguration.setVisible(this.enableBox.isSelected());
            } else if (e.getSource() == this.manageSSLCertificates) {
                try {
                    SSLUploadDialog.showDialog(SwingUtil.getRootPaneContainer((Component)this.manageSSLCertificates), this.techClient);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        final JTextField field = new JTextField();
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    if (System.currentTimeMillis() % 2L == 0L) {
                        field.setText("123");
                        continue;
                    }
                    field.setText("456");
                }
            }
        }.start();
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                while (true) {
                    String value;
                    if ((value = field.getText()).equals("123") || value.equals("456")) {
                        continue;
                    }
                    try {
                        throw new Exception(value);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    class TestLDAPThread
    extends Thread {
        public TestLDAPThread() {
            super("TestLDAPThread");
        }

        @Override
        public void run() {
            String port = AdminLDAP.this.ldapPortField.getText();
            String hostname = AdminLDAP.this.ldapHostnameField.getText();
            String authentication = AdminLDAP.this.authenticationField.getText();
            boolean ssl = AdminLDAP.this.enableSSL.isSelected();
            String username = AdminLDAP.this.ldapUsernameField.getText();
            String password = new String(AdminLDAP.this.ldapPasswordField.getPassword());
            try {
                boolean auth = AdminLDAP.this.techClient.testLDAPConnectSoServer(hostname, port, authentication, ssl, username, password);
                if (AdminLDAP.this.pleaseWaitDialog != null) {
                    AdminLDAP.this.pleaseWaitDialog.setVisible(false);
                }
                SHGlassOptionPane.showMessageDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AdminLDAP.this.rootComponent), (String)Language.get("ADMIN_LDAP_OK_MSG"), (String)Language.get("ADMIN_TEST_LDAP_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/ok.svg,48"), (String)Language.get("CLOSE"));
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (AdminLDAP.this.pleaseWaitDialog != null) {
                    AdminLDAP.this.pleaseWaitDialog.setVisible(false);
                }
                SHGlassOptionPane.showErrorDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)AdminLDAP.this.rootComponent), (String)(Language.get("ADMIN_LDAP_ERR_MSG") + ": " + t.getMessage()), (String)Language.get("ADMIN_TEST_LDAP_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
            }
        }
    }
}

