/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.ssl;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.subsections.ssl.SSLRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RootPaneContainer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import testing.classes.access.AccessPanelTester;
import utils.ssl.sslmanager.CertificateParser;
import utils.swing.SafeJFileChooser;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;

public class SSLUploadDialog
extends OKCancelDialogPanel
implements ListSelectionListener {
    private final TechClient client;
    private SimpleList<TechClient.X509CertificateDescription> certificateList;
    private SimpleTableModel tableModel = null;
    private SHJTable keyTable;
    private JButton deleteButton;
    private JButton addButton;
    private ActionListener buttonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            X509Certificate[] certs;
            File file;
            if (e.getSource() == SSLUploadDialog.this.deleteButton) {
                int row = SSLUploadDialog.this.keyTable.getSelectedRow();
                TechClient.X509CertificateDescription desc = (TechClient.X509CertificateDescription)SSLUploadDialog.this.certificateList.get(row);
                try {
                    SSLUploadDialog.this.client.removeSSLCertificate(desc.serial);
                    SSLUploadDialog.this.certificateList.remove(row);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            } else if (e.getSource() == SSLUploadDialog.this.addButton && (file = SafeJFileChooser.pickFile((Component)SSLUploadDialog.this.addButton, (File)new File(System.getProperty("user.home")), null)) != null && (certs = CertificateParser.parseAnyCertificate(file)) != null) {
                for (X509Certificate cert : certs) {
                    try {
                        SSLUploadDialog.this.certificateList.add(SSLUploadDialog.this.client.addSSLCertificate(cert));
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    };

    public SSLUploadDialog(TechClient client) {
        super(Language.get("CLOSE"));
        this.client = client;
        this.deleteButton = this.addLeftButton(Language.get("REMOVE_CERT"), false, this.buttonListener);
        this.addButton = this.addLeftButton(Language.get("UPLOAD_CERT"), false, this.buttonListener);
        this.deleteButton.setEnabled(false);
        SHButtonUI.makeButtonRed((JButton)this.deleteButton);
        JPanel contentPanel = this.getContentPanel();
        FixedWidthPanel panel = new FixedWidthPanel((JComponent)contentPanel);
        this.setContent((FixedWidthComponent)panel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showDialog(RootPaneContainer rpc, TechClient client) {
        SSLUploadDialog dialog;
        block5: {
            dialog = new SSLUploadDialog(client);
            try {
                TechClient.X509CertificateDescription[] sslCertificates;
                if (client == null || (sslCertificates = client.getSSLCertificates()).length <= 0) break block5;
                dialog.certificateList.startBatch();
                try {
                    Collections.addAll(dialog.certificateList, sslCertificates);
                }
                finally {
                    dialog.certificateList.endBatch();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        AbstractGlassDialog abstractGlassDialog = new AbstractGlassDialog(rpc, 700, (AbstractDialogPanel)dialog);
        abstractGlassDialog.setTitle(Language.get("CERTIFICATE_ROOT_DIALOG"));
        abstractGlassDialog.showDialog();
    }

    protected JPanel getContentPanel() {
        this.certificateList = new SimpleList();
        TableStructure ts = TableStructure.createTableStructure(TechClient.X509CertificateDescription.class, new String[]{"", "", ""}, new String[]{Language.get("SSL_COMMON_NAME"), Language.get("SUBJECT_DN"), Language.get("EXPIRY")});
        ts.setWidths(new int[]{200, 200, 50});
        ts.setAlignment(new int[]{2, 2, 4});
        this.tableModel = new SimpleTableModel(this.certificateList, ts);
        this.keyTable = new SHJTable(this.tableModel);
        this.keyTable.setRowHeight(SimpleHelpLookAndFeel.scale((int)26));
        this.keyTable.getSelectionModel().addListSelectionListener(this);
        this.keyTable.setDefaultRenderer(Object.class, new SSLRenderer());
        this.keyTable.getTableHeader().setDefaultRenderer(new HeaderAlignmentWrapper(this.keyTable));
        ts.initTableDimensions(this.keyTable);
        JScrollPane tableScroller = new JScrollPane(this.keyTable);
        JPanel userPanel = new JPanel(new BorderLayout());
        userPanel.add((Component)tableScroller, "Center");
        return userPanel;
    }

    public static void main(String[] args) throws Exception {
        Language.loadTranslations();
        TechClient techClient = AccessPanelTester.getTechClient();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        frame.setVisible(true);
        SSLUploadDialog.showDialog((RootPaneContainer)frame, techClient);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.deleteButton.setEnabled(this.keyTable.getSelectedRow() != -1);
        this.deleteButton.repaint();
    }

    public static class HeaderAlignmentWrapper
    implements TableCellRenderer {
        private DefaultTableCellRenderer renderer;

        public HeaderAlignmentWrapper(JTable table) {
            this.renderer = (DefaultTableCellRenderer)table.getTableHeader().getDefaultRenderer();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            JLabel label = (JLabel)this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            switch (col) {
                case 0: {
                    label.setHorizontalAlignment(2);
                    break;
                }
                case 1: {
                    label.setHorizontalAlignment(2);
                    break;
                }
                case 2: {
                    label.setHorizontalAlignment(4);
                }
            }
            return label;
        }
    }
}

