/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.simulation.steps;

import com.aem.shelp.common.Language;
import com.aem.shelp.tech.admin.subsections.simulation.SimulationStep;
import com.aem.shelp.tech.admin.subsections.simulation.SimulationStepConfigPanel;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import utils.message.Message;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.layout.BorderPanel;
import utils.swing.layout.VariableLinePanel;

public class WaitStep
implements SimulationStep {
    double mins = 1.0;

    @Override
    public String getTypeOverlayKeyNoSize() {
        return null;
    }

    @Override
    public String getTypeIconKeyNoSize() {
        return "images/svg/general/clock-simple.svg";
    }

    @Override
    public String getTypeNameKey() {
        return "STEP_WAIT_NAME";
    }

    @Override
    public String getTypeDescKey() {
        return "STEP_WAIT_DESC";
    }

    @Override
    public SimulationStepConfigPanel getTypeConfigurationPanel() {
        return new SimulationStepConfigPanel<WaitStep>(this){
            JTextField field;

            @Override
            public JComponent getComponent() {
                BorderPanel squishy = new BorderPanel();
                VariableLinePanel vp = new VariableLinePanel(1, false, true);
                vp.setGridSpacing(new ScaledInsets(0, 0, 0, 5));
                JLabel label = new JLabel(Language.get("STEP_WAIT_TIME"));
                this.field = new JTextField(8);
                this.field.setText(((WaitStep)this.getStep()).mins + "");
                vp.add((Component)label);
                vp.add((Component)this.field);
                squishy.addNorth((JComponent)vp);
                return squishy;
            }

            @Override
            public void finishAndSave() {
                try {
                    ((WaitStep)this.getStep()).mins = Double.parseDouble(this.field.getText().trim());
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        };
    }

    public long getWaitTimeMillis() {
        return (long)(this.mins * 60000.0);
    }

    @Override
    public String getSummary() {
        if (this.mins == 1.0) {
            return Language.get("STEP_WAIT_SUMMARY_SINGULAR", this.mins);
        }
        return Language.get("STEP_WAIT_SUMMARY_PLURAL", this.mins);
    }

    @Override
    public Message toMessage() {
        Message m = new Message(1);
        m.append(this.mins);
        return m;
    }

    public static WaitStep fromMessage(Message m) {
        WaitStep ws = new WaitStep();
        ws.mins = m.getNextDouble();
        return ws;
    }
}

