/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.serversettings;

import aurelienribon.slidinglayout.DoTransition;
import aurelienribon.slidinglayout.SLAnimator;
import aurelienribon.slidinglayout.SLConfig;
import aurelienribon.slidinglayout.SLKeyframe;
import aurelienribon.slidinglayout.SLPanel;
import aurelienribon.slidinglayout.SLSide;
import aurelienribon.slidinglayout.SLTransition;
import com.aem.shelp.common.Language;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.KeystoreDescriptionPanel;
import com.aem.shelp.tech.admin.subsections.serversettings.AdminNewSSL;
import com.aem.shelp.tech.admin.subsections.serversettings.SSLUtil;
import com.aem.shelp.tech.gstarted.SHWebsiteURLUtil;
import com.aem.shelp.tech.utils.IconAndText;
import com.aem.shelp.tech.utils.SHStrippedContentPanel;
import com.aem.shelp.util.KeytoolUtil;
import com.aem.shelp.util.progress.SHProgressAnimatedIcon;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import utils.ssl.KeyStoreUtility;
import utils.swing.SwingUtil;
import utils.swing.components.JWrapLabel;
import utils.swing.components.JWrapTextAreaLabel;
import utils.swing.cui.layouts.CUIHorizontalPanel;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.LabelField;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.CheckBoxField;
import utils.swing.cui.types.fields.FileChooserField;
import utils.swing.cui.types.fields.TextField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.contents.FixedWidthPanel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class NewSSLCertificateWizard
implements ActionListener {
    private JPanel root = new FixedWidthPanel((LayoutManager)new GridLayout(1, 1));
    private JPanel certificateChoicePanel;
    private JPanel selfSignedPanel;
    private JPanel letsEncryptPanel;
    private JPanel uploadPanel;
    private JPanel finishedPanel;
    private SLPanel containerSliding = new SLPanel();
    private SLConfig certificateChoiceConfig;
    private SLConfig selfSignedConfig;
    private SLConfig leConfig;
    private SLConfig uploadConfig;
    private SLConfig finishedConfig;
    private SLConfig verificationConfig;
    private JButton selfSignedButton;
    private JButton leButton;
    private JButton uploadButton;
    private TextField organisationName;
    private TextField domainName;
    private TextField leDomainName;
    private CheckBoxField leAgreement;
    private TextField leEmail;
    private JButton createSelfSigned;
    private JButton createLE;
    private JButton uploadKeystoreButton;
    private JButton checkKeystore;
    private TechClient client;
    private AdminNewSSL adminSSL;
    private IconAndText finishedIconAndText;
    private Component finishedTitle;
    private JLabel selfSignedErrorLabel;
    private JLabel leErrorLabel;
    private JLabel uploadErrorLabel;
    private FileChooserField uploadKeystoreLocation;
    private TextField uploadKeystoreKeyPassword;
    private TextField uploadKeystoreStorePassword;
    private JButton uploadHelpButton;
    private JPanel verificationPanel;
    private String leAgreementURL = "https://letsencrypt.org/documents/LE-SA-v1.2-November-15-2017.pdf";
    private final int mode_CHOICE = 0;
    private final int mode_OTHER = 1;
    private final int mode_FINISHED = 2;
    private final int mode_VERIFY = 3;
    private int modeCurrent = 0;

    public JPanel getRootComponent() {
        return this.root;
    }

    public NewSSLCertificateWizard(TechClient client, AdminNewSSL adminSSL) {
        this.client = client;
        this.adminSSL = adminSSL;
        new LEAgreementURLLoader(client);
        this.certificateChoicePanel = this.getCertificateChoicePanel();
        this.selfSignedPanel = this.getSelfSignedPanel();
        this.letsEncryptPanel = this.getLEPanel();
        this.uploadPanel = this.getUploadPanel();
        this.finishedPanel = this.initFinishedPanel();
        this.verificationPanel = this.getVerificationPanel();
        this.root.add(this.containerSliding);
        this.initSlidingConfigs();
    }

    private JPanel initFinishedPanel() {
        this.finishedIconAndText = new IconAndText(ImageLoader.getImageIcon((String)"images/svg/dialogs/ok.svg,48"), Language.get("SELF_SIGNED_OK"));
        SwingUtil.setWidth((JComponent)((Object)this.finishedIconAndText), (int)SimpleHelpLookAndFeel.scale((int)200));
        GbPanel finishedPanel = new GbPanel();
        finishedPanel.setBorder(SHBorderFactory.createEmptyBorder((int)50, (int)0, (int)0, (int)0));
        finishedPanel.add((Component)((Object)this.finishedIconAndText), 0, 0, 1, 1, 1, 1, 10, 3);
        return finishedPanel;
    }

    private JPanel getUploadPanel() {
        JLabel title = new JLabel(Language.get("EXISTING_SSL_TITLE"));
        title.setFont(SHStyle.largeFont);
        int Y = 0;
        GbPanel panel = new GbPanel(new ScaledInsets(8, 0, 8, 0));
        panel.setBorder(SHBorderFactory.createEmptyBorder((int)15, (int)15, (int)15, (int)15));
        panel.add((Component)title, 0, Y++, 2, 1, 1, 0, 17, 2);
        JWrapLabel desc = new JWrapLabel("<html>" + Language.get("CERT_UPLOAD_DESC"));
        panel.add((Component)desc, 0, Y++, 2, 1, 1, 0, 17, 2);
        CUIHorizontalPanel cuiPanel = new CUIHorizontalPanel(new ScaledInsets(3, 3, 3, 3), false);
        AbstractField.ChangeListener listener = new AbstractField.ChangeListener(){

            public void changed(AbstractField source) {
                if (NewSSLCertificateWizard.this.uploadKeystoreLocation.getFileChoice() != null && NewSSLCertificateWizard.this.uploadKeystoreLocation.getFileChoice().length() > 0) {
                    NewSSLCertificateWizard.this.uploadKeystoreButton.setEnabled(true);
                    NewSSLCertificateWizard.this.checkKeystore.setEnabled(true);
                } else {
                    NewSSLCertificateWizard.this.uploadKeystoreButton.setEnabled(false);
                    NewSSLCertificateWizard.this.checkKeystore.setEnabled(false);
                }
                NewSSLCertificateWizard.this.uploadKeystoreButton.repaint();
                NewSSLCertificateWizard.this.checkKeystore.repaint();
            }
        };
        this.uploadKeystoreLocation = new FileChooserField(Language.get("CERT_KEYSTORE"), listener, "");
        this.uploadKeystoreLocation.setTransientButtonImage(ImageLoader.getImageIcon((String)"images/svg/general/magnifying-glass.svg,16"));
        this.uploadKeystoreStorePassword = new TextField(Language.get("CERT_STOREPASS"), listener, 7);
        this.uploadKeystoreKeyPassword = new TextField(Language.get("CERT_KEYPASS"), listener, 7);
        cuiPanel.add((CUIField)this.uploadKeystoreLocation);
        cuiPanel.add((CUIField)this.uploadKeystoreStorePassword);
        cuiPanel.add((CUIField)this.uploadKeystoreKeyPassword);
        panel.add((Component)cuiPanel.getRootComponent(), 0, Y++, 2, 1, 1, 0, 17, 1);
        this.uploadErrorLabel = new JWrapLabel();
        this.uploadErrorLabel.setVisible(false);
        this.uploadErrorLabel.setForeground(SHStyle.ERROR_TEXT_COLOR);
        panel.add((Component)this.uploadErrorLabel, 0, Y++, 2, 1, 1, 0, 17, 1);
        if (OemBranding.OEM_IS_SH) {
            this.uploadHelpButton = new JButton(ImageLoader.getImageIcon((String)"images/svg/dialogs/question.svg,16"));
            this.uploadHelpButton.addActionListener(this);
        }
        this.checkKeystore = new JButton(Language.get("CHECK_KEYSTORE"));
        this.checkKeystore.addActionListener(this);
        this.checkKeystore.setEnabled(false);
        panel.add((Component)this.checkKeystore, 0, Y, 1, 1, 1, 0, 17, 0);
        this.uploadKeystoreButton = new JButton(Language.get("UPLOAD_KEYSTORE"));
        this.uploadKeystoreButton.setEnabled(false);
        panel.add((Component)this.uploadKeystoreButton, 1, Y++, 1, 1, 1, 0, 13, 0);
        this.uploadKeystoreButton.addActionListener(this);
        panel.add((Component)new JPanel(), 0, Y++, 2, 1, 1, 10000, 17, 2);
        return panel;
    }

    private JPanel getLEPanel() {
        JLabel title = new JLabel(Language.get("LE_TITLE"));
        title.setFont(SHStyle.largeFont);
        int Y = 0;
        GbPanel panel = new GbPanel(new ScaledInsets(8, 0, 8, 0));
        panel.setBorder(SHBorderFactory.createEmptyBorder((int)15, (int)15, (int)15, (int)15));
        panel.add((Component)title, 0, Y++, 1, 1, 1, 0, 17, 2);
        JWrapLabel desc = new JWrapLabel("<html>" + Language.get("LE_INPUT_DESC"));
        panel.add((Component)desc, 0, Y++, 1, 1, 1, 0, 17, 2);
        CUIHorizontalPanel cuiPanel = new CUIHorizontalPanel(new ScaledInsets(3, 3, 3, 3), false);
        AbstractField.ChangeListener listener = new AbstractField.ChangeListener(){

            public void changed(AbstractField source) {
                if (NewSSLCertificateWizard.this.leDomainName.getTextFieldValue().length() > 0 && NewSSLCertificateWizard.this.leEmail.getTextFieldValue().length() > 0 && NewSSLCertificateWizard.this.leAgreement.isChecked()) {
                    NewSSLCertificateWizard.this.createLE.setEnabled(true);
                } else {
                    NewSSLCertificateWizard.this.createLE.setEnabled(false);
                }
                NewSSLCertificateWizard.this.createLE.repaint();
            }
        };
        this.leDomainName = new TextField(Language.get("CERT_DOMAIN"), listener);
        this.leEmail = new TextField(Language.get("EMAIL_ADDRESS"), listener);
        this.leAgreement = new CheckBoxField(Language.get("LE_AGREEMENT"), listener, this.leAgreementURL);
        this.leDomainName.setExampleValue("www.example.com");
        this.leEmail.setExampleValue("mail@domain.com");
        cuiPanel.add((CUIField)this.leDomainName);
        cuiPanel.add((CUIField)new LabelField(Language.get("LE_NOTE2")));
        cuiPanel.add((CUIField)this.leEmail);
        cuiPanel.add((CUIField)this.leAgreement);
        panel.add((Component)cuiPanel.getRootComponent(), 0, Y++, 1, 1, 1, 0, 17, 1);
        JWrapLabel note = new JWrapLabel("<html>" + Language.get("LE_NOTE"));
        panel.add((Component)note, 0, Y++, 1, 1, 1, 0, 17, 1);
        this.leErrorLabel = new JWrapLabel();
        this.leErrorLabel.setVisible(false);
        this.leErrorLabel.setForeground(SHStyle.ERROR_TEXT_COLOR);
        panel.add((Component)this.leErrorLabel, 0, Y++, 1, 1, 1, 0, 17, 1);
        this.createLE = new JButton(Language.get("GEN_LE"));
        this.createLE.setEnabled(false);
        panel.add((Component)this.createLE, 0, Y++, 1, 1, 1, 0, 13, 0);
        this.createLE.addActionListener(this);
        panel.add((Component)new JPanel(), 0, Y++, 1, 1, 1, 10000, 17, 2);
        return panel;
    }

    private void showSelfSignedError(String title, String msg) {
        this.selfSignedErrorLabel.setVisible(true);
        this.selfSignedErrorLabel.setText("<html>" + title + " - " + msg);
    }

    private void showUploadError(String title, String msg) {
        this.uploadErrorLabel.setVisible(true);
        this.uploadErrorLabel.setText("<html>" + title + " - " + msg);
    }

    private JPanel getVerificationPanel() {
        return new JPanel(new GridLayout(1, 1));
    }

    private JPanel getSelfSignedPanel() {
        JLabel title = new JLabel(Language.get("SELF_SIGNED_TITLE"));
        title.setFont(SHStyle.largeFont);
        int Y = 0;
        GbPanel panel = new GbPanel(new ScaledInsets(8, 0, 8, 0));
        panel.setBorder(SHBorderFactory.createEmptyBorder((int)15, (int)15, (int)15, (int)15));
        panel.add((Component)title, 0, Y++, 1, 1, 1, 0, 17, 2);
        JWrapLabel desc = new JWrapLabel("<html>" + Language.get("SELF_SIGNED_INPUT_DESC"));
        panel.add((Component)desc, 0, Y++, 1, 1, 1, 0, 17, 2);
        CUIHorizontalPanel cuiPanel = new CUIHorizontalPanel(new ScaledInsets(3, 3, 3, 3), false);
        AbstractField.ChangeListener listener = new AbstractField.ChangeListener(){

            public void changed(AbstractField source) {
                if (NewSSLCertificateWizard.this.domainName.getTextFieldValue().length() > 0 && NewSSLCertificateWizard.this.organisationName.getTextFieldValue().length() > 0) {
                    NewSSLCertificateWizard.this.createSelfSigned.setEnabled(true);
                } else {
                    NewSSLCertificateWizard.this.createSelfSigned.setEnabled(false);
                }
                NewSSLCertificateWizard.this.createSelfSigned.repaint();
            }
        };
        this.domainName = new TextField(Language.get("CERT_DOMAIN"), listener);
        this.organisationName = new TextField(Language.get("CERT_ORGANISATION"), listener);
        this.domainName.setExampleValue("www.example.com");
        this.organisationName.setExampleValue(OemBranding.OEM_COMPANY_NAME);
        cuiPanel.add((CUIField)this.domainName);
        cuiPanel.add((CUIField)this.organisationName);
        panel.add((Component)cuiPanel.getRootComponent(), 0, Y++, 1, 1, 1, 0, 17, 1);
        this.selfSignedErrorLabel = new JWrapLabel();
        this.selfSignedErrorLabel.setVisible(false);
        this.selfSignedErrorLabel.setForeground(SHStyle.ERROR_TEXT_COLOR);
        panel.add((Component)this.selfSignedErrorLabel, 0, Y++, 1, 1, 1, 0, 17, 1);
        this.createSelfSigned = new JButton(Language.get("GEN_SELF_SIGNED"));
        this.createSelfSigned.setEnabled(false);
        panel.add((Component)this.createSelfSigned, 0, Y++, 1, 1, 1, 0, 13, 0);
        this.createSelfSigned.addActionListener(this);
        panel.add((Component)new JPanel(), 0, Y++, 1, 1, 1, 10000, 17, 2);
        return panel;
    }

    private void initSlidingConfigs() {
        this.certificateChoiceConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.certificateChoicePanel);
        this.selfSignedConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.selfSignedPanel);
        this.leConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.letsEncryptPanel);
        this.uploadConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.uploadPanel);
        this.finishedConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.finishedPanel);
        this.verificationConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.verificationPanel);
        this.containerSliding.setTweenManager(SLAnimator.createTweenManager());
        this.containerSliding.initialize(this.certificateChoiceConfig);
    }

    private void switchToNewView(SLConfig myConfig, int myMode, Component myComponent) {
        if (this.modeCurrent != myMode) {
            SLSide mySide = myMode > this.modeCurrent ? SLSide.RIGHT : SLSide.LEFT;
            SLTransition trans = this.containerSliding.createTransition().push(new SLKeyframe(myConfig, 0.5f).setStartSide(mySide, myComponent));
            new DoTransition(trans).start();
            this.modeCurrent = myMode;
        }
    }

    public void switchToVerificationPanel(final JPanel result) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewSSLCertificateWizard.this.verificationPanel.removeAll();
                NewSSLCertificateWizard.this.verificationPanel.add(new JScrollPane(result));
                NewSSLCertificateWizard.this.verificationPanel.revalidate();
                NewSSLCertificateWizard.this.verificationPanel.repaint();
                NewSSLCertificateWizard.this.switchToNewView(NewSSLCertificateWizard.this.verificationConfig, 3, NewSSLCertificateWizard.this.verificationPanel);
            }
        });
    }

    public void switchToFinished(String title, String message, boolean success) {
        this.finishedIconAndText.setImage(ImageLoader.getImageIcon((String)"images/svg/dialogs/ok.svg,48"));
        this.finishedIconAndText.setText(title);
        this.switchToNewView(this.finishedConfig, 2, this.finishedPanel);
    }

    public void switchToSelfSigned() {
        this.switchToNewView(this.selfSignedConfig, 1, this.selfSignedPanel);
    }

    public void switchToLE() {
        this.switchToNewView(this.leConfig, 1, this.letsEncryptPanel);
    }

    public void switchToUpload() {
        this.switchToNewView(this.uploadConfig, 1, this.uploadPanel);
    }

    private JPanel getCertificateChoicePanel() {
        GbPanel panel = new GbPanel(new ScaledInsets(10, 10, 10, 10));
        SHStrippedContentPanel cp = new SHStrippedContentPanel(panel, false);
        JWrapTextAreaLabel selfSignedDescription = new JWrapTextAreaLabel(Language.get("CERT_SELF_SIGN_WARNING"));
        this.selfSignedButton = new JButton(Language.get("CREATE"));
        this.selfSignedButton.addActionListener(this);
        GbPanel line = new GbPanel(new ScaledInsets(5, 0, 5, 5));
        line.add((Component)selfSignedDescription, 0, 0, 1, 1, 1, 1, 10, 1);
        line.add((Component)this.selfSignedButton, 0, 1, 1, 1, 0, 1, 10, 0);
        cp.addContent((JComponent)line, Language.get("SELF_SIGNED_TITLE"));
        JWrapTextAreaLabel leDescription = new JWrapTextAreaLabel(Language.get("LE_DESC"));
        this.leButton = new JButton(Language.get("CREATE"));
        this.leButton.addActionListener(this);
        line = new GbPanel(new ScaledInsets(5, 0, 5, 5));
        line.add((Component)leDescription, 0, 0, 1, 1, 1, 1, 10, 1);
        line.add((Component)this.leButton, 0, 1, 1, 1, 0, 1, 10, 0);
        cp.addContent((JComponent)line, Language.get("LE_TITLE"));
        JWrapTextAreaLabel existingDescription = new JWrapTextAreaLabel(Language.get("EXISTING_SSL_DESC"));
        this.uploadButton = new JButton(Language.get("UPLOAD"));
        this.uploadButton.addActionListener(this);
        line = new GbPanel(new ScaledInsets(5, 0, 5, 5));
        line.add((Component)existingDescription, 0, 0, 1, 1, 1, 1, 10, 1);
        line.add((Component)this.uploadButton, 0, 1, 1, 1, 0, 1, 10, 0);
        cp.addContent((JComponent)line, Language.get("EXISTING_SSL_TITLE"));
        JPanel filler = cp.addVerticalFiller();
        cp.setBackgroundColours();
        for (Component c : panel.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            ((JComponent)c).setBorder(SHBorderFactory.createEmptyBorder((int)15, (int)15, (int)15, (int)15));
        }
        return panel;
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = new SimpleHelpFrame();
        frame.setSize(500, 500);
        frame.setLocationRelativeTo(null);
        NewSSLCertificateWizard wiz = new NewSSLCertificateWizard(null, null);
        frame.getContentPane().add(wiz.getRootComponent());
        frame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.leButton) {
            this.switchToLE();
        } else if (e.getSource() == this.uploadButton) {
            this.switchToUpload();
        } else if (e.getSource() == this.selfSignedButton) {
            this.switchToSelfSigned();
        } else if (e.getSource() == this.checkKeystore) {
            File keystore = new File(this.uploadKeystoreLocation.getFileChoice());
            String storePassword = this.uploadKeystoreStorePassword.getTextFieldValue();
            String keyPassword = this.uploadKeystoreKeyPassword.getTextFieldValue();
            try {
                KeyStoreUtility.KeystoreValidationResult keystoreValidationResult = KeystoreDescriptionPanel.getKeystoreValidationResult(SwingUtil.getRootPaneContainer((Component)this.root), keystore, storePassword, keyPassword);
                KeystoreDescriptionPanel panel = new KeystoreDescriptionPanel(keystoreValidationResult);
                panel.getRootComponent().setBorder(SHBorderFactory.createEmptyBorder((int)10, (int)10, (int)10, (int)10));
                this.switchToVerificationPanel(panel.getRootComponent());
            }
            catch (Exception ex) {
                this.showUploadError(Language.get("UPLOAD_CERT_FAILURE_TITLE"), ex.getMessage());
                ex.printStackTrace();
            }
        } else if (e.getSource() == this.createSelfSigned) {
            this.createSelfSigned.setEnabled(false);
            this.createSelfSigned.repaint();
            new RequestSelfSignedCertificate().start();
        } else if (e.getSource() == this.createLE) {
            this.createLE.setEnabled(false);
            this.createLE.setIcon(new SHProgressAnimatedIcon());
            this.createLE.setText(Language.get("PLEASE_WAIT_TITLE") + "...");
            this.createLE.repaint();
            new RequestLECertificate().start();
        } else if (e.getSource() == this.uploadKeystoreButton) {
            this.uploadKeystoreButton.setEnabled(false);
            this.uploadKeystoreButton.repaint();
            new UploadCertificate().start();
        } else if (e.getSource() == this.uploadHelpButton) {
            SHWebsiteURLUtil.launchSSLHelpPage();
        }
    }

    public boolean canClose() {
        if (this.modeCurrent == 3) {
            this.switchToUpload();
            return false;
        }
        return true;
    }

    private class LEAgreementURLLoader
    extends Thread {
        private final TechClient client;

        LEAgreementURLLoader(TechClient client) {
            this.client = client;
            this.start();
        }

        @Override
        public void run() {
            try {
                String newURL = this.client.getLEAgreementURL();
                if (newURL != null) {
                    NewSSLCertificateWizard.this.leAgreementURL = newURL;
                    if (NewSSLCertificateWizard.this.leAgreement != null) {
                        NewSSLCertificateWizard.this.leAgreement.setURL(NewSSLCertificateWizard.this.leAgreementURL);
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public class RequestLECertificate
    extends Thread {
        @Override
        public void run() {
            block5: {
                try {
                    String password = "changeit";
                    KeytoolUtil.KeyStoreResult result = NewSSLCertificateWizard.this.client.requestLetsEncryptCertificate(NewSSLCertificateWizard.this.leDomainName.getTextFieldValue(), NewSSLCertificateWizard.this.leEmail.getTextFieldValue());
                    if (result.success == 0) {
                        NewSSLCertificateWizard.this.adminSSL.setKeystoreAndSave("LetsEncrypt", password, password);
                        NewSSLCertificateWizard.this.switchToFinished(Language.get("SELF_SIGNED_OK"), "", true);
                        break block5;
                    }
                    NewSSLCertificateWizard.this.showSelfSignedError(Language.get("GEN_CERT_FAILURE_TITLE"), Language.get("GEN_CERT_FAILURE_MSG") + " (" + result.errorMessage + ")");
                }
                catch (Exception xx) {
                    try {
                        NewSSLCertificateWizard.this.showSelfSignedError(Language.get("GEN_CERT_FAILURE_TITLE"), Language.get("GEN_CERT_FAILURE_MSG"));
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                NewSSLCertificateWizard.this.createLE.setEnabled(true);
                                NewSSLCertificateWizard.this.createLE.setIcon(null);
                                NewSSLCertificateWizard.this.createLE.setText(Language.get("GEN_LE"));
                                NewSSLCertificateWizard.this.createLE.repaint();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }

    private class RequestSelfSignedCertificate
    extends Thread {
        private RequestSelfSignedCertificate() {
        }

        @Override
        public void run() {
            block5: {
                try {
                    KeytoolUtil.KeyStoreResult result = NewSSLCertificateWizard.this.client.requestSelfSignedCertificate(NewSSLCertificateWizard.this.domainName.getTextFieldValue(), SSLUtil.sanitiseForSsl(NewSSLCertificateWizard.this.organisationName.getTextFieldValue()));
                    if (result.success == 0) {
                        NewSSLCertificateWizard.this.adminSSL.setKeystoreAndSave("SelfSigned", "changeit", "changeit");
                        NewSSLCertificateWizard.this.switchToFinished(Language.get("SELF_SIGNED_OK"), "", true);
                        break block5;
                    }
                    NewSSLCertificateWizard.this.showSelfSignedError(Language.get("GEN_CERT_FAILURE_TITLE"), Language.get("GEN_CERT_FAILURE_MSG") + " (" + result.errorMessage + ")");
                }
                catch (Exception xx) {
                    try {
                        NewSSLCertificateWizard.this.showSelfSignedError(Language.get("GEN_CERT_FAILURE_TITLE"), Language.get("GEN_CERT_FAILURE_MSG"));
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                NewSSLCertificateWizard.this.createSelfSigned.setEnabled(true);
                                NewSSLCertificateWizard.this.createSelfSigned.repaint();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }

    public class UploadCertificate
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block5: {
                try {
                    File keystore = new File(NewSSLCertificateWizard.this.uploadKeystoreLocation.getFileChoice());
                    String storePassword = NewSSLCertificateWizard.this.uploadKeystoreStorePassword.getTextFieldValue();
                    String keyPassword = NewSSLCertificateWizard.this.uploadKeystoreKeyPassword.getTextFieldValue();
                    KeytoolUtil.KeyStoreResult result = NewSSLCertificateWizard.this.client.uploadKeystoreWithCertificate(keystore, storePassword, keyPassword);
                    if (result.success == 0) {
                        NewSSLCertificateWizard.this.adminSSL.setKeystoreAndSave("Uploaded", storePassword, keyPassword);
                        NewSSLCertificateWizard.this.switchToFinished(Language.get("UPLOAD_CERT_SUCCESS_MSG"), "", true);
                        break block5;
                    }
                    String title = Language.get("UPLOAD_CERT_FAILURE_TITLE");
                    String message = result.success == 1 ? Language.get("UPLOAD_CERT_FAILURE_MSG_STORE") : Language.get("UPLOAD_CERT_FAILURE_MSG_KEY");
                    NewSSLCertificateWizard.this.showUploadError(title, message);
                }
                catch (Exception xx) {
                    try {
                        NewSSLCertificateWizard.this.showUploadError(Language.get("UPLOAD_CERT_FAILURE_TITLE"), xx.getMessage());
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                NewSSLCertificateWizard.this.uploadKeystoreButton.setEnabled(true);
                                NewSSLCertificateWizard.this.uploadKeystoreButton.repaint();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }
}

