/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.subsections.serversettings;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.config.ServerConfig;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.admin.subsections.SubSection;
import com.aem.shelp.tech.history.TimelineModel;
import com.aem.shelp.tech.history.TimelineSlider;
import com.aem.shelp.util.progress.SHProgressIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.text.DefaultCaret;
import utils.files.AtomicFileOutputStream;
import utils.files.FileUtil;
import utils.message.Message;
import utils.swing.SafeJFileChooser;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.ColorPropagatingPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.icons.CircularProgressLabel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;

public class AdminServerLog
extends SubSection
implements ActionListener,
TimelineModel.TimelineSelectionListener {
    private static final AdminServerLog INSTANCE = new AdminServerLog();
    private TechClient.ServerLogDetails logDetails;
    private GbPanel progressPanel;
    private JTextArea textArea;
    private long textAreaLength = 0L;
    private JButton downloadLogButton;
    private JButton refreshLogButton;
    private boolean showingRefreshProgress = false;
    private boolean showingDownloadProgress = false;
    private CircularProgressLabel refreshProgress;
    private CircularProgressLabel downloadProgress;
    private boolean showWarningWhenDone = false;
    private JLabel warningLabel;
    private JButton cancelDownloadButton;
    private JPanel borderedSlider;
    private TimelineSlider timelineSlider;
    private TimelineModel timelineModel;
    private final Object LOG_FETCHER_LOCK = new Object();
    private LogFetcher logFetcher = null;
    private LogFetcher logDownloader = null;

    public static AdminServerLog getInstance() {
        return INSTANCE;
    }

    private AdminServerLog() {
    }

    @Override
    public boolean grabAllVerticalSpace() {
        return true;
    }

    @Override
    protected void initUI() {
        this.rootComponent = new ColorPropagatingPanel(){

            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }
        };
        this.timelineModel = new TimelineModel(System.currentTimeMillis() - 86400000L, System.currentTimeMillis(), 1);
        this.timelineSlider = new TimelineSlider(this.timelineModel);
        this.timelineSlider.getModel().addTimelineListener(this);
        GbPanelWrapper wrapper = new GbPanelWrapper((Container)this.rootComponent);
        this.textArea = new JTextArea();
        this.textArea.setEditable(false);
        this.textArea.setBorder(SHBorderFactory.createEmptyBorder());
        DefaultCaret caret = (DefaultCaret)this.textArea.getCaret();
        caret.setUpdatePolicy(1);
        JScrollPane pane = new JScrollPane(this.textArea);
        pane.setBorder(SHBorderFactory.createEmptyBorder());
        this.downloadLogButton = new JButton();
        this.downloadLogButton.setText(Language.get("DOWNLOAD"));
        this.downloadLogButton.setToolTipText(Language.get("SAVE_LOG_TO_DISK"));
        this.downloadLogButton.addActionListener(this);
        this.refreshLogButton = new JButton();
        this.refreshLogButton.setText(Language.get("REFRESH"));
        this.refreshLogButton.setToolTipText(Language.get("REFRESH_SERVER_LOG"));
        this.refreshLogButton.addActionListener(this);
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((AbstractButton[])new JButton[]{this.downloadLogButton, this.refreshLogButton});
        this.progressPanel = new ColorPropagatingGBPanel(new ScaledInsets(0, 20, 0, 0));
        this.progressPanel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)20, (int)0, (int)10));
        this.refreshProgress = SHProgressIcons.getCircularInfiniteLabel(SHProgressIcons.SIZE_24);
        this.downloadProgress = SHProgressIcons.getCircularInfiniteLabel(SHProgressIcons.SIZE_24);
        this.refreshProgress.setText(Language.get("ADMIN_SERVER_LOG_REFRESH"));
        this.downloadProgress.setText(Language.get("ADMIN_SERVER_LOG_DOWNLOAD"));
        this.cancelDownloadButton = new JButton(Language.get("CANCEL"));
        this.cancelDownloadButton.addActionListener(this);
        SHButtonUI.makeButtonNaked((JButton)this.cancelDownloadButton);
        this.cancelDownloadButton.setFont(SHStyle.smallerFont);
        this.warningLabel = new JLabel();
        this.warningLabel.setText(Language.get("ADMIN_SERVER_LOG_WARNING"));
        this.warningLabel.setIcon(ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,16"));
        ColorPropagatingGBPanel buttonsBar = new ColorPropagatingGBPanel();
        buttonsBar.setBorder(SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)1, (int)0, (int)0, (int)0, (Color)SHStyle.BORDER_COLOR), (Border)SHBorderFactory.createEmptyBorder((int)5, (int)10, (int)5, (int)10)));
        buttonsBar.add(this.downloadLogButton, 0, 0, 1, 1, 0, 0, 17, 0);
        buttonsBar.add(this.refreshLogButton, 1, 0, 1, 1, 0, 0, 17, 0);
        SwingUtil.setSizesToWidest((JComponent[])new JButton[]{this.refreshLogButton, this.downloadLogButton});
        buttonsBar.add((Component)this.progressPanel, 2, 0, 1, 1, 1, 1, 17, 3);
        SwingUtil.setHeight((JComponent)((Object)buttonsBar), (int)SimpleHelpLookAndFeel.scale((int)60));
        this.borderedSlider = new ColorPropagatingPanel((LayoutManager)new GridLayout(1, 1));
        SwingUtil.setHeight((JComponent)this.borderedSlider, (int)SimpleHelpLookAndFeel.scale((int)60));
        this.borderedSlider.add(this.timelineSlider.getRootComponent());
        this.borderedSlider.setBorder(SHBorderFactory.createCompoundBorder((Border)SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)SHStyle.BORDER_COLOR), (Border)SHBorderFactory.createEmptyBorder((int)0, (int)10, (int)0, (int)10)));
        this.borderedSlider.setVisible(false);
        wrapper.add((Component)this.borderedSlider, 0, 0, 1, 1, 1, 0, 10, 1);
        wrapper.add((Component)pane, 0, 1, 1, 1, 1, 1, 10, 1);
        wrapper.add((Component)((Object)buttonsBar), 0, 2, 1, 1, 1, 0, 10, 1);
        this.progressPanel.setBackground(buttonsBar.getBackground());
        this.showRefreshProgress();
        this.hideRefreshProgress();
    }

    public void showDownloadProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdminServerLog.this.downloadProgress.switchOn();
                AdminServerLog.this.downloadProgress.setVisible(true);
                if (AdminServerLog.this.showingDownloadProgress) {
                    return;
                }
                AdminServerLog.this.progressPanel.removeAll();
                AdminServerLog.this.progressPanel.add((Component)AdminServerLog.this.downloadProgress, 0, 0, 1, 1, 0, 1, 17, 1);
                AdminServerLog.this.progressPanel.add((Component)AdminServerLog.this.cancelDownloadButton, 1, 0, 1, 1, 1, 1, 17, 0);
                AdminServerLog.this.progressPanel.revalidate();
                AdminServerLog.this.progressPanel.repaint();
                AdminServerLog.this.showingDownloadProgress = true;
                AdminServerLog.this.showingRefreshProgress = false;
            }
        });
    }

    public void hideDownloadProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdminServerLog.this.downloadProgress.switchOff();
                AdminServerLog.this.downloadProgress.setVisible(false);
                if (!AdminServerLog.this.showingDownloadProgress) {
                    return;
                }
                AdminServerLog.this.progressPanel.removeAll();
                AdminServerLog.this.progressPanel.add((Component)AdminServerLog.this.refreshProgress, 0, 0, 1, 1, 0, 1, 17, 1);
                AdminServerLog.this.progressPanel.revalidate();
                AdminServerLog.this.progressPanel.repaint();
                AdminServerLog.this.showingDownloadProgress = false;
                AdminServerLog.this.showingRefreshProgress = true;
            }
        });
    }

    public void showRefreshProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdminServerLog.this.refreshProgress.switchOn();
                AdminServerLog.this.refreshProgress.setVisible(true);
                if (AdminServerLog.this.showingRefreshProgress) {
                    return;
                }
                if (AdminServerLog.this.showingDownloadProgress) {
                    return;
                }
                AdminServerLog.this.progressPanel.removeAll();
                AdminServerLog.this.progressPanel.add((Component)AdminServerLog.this.refreshProgress, 0, 0, 1, 1, 0, 1, 17, 1);
                AdminServerLog.this.progressPanel.revalidate();
                AdminServerLog.this.progressPanel.repaint();
                AdminServerLog.this.showingDownloadProgress = false;
                AdminServerLog.this.showingRefreshProgress = true;
            }
        });
    }

    public void hideRefreshProgress() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AdminServerLog.this.refreshProgress.switchOff();
                AdminServerLog.this.refreshProgress.setVisible(false);
                AdminServerLog.this.showingDownloadProgress = false;
                AdminServerLog.this.showingRefreshProgress = false;
                if (AdminServerLog.this.showWarningWhenDone) {
                    AdminServerLog.this.progressPanel.removeAll();
                    AdminServerLog.this.progressPanel.add((Component)AdminServerLog.this.warningLabel, 0, 0, 1, 1, 0, 1, 17, 1);
                    AdminServerLog.this.progressPanel.revalidate();
                    AdminServerLog.this.progressPanel.repaint();
                    AdminServerLog.this.showingDownloadProgress = false;
                    AdminServerLog.this.showingRefreshProgress = false;
                }
            }
        });
    }

    public void newLogData(final int index, final byte[] data, boolean finished) {
        if (index == 0) {
            this.showWarningWhenDone = false;
            this.textAreaLength = 0L;
        }
        if (data != null) {
            this.textAreaLength += (long)data.length;
        }
        if (this.textAreaLength >= 0xA00000L) {
            this.showWarningWhenDone = true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (index == 0) {
                    AdminServerLog.this.textArea.setText("");
                }
                AdminServerLog.this.textArea.append(new String(data, StandardCharsets.UTF_8));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timelineChanged(long startTime, long endTime) {
        Object object = this.LOG_FETCHER_LOCK;
        synchronized (object) {
            if (this.logFetcher == null) {
                this.logFetcher = new LogFetcher();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.downloadLogButton)) {
            File selectedFile = SafeJFileChooser.saveFile((Component)this.rootComponent, (String[])new String[]{"zip"}, (String)"serverlog.zip");
            if (selectedFile != null) {
                if (!selectedFile.getName().trim().endsWith(".zip")) {
                    selectedFile = new File(selectedFile.getParentFile(), selectedFile.getName().trim() + ".zip");
                }
                try {
                    AtomicFileOutputStream afos = new AtomicFileOutputStream(selectedFile);
                    ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream((OutputStream)afos));
                    out.putNextEntry(new ZipEntry("server.log"));
                    Object object = this.LOG_FETCHER_LOCK;
                    synchronized (object) {
                        if (this.logDownloader != null) {
                            this.logDownloader.die();
                        }
                        this.logDownloader = new LogFetcher(out, afos);
                    }
                }
                catch (Exception ex) {
                    SHGlassOptionPane.showErrorDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this.rootComponent), (String)(Language.get("LOG_SAVE_FAIL_MSG") + "\n" + ex.getMessage()), (String)Language.get("LOG_SAVE_FAIL_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/error.svg,48"), (String)Language.get("CLOSE"));
                    ex.printStackTrace();
                }
            }
        } else {
            if (e.getSource().equals(this.refreshLogButton)) {
                Object object = this.LOG_FETCHER_LOCK;
                synchronized (object) {
                    if (this.logFetcher == null) {
                        this.logFetcher = new LogFetcher();
                    }
                }
            }
            if (e.getSource().equals(this.cancelDownloadButton)) {
                Object object = this.LOG_FETCHER_LOCK;
                synchronized (object) {
                    if (this.logDownloader != null) {
                        this.logDownloader.die();
                        this.logDownloader = null;
                        this.hideDownloadProgress();
                    }
                }
            }
        }
    }

    @Override
    public String getTitle() {
        return Language.get("ADMIN_SERVER_LOG_PANEL");
    }

    @Override
    public void loadFrom(ServerConfig config) {
    }

    @Override
    public void saveTo(ServerConfig config) {
    }

    @Override
    public boolean insertDefaultPadding() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchedTo() {
        Object object = this.LOG_FETCHER_LOCK;
        synchronized (object) {
            if (this.logFetcher == null) {
                this.logFetcher = new LogFetcher();
            }
        }
    }

    class LogFetcher
    extends Thread {
        private final OutputStream saveToOutputStream;
        private final AtomicFileOutputStream afos;
        private boolean die;

        LogFetcher(OutputStream savetoOut, AtomicFileOutputStream afos) {
            super("LogFetcher");
            this.saveToOutputStream = savetoOut;
            this.afos = afos;
            this.start();
        }

        LogFetcher() {
            this(null, null);
        }

        public void die() {
            this.die = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (AdminServerLog.this.logDetails == null) {
                    AdminServerLog.this.logDetails = AdminServerLog.this.techClient.getLoggingDetails();
                    AdminServerLog.this.timelineSlider.getModel().setTotalDuration(((AdminServerLog)AdminServerLog.this).logDetails.serverStartTime, System.currentTimeMillis());
                    long start = Math.max(((AdminServerLog)AdminServerLog.this).logDetails.serverStartTime, System.currentTimeMillis() - 259200000L);
                    AdminServerLog.this.timelineSlider.getModel().setTimeSelection(start, System.currentTimeMillis());
                }
                AdminServerLog.this.timelineModel.setTotalDuration(((AdminServerLog)AdminServerLog.this).logDetails.serverStartTime, System.currentTimeMillis());
                AdminServerLog.this.borderedSlider.setVisible(AdminServerLog.this.timelineModel.hasTimePeriods());
                if (this.saveToOutputStream == null) {
                    AdminServerLog.this.showRefreshProgress();
                } else {
                    AdminServerLog.this.showDownloadProgress();
                }
                long startTime = System.currentTimeMillis();
                AdminServerLog.this.techClient.requestServerLog(AdminServerLog.this.timelineModel.getSelectionStartTime(), AdminServerLog.this.timelineModel.getSelectionEndTime(), this.saveToOutputStream != null);
                boolean gotAnyData = false;
                boolean finished = false;
                while (!this.die && !finished) {
                    Message m = AdminServerLog.this.techClient.getNextServerLogChunk();
                    if (m.length() == 0) {
                        finished = true;
                        if (!gotAnyData) {
                            AdminServerLog.this.newLogData(0, new byte[0], true);
                        }
                    } else {
                        int chunk = m.getNextInt();
                        byte[] data = m.getNextByteArray();
                        finished = m.getNextBoolean();
                        if (this.saveToOutputStream == null) {
                            gotAnyData = true;
                            AdminServerLog.this.newLogData(chunk, data, finished);
                        } else {
                            this.saveToOutputStream.write(data);
                        }
                    }
                    if (!finished) continue;
                    long diff = System.currentTimeMillis() - startTime;
                    if ((diff = 1000L - diff) > 0L && diff < 1000L) {
                        Thread.sleep(diff);
                    }
                    if (this.saveToOutputStream == null) {
                        AdminServerLog.this.hideRefreshProgress();
                        continue;
                    }
                    AdminServerLog.this.hideDownloadProgress();
                }
                if (this.die && this.afos != null) {
                    FileUtil.robustClose((OutputStream)this.saveToOutputStream);
                    this.afos.closeAndDeleteResult();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Object object = AdminServerLog.this.LOG_FETCHER_LOCK;
                synchronized (object) {
                    AdminServerLog.this.logFetcher = null;
                }
                if (this.saveToOutputStream != null) {
                    FileUtil.robustClose((OutputStream)this.saveToOutputStream);
                }
            }
        }
    }
}

