/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.tech.admin.enterprise;

import com.aem.shelp.common.Language;
import com.aem.shelp.tech.admin.enterprise.PeerConfig;
import com.aem.shelp.tech.admin.enterprise.PeerServerList;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import utils.swing.SwingUtil;
import utils.swing.components.ColorPropagatingGBPanel;
import utils.swing.components.messagefields.MessageTextField;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class PeerConfigUI
implements ActionListener {
    private final PeerServerList peerServerList;
    public ColorPropagatingGBPanel rootComponent = new ColorPropagatingGBPanel();
    private ColorPropagatingGBPanel targetListPanel = new ColorPropagatingGBPanel();
    private ColorPropagatingGBPanel targetsPanel = new ColorPropagatingGBPanel();
    private GbPanel addNewPanel = new ColorPropagatingGBPanel();
    private JToggleButton configureButton = new JToggleButton(Language.get("EDIT"), ImageLoader.getImageIcon((String)"images/svg/general/pencil.svg,16"));
    private JButton deleteAllButton = new JButton(Language.get("PEER_REMOVE_ALL"));
    private JLabel hostnameLabel;
    private MessageTextField issueLics = new MessageTextField(Language.get("ALERT_TRIGGERS_NONE"), null);
    private JCheckBox pushHistory = new JCheckBox(Language.get("PEER_PUSH_HISTORY"));
    private JCheckBox pushSessionTokens = new JCheckBox(Language.get("PEER_PUSH_TOKENS"));
    private final PeerConfig spec;

    public GbPanel getRootComponent() {
        return this.rootComponent;
    }

    public PeerConfigUI(PeerConfig spec, PeerServerList peerServerList) {
        this.peerServerList = peerServerList;
        this.spec = spec;
        this.initUI();
    }

    public void showDeleteButton(boolean showDelete) {
        this.deleteAllButton.setVisible(showDelete);
    }

    private void initUI() {
        SHButtonUI.makeButtonRed((JButton)this.deleteAllButton);
        this.deleteAllButton.setVisible(false);
        this.deleteAllButton.addActionListener(this);
        JLabel title = new JLabel();
        title.setFont(SHStyle.mediumFont);
        title.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)3, (int)0, (int)10));
        this.hostnameLabel = new JLabel();
        this.hostnameLabel.setFont(SHStyle.smallerFont);
        this.hostnameLabel.setForeground(SHStyle.EXAMPLE_TEXT_COLOR);
        this.hostnameLabel.setBorder(SHBorderFactory.createEmptyBorder((int)3, (int)0, (int)0, (int)3));
        int Y = 0;
        this.rootComponent.add(title, 0, Y, 1, 1, 0, 0, 17, 1);
        this.rootComponent.add(this.hostnameLabel, 1, Y, 1, 1, 1, 0, 17, 1);
        this.rootComponent.add(this.deleteAllButton, 2, Y, 1, 1, 0, 0, 10, 1);
        this.rootComponent.add(this.configureButton, 3, Y++, 1, 1, 0, 0, 10, 1, (Insets)new ScaledInsets(0, 5, 0, 0));
        this.rootComponent.add((Component)((Object)this.targetListPanel), 0, Y++, 3, 1, 1, 1, 10, 1);
        title.setText(this.spec.getIdentity());
        this.updateHostnameLabel();
        this.configureButton.addActionListener(this);
        this.addNewPanel.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)20, (int)0, (int)0));
        this.addNewPanel.setVisible(false);
        this.targetListPanel.add((Component)((Object)this.targetsPanel), 0, 0, 1, 1, 1, 0, 10, 1);
        this.targetListPanel.add((Component)this.addNewPanel, 0, 1, 1, 1, 1, 0, 10, 1);
        this.rootComponent.setBorder(SHBorderFactory.createEmptyBorder((int)2, (int)2, (int)5, (int)1));
        this.addNewPanel.add((Component)new JLabel(Language.get("ISSUE_LICENSES")), 0, 0, 1, 1, 0, 100, 13, 0, (Insets)new ScaledInsets(0, 0, 0, 10));
        this.addNewPanel.add((Component)this.issueLics, 1, 0, 1, 1, 100, 100, 17, 0);
        this.addNewPanel.add((Component)this.pushHistory, 0, 1, 2, 1, 100, 100, 10, 2, (Insets)new ScaledInsets(5, 0, 0, 0));
        this.addNewPanel.add((Component)this.pushSessionTokens, 0, 2, 2, 1, 100, 100, 10, 2, (Insets)new ScaledInsets(2, 0, 0, 0));
        SwingUtil.setWidth((JComponent)this.issueLics, (int)SimpleHelpLookAndFeel.scale((int)100));
    }

    private void updateHostnameLabel() {
        String label = this.spec.getHostname();
        if (this.spec.getLicensesToIssue() > 0) {
            label = label + " (" + Language.get("ISSUING_N_LICENSES", this.spec.getLicensesToIssue()) + ")";
        }
        if (this.spec.getTransientMyIssuedLicenses() > 0) {
            label = label + " (" + Language.get("ISSUED_N_LICENSES", this.spec.getTransientMyIssuedLicenses()) + ")";
        }
        this.hostnameLabel.setText(label);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.configureButton) {
            if (this.configureButton.isSelected()) {
                this.configureButton.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/ok.svg,16"));
                this.configureButton.setText(Language.get("DONE"));
                if (this.spec.getLicensesToIssue() > 0) {
                    this.issueLics.setText("" + this.spec.getLicensesToIssue());
                } else {
                    this.issueLics.setText("");
                }
                this.pushHistory.setSelected(this.spec.syncHistory);
                this.pushSessionTokens.setSelected(this.spec.syncSessionTokens);
            } else {
                this.configureButton.setIcon(ImageLoader.getImageIcon((String)"images/svg/general/pencil.svg,16"));
                this.configureButton.setText(Language.get("EDIT"));
                String licNumber = this.issueLics.getText().trim();
                if (licNumber.length() == 0) {
                    this.spec.setLicensesToIssue(0);
                } else {
                    try {
                        int lics = Integer.parseInt(licNumber);
                        this.spec.setLicensesToIssue(lics);
                    }
                    catch (Exception x) {
                        this.spec.setLicensesToIssue(0);
                    }
                }
                this.spec.syncHistory = this.pushHistory.isSelected();
                this.spec.syncSessionTokens = this.pushSessionTokens.isSelected();
                this.save();
            }
            this.addNewPanel.setVisible(this.configureButton.isSelected());
            this.configureButton.repaint();
            this.targetListPanel.repaint();
            this.showDeleteButton(this.configureButton.isSelected());
            this.updateHostnameLabel();
        } else if (e.getSource() == this.deleteAllButton && SHGlassOptionPane.showOkCancelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)((Object)this.rootComponent)), (String)Language.get("PEER_CONFIRM_DELETE_MSG", this.spec.getIdentity()), (String)Language.get("PEER_CONFIRM_DELETE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/question.svg,48"), (String)Language.get("DELETE"))) {
            this.peerServerList.deletePeerConfig(this.spec);
        }
    }

    public void save() {
        this.peerServerList.save(this.spec);
    }
}

